// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/clouddms/v1/clouddms.proto

package clouddms

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Retrieve a list of all migration jobs in a given project and location.
type ListMigrationJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of migrationJobs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of migration jobs to return. The service may return
	// fewer than this value. If unspecified, at most 50 migration jobs will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The nextPageToken value received in the previous call to
	// migrationJobs.list, used in the subsequent request to retrieve the next
	// page of results. On first call this should be left blank. When paginating,
	// all other parameters provided to migrationJobs.list must match the call
	// that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters migration jobs listed in the response.
	// The expression must specify the field name, a comparison operator, and the
	// value that you want to use for filtering. The value must be a string,
	// a number, or a boolean. The comparison operator must be
	// either =, !=, >, or <. For example, list migration jobs created this year
	// by specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z.**
	// You can also filter nested fields. For example, you could specify
	// **reverseSshConnectivity.vmIp = "1.2.3.4"** to select all migration
	// jobs connecting through the specific SSH tunnel bastion.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Sort the results based on the migration job name.
	// Valid values are: "name", "name asc", and "name desc".
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListMigrationJobsRequest) Reset() {
	*x = ListMigrationJobsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMigrationJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigrationJobsRequest) ProtoMessage() {}

func (x *ListMigrationJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigrationJobsRequest.ProtoReflect.Descriptor instead.
func (*ListMigrationJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{0}
}

func (x *ListMigrationJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMigrationJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMigrationJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMigrationJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMigrationJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListMigrationJobs' request.
type ListMigrationJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of migration jobs objects.
	MigrationJobs []*MigrationJob `protobuf:"bytes,1,rep,name=migration_jobs,json=migrationJobs,proto3" json:"migration_jobs,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListMigrationJobsResponse) Reset() {
	*x = ListMigrationJobsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMigrationJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigrationJobsResponse) ProtoMessage() {}

func (x *ListMigrationJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigrationJobsResponse.ProtoReflect.Descriptor instead.
func (*ListMigrationJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{1}
}

func (x *ListMigrationJobsResponse) GetMigrationJobs() []*MigrationJob {
	if x != nil {
		return x.MigrationJobs
	}
	return nil
}

func (x *ListMigrationJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMigrationJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetMigrationJob' request.
type GetMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the migration job resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMigrationJobRequest) Reset() {
	*x = GetMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMigrationJobRequest) ProtoMessage() {}

func (x *GetMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*GetMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{2}
}

func (x *GetMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message to create a new Database Migration Service migration job
// in the specified project and region.
type CreateMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of migration jobs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID of the instance to create.
	MigrationJobId string `protobuf:"bytes,2,opt,name=migration_job_id,json=migrationJobId,proto3" json:"migration_job_id,omitempty"`
	// Required. Represents a [migration
	// job](https://cloud.google.com/database-migration/docs/reference/rest/v1/projects.locations.migrationJobs)
	// object.
	MigrationJob *MigrationJob `protobuf:"bytes,3,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// A unique id used to identify the request. If the server receives two
	// requests with the same id, then the second request will be ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMigrationJobRequest) Reset() {
	*x = CreateMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMigrationJobRequest) ProtoMessage() {}

func (x *CreateMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*CreateMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{3}
}

func (x *CreateMigrationJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMigrationJobRequest) GetMigrationJobId() string {
	if x != nil {
		return x.MigrationJobId
	}
	return ""
}

func (x *CreateMigrationJobRequest) GetMigrationJob() *MigrationJob {
	if x != nil {
		return x.MigrationJob
	}
	return nil
}

func (x *CreateMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'UpdateMigrationJob' request.
type UpdateMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// migration job resource by the update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The migration job parameters to update.
	MigrationJob *MigrationJob `protobuf:"bytes,2,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// A unique id used to identify the request. If the server receives two
	// requests with the same id, then the second request will be ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateMigrationJobRequest) Reset() {
	*x = UpdateMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMigrationJobRequest) ProtoMessage() {}

func (x *UpdateMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateMigrationJobRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMigrationJobRequest) GetMigrationJob() *MigrationJob {
	if x != nil {
		return x.MigrationJob
	}
	return nil
}

func (x *UpdateMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteMigrationJob' request.
type DeleteMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the migration job resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A unique id used to identify the request. If the server receives two
	// requests with the same id, then the second request will be ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The destination CloudSQL connection profile is always deleted with the
	// migration job. In case of force delete, the destination CloudSQL replica
	// database is also deleted.
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteMigrationJobRequest) Reset() {
	*x = DeleteMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMigrationJobRequest) ProtoMessage() {}

func (x *DeleteMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteMigrationJobRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for 'StartMigrationJob' request.
type StartMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to start.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StartMigrationJobRequest) Reset() {
	*x = StartMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMigrationJobRequest) ProtoMessage() {}

func (x *StartMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*StartMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{6}
}

func (x *StartMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'StopMigrationJob' request.
type StopMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to stop.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *StopMigrationJobRequest) Reset() {
	*x = StopMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StopMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StopMigrationJobRequest) ProtoMessage() {}

func (x *StopMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StopMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*StopMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{7}
}

func (x *StopMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ResumeMigrationJob' request.
type ResumeMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to resume.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *ResumeMigrationJobRequest) Reset() {
	*x = ResumeMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ResumeMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeMigrationJobRequest) ProtoMessage() {}

func (x *ResumeMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*ResumeMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{8}
}

func (x *ResumeMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'PromoteMigrationJob' request.
type PromoteMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to promote.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *PromoteMigrationJobRequest) Reset() {
	*x = PromoteMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PromoteMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromoteMigrationJobRequest) ProtoMessage() {}

func (x *PromoteMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromoteMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*PromoteMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{9}
}

func (x *PromoteMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'VerifyMigrationJob' request.
type VerifyMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to verify.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *VerifyMigrationJobRequest) Reset() {
	*x = VerifyMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VerifyMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VerifyMigrationJobRequest) ProtoMessage() {}

func (x *VerifyMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VerifyMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*VerifyMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{10}
}

func (x *VerifyMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'RestartMigrationJob' request.
type RestartMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to restart.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RestartMigrationJobRequest) Reset() {
	*x = RestartMigrationJobRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestartMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestartMigrationJobRequest) ProtoMessage() {}

func (x *RestartMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestartMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*RestartMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{11}
}

func (x *RestartMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'GenerateSshScript' request.
type GenerateSshScriptRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the migration job resource to generate the SSH script.
	MigrationJob string `protobuf:"bytes,1,opt,name=migration_job,json=migrationJob,proto3" json:"migration_job,omitempty"`
	// Required. Bastion VM Instance name to use or to create.
	Vm string `protobuf:"bytes,2,opt,name=vm,proto3" json:"vm,omitempty"`
	// The VM configuration
	//
	// Types that are assignable to VmConfig:
	//	*GenerateSshScriptRequest_VmCreationConfig
	//	*GenerateSshScriptRequest_VmSelectionConfig
	VmConfig isGenerateSshScriptRequest_VmConfig `protobuf_oneof:"vm_config"`
	// The port that will be open on the bastion host
	VmPort int32 `protobuf:"varint,3,opt,name=vm_port,json=vmPort,proto3" json:"vm_port,omitempty"`
}

func (x *GenerateSshScriptRequest) Reset() {
	*x = GenerateSshScriptRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerateSshScriptRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateSshScriptRequest) ProtoMessage() {}

func (x *GenerateSshScriptRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateSshScriptRequest.ProtoReflect.Descriptor instead.
func (*GenerateSshScriptRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{12}
}

func (x *GenerateSshScriptRequest) GetMigrationJob() string {
	if x != nil {
		return x.MigrationJob
	}
	return ""
}

func (x *GenerateSshScriptRequest) GetVm() string {
	if x != nil {
		return x.Vm
	}
	return ""
}

func (m *GenerateSshScriptRequest) GetVmConfig() isGenerateSshScriptRequest_VmConfig {
	if m != nil {
		return m.VmConfig
	}
	return nil
}

func (x *GenerateSshScriptRequest) GetVmCreationConfig() *VmCreationConfig {
	if x, ok := x.GetVmConfig().(*GenerateSshScriptRequest_VmCreationConfig); ok {
		return x.VmCreationConfig
	}
	return nil
}

func (x *GenerateSshScriptRequest) GetVmSelectionConfig() *VmSelectionConfig {
	if x, ok := x.GetVmConfig().(*GenerateSshScriptRequest_VmSelectionConfig); ok {
		return x.VmSelectionConfig
	}
	return nil
}

func (x *GenerateSshScriptRequest) GetVmPort() int32 {
	if x != nil {
		return x.VmPort
	}
	return 0
}

type isGenerateSshScriptRequest_VmConfig interface {
	isGenerateSshScriptRequest_VmConfig()
}

type GenerateSshScriptRequest_VmCreationConfig struct {
	// The VM creation configuration
	VmCreationConfig *VmCreationConfig `protobuf:"bytes,100,opt,name=vm_creation_config,json=vmCreationConfig,proto3,oneof"`
}

type GenerateSshScriptRequest_VmSelectionConfig struct {
	// The VM selection configuration
	VmSelectionConfig *VmSelectionConfig `protobuf:"bytes,101,opt,name=vm_selection_config,json=vmSelectionConfig,proto3,oneof"`
}

func (*GenerateSshScriptRequest_VmCreationConfig) isGenerateSshScriptRequest_VmConfig() {}

func (*GenerateSshScriptRequest_VmSelectionConfig) isGenerateSshScriptRequest_VmConfig() {}

// VM creation configuration message
type VmCreationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. VM instance machine type to create.
	VmMachineType string `protobuf:"bytes,1,opt,name=vm_machine_type,json=vmMachineType,proto3" json:"vm_machine_type,omitempty"`
	// The Google Cloud Platform zone to create the VM in.
	VmZone string `protobuf:"bytes,2,opt,name=vm_zone,json=vmZone,proto3" json:"vm_zone,omitempty"`
	// The subnet name the vm needs to be created in.
	Subnet string `protobuf:"bytes,3,opt,name=subnet,proto3" json:"subnet,omitempty"`
}

func (x *VmCreationConfig) Reset() {
	*x = VmCreationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmCreationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmCreationConfig) ProtoMessage() {}

func (x *VmCreationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmCreationConfig.ProtoReflect.Descriptor instead.
func (*VmCreationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{13}
}

func (x *VmCreationConfig) GetVmMachineType() string {
	if x != nil {
		return x.VmMachineType
	}
	return ""
}

func (x *VmCreationConfig) GetVmZone() string {
	if x != nil {
		return x.VmZone
	}
	return ""
}

func (x *VmCreationConfig) GetSubnet() string {
	if x != nil {
		return x.Subnet
	}
	return ""
}

// VM selection configuration message
type VmSelectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Google Cloud Platform zone the VM is located.
	VmZone string `protobuf:"bytes,1,opt,name=vm_zone,json=vmZone,proto3" json:"vm_zone,omitempty"`
}

func (x *VmSelectionConfig) Reset() {
	*x = VmSelectionConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VmSelectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmSelectionConfig) ProtoMessage() {}

func (x *VmSelectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmSelectionConfig.ProtoReflect.Descriptor instead.
func (*VmSelectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{14}
}

func (x *VmSelectionConfig) GetVmZone() string {
	if x != nil {
		return x.VmZone
	}
	return ""
}

// Response message for 'GenerateSshScript' request.
type SshScript struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ssh configuration script.
	Script string `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
}

func (x *SshScript) Reset() {
	*x = SshScript{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SshScript) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SshScript) ProtoMessage() {}

func (x *SshScript) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SshScript.ProtoReflect.Descriptor instead.
func (*SshScript) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{15}
}

func (x *SshScript) GetScript() string {
	if x != nil {
		return x.Script
	}
	return ""
}

// Request message for 'ListConnectionProfiles' request.
type ListConnectionProfilesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of connection profiles.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of connection profiles to return. The service may return
	// fewer than this value. If unspecified, at most 50 connection profiles will
	// be returned. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListConnectionProfiles` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListConnectionProfiles`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// A filter expression that filters connection profiles listed in the
	// response. The expression must specify the field name, a comparison
	// operator, and the value that you want to use for filtering. The value must
	// be a string, a number, or a boolean. The comparison operator must be either
	// =, !=, >, or <. For example, list connection profiles created this year by
	// specifying **createTime %gt; 2020-01-01T00:00:00.000000000Z**. You can
	// also filter nested fields. For example, you could specify **mySql.username
	// = %lt;my_username%gt;** to list all connection profiles configured to
	// connect with a specific username.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListConnectionProfilesRequest) Reset() {
	*x = ListConnectionProfilesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionProfilesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionProfilesRequest) ProtoMessage() {}

func (x *ListConnectionProfilesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionProfilesRequest.ProtoReflect.Descriptor instead.
func (*ListConnectionProfilesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{16}
}

func (x *ListConnectionProfilesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListConnectionProfilesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListConnectionProfilesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListConnectionProfilesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListConnectionProfilesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListConnectionProfiles' request.
type ListConnectionProfilesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response list of connection profiles.
	ConnectionProfiles []*ConnectionProfile `protobuf:"bytes,1,rep,name=connection_profiles,json=connectionProfiles,proto3" json:"connection_profiles,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListConnectionProfilesResponse) Reset() {
	*x = ListConnectionProfilesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListConnectionProfilesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListConnectionProfilesResponse) ProtoMessage() {}

func (x *ListConnectionProfilesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListConnectionProfilesResponse.ProtoReflect.Descriptor instead.
func (*ListConnectionProfilesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{17}
}

func (x *ListConnectionProfilesResponse) GetConnectionProfiles() []*ConnectionProfile {
	if x != nil {
		return x.ConnectionProfiles
	}
	return nil
}

func (x *ListConnectionProfilesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListConnectionProfilesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetConnectionProfile' request.
type GetConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the connection profile resource to get.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetConnectionProfileRequest) Reset() {
	*x = GetConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetConnectionProfileRequest) ProtoMessage() {}

func (x *GetConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*GetConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{18}
}

func (x *GetConnectionProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateConnectionProfile' request.
type CreateConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of connection profiles.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The connection profile identifier.
	ConnectionProfileId string `protobuf:"bytes,2,opt,name=connection_profile_id,json=connectionProfileId,proto3" json:"connection_profile_id,omitempty"`
	// Required. The create request body including the connection profile data
	ConnectionProfile *ConnectionProfile `protobuf:"bytes,3,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// A unique id used to identify the request. If the server receives two
	// requests with the same id, then the second request will be ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateConnectionProfileRequest) Reset() {
	*x = CreateConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateConnectionProfileRequest) ProtoMessage() {}

func (x *CreateConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*CreateConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{19}
}

func (x *CreateConnectionProfileRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateConnectionProfileRequest) GetConnectionProfileId() string {
	if x != nil {
		return x.ConnectionProfileId
	}
	return ""
}

func (x *CreateConnectionProfileRequest) GetConnectionProfile() *ConnectionProfile {
	if x != nil {
		return x.ConnectionProfile
	}
	return nil
}

func (x *CreateConnectionProfileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'UpdateConnectionProfile' request.
type UpdateConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// connection profile resource by the update.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The connection profile parameters to update.
	ConnectionProfile *ConnectionProfile `protobuf:"bytes,2,opt,name=connection_profile,json=connectionProfile,proto3" json:"connection_profile,omitempty"`
	// A unique id used to identify the request. If the server receives two
	// requests with the same id, then the second request will be ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateConnectionProfileRequest) Reset() {
	*x = UpdateConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateConnectionProfileRequest) ProtoMessage() {}

func (x *UpdateConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*UpdateConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{20}
}

func (x *UpdateConnectionProfileRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateConnectionProfileRequest) GetConnectionProfile() *ConnectionProfile {
	if x != nil {
		return x.ConnectionProfile
	}
	return nil
}

func (x *UpdateConnectionProfileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteConnectionProfile' request.
type DeleteConnectionProfileRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the connection profile resource to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A unique id used to identify the request. If the server receives two
	// requests with the same id, then the second request will be ignored.
	//
	// It is recommended to always set this value to a UUID.
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9), underscores
	// (_), and hyphens (-). The maximum length is 40 characters.
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// In case of force delete, the CloudSQL replica database is also deleted
	// (only for CloudSQL connection profile).
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteConnectionProfileRequest) Reset() {
	*x = DeleteConnectionProfileRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteConnectionProfileRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteConnectionProfileRequest) ProtoMessage() {}

func (x *DeleteConnectionProfileRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteConnectionProfileRequest.ProtoReflect.Descriptor instead.
func (*DeleteConnectionProfileRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteConnectionProfileRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteConnectionProfileRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteConnectionProfileRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a [google.rpc.Status.code][google.rpc.Status.code] of 1,
	// corresponding to `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP(), []int{22}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

var File_google_cloud_clouddms_v1_clouddms_proto protoreflect.FileDescriptor

var file_google_cloud_clouddms_v1_clouddms_proto_rawDesc = []byte{
	0x0a, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xd4, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xb4, 0x01, 0x0a, 0x19, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4d, 0x0a, 0x0e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a,
	0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x5f, 0x0a, 0x16, 0x47, 0x65, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0x86, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x10, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xce, 0x01, 0x0a, 0x19, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x50, 0x0a, 0x0d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x97, 0x01, 0x0a, 0x19, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29,
	0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66,
	0x6f, 0x72, 0x63, 0x65, 0x22, 0x5e, 0x0a, 0x18, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5d, 0x0a, 0x17, 0x53, 0x74, 0x6f, 0x70, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x19, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x1a, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x19, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x60, 0x0a, 0x1a, 0x52, 0x65, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe5, 0x02, 0x0a, 0x18, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x53, 0x0a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xfa,
	0x41, 0x2b, 0x0a, 0x29, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x13, 0x0a, 0x02, 0x76,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x02, 0x76, 0x6d,
	0x12, 0x5a, 0x0a, 0x12, 0x76, 0x6d, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x64, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x10, 0x76, 0x6d, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5d, 0x0a, 0x13,
	0x76, 0x6d, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x65, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x11, 0x76, 0x6d, 0x53, 0x65, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x76,
	0x6d, 0x5f, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x76, 0x6d,
	0x50, 0x6f, 0x72, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x76, 0x6d, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x22, 0x70, 0x0a, 0x10, 0x56, 0x6d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b, 0x0a, 0x0f, 0x76, 0x6d, 0x5f, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x76, 0x6d, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6d, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73,
	0x75, 0x62, 0x6e, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x75, 0x62,
	0x6e, 0x65, 0x74, 0x22, 0x31, 0x0a, 0x11, 0x56, 0x6d, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x76, 0x6d, 0x5a, 0x6f, 0x6e, 0x65, 0x22, 0x23, 0x0a, 0x09, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0xde, 0x01, 0x0a, 0x1d,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc8, 0x01, 0x0a,
	0x1e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5c, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x69, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xa9, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x5f,
	0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x63, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12,
	0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xe2,
	0x01, 0x0a, 0x1e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x12, 0x5f, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x11, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xa1, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72,
	0x62, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d,
	0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a,
	0x16, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32,
	0xc8, 0x1e, 0x0a, 0x14, 0x44, 0x61, 0x74, 0x61, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc0, 0x01, 0x0a, 0x11, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0xad, 0x01, 0x0a, 0x0f,
	0x47, 0x65, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xff, 0x01, 0x0a, 0x12,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x94, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x22,
	0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x73, 0x3a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0xda, 0x41, 0x25, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x81, 0x02,
	0x0a, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x96, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x50, 0x32, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0xda, 0x41, 0x19, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x21,
	0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0xd7, 0x01, 0x0a, 0x12, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6d, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x33, 0x2a, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41,
	0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xce, 0x01, 0x0a, 0x11,
	0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x66, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x22, 0x37, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xcb, 0x01, 0x0a,
	0x10, 0x53, 0x74, 0x6f, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f,
	0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x22, 0x36, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x74, 0x6f, 0x70, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd1, 0x01, 0x0a, 0x12, 0x52,
	0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd4,
	0x01, 0x0a, 0x13, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x3e, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x3a, 0x01,
	0x2a, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd1, 0x01, 0x0a, 0x12, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x65, 0x72, 0x69, 0x66, 0x79, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x67, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3d, 0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x76, 0x65, 0x72, 0x69,
	0x66, 0x79, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x21, 0x0a, 0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xd4, 0x01, 0x0a, 0x13, 0x52, 0x65,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x68, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x22, 0x39,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x21, 0x0a,
	0x0c, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0xc5, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68,
	0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x73, 0x68, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22,
	0x57, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x53, 0x73, 0x68, 0x53,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0xd4, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x12, 0x36,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0xc1, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x22, 0x45, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x38, 0x12, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0xa2, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x4c, 0x22, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x3a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0xda, 0x41, 0x2f,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0xca,
	0x41, 0x26, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0xa4, 0x02, 0x0a, 0x17, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xaf, 0x01,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x32, 0x49, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x63, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2e,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x12, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0xda, 0x41, 0x1e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0xca, 0x41, 0x26, 0x0a, 0x11, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0xe6, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x72, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x2a, 0x36, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x1a, 0x50, 0xca, 0x41, 0x1c, 0x64, 0x61, 0x74,
	0x61, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xc5, 0x01, 0x0a, 0x1c, 0x63,
	0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x64, 0x6d, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x40, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64,
	0x6d, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x64, 0x6d, 0x73, 0xaa, 0x02,
	0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x44, 0x6d, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x6d,
	0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x44, 0x4d, 0x53, 0x3a, 0x3a,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_clouddms_v1_clouddms_proto_rawDescOnce sync.Once
	file_google_cloud_clouddms_v1_clouddms_proto_rawDescData = file_google_cloud_clouddms_v1_clouddms_proto_rawDesc
)

func file_google_cloud_clouddms_v1_clouddms_proto_rawDescGZIP() []byte {
	file_google_cloud_clouddms_v1_clouddms_proto_rawDescOnce.Do(func() {
		file_google_cloud_clouddms_v1_clouddms_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_clouddms_v1_clouddms_proto_rawDescData)
	})
	return file_google_cloud_clouddms_v1_clouddms_proto_rawDescData
}

var file_google_cloud_clouddms_v1_clouddms_proto_msgTypes = make([]protoimpl.MessageInfo, 23)
var file_google_cloud_clouddms_v1_clouddms_proto_goTypes = []interface{}{
	(*ListMigrationJobsRequest)(nil),       // 0: google.cloud.clouddms.v1.ListMigrationJobsRequest
	(*ListMigrationJobsResponse)(nil),      // 1: google.cloud.clouddms.v1.ListMigrationJobsResponse
	(*GetMigrationJobRequest)(nil),         // 2: google.cloud.clouddms.v1.GetMigrationJobRequest
	(*CreateMigrationJobRequest)(nil),      // 3: google.cloud.clouddms.v1.CreateMigrationJobRequest
	(*UpdateMigrationJobRequest)(nil),      // 4: google.cloud.clouddms.v1.UpdateMigrationJobRequest
	(*DeleteMigrationJobRequest)(nil),      // 5: google.cloud.clouddms.v1.DeleteMigrationJobRequest
	(*StartMigrationJobRequest)(nil),       // 6: google.cloud.clouddms.v1.StartMigrationJobRequest
	(*StopMigrationJobRequest)(nil),        // 7: google.cloud.clouddms.v1.StopMigrationJobRequest
	(*ResumeMigrationJobRequest)(nil),      // 8: google.cloud.clouddms.v1.ResumeMigrationJobRequest
	(*PromoteMigrationJobRequest)(nil),     // 9: google.cloud.clouddms.v1.PromoteMigrationJobRequest
	(*VerifyMigrationJobRequest)(nil),      // 10: google.cloud.clouddms.v1.VerifyMigrationJobRequest
	(*RestartMigrationJobRequest)(nil),     // 11: google.cloud.clouddms.v1.RestartMigrationJobRequest
	(*GenerateSshScriptRequest)(nil),       // 12: google.cloud.clouddms.v1.GenerateSshScriptRequest
	(*VmCreationConfig)(nil),               // 13: google.cloud.clouddms.v1.VmCreationConfig
	(*VmSelectionConfig)(nil),              // 14: google.cloud.clouddms.v1.VmSelectionConfig
	(*SshScript)(nil),                      // 15: google.cloud.clouddms.v1.SshScript
	(*ListConnectionProfilesRequest)(nil),  // 16: google.cloud.clouddms.v1.ListConnectionProfilesRequest
	(*ListConnectionProfilesResponse)(nil), // 17: google.cloud.clouddms.v1.ListConnectionProfilesResponse
	(*GetConnectionProfileRequest)(nil),    // 18: google.cloud.clouddms.v1.GetConnectionProfileRequest
	(*CreateConnectionProfileRequest)(nil), // 19: google.cloud.clouddms.v1.CreateConnectionProfileRequest
	(*UpdateConnectionProfileRequest)(nil), // 20: google.cloud.clouddms.v1.UpdateConnectionProfileRequest
	(*DeleteConnectionProfileRequest)(nil), // 21: google.cloud.clouddms.v1.DeleteConnectionProfileRequest
	(*OperationMetadata)(nil),              // 22: google.cloud.clouddms.v1.OperationMetadata
	(*MigrationJob)(nil),                   // 23: google.cloud.clouddms.v1.MigrationJob
	(*fieldmaskpb.FieldMask)(nil),          // 24: google.protobuf.FieldMask
	(*ConnectionProfile)(nil),              // 25: google.cloud.clouddms.v1.ConnectionProfile
	(*timestamppb.Timestamp)(nil),          // 26: google.protobuf.Timestamp
	(*longrunning.Operation)(nil),          // 27: google.longrunning.Operation
}
var file_google_cloud_clouddms_v1_clouddms_proto_depIdxs = []int32{
	23, // 0: google.cloud.clouddms.v1.ListMigrationJobsResponse.migration_jobs:type_name -> google.cloud.clouddms.v1.MigrationJob
	23, // 1: google.cloud.clouddms.v1.CreateMigrationJobRequest.migration_job:type_name -> google.cloud.clouddms.v1.MigrationJob
	24, // 2: google.cloud.clouddms.v1.UpdateMigrationJobRequest.update_mask:type_name -> google.protobuf.FieldMask
	23, // 3: google.cloud.clouddms.v1.UpdateMigrationJobRequest.migration_job:type_name -> google.cloud.clouddms.v1.MigrationJob
	13, // 4: google.cloud.clouddms.v1.GenerateSshScriptRequest.vm_creation_config:type_name -> google.cloud.clouddms.v1.VmCreationConfig
	14, // 5: google.cloud.clouddms.v1.GenerateSshScriptRequest.vm_selection_config:type_name -> google.cloud.clouddms.v1.VmSelectionConfig
	25, // 6: google.cloud.clouddms.v1.ListConnectionProfilesResponse.connection_profiles:type_name -> google.cloud.clouddms.v1.ConnectionProfile
	25, // 7: google.cloud.clouddms.v1.CreateConnectionProfileRequest.connection_profile:type_name -> google.cloud.clouddms.v1.ConnectionProfile
	24, // 8: google.cloud.clouddms.v1.UpdateConnectionProfileRequest.update_mask:type_name -> google.protobuf.FieldMask
	25, // 9: google.cloud.clouddms.v1.UpdateConnectionProfileRequest.connection_profile:type_name -> google.cloud.clouddms.v1.ConnectionProfile
	26, // 10: google.cloud.clouddms.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	26, // 11: google.cloud.clouddms.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	0,  // 12: google.cloud.clouddms.v1.DataMigrationService.ListMigrationJobs:input_type -> google.cloud.clouddms.v1.ListMigrationJobsRequest
	2,  // 13: google.cloud.clouddms.v1.DataMigrationService.GetMigrationJob:input_type -> google.cloud.clouddms.v1.GetMigrationJobRequest
	3,  // 14: google.cloud.clouddms.v1.DataMigrationService.CreateMigrationJob:input_type -> google.cloud.clouddms.v1.CreateMigrationJobRequest
	4,  // 15: google.cloud.clouddms.v1.DataMigrationService.UpdateMigrationJob:input_type -> google.cloud.clouddms.v1.UpdateMigrationJobRequest
	5,  // 16: google.cloud.clouddms.v1.DataMigrationService.DeleteMigrationJob:input_type -> google.cloud.clouddms.v1.DeleteMigrationJobRequest
	6,  // 17: google.cloud.clouddms.v1.DataMigrationService.StartMigrationJob:input_type -> google.cloud.clouddms.v1.StartMigrationJobRequest
	7,  // 18: google.cloud.clouddms.v1.DataMigrationService.StopMigrationJob:input_type -> google.cloud.clouddms.v1.StopMigrationJobRequest
	8,  // 19: google.cloud.clouddms.v1.DataMigrationService.ResumeMigrationJob:input_type -> google.cloud.clouddms.v1.ResumeMigrationJobRequest
	9,  // 20: google.cloud.clouddms.v1.DataMigrationService.PromoteMigrationJob:input_type -> google.cloud.clouddms.v1.PromoteMigrationJobRequest
	10, // 21: google.cloud.clouddms.v1.DataMigrationService.VerifyMigrationJob:input_type -> google.cloud.clouddms.v1.VerifyMigrationJobRequest
	11, // 22: google.cloud.clouddms.v1.DataMigrationService.RestartMigrationJob:input_type -> google.cloud.clouddms.v1.RestartMigrationJobRequest
	12, // 23: google.cloud.clouddms.v1.DataMigrationService.GenerateSshScript:input_type -> google.cloud.clouddms.v1.GenerateSshScriptRequest
	16, // 24: google.cloud.clouddms.v1.DataMigrationService.ListConnectionProfiles:input_type -> google.cloud.clouddms.v1.ListConnectionProfilesRequest
	18, // 25: google.cloud.clouddms.v1.DataMigrationService.GetConnectionProfile:input_type -> google.cloud.clouddms.v1.GetConnectionProfileRequest
	19, // 26: google.cloud.clouddms.v1.DataMigrationService.CreateConnectionProfile:input_type -> google.cloud.clouddms.v1.CreateConnectionProfileRequest
	20, // 27: google.cloud.clouddms.v1.DataMigrationService.UpdateConnectionProfile:input_type -> google.cloud.clouddms.v1.UpdateConnectionProfileRequest
	21, // 28: google.cloud.clouddms.v1.DataMigrationService.DeleteConnectionProfile:input_type -> google.cloud.clouddms.v1.DeleteConnectionProfileRequest
	1,  // 29: google.cloud.clouddms.v1.DataMigrationService.ListMigrationJobs:output_type -> google.cloud.clouddms.v1.ListMigrationJobsResponse
	23, // 30: google.cloud.clouddms.v1.DataMigrationService.GetMigrationJob:output_type -> google.cloud.clouddms.v1.MigrationJob
	27, // 31: google.cloud.clouddms.v1.DataMigrationService.CreateMigrationJob:output_type -> google.longrunning.Operation
	27, // 32: google.cloud.clouddms.v1.DataMigrationService.UpdateMigrationJob:output_type -> google.longrunning.Operation
	27, // 33: google.cloud.clouddms.v1.DataMigrationService.DeleteMigrationJob:output_type -> google.longrunning.Operation
	27, // 34: google.cloud.clouddms.v1.DataMigrationService.StartMigrationJob:output_type -> google.longrunning.Operation
	27, // 35: google.cloud.clouddms.v1.DataMigrationService.StopMigrationJob:output_type -> google.longrunning.Operation
	27, // 36: google.cloud.clouddms.v1.DataMigrationService.ResumeMigrationJob:output_type -> google.longrunning.Operation
	27, // 37: google.cloud.clouddms.v1.DataMigrationService.PromoteMigrationJob:output_type -> google.longrunning.Operation
	27, // 38: google.cloud.clouddms.v1.DataMigrationService.VerifyMigrationJob:output_type -> google.longrunning.Operation
	27, // 39: google.cloud.clouddms.v1.DataMigrationService.RestartMigrationJob:output_type -> google.longrunning.Operation
	15, // 40: google.cloud.clouddms.v1.DataMigrationService.GenerateSshScript:output_type -> google.cloud.clouddms.v1.SshScript
	17, // 41: google.cloud.clouddms.v1.DataMigrationService.ListConnectionProfiles:output_type -> google.cloud.clouddms.v1.ListConnectionProfilesResponse
	25, // 42: google.cloud.clouddms.v1.DataMigrationService.GetConnectionProfile:output_type -> google.cloud.clouddms.v1.ConnectionProfile
	27, // 43: google.cloud.clouddms.v1.DataMigrationService.CreateConnectionProfile:output_type -> google.longrunning.Operation
	27, // 44: google.cloud.clouddms.v1.DataMigrationService.UpdateConnectionProfile:output_type -> google.longrunning.Operation
	27, // 45: google.cloud.clouddms.v1.DataMigrationService.DeleteConnectionProfile:output_type -> google.longrunning.Operation
	29, // [29:46] is the sub-list for method output_type
	12, // [12:29] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_clouddms_v1_clouddms_proto_init() }
func file_google_cloud_clouddms_v1_clouddms_proto_init() {
	if File_google_cloud_clouddms_v1_clouddms_proto != nil {
		return
	}
	file_google_cloud_clouddms_v1_clouddms_resources_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMigrationJobsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMigrationJobsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StopMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ResumeMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PromoteMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VerifyMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestartMigrationJobRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerateSshScriptRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmCreationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VmSelectionConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SshScript); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionProfilesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListConnectionProfilesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteConnectionProfileRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*OperationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_clouddms_v1_clouddms_proto_msgTypes[12].OneofWrappers = []interface{}{
		(*GenerateSshScriptRequest_VmCreationConfig)(nil),
		(*GenerateSshScriptRequest_VmSelectionConfig)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_clouddms_v1_clouddms_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   23,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_clouddms_v1_clouddms_proto_goTypes,
		DependencyIndexes: file_google_cloud_clouddms_v1_clouddms_proto_depIdxs,
		MessageInfos:      file_google_cloud_clouddms_v1_clouddms_proto_msgTypes,
	}.Build()
	File_google_cloud_clouddms_v1_clouddms_proto = out.File
	file_google_cloud_clouddms_v1_clouddms_proto_rawDesc = nil
	file_google_cloud_clouddms_v1_clouddms_proto_goTypes = nil
	file_google_cloud_clouddms_v1_clouddms_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DataMigrationServiceClient is the client API for DataMigrationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataMigrationServiceClient interface {
	// Lists migration jobs in a given project and location.
	ListMigrationJobs(ctx context.Context, in *ListMigrationJobsRequest, opts ...grpc.CallOption) (*ListMigrationJobsResponse, error)
	// Gets details of a single migration job.
	GetMigrationJob(ctx context.Context, in *GetMigrationJobRequest, opts ...grpc.CallOption) (*MigrationJob, error)
	// Creates a new migration job in a given project and location.
	CreateMigrationJob(ctx context.Context, in *CreateMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the parameters of a single migration job.
	UpdateMigrationJob(ctx context.Context, in *UpdateMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single migration job.
	DeleteMigrationJob(ctx context.Context, in *DeleteMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Start an already created migration job.
	StartMigrationJob(ctx context.Context, in *StartMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Stops a running migration job.
	StopMigrationJob(ctx context.Context, in *StopMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Resume a migration job that is currently stopped and is resumable (was
	// stopped during CDC phase).
	ResumeMigrationJob(ctx context.Context, in *ResumeMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Promote a migration job, stopping replication to the destination and
	// promoting the destination to be a standalone database.
	PromoteMigrationJob(ctx context.Context, in *PromoteMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Verify a migration job, making sure the destination can reach the source
	// and that all configuration and prerequisites are met.
	VerifyMigrationJob(ctx context.Context, in *VerifyMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Restart a stopped or failed migration job, resetting the destination
	// instance to its original state and starting the migration process from
	// scratch.
	RestartMigrationJob(ctx context.Context, in *RestartMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Generate a SSH configuration script to configure the reverse SSH
	// connectivity.
	GenerateSshScript(ctx context.Context, in *GenerateSshScriptRequest, opts ...grpc.CallOption) (*SshScript, error)
	// Retrieve a list of all connection profiles in a given project and location.
	ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error)
	// Gets details of a single connection profile.
	GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error)
	// Creates a new connection profile in a given project and location.
	CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Update the configuration of a single connection profile.
	UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a single Database Migration Service connection profile.
	// A connection profile can only be deleted if it is not in use by any
	// active migration jobs.
	DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type dataMigrationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDataMigrationServiceClient(cc grpc.ClientConnInterface) DataMigrationServiceClient {
	return &dataMigrationServiceClient{cc}
}

func (c *dataMigrationServiceClient) ListMigrationJobs(ctx context.Context, in *ListMigrationJobsRequest, opts ...grpc.CallOption) (*ListMigrationJobsResponse, error) {
	out := new(ListMigrationJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListMigrationJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetMigrationJob(ctx context.Context, in *GetMigrationJobRequest, opts ...grpc.CallOption) (*MigrationJob, error) {
	out := new(MigrationJob)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateMigrationJob(ctx context.Context, in *CreateMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreateMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateMigrationJob(ctx context.Context, in *UpdateMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/UpdateMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteMigrationJob(ctx context.Context, in *DeleteMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeleteMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) StartMigrationJob(ctx context.Context, in *StartMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/StartMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) StopMigrationJob(ctx context.Context, in *StopMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/StopMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ResumeMigrationJob(ctx context.Context, in *ResumeMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ResumeMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) PromoteMigrationJob(ctx context.Context, in *PromoteMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/PromoteMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) VerifyMigrationJob(ctx context.Context, in *VerifyMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/VerifyMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) RestartMigrationJob(ctx context.Context, in *RestartMigrationJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/RestartMigrationJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GenerateSshScript(ctx context.Context, in *GenerateSshScriptRequest, opts ...grpc.CallOption) (*SshScript, error) {
	out := new(SshScript)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GenerateSshScript", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) ListConnectionProfiles(ctx context.Context, in *ListConnectionProfilesRequest, opts ...grpc.CallOption) (*ListConnectionProfilesResponse, error) {
	out := new(ListConnectionProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/ListConnectionProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) GetConnectionProfile(ctx context.Context, in *GetConnectionProfileRequest, opts ...grpc.CallOption) (*ConnectionProfile, error) {
	out := new(ConnectionProfile)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/GetConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) CreateConnectionProfile(ctx context.Context, in *CreateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/CreateConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) UpdateConnectionProfile(ctx context.Context, in *UpdateConnectionProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/UpdateConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataMigrationServiceClient) DeleteConnectionProfile(ctx context.Context, in *DeleteConnectionProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.clouddms.v1.DataMigrationService/DeleteConnectionProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataMigrationServiceServer is the server API for DataMigrationService service.
type DataMigrationServiceServer interface {
	// Lists migration jobs in a given project and location.
	ListMigrationJobs(context.Context, *ListMigrationJobsRequest) (*ListMigrationJobsResponse, error)
	// Gets details of a single migration job.
	GetMigrationJob(context.Context, *GetMigrationJobRequest) (*MigrationJob, error)
	// Creates a new migration job in a given project and location.
	CreateMigrationJob(context.Context, *CreateMigrationJobRequest) (*longrunning.Operation, error)
	// Updates the parameters of a single migration job.
	UpdateMigrationJob(context.Context, *UpdateMigrationJobRequest) (*longrunning.Operation, error)
	// Deletes a single migration job.
	DeleteMigrationJob(context.Context, *DeleteMigrationJobRequest) (*longrunning.Operation, error)
	// Start an already created migration job.
	StartMigrationJob(context.Context, *StartMigrationJobRequest) (*longrunning.Operation, error)
	// Stops a running migration job.
	StopMigrationJob(context.Context, *StopMigrationJobRequest) (*longrunning.Operation, error)
	// Resume a migration job that is currently stopped and is resumable (was
	// stopped during CDC phase).
	ResumeMigrationJob(context.Context, *ResumeMigrationJobRequest) (*longrunning.Operation, error)
	// Promote a migration job, stopping replication to the destination and
	// promoting the destination to be a standalone database.
	PromoteMigrationJob(context.Context, *PromoteMigrationJobRequest) (*longrunning.Operation, error)
	// Verify a migration job, making sure the destination can reach the source
	// and that all configuration and prerequisites are met.
	VerifyMigrationJob(context.Context, *VerifyMigrationJobRequest) (*longrunning.Operation, error)
	// Restart a stopped or failed migration job, resetting the destination
	// instance to its original state and starting the migration process from
	// scratch.
	RestartMigrationJob(context.Context, *RestartMigrationJobRequest) (*longrunning.Operation, error)
	// Generate a SSH configuration script to configure the reverse SSH
	// connectivity.
	GenerateSshScript(context.Context, *GenerateSshScriptRequest) (*SshScript, error)
	// Retrieve a list of all connection profiles in a given project and location.
	ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error)
	// Gets details of a single connection profile.
	GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error)
	// Creates a new connection profile in a given project and location.
	CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunning.Operation, error)
	// Update the configuration of a single connection profile.
	UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunning.Operation, error)
	// Deletes a single Database Migration Service connection profile.
	// A connection profile can only be deleted if it is not in use by any
	// active migration jobs.
	DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunning.Operation, error)
}

// UnimplementedDataMigrationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDataMigrationServiceServer struct {
}

func (*UnimplementedDataMigrationServiceServer) ListMigrationJobs(context.Context, *ListMigrationJobsRequest) (*ListMigrationJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMigrationJobs not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetMigrationJob(context.Context, *GetMigrationJobRequest) (*MigrationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreateMigrationJob(context.Context, *CreateMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) UpdateMigrationJob(context.Context, *UpdateMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeleteMigrationJob(context.Context, *DeleteMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) StartMigrationJob(context.Context, *StartMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) StopMigrationJob(context.Context, *StopMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ResumeMigrationJob(context.Context, *ResumeMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) PromoteMigrationJob(context.Context, *PromoteMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PromoteMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) VerifyMigrationJob(context.Context, *VerifyMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) RestartMigrationJob(context.Context, *RestartMigrationJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestartMigrationJob not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GenerateSshScript(context.Context, *GenerateSshScriptRequest) (*SshScript, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateSshScript not implemented")
}
func (*UnimplementedDataMigrationServiceServer) ListConnectionProfiles(context.Context, *ListConnectionProfilesRequest) (*ListConnectionProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConnectionProfiles not implemented")
}
func (*UnimplementedDataMigrationServiceServer) GetConnectionProfile(context.Context, *GetConnectionProfileRequest) (*ConnectionProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) CreateConnectionProfile(context.Context, *CreateConnectionProfileRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) UpdateConnectionProfile(context.Context, *UpdateConnectionProfileRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConnectionProfile not implemented")
}
func (*UnimplementedDataMigrationServiceServer) DeleteConnectionProfile(context.Context, *DeleteConnectionProfileRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConnectionProfile not implemented")
}

func RegisterDataMigrationServiceServer(s *grpc.Server, srv DataMigrationServiceServer) {
	s.RegisterService(&_DataMigrationService_serviceDesc, srv)
}

func _DataMigrationService_ListMigrationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigrationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListMigrationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListMigrationJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListMigrationJobs(ctx, req.(*ListMigrationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetMigrationJob(ctx, req.(*GetMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreateMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateMigrationJob(ctx, req.(*CreateMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/UpdateMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateMigrationJob(ctx, req.(*UpdateMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeleteMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteMigrationJob(ctx, req.(*DeleteMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_StartMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).StartMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/StartMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).StartMigrationJob(ctx, req.(*StartMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_StopMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).StopMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/StopMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).StopMigrationJob(ctx, req.(*StopMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ResumeMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ResumeMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ResumeMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ResumeMigrationJob(ctx, req.(*ResumeMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_PromoteMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PromoteMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).PromoteMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/PromoteMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).PromoteMigrationJob(ctx, req.(*PromoteMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_VerifyMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).VerifyMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/VerifyMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).VerifyMigrationJob(ctx, req.(*VerifyMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_RestartMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestartMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).RestartMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/RestartMigrationJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).RestartMigrationJob(ctx, req.(*RestartMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GenerateSshScript_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateSshScriptRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GenerateSshScript(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GenerateSshScript",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GenerateSshScript(ctx, req.(*GenerateSshScriptRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_ListConnectionProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConnectionProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).ListConnectionProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/ListConnectionProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).ListConnectionProfiles(ctx, req.(*ListConnectionProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_GetConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).GetConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/GetConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).GetConnectionProfile(ctx, req.(*GetConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_CreateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).CreateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/CreateConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).CreateConnectionProfile(ctx, req.(*CreateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_UpdateConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).UpdateConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/UpdateConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).UpdateConnectionProfile(ctx, req.(*UpdateConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataMigrationService_DeleteConnectionProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConnectionProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataMigrationServiceServer).DeleteConnectionProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.clouddms.v1.DataMigrationService/DeleteConnectionProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataMigrationServiceServer).DeleteConnectionProfile(ctx, req.(*DeleteConnectionProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataMigrationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.clouddms.v1.DataMigrationService",
	HandlerType: (*DataMigrationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMigrationJobs",
			Handler:    _DataMigrationService_ListMigrationJobs_Handler,
		},
		{
			MethodName: "GetMigrationJob",
			Handler:    _DataMigrationService_GetMigrationJob_Handler,
		},
		{
			MethodName: "CreateMigrationJob",
			Handler:    _DataMigrationService_CreateMigrationJob_Handler,
		},
		{
			MethodName: "UpdateMigrationJob",
			Handler:    _DataMigrationService_UpdateMigrationJob_Handler,
		},
		{
			MethodName: "DeleteMigrationJob",
			Handler:    _DataMigrationService_DeleteMigrationJob_Handler,
		},
		{
			MethodName: "StartMigrationJob",
			Handler:    _DataMigrationService_StartMigrationJob_Handler,
		},
		{
			MethodName: "StopMigrationJob",
			Handler:    _DataMigrationService_StopMigrationJob_Handler,
		},
		{
			MethodName: "ResumeMigrationJob",
			Handler:    _DataMigrationService_ResumeMigrationJob_Handler,
		},
		{
			MethodName: "PromoteMigrationJob",
			Handler:    _DataMigrationService_PromoteMigrationJob_Handler,
		},
		{
			MethodName: "VerifyMigrationJob",
			Handler:    _DataMigrationService_VerifyMigrationJob_Handler,
		},
		{
			MethodName: "RestartMigrationJob",
			Handler:    _DataMigrationService_RestartMigrationJob_Handler,
		},
		{
			MethodName: "GenerateSshScript",
			Handler:    _DataMigrationService_GenerateSshScript_Handler,
		},
		{
			MethodName: "ListConnectionProfiles",
			Handler:    _DataMigrationService_ListConnectionProfiles_Handler,
		},
		{
			MethodName: "GetConnectionProfile",
			Handler:    _DataMigrationService_GetConnectionProfile_Handler,
		},
		{
			MethodName: "CreateConnectionProfile",
			Handler:    _DataMigrationService_CreateConnectionProfile_Handler,
		},
		{
			MethodName: "UpdateConnectionProfile",
			Handler:    _DataMigrationService_UpdateConnectionProfile_Handler,
		},
		{
			MethodName: "DeleteConnectionProfile",
			Handler:    _DataMigrationService_DeleteConnectionProfile_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/clouddms/v1/clouddms.proto",
}
