#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2020 Hoël Bézier <hoelbezier@riseup.net>
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Oxenfree
# send your bug reports to bugs@dotslashplay.it
###

script_version=20240915.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='oxenfree'
GAME_NAME='Oxenfree'

ARCHIVE_BASE_GOG_1_NAME='oxenfree_2_7_1_27542.sh'
ARCHIVE_BASE_GOG_1_MD5='d1571d0af998fafcf26d628b3be13537'
ARCHIVE_BASE_GOG_1_SIZE='3000000'
ARCHIVE_BASE_GOG_1_VERSION='2.7.1f8-gog27542'
ARCHIVE_BASE_GOG_1_URL='https://www.gog.com/game/oxenfree'

ARCHIVE_BASE_GOG_0_NAME='oxenfree_en_2_6_0_15278.sh'
ARCHIVE_BASE_GOG_0_MD5='9f9e9c4a3f4b73fa85a8d29714f5959e'
ARCHIVE_BASE_GOG_0_SIZE='3000000'
ARCHIVE_BASE_GOG_0_VERSION='2.6.0f30-gog15278'

## Oxenfree is no longer available for sale from itch.io
## cf. https://www.gamingonlinux.com/2024/09/oxenfree-is-being-completely-removed-from-itchio-in-october/
ARCHIVE_BASE_ITCH_0_NAME='oxenfree-release-linux.zip'
ARCHIVE_BASE_ITCH_0_MD5='54469a9bf98bc08125e69fc4612f390b'
ARCHIVE_BASE_ITCH_0_SIZE='3000000'
ARCHIVE_BASE_ITCH_0_VERSION='2.7.1f8-itch.2020.06.05'

UNITY3D_NAME='Oxenfree'
UNITY3D_PLUGINS='
ScreenSelector.so'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_ITCH='Oxenfree_2.7.1_Linux-Uni-NoSteam_20190208_008'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN64_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN32_DEPENDENCIES_SIBLINGS="$PKG_BIN_DEPENDENCIES_SIBLINGS"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
