/*
 * Copyright (c) 2007, 2008, 2009, Czirkos Zoltan <cirix@fw.hu>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "main_bd.h"


// some cells are created inside the game (by merging two cells from the png etc);
// those are used only in the editor.
// this enum is used to give each and every one a different index automatically.
enum _generated_cells_indexes
{
  // the first one gets the first available index.
  // the following ones will be generated by the compiler automatically.
  i_stonefly_1 = GD_NUM_OF_CELLS_X * GD_NUM_OF_CELLS_Y,
  i_stonefly_2,
  i_stonefly_3,
  i_stonefly_4,
  i_alt_firefly_1,
  i_alt_firefly_2,
  i_alt_firefly_3,
  i_alt_firefly_4,
  i_steel_eatable,
  i_brick_eatable,
  i_dirt_glued,
  i_diamond_glued,
  i_stone_glued,
  i_falling_wall,
  i_falling_wall_falling,
  i_expanding_wall,
  i_h_expanding_wall,
  i_v_expanding_wall,
  i_expanding_steel_wall,
  i_h_expanding_steel_wall,
  i_v_expanding_steel_wall,
  i_mega_stone_falling,
  i_light_stone_falling,
  i_time_penalty,
  i_biter_1,
  i_biter_2,
  i_biter_3,
  i_biter_4,
  i_cow_1,
  i_cow_2,
  i_cow_3,
  i_cow_4,
  i_firefly_1,
  i_firefly_2,
  i_firefly_3,
  i_firefly_4,
  i_butter_1,
  i_butter_2,
  i_butter_3,
  i_butter_4,
  i_dragonfly_1,
  i_dragonfly_2,
  i_dragonfly_3,
  i_dragonfly_4,
  i_cow_enclosed,
  i_pre_outbox_nonblink,
  i_invis_outbox,
  i_brick_non_sloped,
  i_outbox,
  i_stone_f,
  i_flying_stone_f,
  i_diamond_f,
  i_flying_diamond_f,
  i_pre_invis_outbox,
  i_unknown,
  i_waiting_stone,
  i_pre_outbox_frame_1,    // this will have 8 frames.
  i_pre_outbox_frame_2,
  i_pre_outbox_frame_3,
  i_pre_outbox_frame_4,
  i_pre_outbox_frame_5,
  i_pre_outbox_frame_6,
  i_pre_outbox_frame_7,
  i_pre_outbox_frame_8,
  i_nitro_pack_f,
  i_alt_butter_1,
  i_alt_butter_2,
  i_alt_butter_3,
  i_alt_butter_4,
  i_conveyor_left,
  i_conveyor_right,
  i_nitro_explode,
  i_walled_diamond,
  i_walled_key_1,
  i_walled_key_2,
  i_walled_key_3,
  i_player,
  i_player_glued,
  i_nut_f,

  i_max_cell_num
};

/*
  elements description array. do not miss an index!
  the game will check if one is missing and stop the game.
  the identifier in the saved file might also not match, reading an "outbox" from
  the file should store an O_PRE_OUTBOX.

  images are: image in editor, image in editor - animated, game image
  indexes which are in the png have to be given as numeric constants.
  for generated cells (ie. firefly + an arrow), use the above enum
*/
GdElementProperty gd_element_properties[] =
{
  {
    O_SPACE, O_SPACE, N_("Space"),
    P_AMOEBA_CONSUMES | P_WALKABLE,
    "SPACE", ' ', 0, 0, 0
  },
  {
    O_DIRT, O_DIRT, N_("Dirt"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT", '.', 2, 2, 2
  },
  {
    O_DIRT_CRUMBLED, O_DIRT_CRUMBLED, N_("Dirt (crumbled)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_CRUMBLED", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_LEFT, O_DIRT_DIGGING_LEFT, N_("Dirt (digging left)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_LEFT", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_RIGHT, O_DIRT_DIGGING_RIGHT, N_("Dirt (digging right)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_RIGHT", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_UP, O_DIRT_DIGGING_UP, N_("Dirt (digging up)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_UP", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_DOWN, O_DIRT_DIGGING_DOWN, N_("Dirt (digging down)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_LEFT_CRUMBLED, O_DIRT_DIGGING_LEFT_CRUMBLED, N_("Dirt (digging left, crumbled)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_LEFT_CRUMBLED", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_RIGHT_CRUMBLED, O_DIRT_DIGGING_RIGHT_CRUMBLED, N_("Dirt (digging right, crumbled)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_RIGHT_CRUMBLED", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_UP_CRUMBLED, O_DIRT_DIGGING_UP_CRUMBLED, N_("Dirt (digging up, crumbled)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_UP_CRUMBLED", 0, 2, 2, 2
  },
  {
    O_DIRT_DIGGING_DOWN_CRUMBLED, O_DIRT_DIGGING_DOWN_CRUMBLED, N_("Dirt (digging down, crumbled)"),
    P_AMOEBA_CONSUMES | P_VISUAL_EFFECT | P_DIRT | P_DIGGABLE,
    "DIRT_DIGGING_DOWN_CRUMBLED", 0, 2, 2, 2
  },
  {
    O_DIRT_SLOPED_UP_RIGHT, O_DIRT_SLOPED_UP_RIGHT, N_("Sloped dirt (up & right)"),
    P_DIRT | P_SLOPED_UP | P_SLOPED_RIGHT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDUPRIGHT", 0, 280, 280, 280
  },
  {
    O_DIRT_SLOPED_UP_LEFT, O_DIRT_SLOPED_UP_LEFT, N_("Sloped dirt (up & left)"),
    P_DIRT | P_SLOPED_UP | P_SLOPED_LEFT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDUPLEFT", 0, 281, 281, 281
  },
  {
    O_DIRT_SLOPED_DOWN_LEFT, O_DIRT_SLOPED_DOWN_LEFT, N_("Sloped dirt (down & left)"),
    P_DIRT | P_SLOPED_DOWN | P_SLOPED_LEFT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDDOWNLEFT", 0, 282, 282, 282
  },
  {
    O_DIRT_SLOPED_DOWN_RIGHT, O_DIRT_SLOPED_DOWN_RIGHT, N_("Sloped dirt (down & right)"),
    P_DIRT | P_SLOPED_DOWN | P_SLOPED_RIGHT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDDOWNRIGHT", 0, 283, 283, 283
  },
  {
    O_DIRT_SLOPED_UP_RIGHT_CRUMBLED, O_DIRT_SLOPED_UP_RIGHT_CRUMBLED, N_("Sloped dirt (up & right, crumbled)"),
    P_DIRT | P_SLOPED_UP | P_SLOPED_RIGHT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDUPRIGHT_CRUMBLED", 0, 280, 280, 280
  },
  {
    O_DIRT_SLOPED_UP_LEFT_CRUMBLED, O_DIRT_SLOPED_UP_LEFT_CRUMBLED, N_("Sloped dirt (up & left, crumbled)"),
    P_DIRT | P_SLOPED_UP | P_SLOPED_LEFT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDUPLEFT_CRUMBLED", 0, 281, 281, 281
  },
  {
    O_DIRT_SLOPED_DOWN_LEFT_CRUMBLED, O_DIRT_SLOPED_DOWN_LEFT_CRUMBLED, N_("Sloped dirt (down & left, crumbled)"),
    P_DIRT | P_SLOPED_DOWN | P_SLOPED_LEFT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDDOWNLEFT_CRUMBLED", 0, 282, 282, 282
  },
  {
    O_DIRT_SLOPED_DOWN_RIGHT_CRUMBLED, O_DIRT_SLOPED_DOWN_RIGHT_CRUMBLED, N_("Sloped dirt (down & right, crumbled)"),
    P_DIRT | P_SLOPED_DOWN | P_SLOPED_RIGHT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRTSLOPEDDOWNRIGHT_CRUMBLED", 0, 283, 283, 283
  },
  {
    O_DIRT_BALL, O_DIRT_BALL_scanned, N_("Dirt ball"),
    P_DIRT | P_SLOPED | P_AMOEBA_CONSUMES | P_MOVED_BY_CONVEYOR_TOP | P_DIGGABLE | P_CAN_FALL,
    "DIRTBALL", 0, 289, 289, 289, 120
  },    // has ckdelay
  {
    O_DIRT_BALL_scanned, O_DIRT_BALL, N_("Dirt ball (scanned)"),
    P_SCANNED,
    "SCANN_DIRTBALL", 0, 289, 289, 289
  },
  {
    O_DIRT_BALL_F, O_DIRT_BALL_F_scanned, N_("Dirt ball, falling"),
    P_FALLING | P_DIGGABLE,
    "DIRTBALLf", 0, 289, 289, 289, 120
  },    // has ckdelay
  {
    O_DIRT_BALL_F_scanned, O_DIRT_BALL_F, N_("Dirt ball, falling (scanned)"),
    P_SCANNED,
    "SCANN_DIRTBALLf", 0, 289, 289, 289
  },
  {
    O_DIRT_LOOSE, O_DIRT_LOOSE_scanned, N_("Loose dirt"),
    P_DIRT | P_AMOEBA_CONSUMES | P_MOVED_BY_CONVEYOR_TOP | P_DIGGABLE | P_CAN_FALL,
    "DIRTLOOSE", 0, 352, 352, 352, 60
  },    // has ckdelay
  {
    O_DIRT_LOOSE_scanned, O_DIRT_LOOSE, N_("Loose dirt (scanned)"),
    P_SCANNED,
    "SCANN_DIRTLOOSE", 0, 352, 352, 352
  },
  {
    O_DIRT_LOOSE_F, O_DIRT_LOOSE_F_scanned, N_("Loose dirt, falling"),
    P_FALLING,
    "DIRTLOOSEf", 0, 352, 352, 352, 60
  },    // has ckdelay
  {
    O_DIRT_LOOSE_F_scanned, O_DIRT_LOOSE_F, N_("Loose dirt, falling (scanned)"),
    P_SCANNED,
    "SCANN_DIRTLOOSEf", 0, 352, 352, 352
  },
  {
    O_DIRT2, O_DIRT2, N_("Dirt 2"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2", 0, 3, 3, 3
  },
  {
    O_DIRT2_CRUMBLED, O_DIRT2_CRUMBLED, N_("Dirt 2 (crumbled)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_CRUMBLED", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_LEFT, O_DIRT2_DIGGING_LEFT, N_("Dirt 2 (digging left)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_LEFT", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_RIGHT, O_DIRT2_DIGGING_RIGHT, N_("Dirt 2 (digging right)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_RIGHT", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_UP, O_DIRT2_DIGGING_UP, N_("Dirt 2 (digging up)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_UP", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_DOWN, O_DIRT2_DIGGING_DOWN, N_("Dirt 2 (digging down)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_DOWN", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_LEFT_CRUMBLED, O_DIRT2_DIGGING_LEFT_CRUMBLED, N_("Dirt 2 (digging left, crumbled)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_LEFT_CRUMBLED", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_RIGHT_CRUMBLED, O_DIRT2_DIGGING_RIGHT_CRUMBLED, N_("Dirt 2 (digging right, crumbled)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_RIGHT_CRUMBLED", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_UP_CRUMBLED, O_DIRT2_DIGGING_UP_CRUMBLED, N_("Dirt 2 (digging up, crumbled)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_UP_CRUMBLED", 0, 3, 3, 3
  },
  {
    O_DIRT2_DIGGING_DOWN_CRUMBLED, O_DIRT2_DIGGING_DOWN_CRUMBLED, N_("Dirt 2 (digging down, crumbled)"),
    P_DIRT | P_AMOEBA_CONSUMES | P_DIGGABLE,
    "DIRT2_DIGGING_DOWN_CRUMBLED", 0, 3, 3, 3
  },
  {
    O_BRICK, O_BRICK, N_("Brick wall"),
    P_SLOPED|P_BLADDER_SLOPED|P_CAN_BE_HAMMERED,
    "WALL", 'w', 5, 5, 5
  },
  {
    O_BRICK_SLOPED_UP_RIGHT, O_BRICK_SLOPED_UP_RIGHT, N_("Sloped brick wall (up & right)"),
    P_SLOPED_UP|P_SLOPED_RIGHT|P_BLADDER_SLOPED|P_CAN_BE_HAMMERED,
    "WALLSLOPEDUPRIGHT", 0, 276, 276, 276
  },
  {
    O_BRICK_SLOPED_UP_LEFT, O_BRICK_SLOPED_UP_LEFT, N_("Sloped brick wall (up & left)"),
    P_SLOPED_UP|P_SLOPED_LEFT|P_BLADDER_SLOPED|P_CAN_BE_HAMMERED,
    "WALLSLOPEDUPLEFT", 0, 277, 277, 277
  },
  {
    O_BRICK_SLOPED_DOWN_LEFT, O_BRICK_SLOPED_DOWN_LEFT, N_("Sloped brick wall (down & left)"),
    P_SLOPED_DOWN|P_SLOPED_LEFT|P_BLADDER_SLOPED|P_CAN_BE_HAMMERED,
    "WALLSLOPEDDOWNLEFT", 0, 278, 278, 278
  },
  {
    O_BRICK_SLOPED_DOWN_RIGHT, O_BRICK_SLOPED_DOWN_RIGHT, N_("Sloped brick wall (down & right)"),
    P_SLOPED_DOWN|P_SLOPED_RIGHT|P_BLADDER_SLOPED|P_CAN_BE_HAMMERED,
    "WALLSLOPEDDOWNRIGHT", 0, 279, 279, 279
  },
  {
    O_BRICK_NON_SLOPED, O_BRICK_NON_SLOPED, N_("Non-sloped brick wall"),
    P_CAN_BE_HAMMERED,
    "WALLNONSLOPED", 0, i_brick_non_sloped, i_brick_non_sloped, 5
  },
  {
    O_MAGIC_WALL, O_MAGIC_WALL, N_("Magic wall"),
    P_CAN_BE_HAMMERED,
    "MAGICWALL", 'M', 5, 5, 5
  },
  {
    O_PRE_OUTBOX, O_PRE_OUTBOX, N_("Outbox"),
    0,
    "OUTBOX", 'X', i_pre_outbox_nonblink, -i_pre_outbox_frame_1, 22
  },
  {
    O_OUTBOX, O_OUTBOX, N_("Outbox (open)"),
    0,
    "OUTBOXopen", 0, i_outbox, i_outbox, 22
  },
  {
    O_PRE_INVIS_OUTBOX, O_PRE_INVIS_OUTBOX, N_("Invisible outbox"),
    0,
    "HIDDENOUTBOX", 'H', i_pre_invis_outbox, i_pre_invis_outbox, 22
  },
  {
    O_INVIS_OUTBOX, O_INVIS_OUTBOX, N_("Invisible outbox (open)"),
    0,
    "HIDDENOUTBOXopen", 0, i_invis_outbox, i_invis_outbox, 22
  },
  {
    O_STEEL, O_STEEL, N_("Steel wall"),
    P_NON_EXPLODABLE,
    "STEELWALL", 'W', 4, 4, 4
  },
  {
    O_STEEL_SLOPED_UP_RIGHT, O_STEEL_SLOPED_UP_RIGHT, N_("Sloped steel wall (up & right)"),
    P_SLOPED_UP|P_SLOPED_RIGHT|P_NON_EXPLODABLE,
    "STEELWALLSLOPEDUPRIGHT", 0, 284, 284, 284
  },
  {
    O_STEEL_SLOPED_UP_LEFT, O_STEEL_SLOPED_UP_LEFT, N_("Sloped steel wall (up & left)"),
    P_SLOPED_UP|P_SLOPED_LEFT|P_NON_EXPLODABLE,
    "STEELWALLSLOPEDUPLEFT", 0, 285, 285, 285
  },
  {
    O_STEEL_SLOPED_DOWN_LEFT, O_STEEL_SLOPED_DOWN_LEFT, N_("Sloped steel wall (down & left)"),
    P_SLOPED_DOWN|P_SLOPED_LEFT|P_NON_EXPLODABLE,
    "STEELWALLSLOPEDDOWNLEFT", 0, 286, 286, 286
  },
  {
    O_STEEL_SLOPED_DOWN_RIGHT, O_STEEL_SLOPED_DOWN_RIGHT, N_("Sloped steel wall (down & right)"),
    P_SLOPED_DOWN|P_SLOPED_RIGHT|P_NON_EXPLODABLE,
    "STEELWALLSLOPEDDOWNRIGHT", 0, 287, 287, 287
  },
  {
    O_STEEL_EXPLODABLE, O_STEEL_EXPLODABLE, N_("Explodable steel wall"),
    P_CAN_BE_HAMMERED,
    "STEELWALLDESTRUCTABLE", 'E', 72, 72, 4
  },
  {
    O_STEEL_EATABLE, O_STEEL_EATABLE, N_("Eatable steel wall"),
    P_DIGGABLE,
    "STEELWALLEATABLE", 0, i_steel_eatable, i_steel_eatable, 4
  },
  {
    O_BRICK_EATABLE, O_BRICK_EATABLE, N_("Eatable brick wall"),
    P_DIGGABLE,
    "WALLEATABLE", 0, i_brick_eatable, i_brick_eatable, 5
  },
  {
    O_STONE, O_STONE_scanned, N_("Stone"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_TOP | P_PUSHABLE | P_CAN_FALL,
    "BOULDER", 'r', 1, 1, 1, 156
  },    // has ckdelay
  {
    O_STONE_scanned, O_STONE, N_("Stone (scanned)"),
    P_SCANNED,
    "SCANN_BOULDER", 0, 1, 1, 1
  },
  {
    O_STONE_F, O_STONE_F_scanned, N_("Stone, falling"),
    P_FALLING,
    "BOULDERf", 'R', i_stone_f, i_stone_f, 1, 156
  },    // has ckdelay
  {
    O_STONE_F_scanned, O_STONE_F, N_("Stone, falling (scanned)"),
    P_SCANNED,
    "SCANN_BOULDERf", 0, i_stone_f, i_stone_f, 1
  },
  {
    O_FLYING_STONE, O_FLYING_STONE_scanned, N_("Flying stone"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_BOTTOM | P_PUSHABLE | P_CAN_FALL,
    "FLYINGBOULDER", 0, 357, 357, 357, 156
  },    // has ckdelay
  {
    O_FLYING_STONE_scanned, O_FLYING_STONE, N_("Flying stone (scanned)"),
    P_SCANNED,
    "SCANN_FLYINGBOULDER", 0, 357, 357, 357
  },
  {
    O_FLYING_STONE_F, O_FLYING_STONE_F_scanned, N_("Flying stone, flying"),
    P_FALLING,
    "FLYINGBOULDERf", 0, i_flying_stone_f, i_flying_stone_f, 357, 156
  },    // has ckdelay
  {
    O_FLYING_STONE_F_scanned, O_FLYING_STONE_F, N_("Flying stone, flying (scanned)"),
    P_SCANNED,
    "SCANN_FLYINGBOULDERf", 0, i_flying_stone_f, i_flying_stone_f, 357
  },
  {
    O_MEGA_STONE, O_MEGA_STONE_scanned, N_("Mega stone"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_TOP | P_PUSHABLE | P_CAN_FALL,
    "MEGABOULDER", 0, 272, 272, 272, 156
  },    // has ckdelay
  {
    O_MEGA_STONE_scanned, O_MEGA_STONE, N_("Mega stone (scanned)"),
    P_SCANNED,
    "SCANN_MEGABOULDER", 0, 272, 272, 272
  },
  {
    O_MEGA_STONE_F, O_MEGA_STONE_F_scanned, N_("Mega stone, falling"),
    P_FALLING,
    "MEGABOULDERf", 0, i_mega_stone_falling, i_mega_stone_falling, 272, 156
  },    // has ckdelay
  {
    O_MEGA_STONE_F_scanned, O_MEGA_STONE_F, N_("Mega stone, falling (scanned)"),
    P_SCANNED,
    "SCANN_MEGABOULDERf", 0, i_mega_stone_falling, i_mega_stone_falling, 272
  },
  {
    O_LIGHT_STONE, O_LIGHT_STONE_scanned, N_("Light stone"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_TOP | P_PUSHABLE | P_CAN_FALL,
    "LIGHTBOULDER", 0, 359, 359, 359, 156
  },    // has ckdelay
  {
    O_LIGHT_STONE_scanned, O_LIGHT_STONE, N_("Light stone (scanned)"),
    P_SCANNED,
    "SCANN_LIGHTBOULDER", 0, 359, 359, 359
  },
  {
    O_LIGHT_STONE_F, O_LIGHT_STONE_F_scanned, N_("Light stone, falling"),
    P_FALLING,
    "LIGHTBOULDERf", 0, i_light_stone_falling, i_light_stone_falling, 359, 156
  },    // has ckdelay
  {
    O_LIGHT_STONE_F_scanned, O_LIGHT_STONE_F, N_("Light stone, falling (scanned)"),
    P_SCANNED,
    "SCANN_LIGHTBOULDERf", 0, i_light_stone_falling, i_light_stone_falling, 359
  },
  {
    O_DIAMOND, O_DIAMOND_scanned, N_("Diamond"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_TOP | P_COLLECTIBLE | P_CAN_FALL,
    "DIAMOND", 'd', 248, -248, -248, 156
  },    // has ckdelay
  {
    O_DIAMOND_scanned, O_DIAMOND, N_("Diamond (scanned)"),
    P_SCANNED,
    "SCANN_DIAMOND", 0, 248, -248, -248
  },
  {
    O_DIAMOND_F, O_DIAMOND_F_scanned, N_("Diamond, falling"),
    P_FALLING,
    "DIAMONDf", 'D', i_diamond_f, i_diamond_f, -248, 156
  },    // has ckdelay
  {
    O_DIAMOND_F_scanned, O_DIAMOND_F, N_("Diamond, falling (scanned)"),
    P_SCANNED,
    "SCANN_DIAMONDf", 0, i_diamond_f, i_diamond_f, -248
  },
  {
    O_FLYING_DIAMOND, O_FLYING_DIAMOND_scanned, N_("Flying diamond"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_BOTTOM | P_COLLECTIBLE | P_CAN_FALL,
    "FLYINGDIAMOND", 0, 344, -344, -344, 156
  },    // has ckdelay
  {
    O_FLYING_DIAMOND_scanned, O_FLYING_DIAMOND, N_("Flying diamond (scanned)"),
    P_SCANNED,
    "SCANN_FLYINGDIAMOND", 0, 344, -344, -344
  },
  {
    O_FLYING_DIAMOND_F, O_FLYING_DIAMOND_F_scanned, N_("Flying diamond, flying"),
    P_FALLING,
    "FLYINGDIAMONDf", 0, i_flying_diamond_f, i_flying_diamond_f, -344, 156
  },    // has ckdelay
  {
    O_FLYING_DIAMOND_F_scanned, O_FLYING_DIAMOND_F, N_("Flying diamond, flying (scanned)"),
    P_SCANNED,
    "SCANN_FLYINGDIAMONDf", 0, i_flying_diamond_f, i_flying_diamond_f, -344
  },
  {
    O_NUT, O_NUT_scanned, N_("Nut"),
    P_SLOPED | P_MOVED_BY_CONVEYOR_TOP | P_PUSHABLE | P_CAN_FALL,
    "NUT", 0, 358, 358, 358, 156
  },    // has ckdelay
  {
    O_NUT_scanned, O_NUT, N_("Nut (scanned)"),
    P_SCANNED,
    "SCANN_NUT", 0, 358, 358, 358
  },
  {
    O_NUT_F, O_NUT_F_scanned, N_("Nut, falling"),
    P_FALLING,
    "NUTf", 0, i_nut_f, i_nut_f, 358, 156
  },    // has ckdelay
  {
    O_NUT_F_scanned, O_NUT_F, N_("Nut, falling (scanned)"),
    P_SCANNED,
    "SCANN_NUTf", 0, i_nut_f, i_nut_f, 358
  },
  {
    O_BLADDER_SPENDER, O_BLADDER_SPENDER, N_("Bladder Spender"),
    P_PUSHABLE,
    "BLADDERSPENDER", 0, 6, 6, 6, 20
  },    // has ckdelay
  {
    O_INBOX, O_INBOX, N_("Inbox"),
    0,
    "INBOX", 'P', 35, 35, 22
  },
  {
    O_H_EXPANDING_WALL, O_H_EXPANDING_WALL_scanned, N_("Expanding wall, horizontal"),
    P_VISUAL_EFFECT | P_CAN_BE_HAMMERED | P_CAN_GROW,
    "HEXPANDINGWALL", 'x', i_h_expanding_wall, i_h_expanding_wall, 5, 111
  },    // has ckdelay
  {
    O_H_EXPANDING_WALL_scanned, O_H_EXPANDING_WALL, N_("Expanding wall, horizontal (scanned)"),
    P_SCANNED,
    "SCANN_HEXPANDINGWALL", 0, i_h_expanding_wall, i_h_expanding_wall, 5
  },
  {
    O_V_EXPANDING_WALL, O_V_EXPANDING_WALL_scanned, N_("Expanding wall, vertical"),
    P_VISUAL_EFFECT | P_CAN_BE_HAMMERED | P_CAN_GROW,
    "VEXPANDINGWALL", 'v', i_v_expanding_wall, i_v_expanding_wall, 5, 111
  },    // has ckdelay
  {
    O_V_EXPANDING_WALL_scanned, O_V_EXPANDING_WALL, N_("Expanding wall, vertical (scanned)"),
    P_SCANNED,
    "SCANN_VEXPANDINGWALL", 0, i_v_expanding_wall, i_v_expanding_wall, 5
  },
  {
    O_EXPANDING_WALL, O_EXPANDING_WALL_scanned, N_("Expanding wall"),
    P_VISUAL_EFFECT | P_CAN_BE_HAMMERED | P_CAN_GROW,
    "EXPANDINGWALL", 'e', i_expanding_wall, i_expanding_wall, 5, 111
  },    // has ckdelay
  {
    O_EXPANDING_WALL_scanned, O_EXPANDING_WALL, N_("Expanding wall (scanned)"),
    P_SCANNED,
    "SCANN_EXPANDINGWALL", 0, i_expanding_wall, i_expanding_wall, 5
  },
  {
    O_H_EXPANDING_STEEL_WALL, O_H_EXPANDING_STEEL_WALL_scanned, N_("Expanding steel wall, horizontal"),
    P_NON_EXPLODABLE | P_CAN_GROW,
    "HEXPANDINGSTEELWALL", 0, i_h_expanding_steel_wall, i_h_expanding_steel_wall, 4, 111
  },    // has ckdelay
  {
    O_H_EXPANDING_STEEL_WALL_scanned, O_H_EXPANDING_STEEL_WALL, N_("Expanding steel wall, horizontal (scanned)"),
    P_SCANNED | P_NON_EXPLODABLE,
    "SCANN_HEXPANDINGSTEELWALL", 0, i_h_expanding_steel_wall, i_h_expanding_steel_wall, 4
  },
  {
    O_V_EXPANDING_STEEL_WALL, O_V_EXPANDING_STEEL_WALL_scanned, N_("Expanding steel wall, vertical"),
    P_NON_EXPLODABLE | P_CAN_GROW,
    "VEXPANDINGSTEELWALL", 0, i_v_expanding_steel_wall, i_v_expanding_steel_wall, 4, 111
  },    // has ckdelay
  {
    O_V_EXPANDING_STEEL_WALL_scanned, O_V_EXPANDING_STEEL_WALL, N_("Expanding steel wall, vertical (scanned)"),
    P_SCANNED | P_NON_EXPLODABLE,
    "SCANN_VEXPANDINGSTEELWALL", 0, i_v_expanding_steel_wall, i_v_expanding_steel_wall, 4
  },
  {
    O_EXPANDING_STEEL_WALL, O_EXPANDING_STEEL_WALL_scanned, N_("Expanding steel wall"),
    P_NON_EXPLODABLE | P_CAN_GROW,
    "EXPANDINGSTEELWALL", 0, i_expanding_steel_wall, i_expanding_steel_wall, 4, 111
  },    // has ckdelay
  {
    O_EXPANDING_STEEL_WALL_scanned, O_EXPANDING_STEEL_WALL, N_("Expanding steel wall (scanned)"),
    P_SCANNED | P_NON_EXPLODABLE,
    "SCANN_EXPANDINGSTEELWALL", 0, i_expanding_steel_wall, i_expanding_steel_wall, 4
  },
  {
    O_EXPANDING_WALL_SWITCH, O_EXPANDING_WALL_SWITCH, N_("Expanding wall switch"),
    0,
    "EXPANDINGWALLSWITCH", 0, 40, 40, 40
  },
  {
    O_CREATURE_SWITCH, O_CREATURE_SWITCH, N_("Creature direction switch"),
    0,
    "FIREFLYBUTTERFLYSWITCH", 0, 18, 18, 18
  },
  {
    O_BITER_SWITCH, O_BITER_SWITCH, N_("Biter switch"),
    0,
    "BITERSWITCH", 0, 12, 12, 12
  },
  {
    O_REPLICATOR_SWITCH, O_REPLICATOR_SWITCH, N_("Replicator switch"),
    0,
    "REPLICATORSWITCH", 0, 290, 290, 290
  },
  {
    O_CONVEYOR_SWITCH, O_CONVEYOR_SWITCH, N_("Conveyor belt power switch"),
    0,
    "CONVEYORSWITCH", 0, 356, 356, 356
  },
  {
    O_CONVEYOR_DIR_SWITCH, O_CONVEYOR_DIR_SWITCH, N_("Conveyor belt direction switch"),
    0,
    "CONVEYORDIRECTIONSWITCH", 0, 353, 353, 353
  },
  {
    O_ACID, O_ACID_scanned, N_("Acid"),
    0,
    "ACID", 0, 20, 20, 20, 128
  },    // has ckdelay
  {
    O_ACID_scanned, O_ACID, N_("Acid (scanned)"),
    P_SCANNED,
    "SCANN_ACID", 0, 20, 20, 20
  },
  {
    O_FALLING_WALL, O_FALLING_WALL, N_("Falling wall"),
    P_CAN_BE_HAMMERED | P_CAN_FALL,
    "FALLINGWALL", 0, i_falling_wall, i_falling_wall, 5, 80
  },    // has ckdelay
  {
    O_FALLING_WALL_F, O_FALLING_WALL_F_scanned, N_("Falling wall, falling"),
    P_CAN_BE_HAMMERED | P_FALLING,
    "FALLINGWALLf", 0, i_falling_wall_falling, i_falling_wall_falling, 5, 80
  },    // has ckdelay
  {
    O_FALLING_WALL_F_scanned, O_FALLING_WALL_F, N_("Falling wall, falling (scanned)"),
    P_SCANNED,
    "SCANN_FALLINGWALLf", 0, i_falling_wall_falling, i_falling_wall_falling, 5
  },
  {
    O_BOX, O_BOX, N_("Box"),
    P_PUSHABLE,
    "SOKOBANBOX", 0, 21, 21, 21
  },
  {
    O_TIME_PENALTY, O_TIME_PENALTY, N_("Time penalty"),
    P_NON_EXPLODABLE,
    "TIMEPENALTY", 0, i_time_penalty, i_time_penalty, 9
  },
  {
    O_GRAVESTONE, O_GRAVESTONE, N_("Gravestone"),
    P_NON_EXPLODABLE,
    "GRAVESTONE", 'G', 9, 9, 9
  },
  {
    O_STONE_GLUED, O_STONE_GLUED, N_("Glued stone"),
    P_SLOPED,
    "GLUEDBOULDER", 0, i_stone_glued, i_stone_glued, 1
  },
  {
    O_DIAMOND_GLUED, O_DIAMOND_GLUED, N_("Glued diamond"),
    P_SLOPED,
    "GLUEDDIAMOND", 0, i_diamond_glued, i_diamond_glued, -248
  },
  {
    O_DIAMOND_KEY, O_DIAMOND_KEY, N_("Diamond key"),
    P_COLLECTIBLE,
    "DIAMONDRELEASEKEY", 0, 11, 11, 11
  },
  {
    O_TRAPPED_DIAMOND, O_TRAPPED_DIAMOND, N_("Trapped diamond"),
    P_NON_EXPLODABLE,
    "TRAPPEDDIAMOND", 0, 10, 10, 10
  },
  {
    O_CLOCK, O_CLOCK, N_("Clock"),
    P_COLLECTIBLE,
    "CLOCK", 0, 16, 16, 16
  },
  {
    O_DIRT_GLUED, O_DIRT_GLUED, N_("Glued dirt"),
    0,
    "GLUEDDIRT", 0, i_dirt_glued, i_dirt_glued, 2
  },
  {
    O_DIRT_GLUED_CRUMBLED, O_DIRT_GLUED_CRUMBLED, N_("Glued dirt (crumbled)"),
    0,
    "GLUEDDIRT_CRUMBLED", 0, i_dirt_glued, i_dirt_glued, 2
  },
  {
    O_KEY_1, O_KEY_1, N_("Key 1"),
    P_COLLECTIBLE,
    "KEY1", 0, 67, 67, 67
  },
  {
    O_KEY_2, O_KEY_2, N_("Key 2"),
    P_COLLECTIBLE,
    "KEY2", 0, 68, 68, 68
  },
  {
    O_KEY_3, O_KEY_3, N_("Key 3"),
    P_COLLECTIBLE,
    "KEY3", 0, 69, 69, 69
  },
  {
    O_DOOR_1, O_DOOR_1, N_("Door 1"),
    0,
    "DOOR1", 0, 64, 64, 64
  },
  {
    O_DOOR_2, O_DOOR_2, N_("Door 2"),
    0,
    "DOOR2", 0, 65, 65, 65
  },
  {
    O_DOOR_3, O_DOOR_3, N_("Door 3"),
    0,
    "DOOR3", 0, 66, 66, 66
  },

  {
    O_POT, O_POT, N_("Pot"),
    0,
    "POT", 0, 63, 63, 63
  },
  {
    O_GRAVITY_SWITCH, O_GRAVITY_SWITCH, N_("Gravity switch"),
    0,
    "GRAVITY_SWITCH", 0, 274, 274, 274
  },
  {
    O_PNEUMATIC_HAMMER, O_PNEUMATIC_HAMMER, N_("Pneumatic hammer"),
    P_COLLECTIBLE,
    "PNEUMATIC_HAMMER", 0, 62, 62, 62
  },
  {
    O_TELEPORTER, O_TELEPORTER, N_("Teleporter"),
    P_WALKABLE,
    "TELEPORTER", 0, 61, 61, 61
  },
  {
    O_SKELETON, O_SKELETON, N_("Skeleton"),
    0,
    "SKELETON", 0, 273, 273, 273
  },
  {
    O_WATER, O_WATER, N_("Water"),
    0,
    "WATER", 0, 96, -96, -96, 100
  },    // has ckdelay
  {
    O_WATER_1, O_WATER_1, N_("Water (1)"),
    0,
    "WATER1", 0, 96, -96, -96
  },
  {
    O_WATER_2, O_WATER_2, N_("Water (2)"),
    0,
    "WATER2", 0, 96, -96, -96
  },
  {
    O_WATER_3, O_WATER_3, N_("Water (3)"),
    0,
    "WATER3", 0, 96, -96, -96
  },
  {
    O_WATER_4, O_WATER_4, N_("Water (4)"),
    0,
    "WATER4", 0, 96, -96, -96
  },
  {
    O_WATER_5, O_WATER_5, N_("Water (5)"),
    0,
    "WATER5", 0, 96, -96, -96
  },
  {
    O_WATER_6, O_WATER_6, N_("Water (6)"),
    0,
    "WATER6", 0, 96, -96, -96
  },
  {
    O_WATER_7, O_WATER_7, N_("Water (7)"),
    0,
    "WATER7", 0, 96, -96, -96
  },
  {
    O_WATER_8, O_WATER_8, N_("Water (8)"),
    0,
    "WATER8", 0, 96, -96, -96
  },
  {
    O_WATER_9, O_WATER_9, N_("Water (9)"),
    0,
    "WATER9", 0, 96, -96, -96
  },
  {
    O_WATER_10, O_WATER_10, N_("Water (10)"),
    0,
    "WATER10", 0, 96, -96, -96
  },
  {
    O_WATER_11, O_WATER_11, N_("Water (11)"),
    0,
    "WATER11", 0, 96, -96, -96
  },
  {
    O_WATER_12, O_WATER_12, N_("Water (12)"),
    0,
    "WATER12", 0, 96, -96, -96
  },
  {
    O_WATER_13, O_WATER_13, N_("Water (13)"),
    0,
    "WATER13", 0, 96, -96, -96
  },
  {
    O_WATER_14, O_WATER_14, N_("Water (14)"),
    0,
    "WATER14", 0, 96, -96, -96
  },
  {
    O_WATER_15, O_WATER_15, N_("Water (15)"),
    0,
    "WATER15", 0, 96, -96, -96
  },
  {
    O_WATER_16, O_WATER_16, N_("Water (16)"),
    0,
    "WATER16", 0, 96, -96, -96
  },
  {
    O_COW, O_COW, N_("Cow (internal)"),
    0,
    "COW", 0, 0, 0, 0,
  },
  {
    O_COW_1, O_COW_1_scanned, N_("Cow (left)"),
    P_CCW | P_CAN_MOVE,
    "COWl", 0, i_cow_1, -88, -88, 384
  },    // has ckdelay
  {
    O_COW_2, O_COW_2_scanned, N_("Cow (up)"),
    P_CCW | P_CAN_MOVE,
    "COWu", 0, i_cow_2, -88, -88, 384
  },    // has ckdelay
  {
    O_COW_3, O_COW_3_scanned, N_("Cow (right)"),
    P_CCW | P_CAN_MOVE,
    "COWr", 0, i_cow_3, -88, -88, 384
  },   // has ckdelay
  {
    O_COW_4, O_COW_4_scanned, N_("Cow (down)"),
    P_CCW | P_CAN_MOVE,
    "COWd", 0, i_cow_4, -88, -88, 384
  },    // has ckdelay
  {
    O_COW_1_scanned, O_COW_1, N_("Cow (left) (scanned)"),
    P_SCANNED,
    "SCANN_COWl", 0, i_cow_1, -88, -88
  },
  {
    O_COW_2_scanned, O_COW_2, N_("Cow (up) (scanned)"),
    P_SCANNED,
    "SCANN_COWu", 0, i_cow_2, -88, -88
  },
  {
    O_COW_3_scanned, O_COW_3, N_("Cow (right) (scanned)"),
    P_SCANNED,
    "SCANN_COWr", 0, i_cow_3, -88, -88
  },
  {
    O_COW_4_scanned, O_COW_4, N_("Cow (down) (scanned)"),
    P_SCANNED,
    "SCANN_COWd", 0, i_cow_4, -88, -88
  },
  {
    O_COW_ENCLOSED_1, O_COW_ENCLOSED_1, N_("Cow (enclosed, 1)"),
    0,
    "COW_ENCLOSED1", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_COW_ENCLOSED_2, O_COW_ENCLOSED_2, N_("Cow (enclosed, 2)"),
    0,
    "COW_ENCLOSED2", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_COW_ENCLOSED_3, O_COW_ENCLOSED_3, N_("Cow (enclosed, 3)"),
    0,
    "COW_ENCLOSED3", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_COW_ENCLOSED_4, O_COW_ENCLOSED_4, N_("Cow (enclosed, 4)"),
    0,
    "COW_ENCLOSED4", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_COW_ENCLOSED_5, O_COW_ENCLOSED_5, N_("Cow (enclosed, 5)"),
    0,
    "COW_ENCLOSED5", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_COW_ENCLOSED_6, O_COW_ENCLOSED_6, N_("Cow (enclosed, 6)"),
    0,
    "COW_ENCLOSED6", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_COW_ENCLOSED_7, O_COW_ENCLOSED_7, N_("Cow (enclosed, 7)"),
    0,
    "COW_ENCLOSED7", 0, i_cow_enclosed, -88, -88, 120
  },    // has ckdelay
  {
    O_WALLED_DIAMOND, O_WALLED_DIAMOND, N_("Walled diamond"),
    P_CAN_BE_HAMMERED,
    "WALLED_DIAMOND", 0, i_walled_diamond, i_walled_diamond, 5
  },
  {
    O_WALLED_KEY_1, O_WALLED_KEY_1, N_("Walled key 1"),
    P_CAN_BE_HAMMERED,
    "WALLED_KEY1", 0, i_walled_key_1, i_walled_key_1, 5
  },
  {
    O_WALLED_KEY_2, O_WALLED_KEY_2, N_("Walled key 2"),
    P_CAN_BE_HAMMERED,
    "WALLED_KEY2", 0, i_walled_key_2, i_walled_key_2, 5
  },
  {
    O_WALLED_KEY_3, O_WALLED_KEY_3, N_("Walled key 3"),
    P_CAN_BE_HAMMERED,
    "WALLED_KEY3", 0, i_walled_key_3, i_walled_key_3, 5
  },

  {
    O_AMOEBA, O_AMOEBA_scanned, N_("Amoeba"),
    P_BLOWS_UP_FLIES | P_CAN_GROW | P_CAN_DIG,
    "AMOEBA", 'a', 192, -192, -192, 260
  },    // has ckdelay
  {
    O_AMOEBA_scanned, O_AMOEBA, N_("Amoeba (scanned)"),
    P_SCANNED,
    "SCANN_AMOEBA", 0, 192, -192, -192
  },
  {
    O_AMOEBA_2, O_AMOEBA_2_scanned, N_("Amoeba 2"),
    P_BLOWS_UP_FLIES | P_CAN_GROW | P_CAN_DIG | P_VISUAL_EFFECT,
    "AMOEBA2", 0, 296, -296, -296, 260
  },    // has ckdelay
  {
    O_AMOEBA_2_scanned, O_AMOEBA_2, N_("Amoeba 2 (scanned)"),
    P_SCANNED,
    "SCANN_AMOEBA2", 0, 296, -296, -296
  },
  {
    O_REPLICATOR, O_REPLICATOR, N_("Replicator"),
    P_NON_EXPLODABLE,
    "REPLICATOR", 0, 304, -304, -304, 210
  },    // has ckdelay
  {
    O_CONVEYOR_LEFT, O_CONVEYOR_LEFT, N_("Conveyor belt (left)"),
    P_NON_EXPLODABLE,
    "CONVEYORLEFT", 0, i_conveyor_left, -328, -328, 256
  },    // has ckdelay
  {
    O_CONVEYOR_RIGHT, O_CONVEYOR_RIGHT, N_("Conveyor belt (right)"),
    P_NON_EXPLODABLE,
    "CONVEYORRIGHT", 0, i_conveyor_right, -320, -320
  },
  {
    O_LAVA, O_LAVA, N_("Lava"),
    P_NON_EXPLODABLE,
    "LAVA", 0, 312, -312, -312
  },
  {
    O_SWEET, O_SWEET, N_("Sweet"),
    P_COLLECTIBLE,
    "SWEET", 0, 8, 8, 8
  },
  {
    O_VOODOO, O_VOODOO, N_("Voodoo doll"),
    P_BLOWS_UP_FLIES,
    "DUMMY", 'F', 7, 7, 7
  },
  {
    O_SLIME, O_SLIME, N_("Slime"),
    0,
    "SLIME", 's', 200, -200, -200, 211
  },    // has ckdelay
  {
    O_BLADDER, O_BLADDER, N_("Bladder"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDER", 0, 176, -176, -176, 267
  },    // has ckdelay
  {
    O_BLADDER_1, O_BLADDER_1, N_("Bladder (1)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd1", 0, 176, -176, -176
  },
  {
    O_BLADDER_2, O_BLADDER_2, N_("Bladder (2)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd2", 0, 176, -176, -176
  },
  {
    O_BLADDER_3, O_BLADDER_3, N_("Bladder (3)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd3", 0, 176, -176, -176
  },
  {
    O_BLADDER_4, O_BLADDER_4, N_("Bladder (4)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd4", 0, 176, -176, -176
  },
  {
    O_BLADDER_5, O_BLADDER_5, N_("Bladder (5)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd5", 0, 176, -176, -176
  },
  {
    O_BLADDER_6, O_BLADDER_6, N_("Bladder (6)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd6", 0, 176, -176, -176
  },
  {
    O_BLADDER_7, O_BLADDER_7, N_("Bladder (7)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd7", 0, 176, -176, -176
  },
  {
    O_BLADDER_8, O_BLADDER_8, N_("Bladder (8)"),
    P_PUSHABLE | P_CAN_MOVE,
    "BLADDERd8", 0, 176, -176, -176
  },

  {
    O_WAITING_STONE, O_WAITING_STONE_scanned, N_("Waiting stone"),
    P_SLOPED | P_PUSHABLE,
    "WAITINGBOULDER", 0, i_waiting_stone, i_waiting_stone, 1, 176
  },    // has ckdelay
  {
    O_WAITING_STONE_scanned, O_WAITING_STONE, N_("Waiting stone (scanned)"),
    P_SCANNED,
    "SCANN_WAITINGBOULDER", 0, i_waiting_stone, i_waiting_stone, 1
  },
  {
    O_CHASING_STONE, O_CHASING_STONE_scanned, N_("Chasing stone"),
    P_SLOPED | P_CAN_MOVE | P_PUSHABLE,
    "CHASINGBOULDER", 0, 17, 17, 17, 269
  },    // has ckdelay
  {
    O_CHASING_STONE_scanned, O_CHASING_STONE, N_("Chasing stone (scanned)"),
    P_SCANNED,
    "SCANN_CHASINGBOULDER", 0, 17, 17, 17
  },
  {
    O_GHOST, O_GHOST_scanned, N_("Ghost"),
    P_CAN_MOVE,
    "GHOST", 'g', 160, -160, -160, 50
  },    // has ckdelay
  {
    O_GHOST_scanned, O_GHOST, N_("Ghost (scanned)"),
    P_SCANNED,
    "SCANN_GHOST", 0, 160, -160, -160
  },
  {
    O_FIREFLY, O_FIREFLY, N_("Firefly (internal)"),
    0,
    "FIREFLY", 0, 0, 0, 0,
  },
  {
    O_FIREFLY_1, O_FIREFLY_1_scanned, N_("Firefly, left"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "FIREFLYl", 'Q', i_firefly_1, -136, -136, 384
  },    // has ckdelay
  {
    O_FIREFLY_2, O_FIREFLY_2_scanned, N_("Firefly, up"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "FIREFLYu", 'o', i_firefly_2, -136, -136, 384
  },      // has ckdelay
  {
    O_FIREFLY_3, O_FIREFLY_3_scanned, N_("Firefly, right"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "FIREFLYr", 'O', i_firefly_3, -136, -136, 384
  },   // has ckdelay
  {
    O_FIREFLY_4, O_FIREFLY_4_scanned, N_("Firefly, down"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "FIREFLYd", 'q', i_firefly_4, -136, -136, 384
  },    // has ckdelay
  {
    O_FIREFLY_1_scanned, O_FIREFLY_1, N_("Firefly, left (scanned)"),
    P_SCANNED,
    "SCANN_FIREFLYl", 0, i_firefly_1, -136, -136
  },
  {
    O_FIREFLY_2_scanned, O_FIREFLY_2, N_("Firefly, up (scanned)"),
    P_SCANNED,
    "SCANN_FIREFLYu", 0, i_firefly_2, -136, -136
  },
  {
    O_FIREFLY_3_scanned, O_FIREFLY_3, N_("Firefly, right (scanned)"),
    P_SCANNED,
    "SCANN_FIREFLYr", 0, i_firefly_3, -136, -136
  },
  {
    O_FIREFLY_4_scanned, O_FIREFLY_4, N_("Firefly, down (scanned)"),
    P_SCANNED,
    "SCANN_FIREFLYd", 0, i_firefly_4, -136, -136
  },
  {
    O_ALT_FIREFLY, O_ALT_FIREFLY, N_("Alternative firefly (internal)"),
    0,
    "A_FIREFLY", 0, 0, 0, 0,
  },
  {
    O_ALT_FIREFLY_1, O_ALT_FIREFLY_1_scanned, N_("Alternative firefly, left"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "A_FIREFLYl", 0, i_alt_firefly_1, -104, -104, 384
  },    // has ckdelay
  {
    O_ALT_FIREFLY_2, O_ALT_FIREFLY_2_scanned, N_("Alternative firefly, up"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "A_FIREFLYu", 0, i_alt_firefly_2, -104, -104, 384
  },    // has ckdelay
  {
    O_ALT_FIREFLY_3, O_ALT_FIREFLY_3_scanned, N_("Alternative firefly, right"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "A_FIREFLYr", 0, i_alt_firefly_3, -104, -104, 384
  },    // has ckdelay
  {
    O_ALT_FIREFLY_4, O_ALT_FIREFLY_4_scanned, N_("Alternative firefly, down"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "A_FIREFLYd", 0, i_alt_firefly_4, -104, -104, 384
  },    // has ckdelay
  {
    O_ALT_FIREFLY_1_scanned, O_ALT_FIREFLY_1, N_("Alternative firefly, left (scanned)"),
    P_SCANNED,
    "SCANN_A_FIREFLYl", 0, i_alt_firefly_1, -104, -104
  },
  {
    O_ALT_FIREFLY_2_scanned, O_ALT_FIREFLY_2, N_("Alternative firefly, up (scanned)"),
    P_SCANNED,
    "SCANN_A_FIREFLYu", 0, i_alt_firefly_2, -104, -104
  },
  {
    O_ALT_FIREFLY_3_scanned, O_ALT_FIREFLY_3, N_("Alternative firefly, right (scanned)"),
    P_SCANNED,
    "SCANN_A_FIREFLYr", 0, i_alt_firefly_3, -104, -104
  },
  {
    O_ALT_FIREFLY_4_scanned, O_ALT_FIREFLY_4, N_("Alternative firefly, down (scanned)"),
    P_SCANNED,
    "SCANN_A_FIREFLYd", 0, i_alt_firefly_4, -104, -104
  },
  {
    O_BUTTER, O_BUTTER, N_("Butterfly (internal)"),
    0,
    "BUTTERFLY", 0, 0, 0, 0,
  },
  {
    O_BUTTER_1, O_BUTTER_1_scanned, N_("Butterfly, left"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "BUTTERFLYl", 'C', i_butter_1, -144, -144, 384
  },    // has ckdelay
  {
    O_BUTTER_2, O_BUTTER_2_scanned, N_("Butterfly, up"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "BUTTERFLYu", 'b', i_butter_2, -144, -144, 384
  },    // has ckdelay
  {
    O_BUTTER_3, O_BUTTER_3_scanned, N_("Butterfly, right"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "BUTTERFLYr", 'B', i_butter_3, -144, -144, 384
  },    // has ckdelay
  {
    O_BUTTER_4, O_BUTTER_4_scanned, N_("Butterfly, down"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "BUTTERFLYd", 'c', i_butter_4, -144, -144, 384
  },    // has ckdelay
  {
    O_BUTTER_1_scanned, O_BUTTER_1, N_("Butterfly, left (scanned)"),
    P_SCANNED,
    "SCANN_BUTTERFLYl", 0, i_butter_1, -144, -144
  },
  {
    O_BUTTER_2_scanned, O_BUTTER_2, N_("Butterfly, up (scanned)"),
    P_SCANNED,
    "SCANN_BUTTERFLYu", 0, i_butter_2, -144, -144
  },
  {
    O_BUTTER_3_scanned, O_BUTTER_3, N_("Butterfly, right (scanned)"),
    P_SCANNED,
    "SCANN_BUTTERFLYr", 0, i_butter_3, -144, -144
  },
  {
    O_BUTTER_4_scanned, O_BUTTER_4, N_("Butterfly, down (scanned)"),
    P_SCANNED,
    "SCANN_BUTTERFLYd", 0, i_butter_4, -144, -144
  },
  {
    O_ALT_BUTTER, O_ALT_BUTTER, N_("Alternative butterfly (internal)"),
    0,
    "A_BUTTERFLY", 0, 0, 0, 0,
  },
  {
    O_ALT_BUTTER_1, O_ALT_BUTTER_1_scanned, N_("Alternative butterfly, left"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "A_BUTTERFLYl", 0, i_alt_butter_1, -112, -112, 384
  },    // has ckdelay
  {
    O_ALT_BUTTER_2, O_ALT_BUTTER_2_scanned, N_("Alternative butterfly, up"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "A_BUTTERFLYu", 0, i_alt_butter_2, -112, -112, 384
  },    // has ckdelay
  {
    O_ALT_BUTTER_3, O_ALT_BUTTER_3_scanned, N_("Alternative butterfly, right"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "A_BUTTERFLYr", 0, i_alt_butter_3, -112, -112, 384
  },    // has ckdelay
  {
    O_ALT_BUTTER_4, O_ALT_BUTTER_4_scanned, N_("Alternative butterfly, down"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "A_BUTTERFLYd", 0, i_alt_butter_4, -112, -112, 384
  },    // has ckdelay
  {
    O_ALT_BUTTER_1_scanned, O_ALT_BUTTER_1, N_("Alternative butterfly, left (scanned)"),
    P_SCANNED,
    "SCANN_A_BUTTERFLYl", 0, i_alt_butter_1, -112, -112
  },
  {
    O_ALT_BUTTER_2_scanned, O_ALT_BUTTER_2, N_("Alternative butterfly, up (scanned)"),
    P_SCANNED,
    "SCANN_A_BUTTERFLYu", 0, i_alt_butter_2, -112, -112
  },
  {
    O_ALT_BUTTER_3_scanned, O_ALT_BUTTER_3, N_("Alternative butterfly, right (scanned)"),
    P_SCANNED,
    "SCANN_A_BUTTERFLYr", 0, i_alt_butter_3, -112, -112
  },
  {
    O_ALT_BUTTER_4_scanned, O_ALT_BUTTER_4, N_("Alternative butterfly, down (scanned)"),
    P_SCANNED,
    "SCANN_A_BUTTERFLYd", 0, i_alt_butter_4, -112, -112
  },
  {
    O_STONEFLY, O_STONEFLY, N_("Stonefly (internal)"),
    0,
    "STONEFLY", 0, 0, 0, 0,
  },
  {
    O_STONEFLY_1, O_STONEFLY_1_scanned, N_("Stonefly, left"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "STONEFLYl", 0, i_stonefly_1, -152, -152, 384
  },    // has ckdelay
  {
    O_STONEFLY_2, O_STONEFLY_2_scanned, N_("Stonefly, up"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "STONEFLYu", 0, i_stonefly_2, -152, -152, 384
  },    // has ckdelay
  {
    O_STONEFLY_3, O_STONEFLY_3_scanned, N_("Stonefly, right"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "STONEFLYr", 0, i_stonefly_3, -152, -152, 384
  },    // has ckdelay
  {
    O_STONEFLY_4, O_STONEFLY_4_scanned, N_("Stonefly, down"),
    P_EXPLODES_BY_HIT | P_CAN_MOVE,
    "STONEFLYd", 0, i_stonefly_4, -152, -152, 384
  },    // has ckdelay
  {
    O_STONEFLY_1_scanned, O_STONEFLY_1, N_("Stonefly, left (scanned)"),
    P_SCANNED,
    "SCANN_STONEFLYl", 0, i_stonefly_1, -152, -152
  },
  {
    O_STONEFLY_2_scanned, O_STONEFLY_2, N_("Stonefly, up (scanned)"),
    P_SCANNED,
    "SCANN_STONEFLYu", 0, i_stonefly_2, -152, -152
  },
  {
    O_STONEFLY_3_scanned, O_STONEFLY_3, N_("Stonefly, right (scanned)"),
    P_SCANNED,
    "SCANN_STONEFLYr", 0, i_stonefly_3, -152, -152
  },
  {
    O_STONEFLY_4_scanned, O_STONEFLY_4, N_("Stonefly, down (scanned)"),
    P_SCANNED,
    "SCANN_STONEFLYd", 0, i_stonefly_4, -152, -152
  },
  {
    O_BITER, O_BITER, N_("Biter (internal)"),
    0,
    "BITER", 0, 0, 0, 0,
  },
  {
    O_BITER_1, O_BITER_1_scanned, N_("Biter, up"),
    P_CAN_MOVE,
    "BITERu", 0, i_biter_1, -168, -168, 518
  },    // has ckdelay
  {
    O_BITER_2, O_BITER_2_scanned, N_("Biter, right"),
    P_CAN_MOVE,
    "BITERr", 0, i_biter_2, -168, -168, 518
  },    // has ckdelay
  {
    O_BITER_3, O_BITER_3_scanned, N_("Biter, down"),
    P_CAN_MOVE,
    "BITERd", 0, i_biter_3, -168, -168, 518
  },    // has ckdelay
  {
    O_BITER_4, O_BITER_4_scanned, N_("Biter, left"),
    P_CAN_MOVE,
    "BITERl", 0, i_biter_4, -168, -168, 518
  },    // has ckdelay
  {
    O_BITER_1_scanned, O_BITER_1, N_("Biter, up (scanned)"),
    P_SCANNED,
    "SCANN_BITERu", 0, i_biter_1, -168, -168
  },
  {
    O_BITER_2_scanned, O_BITER_2, N_("Biter, right (scanned)"),
    P_SCANNED,
    "SCANN_BITERr", 0, i_biter_2, -168, -168
  },
  {
    O_BITER_3_scanned, O_BITER_3, N_("Biter, down (scanned)"),
    P_SCANNED,
    "SCANN_BITERd", 0, i_biter_3, -168, -168
  },
  {
    O_BITER_4_scanned, O_BITER_4, N_("Biter, left (scanned)"),
    P_SCANNED,
    "SCANN_BITERl", 0, i_biter_4, -168, -168
  },
  {
    O_DRAGONFLY, O_DRAGONFLY, N_("Dragonfly (internal)"),
    0,
    "DRAGONFLY", 0, 0, 0, 0,
  },
  {
    O_DRAGONFLY_1, O_DRAGONFLY_1_scanned, N_("Dragonfly, left"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "DRAGONFLYl", 0, i_dragonfly_1, -336, -336, 256
  },    // has ckdelay
  {
    O_DRAGONFLY_2, O_DRAGONFLY_2_scanned, N_("Dragonfly, up"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "DRAGONFLYu", 0, i_dragonfly_2, -336, -336, 256
  },    // has ckdelay
  {
    O_DRAGONFLY_3, O_DRAGONFLY_3_scanned, N_("Dragonfly, right"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "DRAGONFLYr", 0, i_dragonfly_3, -336, -336, 256
  },    // has ckdelay
  {
    O_DRAGONFLY_4, O_DRAGONFLY_4_scanned, N_("Dragonfly, down"),
    P_EXPLODES_BY_HIT | P_CCW | P_CAN_MOVE,
    "DRAGONFLYd", 0, i_dragonfly_4, -336, -336, 256
  },    // has ckdelay
  {
    O_DRAGONFLY_1_scanned, O_DRAGONFLY_1, N_("Dragonfly, left (scanned)"),
    P_SCANNED,
    "SCANN_DRAGONFLYl", 0, i_dragonfly_1, -336, -336
  },
  {
    O_DRAGONFLY_2_scanned, O_DRAGONFLY_2, N_("Dragonfly, up (scanned)"),
    P_SCANNED,
    "SCANN_DRAGONFLYu", 0, i_dragonfly_2, -336, -336
  },
  {
    O_DRAGONFLY_3_scanned, O_DRAGONFLY_3, N_("Dragonfly, right (scanned)"),
    P_SCANNED,
    "SCANN_DRAGONFLYr", 0, i_dragonfly_3, -336, -336
  },
  {
    O_DRAGONFLY_4_scanned, O_DRAGONFLY_4, N_("Dragonfly, down (scanned)"),
    P_SCANNED,
    "SCANN_DRAGONFLYd", 0, i_dragonfly_4, -336, -336
  },

  {
    O_PRE_PL_1, O_PRE_PL_1, N_("Player birth (1)"),
    P_GROWING,
    "GUYBIRTH1", 0, 32, 32, 32
  },
  {
    O_PRE_PL_2, O_PRE_PL_2, N_("Player birth (2)"),
    P_GROWING,
    "GUYBIRTH2", 0, 33, 33, 33
  },
  {
    O_PRE_PL_3, O_PRE_PL_3, N_("Player birth (3)"),
    P_GROWING,
    "GUYBIRTH3", 0, 34, 34, 34
  },
  {
    O_PLAYER_START, O_PLAYER_START_scanned, N_("Player start"),
    P_PLAYER | P_CAN_DIG,
    "GUYSTART", 0, i_player, i_player, 35, 32
  },    // has ckdelay
  {
    O_PLAYER_START_scanned, O_PLAYER_START, N_("Player start (scanned)"),
    P_SCANNED,
    "SCANN_GUYSTART", 0, i_player, i_player, 35
  },
  {
    O_PLAYER, O_PLAYER_scanned, N_("Player"),
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT | P_PLAYER | P_CAN_DIG,
    "GUY", 0, i_player, i_player, 35, 32
  },    // has ckdelay
  {
    O_PLAYER_scanned, O_PLAYER, N_("Player (scanned)"),
    P_SCANNED | P_BLOWS_UP_FLIES,
    "SCANN_GUY", 0, i_player, i_player, 35
  },
  {
    O_PLAYER_BOMB, O_PLAYER_BOMB_scanned, N_("Player with bomb"),
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT | P_PLAYER | P_CAN_DIG,
    "GUYBOMB", 0, 42, 42, 42, 25
  },    // has ckdelay
  {
    O_PLAYER_BOMB_scanned, O_PLAYER_BOMB, N_("Player with bomb (scanned)"),
    P_SCANNED,
    "SCANN_GUYBOMB", 0, 42, 42, 42
  },
  {
    O_PLAYER_ROCKET_LAUNCHER, O_PLAYER_ROCKET_LAUNCHER_scanned, N_("Player with rocket launcher"),
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT | P_PLAYER | P_CAN_DIG,
    "GUYROCKETLAUNCER", 0, 369, 369, 369, 25
  },    // has ckdelay
  {
    O_PLAYER_ROCKET_LAUNCHER_scanned, O_PLAYER_ROCKET_LAUNCHER, N_("Player with rocket launcher (scanned)"),
    P_SCANNED,
    "SCANN_GUYROCKETLAUNCER", 0, 369, 369, 369
  },
  {
    O_PLAYER_GLUED, O_PLAYER_GLUED, N_("Glued player"),
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT,
    "GUYGLUED", 0, i_player_glued, i_player_glued, 35
  },    // is not a real player! so active x, y will not find it. no P_PLAYER bit!
  {
    O_PLAYER_STIRRING, O_PLAYER_STIRRING, N_("Player stirring"),
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT | P_PLAYER | P_PLAYER_STIRRING,
    "GUYSTIRRING", 0, 256, -256, -256
  },

  {
    O_ROCKET_LAUNCHER, O_ROCKET_LAUNCHER, N_("Rocket launcher"),
    0,
    "ROCKET_LAUNCHER", 0, 368, 368, 368
  },
  {
    O_ROCKET, O_ROCKET, N_("Rocket"),
    0,
    "ROCKET", 0, 365, 365, 365
  },
  {
    O_ROCKET_1, O_ROCKET_1_scanned, N_("Rocket (right)"),
    P_CAN_MOVE,
    "ROCKETr", 0, 364, 364, 364, 40
  },    // has ckdelay
  {
    O_ROCKET_1_scanned, O_ROCKET_1, N_("Rocket (right) (scanned)"),
    P_SCANNED,
    "SCANN_ROCKETr", 0, 364, 364, 364
  },
  {
    O_ROCKET_2, O_ROCKET_2_scanned, N_("Rocket (up)"),
    P_CAN_MOVE,
    "ROCKETu", 0, 365, 365, 365, 40
  },    // has ckdelay
  {
    O_ROCKET_2_scanned, O_ROCKET_2, N_("Rocket (up) (scanned)"),
    P_SCANNED,
    "SCANN_ROCKETu", 0, 365, 365, 365
  },
  {
    O_ROCKET_3, O_ROCKET_3_scanned, N_("Rocket (left)"),
    P_CAN_MOVE,
    "ROCKETl", 0, 366, 366, 366, 40
  },    // has ckdelay
  {
    O_ROCKET_3_scanned, O_ROCKET_3, N_("Rocket (left) (scanned)"),
    P_SCANNED,
    "SCANN_ROCKETl", 0, 366, 366, 366
  },
  {
    O_ROCKET_4, O_ROCKET_4_scanned, N_("Rocket (down)"),
    P_CAN_MOVE,
    "ROCKETd", 0, 367, 367, 367, 40
  },    // has ckdelay
  {
    O_ROCKET_4_scanned, O_ROCKET_4, N_("Rocket (down) (scanned)"),
    P_SCANNED,
    "SCANN_ROCKETd", 0, 367, 367, 367
  },

  {
    O_BOMB, O_BOMB, N_("Bomb"),
    P_COLLECTIBLE | P_CAN_MOVE,
    "BOMB", 0, 48, 48, 48
  },
  {
    O_BOMB_TICK_1, O_BOMB_TICK_1, N_("Ticking bomb (1)"),
    P_EXPLOSION_FIRST_STAGE | P_CAN_DIG,
    "IGNITEDBOMB1", 0, 49, 49, 49
  },
  {
    O_BOMB_TICK_2, O_BOMB_TICK_2, N_("Ticking bomb (2)"),
    P_CAN_DIG,
    "IGNITEDBOMB2", 0, 50, 50, 50
  },
  {
    O_BOMB_TICK_3, O_BOMB_TICK_3, N_("Ticking bomb (3)"),
    0,
    "IGNITEDBOMB3", 0, 51, 51, 51
  },
  {
    O_BOMB_TICK_4, O_BOMB_TICK_4, N_("Ticking bomb (4)"),
    0,
    "IGNITEDBOMB4", 0, 52, 52, 52
  },
  {
    O_BOMB_TICK_5, O_BOMB_TICK_5, N_("Ticking bomb (5)"),
    0,
    "IGNITEDBOMB5", 0, 53, 53, 53
  },
  {
    O_BOMB_TICK_6, O_BOMB_TICK_6, N_("Ticking bomb (6)"),
    0,
    "IGNITEDBOMB6", 0, 54, 54, 54
  },
  {
    O_BOMB_TICK_7, O_BOMB_TICK_7, N_("Ticking bomb (7)"),
    0,
    "IGNITEDBOMB7", 0, 55, 55, 55
  },

  {
    O_NITRO_PACK, O_NITRO_PACK_scanned, N_("Nitro pack"),
    P_SLOPED | P_EXPLODES_BY_HIT | P_MOVED_BY_CONVEYOR_TOP | P_PUSHABLE | P_CAN_FALL,
    "NITRO", 0, 288, 288, 288
  },
  {
    O_NITRO_PACK_scanned, O_NITRO_PACK, N_("Nitro pack (scanned)"),
    P_SCANNED,
    "SCANN_NITRO", 0, 288, 288, 288
  },
  {
    O_NITRO_PACK_F, O_NITRO_PACK_F_scanned, N_("Nitro pack, falling"),
    P_EXPLODES_BY_HIT | P_FALLING,
    "NITROf", 0, i_nitro_pack_f, i_nitro_pack_f, 288
  },
  {
    O_NITRO_PACK_F_scanned, O_NITRO_PACK_F, N_("Nitro pack, falling (scanned)"),
    P_SCANNED,
    "SCANN_NITROf", 0, i_nitro_pack_f, i_nitro_pack_f, 288
  },
  {
    O_NITRO_PACK_EXPLODE, O_NITRO_PACK_EXPLODE_scanned, N_("Nitro pack, triggered"),
    P_EXPLODES_BY_HIT,
    "NITROtriggered", 0, i_nitro_explode, i_nitro_explode, 288
  },
  {
    O_NITRO_PACK_EXPLODE_scanned, O_NITRO_PACK_EXPLODE, N_("Nitro pack, triggered (scanned)"),
    P_SCANNED,
    "SCANN_NITROtriggered", 0, i_nitro_explode, i_nitro_explode, 288
  },

  {
    O_PRE_CLOCK_0, O_PRE_CLOCK_1, N_("Clock birth (0)"),
    P_SCANNED,
    "CLOCKBIRTH0", 0, 28, 28, 28
  },
  {
    O_PRE_CLOCK_1, O_PRE_CLOCK_0, N_("Clock birth (1)"),
    P_GROWING | P_EXPLOSION_FIRST_STAGE,
    "CLOCKBIRTH1", 0, 28, 28, 28, 280
  },    // has ckdelay
  {
    O_PRE_CLOCK_2, O_PRE_CLOCK_2, N_("Clock birth (2)"),
    P_GROWING,
    "CLOCKBIRTH2", 0, 29, 29, 29, 280
  },    // has ckdelay
  {
    O_PRE_CLOCK_3, O_PRE_CLOCK_3, N_("Clock birth (3)"),
    P_GROWING,
    "CLOCKBIRTH3", 0, 30, 30, 30, 280
  },    // has ckdelay
  {
    O_PRE_CLOCK_4, O_PRE_CLOCK_4, N_("Clock birth (4)"),
    P_GROWING,
    "CLOCKBIRTH4", 0, 31, 31, 31, 280
  },    // has ckdelay
  {
    O_PRE_DIA_0, O_PRE_DIA_1, N_("Diamond birth (0)"),
    P_SCANNED,
    "DIAMONDBIRTH0", 0, 56, 56, 56
  },
  {
    O_PRE_DIA_1, O_PRE_DIA_0, N_("Diamond birth (1)"),
    P_GROWING | P_EXPLOSION_FIRST_STAGE,
    "DIAMONDBIRTH1", 0, 56, 56, 56, 280
  },    // has ckdelay
  {
    O_PRE_DIA_2, O_PRE_DIA_2, N_("Diamond birth (2)"),
    P_GROWING,
    "DIAMONDBIRTH2", 0, 57, 57, 57, 280
  },    // has ckdelay
  {
    O_PRE_DIA_3, O_PRE_DIA_3, N_("Diamond birth (3)"),
    P_GROWING,
    "DIAMONDBIRTH3", 0, 58, 58, 58, 280
  },    // has ckdelay
  {
    O_PRE_DIA_4, O_PRE_DIA_4, N_("Diamond birth (4)"),
    P_GROWING,
    "DIAMONDBIRTH4", 0, 59, 59, 59, 280
  },    // has ckdelay
  {
    O_PRE_DIA_5, O_PRE_DIA_5, N_("Diamond birth (5)"),
    P_GROWING,
    "DIAMONDBIRTH5", 0, 60, 60, 60, 280
  },    // has ckdelay
  {
    O_EXPLODE_0, O_EXPLODE_1, N_("Explosion (0)"),
    P_SCANNED,
    "EXPLOSION0", 0, 43, 43, 43
  },
  {
    O_EXPLODE_1, O_EXPLODE_0, N_("Explosion (1)"),
    P_EXPLOSION | P_EXPLOSION_FIRST_STAGE,
    "EXPLOSION1", 0, 43, 43, 43, 280
  },    // has ckdelay
  {
    O_EXPLODE_2, O_EXPLODE_2, N_("Explosion (2)"),
    P_EXPLOSION,
    "EXPLOSION2", 0, 44, 44, 44, 280
  },    // has ckdelay
  {
    O_EXPLODE_3, O_EXPLODE_3, N_("Explosion (3)"),
    P_EXPLOSION,
    "EXPLOSION3", 0, 45, 45, 45, 280
  },    // has ckdelay
  {
    O_EXPLODE_4, O_EXPLODE_4, N_("Explosion (4)"),
    P_EXPLOSION,
    "EXPLOSION4", 0, 46, 46, 46, 280
  },    // has ckdelay
  {
    O_EXPLODE_5, O_EXPLODE_5, N_("Explosion (5)"),
    P_EXPLOSION,
    "EXPLOSION5", 0, 47, 47, 47, 280
  },    // has ckdelay
  {
    O_PRE_STONE_0, O_PRE_STONE_1, N_("Stone birth (0)"),
    P_SCANNED,
    "BOULDERBIRTH0", 0, 36, 36, 36
  },
  {
    O_PRE_STONE_1, O_PRE_STONE_0, N_("Stone birth (1)"),
    P_GROWING | P_EXPLOSION_FIRST_STAGE,
    "BOULDERBIRTH1", 0, 36, 36, 36, 280
  },    // has ckdelay
  {
    O_PRE_STONE_2, O_PRE_STONE_2, N_("Stone birth (2)"),
    P_GROWING,
    "BOULDERBIRTH2", 0, 37, 37, 37, 280
  },    // has ckdelay
  {
    O_PRE_STONE_3, O_PRE_STONE_3, N_("Stone birth (3)"),
    P_GROWING,
    "BOULDERBIRTH3", 0, 38, 38, 38, 280
  },    // has ckdelay
  {
    O_PRE_STONE_4, O_PRE_STONE_4, N_("Stone birth (4)"),
    P_GROWING,
    "BOULDERBIRTH4", 0, 39, 39, 39, 280
  },    // has ckdelay
  {
    O_PRE_STEEL_0, O_PRE_STEEL_1, N_("Steel birth (0)"),
    P_SCANNED,
    "STEELWALLBIRTH0", 0, 24, 24, 24
  },
  {
    O_PRE_STEEL_1, O_PRE_STEEL_0, N_("Steel birth (1)"),
    P_GROWING | P_EXPLOSION_FIRST_STAGE,
    "STEELWALLBIRTH1", 0, 24, 24, 24, 280
  },    // has ckdelay
  {
    O_PRE_STEEL_2, O_PRE_STEEL_2, N_("Steel birth (2)"),
    P_GROWING,
    "STEELWALLBIRTH2", 0, 25, 25, 25, 280
  },    // has ckdelay
  {
    O_PRE_STEEL_3, O_PRE_STEEL_3, N_("Steel birth (3)"),
    P_GROWING,
    "STEELWALLBIRTH3", 0, 26, 26, 26, 280
  },    // has ckdelay
  {
    O_PRE_STEEL_4, O_PRE_STEEL_4, N_("Steel birth (4)"),
    P_GROWING,
    "STEELWALLBIRTH4", 0, 27, 27, 27, 280
  },    // has ckdelay
  {
    O_GHOST_EXPL_0, O_GHOST_EXPL_1, N_("Ghost explosion (0)"),
    P_SCANNED,
    "GHOSTEXPLOSION0", 0, 80, 80, 80
  },
  {
    O_GHOST_EXPL_1, O_GHOST_EXPL_0, N_("Ghost explosion (1)"),
    P_EXPLOSION | P_EXPLOSION_FIRST_STAGE,
    "GHOSTEXPLOSION1", 0, 80, 80, 80, 280
  },    // has ckdelay
  {
    O_GHOST_EXPL_2, O_GHOST_EXPL_2, N_("Ghost explosion (2)"),
    P_EXPLOSION,
    "GHOSTEXPLOSION2", 0, 81, 81, 81, 280
  },    // has ckdelay
  {
    O_GHOST_EXPL_3, O_GHOST_EXPL_3, N_("Ghost explosion (3)"),
    P_EXPLOSION,
    "GHOSTEXPLOSION3", 0, 82, 82, 82, 280
  },    // has ckdelay
  {
    O_GHOST_EXPL_4, O_GHOST_EXPL_4, N_("Ghost explosion (4)"),
    P_EXPLOSION,
    "GHOSTEXPLOSION4", 0, 83, 83, 83, 280
  },    // has ckdelay
  {
    O_BOMB_EXPL_0, O_BOMB_EXPL_1, N_("Bomb explosion (0)"),
    P_SCANNED,
    "BOMBEXPLOSION0", 0, 84, 84, 84
  },
  {
    O_BOMB_EXPL_1, O_BOMB_EXPL_0, N_("Bomb explosion (1)"),
    P_EXPLOSION | P_EXPLOSION_FIRST_STAGE,
    "BOMBEXPLOSION1", 0, 84, 84, 84, 280
  },    // has ckdelay
  {
    O_BOMB_EXPL_2, O_BOMB_EXPL_2, N_("Bomb explosion (2)"),
    P_EXPLOSION,
    "BOMBEXPLOSION2", 0, 85, 85, 85, 280
  },    // has ckdelay
  {
    O_BOMB_EXPL_3, O_BOMB_EXPL_3, N_("Bomb explosion (3)"),
    P_EXPLOSION,
    "BOMBEXPLOSION3", 0, 86, 86, 86, 280
  },    // has ckdelay
  {
    O_BOMB_EXPL_4, O_BOMB_EXPL_4, N_("Bomb explosion (4)"),
    P_EXPLOSION,
    "BOMBEXPLOSION4", 0, 87, 87, 87, 280
  },    // has ckdelay
  {
    O_NITRO_EXPL_0, O_NITRO_EXPL_1, N_("Nitro pack explosion (0)"),
    P_SCANNED,
    "NITROEXPLOSION0", 0, 44, 44, 44
  },
  {
    O_NITRO_EXPL_1, O_NITRO_EXPL_0, N_("Nitro pack explosion (1)"),
    P_EXPLOSION | P_EXPLOSION_FIRST_STAGE,
    "NITROEXPLOSION1", 0, 44, 44, 44, 280
  },    // has ckdelay
  {
    O_NITRO_EXPL_2, O_NITRO_EXPL_2, N_("Nitro pack explosion (2)"),
    P_EXPLOSION,
    "NITROEXPLOSION2", 0, 45, 45, 45, 280
  },    // has ckdelay
  {
    O_NITRO_EXPL_3, O_NITRO_EXPL_3, N_("Nitro pack explosion (3)"),
    P_EXPLOSION,
    "NITROEXPLOSION3", 0, 46, 46, 46, 280
  },    // has ckdelay
  {
    O_NITRO_EXPL_4, O_NITRO_EXPL_4, N_("Nitro pack explosion (4)"),
    P_EXPLOSION,
    "NITROEXPLOSION4", 0, 47, 47, 47, 280
  },    // has ckdelay
  {
    O_AMOEBA_2_EXPL_0, O_AMOEBA_2_EXPL_1, N_("Amoeba 2 explosion (0)"),
    P_SCANNED,
    "AMOEBA2EXPLOSION0", 0, 292, 292, 292
  },
  {
    O_AMOEBA_2_EXPL_1, O_AMOEBA_2_EXPL_0, N_("Amoeba 2 explosion (1)"),
    P_EXPLOSION | P_EXPLOSION_FIRST_STAGE,
    "AMOEBA2EXPLOSION1", 0, 292, 292, 292, 280
  },    // has ckdelay
  {
    O_AMOEBA_2_EXPL_2, O_AMOEBA_2_EXPL_2, N_("Amoeba 2 explosion (2)"),
    P_EXPLOSION,
    "AMOEBA2EXPLOSION2", 0, 293, 293, 293, 280
  },    // has ckdelay
  {
    O_AMOEBA_2_EXPL_3, O_AMOEBA_2_EXPL_3, N_("Amoeba 2 explosion (3)"),
    P_EXPLOSION,
    "AMOEBA2EXPLOSION3", 0, 294, 294, 294, 280
  },    // has ckdelay
  {
    O_AMOEBA_2_EXPL_4, O_AMOEBA_2_EXPL_4, N_("Amoeba 2 explosion (4)"),
    P_EXPLOSION,
    "AMOEBA2EXPLOSION4", 0, 295, 295, 295, 280
  },    // has ckdelay

  // nut "explosions" are not real explosions, but the stages of a cracked nut opening.
  // therefore they are sloped
  {
    O_NUT_CRACK_0, O_NUT_CRACK_1, N_("Nut crack (0)"),
    P_SCANNED,
    "NUTCRACK0", 0, 360, 360, 360
  },
  {
    O_NUT_CRACK_1, O_NUT_CRACK_0, N_("Nut crack (1)"),
    P_SLOPED | P_EXPLOSION | P_EXPLOSION_FIRST_STAGE,
    "NUTCRACK1", 0, 360, 360, 360, 280
  },    // has ckdelay
  {
    O_NUT_CRACK_2, O_NUT_CRACK_2, N_("Nut crack (2)"),
    P_SLOPED | P_EXPLOSION,
    "NUTCRACK2", 0, 361, 361, 361, 280
  },    /* has ckdelay */        /* these are rounded!! */
  {
    O_NUT_CRACK_3, O_NUT_CRACK_3, N_("Nut crack (3)"),
    P_SLOPED | P_EXPLOSION,
    "NUTCRACK3", 0, 362, 362, 362, 280
  },    // has ckdelay
  {
    O_NUT_CRACK_4, O_NUT_CRACK_4, N_("Nut crack (4)"),
    P_SLOPED | P_EXPLOSION,
    "NUTCRACK4", 0, 363, 363, 363, 280
  },    // has ckdelay

  {
    O_PLAYER_PNEUMATIC_LEFT, O_PLAYER_PNEUMATIC_LEFT, NULL /* Player using hammer, left */,
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT | P_PLAYER | P_CAN_DIG,
    "GUYHAMMERl", 0, 265, 265, 265
  },
  {
    O_PLAYER_PNEUMATIC_RIGHT, O_PLAYER_PNEUMATIC_RIGHT, NULL /* Player using hammer, right */,
    P_BLOWS_UP_FLIES | P_EXPLODES_BY_HIT | P_PLAYER | P_CAN_DIG,
    "GUYHAMMERr", 0, 268, 268, 268
  },
  {
    O_PNEUMATIC_ACTIVE_LEFT, O_PNEUMATIC_ACTIVE_LEFT, NULL /* Active hammer, left */, 0,
    "HAMMERACTIVEl", 0, 264, 264, 264
  },
  {
    O_PNEUMATIC_ACTIVE_RIGHT, O_PNEUMATIC_ACTIVE_RIGHT, NULL /* Active hammer, right */, 0,
    "HAMMERACTIVEr", 0, 269, 269, 269
  },

  {
    O_UNKNOWN, O_UNKNOWN, N_("Unknown element"),
    P_NON_EXPLODABLE,
    "UNKNOWN", 0, i_unknown, i_unknown, 4
  },
  {
    O_NONE, O_NONE, N_("No element"),
    0,
    "NONE", 0, 79, 79, 79
  },

  {
    O_MAX
  },

  // these are just helpers, for all the element -> image index information to be in this array
  {
    O_FAKE_BONUS, O_FAKE_BONUS, NULL,
    0,
    NULL, 0, 120, -120, -120
  },
  {
    O_INBOX_CLOSED, O_INBOX_CLOSED, NULL,
    0,
    NULL, 0, 22, 22, 22
  },
  {
    O_INBOX_OPEN, O_INBOX_OPEN, NULL,
    0,
    NULL, 0, 23, 23, 23
  },

  // game graphics
  // also for imported diego effects, but don't know if it is used anywhere in original games
  {
    O_OUTBOX_CLOSED, O_OUTBOX_CLOSED, NULL,
    0,
    NULL, 0, 22, 22, 22
  },
  {
    O_OUTBOX_OPEN, O_OUTBOX_OPEN, NULL,
    0,
    NULL, 0, 23, 23, 23
  },
  {
    O_COVERED, O_COVERED, NULL,
    0,
    NULL, 0, 128, -128, -128
  },
  {
    O_PLAYER_LEFT, O_PLAYER_LEFT, NULL,
    P_PLAYER | P_CAN_DIG,
    NULL, 0, 232, -232, -232
  },
  {
    O_PLAYER_RIGHT, O_PLAYER_RIGHT, NULL,
    P_PLAYER | P_CAN_DIG,
    NULL, 0, 240, -240, -240
  },
  {
    O_PLAYER_UP, O_PLAYER_UP, NULL,
    P_PLAYER | P_CAN_DIG,
    NULL, 0, 376, -376, -376
  },
  {
    O_PLAYER_DOWN, O_PLAYER_DOWN, NULL,
    P_PLAYER | P_CAN_DIG,
    NULL, 0, 384, -384, -384
  },
  {
    O_PLAYER_TAP, O_PLAYER_TAP, NULL,
    P_PLAYER,
    NULL, 0, 216, -216, -216
  },
  {
    O_PLAYER_BLINK, O_PLAYER_BLINK, NULL,
    P_PLAYER,
    NULL, 0, 208, -208, -208
  },
  {
    O_PLAYER_TAP_BLINK, O_PLAYER_TAP_BLINK, NULL,
    P_PLAYER,
    NULL, 0, 224, -224, -224
  },
  {
    O_PLAYER_PUSH_LEFT, O_PLAYER_PUSH_LEFT, N_("Player, pushing left"),
    P_PLAYER | P_PLAYER_PUSHING,
    NULL, 0, 392, -392, -392
  },
  {
    O_PLAYER_PUSH_RIGHT, O_PLAYER_PUSH_RIGHT, N_("Player, pushing right"),
    P_PLAYER | P_PLAYER_PUSHING,
    NULL, 0, 400, -400, -400
  },
  {
    O_PLAYER_BOMB_TURNING, O_PLAYER_BOMB_TURNING, N_("Player with bomb (turning)"),
    P_PLAYER,
    NULL, 0, 42, 42, 42,
  },
  {
    O_PLAYER_ROCKET_LAUNCHER_TURNING, O_PLAYER_ROCKET_LAUNCHER_TURNING, N_("Player with rocket launcher (turning)"),
    P_PLAYER,
    NULL, 0, 369, 369, 369,
  },
  {
    O_CREATURE_SWITCH_ON, O_CREATURE_SWITCH_ON, NULL,
    0,
    NULL, 0, 19, 19, 19
  },
  {
    O_EXPANDING_WALL_SWITCH_HORIZ, O_EXPANDING_WALL_SWITCH_HORIZ, NULL,
    0,
    NULL, 0, 40, 40, 40
  },
  {
    O_EXPANDING_WALL_SWITCH_VERT, O_EXPANDING_WALL_SWITCH_VERT, NULL,
    0,
    NULL, 0, 41, 41, 41
  },
  {
    O_GRAVITY_SWITCH_ACTIVE, O_GRAVITY_SWITCH_ACTIVE, NULL,
    0,
    NULL, 0, 275, 275, 275
  },
  {
    O_REPLICATOR_SWITCH_ON, O_REPLICATOR_SWITCH_ON, NULL,
    0,
    NULL, 0, 290, 290, 290
  },
  {
    O_REPLICATOR_SWITCH_OFF, O_REPLICATOR_SWITCH_OFF, NULL,
    0,
    NULL, 0, 291, 291, 291
  },
  {
    O_CONVEYOR_DIR_NORMAL, O_CONVEYOR_DIR_NORMAL, NULL,
    0,
    NULL, 0, 353, 353, 353
  },
  {
    O_CONVEYOR_DIR_CHANGED, O_CONVEYOR_DIR_CHANGED, NULL,
    0,
    NULL, 0, 354, 354, 354
  },
  {
    O_CONVEYOR_SWITCH_OFF, O_CONVEYOR_SWITCH_OFF, NULL,
    0,
    NULL, 0, 355, 355, 355
  },
  {
    O_CONVEYOR_SWITCH_ON, O_CONVEYOR_SWITCH_ON, NULL,
    0,
    NULL, 0, 356, 356, 356
  },

  {
    O_MAGIC_WALL_ACTIVE, O_MAGIC_WALL_ACTIVE, NULL,
    0,
    NULL, 0, 184, -184, -184
  },
  {
    O_REPLICATOR_ACTIVE, O_REPLICATOR_ACTIVE, NULL,
    0,
    NULL, 0, 304, -304, -304
  },
  {
    O_CONVEYOR_LEFT_ACTIVE, O_CONVEYOR_LEFT_ACTIVE, NULL,
    0,
    NULL, 0, i_conveyor_left, -328, -328
  },
  {
    O_CONVEYOR_RIGHT_ACTIVE, O_CONVEYOR_RIGHT_ACTIVE, NULL,
    0,
    NULL, 0, i_conveyor_right, -320, -320
  },
  {
    O_BITER_SWITCH_1, O_BITER_SWITCH_1, NULL,
    0,
    NULL, 0, 12, 12, 12
  },
  {
    O_BITER_SWITCH_2, O_BITER_SWITCH_2, NULL,
    0,
    NULL, 0, 13, 13, 13
  },
  {
    O_BITER_SWITCH_3, O_BITER_SWITCH_3, NULL,
    0,
    NULL, 0, 14, 14, 14
  },
  {
    O_BITER_SWITCH_4, O_BITER_SWITCH_4, NULL,
    0,
    NULL, 0, 15, 15, 15
  },
  {
    O_BITER_SWITCH_1_CRUMBLED, O_BITER_SWITCH_1_CRUMBLED, NULL,
    0,
    NULL, 0, 12, 12, 12
  },
  {
    O_BITER_SWITCH_2_CRUMBLED, O_BITER_SWITCH_2_CRUMBLED, NULL,
    0,
    NULL, 0, 13, 13, 13
  },
  {
    O_BITER_SWITCH_3_CRUMBLED, O_BITER_SWITCH_3_CRUMBLED, NULL,
    0,
    NULL, 0, 14, 14, 14
  },
  {
    O_BITER_SWITCH_4_CRUMBLED, O_BITER_SWITCH_4_CRUMBLED, NULL,
    0,
    NULL, 0, 15, 15, 15
  },

  {
    O_STONE_MOVE_LEFT, O_STONE_MOVE_LEFT, N_("Stone, moved left"),
    0,
    NULL, 0, 1, 1, 1,
  },
  {
    O_STONE_MOVE_RIGHT, O_STONE_MOVE_RIGHT, N_("Stone, moved right"),
    0,
    NULL, 0, 1, 1, 1,
  },
  {
    O_STONE_PUSH_LEFT, O_STONE_PUSH_LEFT, N_("Stone, pushed left"),
    0,
    NULL, 0, 1, 1, 1,
  },
  {
    O_STONE_PUSH_RIGHT, O_STONE_PUSH_RIGHT, N_("Stone, pushed right"),
    0,
    NULL, 0, 1, 1, 1,
  },

  {
    O_QUESTION_MARK, O_QUESTION_MARK, NULL,
    0,
    NULL, 0, 70, 70, 70
  },
  {
    O_EATABLE, O_EATABLE, NULL,
    0,
    NULL, 0, 71, 71, 71
  },
  {
    O_DOWN_ARROW, O_DOWN_ARROW, NULL,
    0,
    NULL, 0, 73, 73, 73
  },
  {
    O_LEFTRIGHT_ARROW, O_LEFTRIGHT_ARROW, NULL,
    0,
    NULL, 0, 74, 74, 74
  },
  {
    O_EVERYDIR_ARROW, O_EVERYDIR_ARROW, NULL,
    0,
    NULL, 0, 75, 75, 75
  },
  {
    O_GLUED, O_GLUED, NULL,
    0,
    NULL, 0, 76, 76, 76
  },
  {
    O_OUT, O_OUT, NULL,
    0,
    NULL, 0, 77, 77, 77
  },
  {
    O_EXCLAMATION_MARK, O_EXCLAMATION_MARK, NULL,
    0,
    NULL, 0, 78, 78, 78
  },

  {
    O_MAX_ALL
  },
};

// entries.
/* type given for each element;
 * GD_TYPE_ELEMENT represents a combo box of gdash objects.
 * GD_TAB&LABEL represents a notebook tab or a label.
 * others are self-explanatory.
 */
const GdStructDescriptor gd_cave_properties[] =
{
  // default data
  {
    "", GD_TAB, 0,
    N_("Cave data")
  },
  {
    "Name", GD_TYPE_STRING, 0,
    N_("Name"), STRUCT_OFFSET(GdCave, name), 1,
    N_("Name of game")
  },
  {
    "Description", GD_TYPE_STRING, 0,
    N_("Description"), STRUCT_OFFSET(GdCave, description), 1,
    N_("Some words about the game")
  },
  {
    "Author", GD_TYPE_STRING, 0,
    N_("Author"), STRUCT_OFFSET(GdCave, author), 1,
    N_("Name of author")
  },
  {
    "Date", GD_TYPE_STRING, 0,
    N_("Date"), STRUCT_OFFSET(GdCave, date), 1,
    N_("Date of creation")
  },
  {
    "WWW", GD_TYPE_STRING, 0,
    N_("WWW"), STRUCT_OFFSET(GdCave, www), 1,
    N_("Web page or e-mail address")
  },
  {
    "Difficulty", GD_TYPE_STRING, 0,
    N_("Difficulty"), STRUCT_OFFSET(GdCave, difficulty), 1,
    N_("Difficulty (informative)")
  },

  {
    "Selectable", GD_TYPE_BOOLEAN, 0,
    N_("Selectable as start"), STRUCT_OFFSET(GdCave, selectable), 1,
    N_("This sets whether the game can be started at this cave.")
  },
  {
    "Intermission", GD_TYPE_BOOLEAN, GD_ALWAYS_SAVE,
    N_("Intermission"), STRUCT_OFFSET(GdCave, intermission), 1,
    N_("Intermission caves are usually small and fast caves, which are not required to be solved. The player will not lose a life if he is not successful. The game always proceeds to the next cave.")
  },
  {
    "IntermissionProperties.instantlife", GD_TYPE_BOOLEAN, 0,
    N_("   Instant life"), STRUCT_OFFSET(GdCave, intermission_instantlife), 1,
    N_("If true, an extra life is given to the player, when the intermission cave is reached.")
  },
  {
    "IntermissionProperties.rewardlife", GD_TYPE_BOOLEAN, 0,
    N_("   Reward life"), STRUCT_OFFSET(GdCave, intermission_rewardlife), 1,
    N_("If true, an extra life is given to the player, when the intermission cave is successfully finished.")
  },
  {
    "Size", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Width"), STRUCT_OFFSET(GdCave, w), 1,
    N_("Width of cave. The standard size for a cave is 40x22, and 20x12 for an intermission."), 12, 128
  },
  {
    "Size", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Height"), STRUCT_OFFSET(GdCave, h), 1,
    N_("Height of cave. The standard size for a cave is 40x22, and 20x12 for an intermission."), 12, 128
  },
  {
    "Size", GD_TYPE_INT, GD_ALWAYS_SAVE|GD_DONT_SHOW_IN_EDITOR,
    N_("Visible, left"), STRUCT_OFFSET(GdCave, x1), 1,
    N_("Visible parts of the cave, upper left and lower right corner."), 0, 127
  },
  {
    "Size", GD_TYPE_INT, GD_ALWAYS_SAVE|GD_DONT_SHOW_IN_EDITOR,
    N_("Visible, upper"), STRUCT_OFFSET(GdCave, y1), 1,
    N_("Visible parts of the cave, upper left and lower right corner."), 0, 127
  },
  {
    "Size", GD_TYPE_INT, GD_ALWAYS_SAVE|GD_DONT_SHOW_IN_EDITOR,
    N_("Visible, right"), STRUCT_OFFSET(GdCave, x2), 1,
    N_("Visible parts of the cave, upper left and lower right corner."), 0, 127
  },
  {
    "Size", GD_TYPE_INT, GD_ALWAYS_SAVE|GD_DONT_SHOW_IN_EDITOR,
    N_("Visible, lower"), STRUCT_OFFSET(GdCave, y2), 1,
    N_("Visible parts of the cave, upper left and lower right corner."), 0, 127
  },
  {
    "Charset", GD_TYPE_STRING, 0,
    N_("Character set"), STRUCT_OFFSET(GdCave, charset), 1,
    N_("Theme used for displaying the game. Not used by GDash.")
  },
  {
    "Fontset", GD_TYPE_STRING, 0,
    N_("Font set"), STRUCT_OFFSET(GdCave, fontset), 1,
    N_("Font used during the game. Not used by GDash.")
  },

  // notes - a tab on its own
  {
    "Story", GD_TYPE_LONGSTRING, 0,
    N_("Story"), STRUCT_OFFSET(GdCave, story), 1,
    N_("Story for the cave. It will be shown when the cave is played.")
  },

  // remark - also a tab on its own
  {
    "Remark", GD_TYPE_LONGSTRING, 0,
    N_("Remark"), STRUCT_OFFSET(GdCave, remark), 1,
    N_("Remark (informative). Can contain supplementary information about the design of the cave. It is not shown during the game, only when the user requests the cave info dialog, so can also contain spoilers and hints.")
  },

  {
    "", GD_TAB, 0,
    N_("Colors")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Border color"), STRUCT_OFFSET(GdCave, color_b), 1,
    N_("Border color for C64 graphics. Only for compatibility, not used by GDash.")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Background color"), STRUCT_OFFSET(GdCave, color[0]), 1,
    N_("Background color for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Color 1 (dirt)"), STRUCT_OFFSET(GdCave, color[1]), 1,
    N_("Foreground color 1 for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Color 2 (steel wall)"), STRUCT_OFFSET(GdCave, color[2]), 1,
    N_("Foreground color 2 for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Color 3 (brick wall)"), STRUCT_OFFSET(GdCave, color[3]), 1,
    N_("Foreground color 3 for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Amoeba color"), STRUCT_OFFSET(GdCave, color[4]), 1,
    N_("Amoeba color for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Slime color"), STRUCT_OFFSET(GdCave, color[5]), 1,
    N_("Slime color for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Extra color 1"), STRUCT_OFFSET(GdCave, color[6]), 1,
    N_("Extra color 1 for C64 graphics")
  },
  {
    "Colors", GD_TYPE_COLOR, GD_ALWAYS_SAVE,
    N_("Extra color 2"), STRUCT_OFFSET(GdCave, color[7]), 1,
    N_("Extra color 2 for C64 graphics")
  },

  // difficulty
  {
    "", GD_TAB, 0,
    N_("Difficulty")
  },
  {
    "", GD_LABEL, GD_SHOW_LEVEL_LABEL,
    N_("Diamonds")
  },
  {
    "DiamondsRequired", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Diamonds needed"), CAVE_OFFSET(level_diamonds[0]), 5,
    N_("Here zero means automatically count diamonds before level start. If negative, the value is subtracted from that. This is useful for totally random caves."), -100, 999
  },
  {
    "DiamondValue", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Score for diamonds"), CAVE_OFFSET(diamond_value), 1,
    N_("Number of points per diamond collected, before opening the exit."), 0, 100
  },
  {
    "DiamondValue", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Score for extra diamonds"), CAVE_OFFSET(extra_diamond_value), 1,
    N_("Number of points per diamond collected, after opening the exit."), 0, 100
  },
  {
    "", GD_LABEL, 0,
    N_("Time")
  },
  {
    "CaveTime", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Time (s)"), CAVE_OFFSET(level_time[0]), 5,
    N_("Time available to solve cave, in seconds."), 1, 999
  },
  {
    "CaveMaxTime", GD_TYPE_INT, 0,
    N_("Maximum time (s)"), CAVE_OFFSET(max_time), 1,
    N_("If you reach this time by collecting too many clocks, the timer will overflow."), 60, 999
  },
  {
    "TimeValue", GD_TYPE_INT, 0,
    N_("Score for time"), CAVE_OFFSET(level_timevalue[0]), 5,
    N_("Points for each seconds remaining, when the player exits the level."), 0, 50
  },
  {
    "CaveScheduling", GD_TYPE_SCHEDULING, GD_ALWAYS_SAVE,
    N_("Scheduling type"), CAVE_OFFSET(scheduling), 1,
    N_("This flag sets whether the game uses an emulation of the original timing (c64-style), or a more modern milliseconds-based timing. The original game used a delay (empty loop) based timing of caves; this is selected by setting this to BD1, BD2, Construction Kit or Crazy Dream 7. This is a compatibility setting only; milliseconds-based timing is recommended for every new cave.")
  },
  {
    "PALTiming", GD_TYPE_BOOLEAN, 0,
    N_("PAL timing"), CAVE_OFFSET(pal_timing), 1,
    N_("On the PAL version of the C64 computer, the timer was actually slower than normal seconds. This flag is used to compensate for this. If enabled, one game second will last 1.2 real seconds. Most original games were authored for the PAL version. This is a compatibility setting for imported caves; it is not recommended to enable it for newly authored ones.")
  },
  {
    "FrameTime", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("   Speed (ms)"), CAVE_OFFSET(level_speed[0]), 5,
    N_("Number of milliseconds between game frames. Used when milliseconds-based timing is active, ie. C64 scheduling is off."), 50, 500
  },
  {
    "HatchingDelay", GD_TYPE_INT, 0,
    N_("   Hatching delay (frames)"), CAVE_OFFSET(level_hatching_delay_frame[0]), 5,
    N_("This value sets how much the cave will move until the player enters the cave, and is expressed in frames. This is used for the milliseconds-based scheduling."), 1, 40
  },
  {
    "CaveDelay", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("   Delay (C64-style)"), CAVE_OFFSET(level_ckdelay[0]), 5,
    N_("The length of the delay loop between game frames. Used when milliseconds-based timing is inactive, ie. some kind of C64 or Atari scheduling is selected."), 0, 32
  },
  {
    "HatchingTime", GD_TYPE_INT, 0,
    N_("   Hatching time (seconds)"), CAVE_OFFSET(level_hatching_delay_time[0]), 5,
    N_("This value sets how much the cave will move until the player enters the cave. This is used for the C64-like schedulings."), 1, 40
  },

  // initial fill
  {
    "RandSeed", GD_TYPE_INT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* random seed value */, CAVE_OFFSET(level_rand[0]), 5,
    NULL, -1, 255
  },
  {
    "InitialBorder", GD_TYPE_ELEMENT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Initial border */, CAVE_OFFSET(initial_border), 1,
    NULL
  },
  {
    "InitialFill", GD_TYPE_ELEMENT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Initial fill */, CAVE_OFFSET(initial_fill), 1,
    NULL
  },
  {
    "RandomFill", GD_TYPE_ELEMENT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Random fill 1 */, CAVE_OFFSET(random_fill[0]), 1,
    NULL
  },
  {
    "RandomFill", GD_TYPE_INT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Probability 1 */, CAVE_OFFSET(random_fill_probability[0]), 1,
    NULL, 0, 255
  },
  {
    "RandomFill", GD_TYPE_ELEMENT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Random fill 2 */, CAVE_OFFSET(random_fill[1]), 1,
    NULL
  },
  {
    "RandomFill", GD_TYPE_INT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Probability 2 */, CAVE_OFFSET(random_fill_probability[1]), 1,
    NULL, 0, 255
  },
  {
    "RandomFill", GD_TYPE_ELEMENT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Random fill 3 */, CAVE_OFFSET(random_fill[2]), 1,
    NULL
  },
  {
    "RandomFill", GD_TYPE_INT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Probability 3 */, CAVE_OFFSET(random_fill_probability[2]), 1,
    NULL, 0, 255
  },
  {
    "RandomFill", GD_TYPE_ELEMENT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Random fill 4 */, CAVE_OFFSET(random_fill[3]), 1,
    NULL
  },
  {
    "RandomFill", GD_TYPE_INT, GD_DONT_SHOW_IN_EDITOR,
    NULL /* Probability 4 */, CAVE_OFFSET(random_fill_probability[3]), 1,
    NULL, 0, 255
  },

  // PLAYER
  {
    "", GD_TAB, 0,
    N_("Player")
  },

  // player
  {
    "", GD_LABEL, 0,
    N_("Player movements")
  },
  {
    "DiagonalMovement", GD_TYPE_BOOLEAN, 0,
    N_("Diagonal movements"), CAVE_OFFSET(diagonal_movements), 1,
    N_("Controls if the player can move diagonally.")
  },
  {
    "ActiveGuyIsFirst", GD_TYPE_BOOLEAN, 0,
    N_("Uppermost player active"), CAVE_OFFSET(active_is_first_found), 1,
    N_("In 1stB, cave is scrolled to the uppermost and leftmost player found, whereas in the original game to the last one. Chasing stones also follow the active player.")
  },
  {
    "SnapEffect", GD_TYPE_ELEMENT, 0,
    N_("Snap element"), CAVE_OFFSET(snap_element), 1,
    N_("Snapping (pressing fire while moving) usually creates space, but it can create any other element.")
  },
  {
    "PushingBoulderProb", GD_TYPE_PROBABILITY, 0,
    N_("Probability of pushing (%)"), CAVE_OFFSET(pushing_stone_prob), 1,
    N_("Chance of player managing to push a stone, every game cycle he tries. This is the normal probability.")
  },
  {
    "", GD_LABEL, 0,
    N_("Sweet")
  },
  {
    "PushingBoulderProb", GD_TYPE_PROBABILITY, 0,
    N_("Probability of pushing (%)"), CAVE_OFFSET(pushing_stone_prob_sweet), 1,
    N_("Chance of player managing to push a stone, every game cycle he tries. This is used after eating sweet.")
  },
  {
    "PushingMegaStonesAfterSweet", GD_TYPE_BOOLEAN, 0,
    N_("Mega stones pushable"), CAVE_OFFSET(mega_stones_pushable_with_sweet), 1,
    N_("If it is true, mega stones can be pushed after eating sweet.")
  },

  // rocket launcher
  {
    "", GD_LABEL, 0,
    N_("Rocket launcher")
  },
  {
    "RocketLauncher.infinite", GD_TYPE_BOOLEAN, 0,
    N_("Infinite rockets"), CAVE_OFFSET(infinite_rockets), 1,
    N_("If it is true, the player is able to launch an infinite number of rockets. Otherwise every rocket launcher contains only a single rocket.")
  },
  {
    "Teleporter.buggy", GD_TYPE_BOOLEAN, 0,
    N_("Buggy teleporter"), CAVE_OFFSET(buggy_teleporter), 1,
    N_("If it is true, the player can only enter a teleporter from two sides (right and bottom side). Otherwise, the teleporter works as expected, and the player can enter from all four sides.")
  },

  // pneumatic hammer
  {
    "", GD_LABEL, 0,
    N_("Pneumatic hammer")
  },
  {
    "PneumaticHammer.frames", GD_TYPE_INT, 0,
    N_("Time for hammer (frames)"), CAVE_OFFSET(pneumatic_hammer_frame), 1,
    N_("This is the number of game frames, a pneumatic hammer is required to break a wall."), 1, 100
  },
  {
    "PneumaticHammer.wallsreappear", GD_TYPE_BOOLEAN, 0,
    N_("Hammered walls reappear"), CAVE_OFFSET(hammered_walls_reappear), 1,
    N_("If this is set to true, walls broken with a pneumatic hammer will reappear later.")
  },
  {
    "PneumaticHammer.wallsreappearframes", GD_TYPE_INT, 0,
    N_("   Timer for reappear (frames)"), CAVE_OFFSET(hammered_wall_reappear_frame), 1,
    N_("This sets the number of game frames, after hammered walls reappear, when the above setting is true."), 1, 200
  },

  // clock
  {
    "", GD_LABEL, GD_SHOW_LEVEL_LABEL,
    N_("Clock")
  },
  {
    "BonusTime", GD_TYPE_INT, 0,
    N_("Time bonus (s)"), CAVE_OFFSET(level_bonus_time), 5,
    N_("Bonus time when a clock is collected."), -100, 100
  },

  // voodoo
  {
    "", GD_LABEL, 0,
    N_("Voodoo Doll")
  },
  {
    "DummyProperties.diamondcollector", GD_TYPE_BOOLEAN, 0,
    N_("Can collect diamonds"), CAVE_OFFSET(voodoo_collects_diamonds), 1,
    N_("Controls if a voodoo doll can collect diamonds for the player.")
  },
  {
    "DummyProperties.penalty", GD_TYPE_BOOLEAN, 0,
    N_("Dies if hit by a stone"), CAVE_OFFSET(voodoo_dies_by_stone), 1,
    N_("Controls if the voodoo doll dies if it is hit by a stone. Then the player gets a time penalty, and it is turned to a gravestone surrounded by steel wall.")
  },
  {
    "DummyProperties.destructable", GD_TYPE_BOOLEAN, 0,
    N_("Disappear in explosion"), CAVE_OFFSET(voodoo_disappear_in_explosion), 1,
    N_("Controls if the voodoo can be destroyed by an explosion nearby. If not, it is converted to a gravestone, and you get a time penalty. If yes, the voodoo simply disappears.")
  },
  {
    "DummyProperties.alwayskillsplayer", GD_TYPE_BOOLEAN, 0,
    N_("Any way hurt, player explodes"), CAVE_OFFSET(voodoo_any_hurt_kills_player), 1,
    N_("If this setting is enabled, the player will explode if the voodoo is hurt in any possible way, ie. touched by a firefly, hit by a stone or an explosion.")
  },
  {
    "PenaltyTime", GD_TYPE_INT, 0,
    N_("Time penalty (s)"), CAVE_OFFSET(level_penalty_time), 5,
    N_("Penalty time when the voodoo is destroyed by a stone."), 0, 100
  },

  // AMOEBA
  {
    "", GD_TAB, 0,
    N_("Amoeba")
  },
  {
    "AmoebaProperties.immediately", GD_TYPE_BOOLEAN, 0,
    N_("Timer started immediately"), CAVE_OFFSET(amoeba_timer_started_immediately), 1,
    N_("If this flag is enabled, the amoeba slow growth timer will start at the beginning of the cave, regardless of the amoeba being let free or not. This can make a big difference when playing the cave!")
  },
  {
    "AmoebaProperties.waitforhatching", GD_TYPE_BOOLEAN, 0,
    N_("Timer waits for hatching"), CAVE_OFFSET(amoeba_timer_wait_for_hatching), 1,
    N_("This determines if the amoeba timer starts before the player appearing. Amoeba can always be activated before that; but if this is set to true, the timer will not start. This setting is for compatiblity for some old imported caves. As the player is usually born within a few seconds, changing this setting makes not much difference. It is not advised to change it, set the slow growth time to fit your needs instead.")
  },

  // amoeba
  {
    "", GD_LABEL, GD_SHOW_LEVEL_LABEL,
    N_("Amoeba")
  },
  {
    "AmoebaThreshold", GD_TYPE_RATIO, 0,
    N_("Threshold (cells)"), CAVE_OFFSET(level_amoeba_threshold), 5,
    N_("If the amoeba grows more than this fraction of the cave, it is considered too big and it converts to the element specified below."), 0, 16383
  },
  {
    "AmoebaTime", GD_TYPE_INT, 0,
    N_("Slow growth time (s)"), CAVE_OFFSET(level_amoeba_time), 5,
    N_("After this time, amoeba will grow very quickly."), 0, 999
  },
  {
    "AmoebaGrowthProb", GD_TYPE_PROBABILITY, 0,
    N_("Growth ratio, slow (%)"), CAVE_OFFSET(amoeba_growth_prob), 1,
    N_("This sets the speed at which a slow amoeba grows.")
  },
  {
    "AmoebaGrowthProb", GD_TYPE_PROBABILITY, 0,
    N_("Growth ratio, fast (%)"), CAVE_OFFSET(amoeba_fast_growth_prob), 1,
    N_("This sets the speed at which a fast amoeba grows.")
  },
  {
    "AMOEBABOULDEReffect", GD_TYPE_EFFECT, 0,
    N_("If too big, converts to"), CAVE_OFFSET(amoeba_too_big_effect), 1,
    N_("Controls which element an overgrown amoeba converts to.")
  },
  {
    "AMOEBADIAMONDeffect", GD_TYPE_EFFECT, 0,
    N_("If enclosed, converts to"), CAVE_OFFSET(amoeba_enclosed_effect), 1,
    N_("Controls which element an enclosed amoeba converts to.")
  },
  {
    "", GD_LABEL, GD_SHOW_LEVEL_LABEL,
    N_("Amoeba 2")
  },
  {
    "Amoeba2Threshold", GD_TYPE_RATIO, 0,
    N_("Threshold (cells)"), CAVE_OFFSET(level_amoeba_2_threshold), 5,
    N_("If the amoeba grows more than this fraction of the cave, it is considered too big and it converts to the element specified below."), 0, 16383
  },
  {
    "Amoeba2Time", GD_TYPE_INT, 0,
    N_("Slow growth time (s)"), CAVE_OFFSET(level_amoeba_2_time), 5,
    N_("After this time, amoeba will grow very quickly."), 0, 999
  },
  {
    "Amoeba2GrowthProb", GD_TYPE_PROBABILITY, 0,
    N_("Growth ratio, slow (%)"), CAVE_OFFSET(amoeba_2_growth_prob), 1,
    N_("This sets the speed at which a slow amoeba grows.")
  },
  {
    "Amoeba2GrowthProb", GD_TYPE_PROBABILITY, 0,
    N_("Growth ratio, fast (%)"), CAVE_OFFSET(amoeba_2_fast_growth_prob), 1,
    N_("This sets the speed at which a fast amoeba grows.")
  },
  {
    "Amoeba2Properties.explode", GD_TYPE_BOOLEAN, 0,
    N_("Explodes by amoeba"), CAVE_OFFSET(amoeba_2_explodes_by_amoeba), 1,
    N_("If this setting is enabled, an amoeba 2 will explode if it is touched by a normal amoeba.")
  },
  {
    "AMOEBA2EXPLOSIONeffect", GD_TYPE_EFFECT, 0,
    N_("   Explosion ends in"), CAVE_OFFSET(amoeba_2_explosion_effect), 1,
    N_("An amoeba 2 explodes to this element, when touched by the original amoeba.")
  },
  {
    "AMOEBA2BOULDEReffect", GD_TYPE_EFFECT, 0,
    N_("If too big, converts to"), CAVE_OFFSET(amoeba_2_too_big_effect), 1,
    N_("Controls which element an overgrown amoeba converts to.")
  },
  {
    "AMOEBA2DIAMONDeffect", GD_TYPE_EFFECT, 0,
    N_("If enclosed, converts to"), CAVE_OFFSET(amoeba_2_enclosed_effect), 1,
    N_("Controls which element an enclosed amoeba converts to.")
  },
  {
    "AMOEBA2LOOKSLIKEeffect", GD_TYPE_EFFECT, 0,
    N_("Looks like"), CAVE_OFFSET(amoeba_2_looks_like), 1,
    N_("Amoeba 2 can look like any other element. Hint: it can also look like a normal amoeba. Or it can look like slime, and then you have two different colored amoebas!")
  },

  // magic wall
  {
    "", GD_TAB, 0,
    N_("Magic Wall")
  },
  {
    "", GD_LABEL, GD_SHOW_LEVEL_LABEL,
    N_("Timing")
  },
  {
    "MagicWallTime", GD_TYPE_INT, 0,
    N_("Milling time (s)"), CAVE_OFFSET(level_magic_wall_time), 5,
    N_("Magic wall will stop after this time, and it cannot be activated again."), 0, 999
  },
  {
    "MagicWallProperties.zeroisinfinite", GD_TYPE_BOOLEAN, 0,
    N_("Milling time 0 is infinite"), CAVE_OFFSET(magic_timer_zero_is_infinite), 1,
    N_("This determines if the magic wall timer 0 is interpreted as infinite.")
  },
  {
    "MagicWallProperties.waitforhatching", GD_TYPE_BOOLEAN, 0,
    N_("Timer waits for hatching"), CAVE_OFFSET(magic_timer_wait_for_hatching), 1,
    N_("This determines if the magic wall timer starts before the player appearing. Magic can always be activated before that; but if this is set to true, the timer will not start.")
  },
  {
    "MagicWallProperties.convertamoeba", GD_TYPE_BOOLEAN, 0,
    N_("Stops amoeba"), CAVE_OFFSET(magic_wall_stops_amoeba), 1,
    N_("When the magic wall is activated, it can convert amoeba into diamonds.")
  },
  {
    "MagicWallProperties.breakscan", GD_TYPE_BOOLEAN, 0,
    N_("BD1 amoeba bug"), CAVE_OFFSET(magic_wall_breakscan), 1,
    N_("This setting emulates the BD1 bug, where a stone or a diamond falling into a magic wall sometimes caused the active amoeba to convert into a diamond. The rule is: if all amoeba cells above or left to the point where the stone or the diamond falls into the magic wall are enclosed, the amoeba is converted. The timing implications of the bug are not emulated.")
  },
  {
    "", GD_LABEL, 0,
    N_("Conversions")
  },
  {
    "MagicWallProperties", GD_TYPE_ELEMENT, 0,
    N_("Diamond to"), CAVE_OFFSET(magic_diamond_to), 1,
    N_("As a special effect, magic walls can convert diamonds to any other element.")
  },
  {
    "MagicWallProperties", GD_TYPE_ELEMENT, 0,
    N_("Stone to"), CAVE_OFFSET(magic_stone_to), 1,
    N_("As a special effect, magic walls can convert stones to any other element.")
  },
  {
    "MagicWallProperties.megastoneto", GD_TYPE_ELEMENT, 0,
    N_("Mega stone to"), CAVE_OFFSET(magic_mega_stone_to), 1,
    N_("If a mega stone falls into the magic wall, it will drop this element.")
  },
  {
    "MagicWallProperties.lightstoneto", GD_TYPE_ELEMENT, 0,
    N_("Light stone to"), CAVE_OFFSET(magic_light_stone_to), 1,
    N_("If a light stone falls into the magic wall, it will drop this element.")
  },
  {
    "MagicWallProperties.nitropackto", GD_TYPE_ELEMENT, 0,
    N_("Nitro pack to"), CAVE_OFFSET(magic_nitro_pack_to), 1,
    N_("If a nitro pack falls into the magic wall, it will be turned to this element.")
  },
  {
    "MagicWallProperties.nutto", GD_TYPE_ELEMENT, 0,
    N_("Nut to"), CAVE_OFFSET(magic_nut_to), 1,
    N_("As a special effect, magic walls can convert nuts to any other element.")
  },
  {
    "MagicWallProperties.flyingstoneto", GD_TYPE_ELEMENT, 0,
    N_("Flying stone to"), CAVE_OFFSET(magic_flying_stone_to), 1,
    N_("If a flying stone climbs up into the magic wall, it will be turned to this element. Remember that flying stones enter the magic wall from its bottom, not from the top!")
  },
  {
    "MagicWallProperties.flyingdiamondto", GD_TYPE_ELEMENT, 0,
    N_("Flying diamonds to"), CAVE_OFFSET(magic_flying_diamond_to), 1,
    N_("If a flying diamond enters the magic wall, it will be turned to this element. Remember that flying diamonds enter the magic wall from its bottom, not from the top!")
  },

  // slime
  {
    "", GD_TAB, 0,
    N_("Slime")
  },
  {
    "", GD_LABEL, GD_SHOW_LEVEL_LABEL,
    N_("Permeability")
  },
  {
    "", GD_TYPE_BOOLEAN, GD_DONT_SAVE,
    N_("Predictable"), CAVE_OFFSET(slime_predictable), 1,
    N_("Controls if the predictable random generator is used for slime. It is required for compatibility with some older caves.")
  },

  // permeabilities are "always" saved; and according to the predictability, one of them is removed.
  {
    "SlimePermeability", GD_TYPE_PROBABILITY, GD_ALWAYS_SAVE,
    N_("Permeability (unpredictable, %)"), CAVE_OFFSET(level_slime_permeability[0]), 5,
    N_("This controls the rate at which elements go through the slime. Higher values represent higher probability of passing. This one is for unpredictable slime.")
  },
  {
    "SlimePermeabilityC64", GD_TYPE_INT, GD_ALWAYS_SAVE,
    N_("Permeability (predictable, bits)"), CAVE_OFFSET(level_slime_permeability_c64[0]), 5,
    N_("This controls the rate at which elements go through the slime. This one is for predictable slime, and the value is used for a bitwise AND function. The values used by the C64 engines are 0, 128, 192, 224, 240, 248, 252, 254 and 255."), 0, 255
  },
  {
    "SlimePredictableC64.seed", GD_TYPE_INT, 0,
    N_("Random seed (predictable)"), CAVE_OFFSET(level_slime_seed_c64), 5,
    N_("The random number seed for predictable slime. Use -1 to leave on its default. Not recommended to change. Does not affect unpredictable slime."), -1, 65535
  },
  {
    "", GD_LABEL, 0,
    N_("Passing elements")
  },
  {
    "SlimeProperties", GD_TYPE_ELEMENT, 0,
    N_("Eats this..."), CAVE_OFFSET(slime_eats_1), 1,
    N_("Slime can let other elements than stone and diamond go through. It always lets a waiting or a chasing stone pass, though. Also, flying diamonds and stones, as well as bladders are always passed.")
  },
  {
    "SlimeProperties", GD_TYPE_ELEMENT, 0,
    N_("  ... and converts to"), CAVE_OFFSET(slime_converts_1), 1,
    N_("Slime can let other elements than stone and diamond go through. It always lets a waiting or a chasing stone pass, though. Also, flying diamonds and stones, as well as bladders are always passed.")
  },
  {
    "SlimeProperties", GD_TYPE_ELEMENT, 0,
    N_("Eats this..."), CAVE_OFFSET(slime_eats_2), 1,
    N_("Slime can let other elements than stone and diamond go through. It always lets a waiting or a chasing stone pass, though. Also, flying diamonds and stones, as well as bladders are always passed.")
  },
  {
    "SlimeProperties", GD_TYPE_ELEMENT, 0,
    N_("  ... and converts to"), CAVE_OFFSET(slime_converts_2), 1,
    N_("Slime can let other elements than stone and diamond go through. It always lets a waiting or a chasing stone pass, though. Also, flying diamonds and stones, as well as bladders are always passed.")
  },
  {
    "SlimeProperties", GD_TYPE_ELEMENT, 0,
    N_("Eats this..."), CAVE_OFFSET(slime_eats_3), 1,
    N_("Slime can let other elements than stone and diamond go through. It always lets a waiting or a chasing stone pass, though. Also, flying diamonds and stones, as well as bladders are always passed.")
  },
  {
    "SlimeProperties", GD_TYPE_ELEMENT, 0,
    N_("  ... and converts to"), CAVE_OFFSET(slime_converts_3), 1,
    N_("Slime can let other elements than stone and diamond go through. It always lets a waiting or a chasing stone pass, though. Also, flying diamonds and stones, as well as bladders are always passed.")
  },

  // ACTIVE 2
  {
    "", GD_TAB, 0,
    N_("Other elements")
  },

  // acid
  {
    "", GD_LABEL, 0,
    N_("Acid")
  },
  {
    "AcidProperties", GD_TYPE_ELEMENT, 0,
    N_("Eats this element"), CAVE_OFFSET(acid_eats_this), 1,
    N_("The element which acid eats. If it cannot find any, it simply disappears.")
  },
  {
    "AcidProperties", GD_TYPE_PROBABILITY, 0,
    N_("Spread ratio (%)"), CAVE_OFFSET(acid_spread_ratio), 1,
    N_("The probability at which an acid will explode and eat neighbouring elements.")
  },
  {
    "ACIDEffect", GD_TYPE_EFFECT, 0,
    N_("Leaves this behind"), CAVE_OFFSET(acid_turns_to), 1,
    N_("If acid converts to an explosion puff on spreading or any other element.")
  },

  // biter
  {
    "", GD_LABEL, 0,
    N_("Biter")
  },
  {
    "BiterProperties", GD_TYPE_INT, 0,
    N_("Delay (frame)"), CAVE_OFFSET(biter_delay_frame), 1,
    N_("Number of frames biters wait between movements."), 0, 3
  },
  {
    "BiterProperties", GD_TYPE_ELEMENT, 0,
    N_("Eats this"), CAVE_OFFSET(biter_eat), 1,
    N_("Biters eat this element. (They always eat dirt.)")
  },

  // bladder
  {
    "", GD_LABEL, 0,
    N_("Bladder")
  },
  {
    "BladderProperties", GD_TYPE_ELEMENT, 0,
    N_("Converts to clock by touching"), CAVE_OFFSET(bladder_converts_by), 1,
    NULL
  },

  // expanding wall
  {
    "", GD_LABEL, 0,
    N_("Expanding wall")
  },
  {
    "ExpandingWallDirection.changed", GD_TYPE_BOOLEAN, 0,
    N_("Direction changed"), CAVE_OFFSET(expanding_wall_changed), 1,
    N_("If this option is enabled, the direction of growing for the horizontal and vertical expanding wall is switched. As you can use both horizontal and vertical expanding walls in a cave, it is not recommended to change this setting, as it might be confusing. You should rather select the type with the correct direction from the element box when drawing the cave.")
  },

  // replicator
  {
    "", GD_LABEL, 0,
    N_("Replicator")
  },
  {
    "ReplicatorActive", GD_TYPE_BOOLEAN, 0,
    N_("Active at start"), CAVE_OFFSET(replicators_active), 1,
    N_("Whether the replicators are turned on or off at the cave start.")
  },
  {
    "ReplicatorDelayFrame", GD_TYPE_INT, 0,
    N_("Delay (frame)"), CAVE_OFFSET(replicator_delay_frame), 1,
    N_("Number of frames to wait between replicating elements."), 0, 100
  },

  // conveyor belt
  {
    "", GD_LABEL, 0,
    N_("Conveyor belt")
  },
  {
    "ConveyorBeltActive", GD_TYPE_BOOLEAN, 0,
    N_("Active at start"), CAVE_OFFSET(conveyor_belts_active), 1,
    N_("Whether the conveyor belts are moving when the cave starts.")
  },
  {
    "ConveyorBeltDirection.changed", GD_TYPE_BOOLEAN, 0,
    N_("Direction changed"), CAVE_OFFSET(conveyor_belts_direction_changed), 1,
    N_("If the conveyor belts' movement is changed, ie. they are running in the opposite direction. As you can freely use left and right going versions of the conveyor belt in a cave, it is not recommended to change this setting, rather you should select the correct one from the element box when drawing.")
  },
  {
    "ConveyorBelt.buggy", GD_TYPE_BOOLEAN, 0,
    N_("Buggy conveyor belt"), CAVE_OFFSET(conveyor_belts_buggy), 1,
    N_("If it is true, pushing an object onto an active (going right) conveyor belt from the left side results in that object immediately jumping another tile to the right before moving further on the conveyor belt. Otherwise, the conveyor belt works as expected, and objects being pushed onto it from the left side move normally.")
  },

  // water
  {
    "", GD_LABEL, 0,
    N_("Water")
  },
  {
    "WaterProperties.doesnotflowdown", GD_TYPE_BOOLEAN, 0,
    N_("Does not flow downwards"), CAVE_OFFSET(water_does_not_flow_down), 1,
    N_("In CrDr, the water element had the odd property that it did not flow downwards, only in other directions. This flag emulates this behaviour.")
  },

  // nut
  {
    "", GD_LABEL, 0,
    N_("Nut")
  },
  {
    "Nut.whencrushed", GD_TYPE_ELEMENT, 0,
    N_("Turns to when crushed"), CAVE_OFFSET(nut_turns_to_when_crushed), 1,
    N_("Normally, a nut contains a diamond. If you crush it with a stone, the diamond will appear after the usual nut explosion sequence. This setting can be used to change the element the nut contains.")
  },

  // EFFECTS 1
  {
    "", GD_TAB, 0,
    N_("Effects")
  },

  // cave effects
  {
    "", GD_LABEL, 0,
    N_("Stone and diamond effects")
  },
  {
    "BOULDERfallingeffect", GD_TYPE_EFFECT, 0,
    N_("Falling stones convert to"), CAVE_OFFSET(stone_falling_effect), 1,
    N_("When a stone begins falling, it converts to this element.")
  },
  {
    "BOULDERbouncingeffect", GD_TYPE_EFFECT, 0,
    N_("Bouncing stones convert to"), CAVE_OFFSET(stone_bouncing_effect), 1,
    N_("When a stone stops falling and rolling, it converts to this element.")
  },
  {
    "DIAMONDfallingeffect", GD_TYPE_EFFECT, 0,
    N_("Falling diamonds convert to"), CAVE_OFFSET(diamond_falling_effect), 1,
    N_("When a diamond begins falling, it converts to this element.")
  },
  {
    "DIAMONDbouncingeffect", GD_TYPE_EFFECT, 0,
    N_("Bouncing diamonds convert to"), CAVE_OFFSET(diamond_bouncing_effect), 1,
    N_("When a diamond stops falling and rolling, it converts to this element.")
  },

  {
    "", GD_LABEL, 0,
    N_("Creature explosion effects")
  },
  {
    "FireflyExplodeTo", GD_TYPE_ELEMENT, 0,
    N_("Fireflies explode to"), CAVE_OFFSET(firefly_explode_to), 1,
    N_("When a firefly explodes, it will create this element. Change this setting wisely. The firefly is a traditional element which is expected to explode to empty space.")
  },
  {
    "AltFireflyExplodeTo", GD_TYPE_ELEMENT, 0,
    N_("Alt. fireflies explode to"), CAVE_OFFSET(alt_firefly_explode_to), 1,
    N_("When an alternative firefly explodes, it will create this element. Use this setting wisely. Do not create a firefly which explodes to stones, for example: use the stonefly instead.")
  },
  {
    "ButterflyExplodeTo", GD_TYPE_ELEMENT, 0,
    N_("Butterflies explode to"), CAVE_OFFSET(butterfly_explode_to), 1,
    N_("When a butterfly explodes, it will create this element. Use this setting wisely. Butterflies should explode to diamonds. If you need a creature which explodes to space, use the firefly instead.")
  },
  {
    "AltButterflyExplodeTo", GD_TYPE_ELEMENT, 0,
    N_("Alt. butterflies explode to"), CAVE_OFFSET(alt_butterfly_explode_to), 1,
    N_("When an alternative butterfly explodes, it will create this element. Use this setting wisely.")
  },
  {
    "StoneflyExplodeTo", GD_TYPE_ELEMENT, 0,
    N_("Stoneflies explode to"), CAVE_OFFSET(stonefly_explode_to), 1,
    N_("When a stonefly explodes, it will create this element.")
  },
  {
    "DragonflyExplodeTo", GD_TYPE_ELEMENT, 0,
    N_("Dragonflies explode to"), CAVE_OFFSET(dragonfly_explode_to), 1,
    N_("When a dragonfly explodes, it will create this element.")
  },

  {
    "", GD_LABEL, 0,
    N_("Explosion effects")
  },
  {
    "EXPLOSIONEffect", GD_TYPE_EFFECT, 0,
    N_("Explosions end in"), CAVE_OFFSET(explosion_effect), 1,
    N_("This element appears in places where an explosion finishes.")
  },
  {
    "EXPLOSION3S", GD_TYPE_EFFECT, 0,
    N_("Explosion stage 3 to"), CAVE_OFFSET(explosion_3_effect), 1,
    N_("This element appears as the next stage of explosion 3. Not recommended to change. Check explosion effects on the effects page for a better alternative.")
  },
  {
    "DIAMONDBIRTHEffect", GD_TYPE_EFFECT, 0,
    N_("Diamond births end in"), CAVE_OFFSET(diamond_birth_effect), 1,
    N_("When a diamond birth animation reaches its end, it will leave this element there. This can be used to change the element butterflies explode to.")
  },
  {
    "BOMBEXPLOSIONeffect", GD_TYPE_EFFECT, 0,
    N_("Bombs explosions end in"), CAVE_OFFSET(bomb_explosion_effect), 1,
    N_("Use this setting to select the element the exploding bomb creates.")
  },
  {
    "NITROEXPLOSIONeffect", GD_TYPE_EFFECT, 0,
    N_("Nitro explosions end in"), CAVE_OFFSET(nitro_explosion_effect), 1,
    N_("The nitro explosions can create some element other than space.")
  },

  // EFFECTS 2
  {
    "", GD_TAB, 0,
    N_("More effects")
  },

  // visual effects
  {
    "", GD_LABEL, 0,
    N_("Visual effects")
  },
  {
    "EXPANDINGWALLLOOKSLIKEeffect", GD_TYPE_EFFECT, 0,
    N_("Expanding wall looks like"), CAVE_OFFSET(expanding_wall_looks_like), 1,
    N_("This is a compatibility setting for old caves. If you need an expanding wall which looks like steel, you should rather choose the expanding steel wall from the element box.")
  },
  {
    "DIRTLOOKSLIKEeffect", GD_TYPE_EFFECT, 0,
    N_("Dirt looks like"), CAVE_OFFSET(dirt_looks_like), 1,
    N_("Compatibility setting. Use it wisely! Anything other than Dirt 2 (which can be used to emulate the Dirt Mod) is not recommended.")
  },

  // creature effects
  {
    "", GD_LABEL, 0,
    N_("Creature movement")
  },
  {
    "EnemyDirectionProperties.startbackwards", GD_TYPE_BOOLEAN, 0,
    N_("Start backwards"), CAVE_OFFSET(creatures_backwards), 1,
    N_("Whether the direction creatures travel will already be switched at the cave start.")
  },
  {
    "EnemyDirectionProperties.time", GD_TYPE_INT, 0,
    N_("Automatically turn (s)"), CAVE_OFFSET(creatures_direction_auto_change_time), 1,
    N_("If this is greater than zero, creatures will automatically change direction in every x seconds."), 0, 999
  },
  {
    "EnemyDirectionProperties.changeathatching", GD_TYPE_BOOLEAN, 0,
    N_("Auto turn on hatching"), CAVE_OFFSET(creatures_direction_auto_change_on_start), 1,
    N_("If this is set to true, creatures also turn at the start signal. If false, the first change in direction occurs only later.")
  },

  // gravity
  {
    "", GD_LABEL, 0,
    N_("Gravitation change")
  },
  {
    "Gravitation", GD_TYPE_DIRECTION, 0,
    N_("Direction"), CAVE_OFFSET(gravity), 1,
    N_("The direction where stones and diamonds fall.")
  },
  {
    "GravitationSwitchActive", GD_TYPE_BOOLEAN, 0,
    N_("Switch active at start"), CAVE_OFFSET(gravity_switch_active), 1,
    N_("If set to true, the gravitation switch will be already activated, when the cave is started, as if a pot has already been collected.")
  },
  {
    "SkeletonsForPot", GD_TYPE_INT, 0,
    N_("Skeletons needed for pot"), CAVE_OFFSET(skeletons_needed_for_pot), 1,
    N_("The number of skeletons to be collected to be able to use a pot."), 0, 50
  },
  {
    "GravitationChangeDelay", GD_TYPE_INT, 0,
    N_("Gravitation switch delay"), CAVE_OFFSET(gravity_change_time), 1,
    N_("The gravitation changes after a while using the gravitation switch. This option sets the number of seconds to wait."), 1, 60
  },

  // SOUND
  {
    "", GD_TAB, 0,
    N_("Sound")
  },
  {
    "", GD_LABEL, 0,
    N_("Sound for elements")
  },
  {
    "Diamond.sound", GD_TYPE_BOOLEAN, 0,
    N_("Diamond"), CAVE_OFFSET(diamond_sound), 1,
    N_("If true, falling diamonds will have sound.")
  },
  {
    "Stone.sound", GD_TYPE_BOOLEAN, 0,
    N_("Stone"), CAVE_OFFSET(stone_sound), 1,
    N_("If true, falling and pushed stones will have sound.")
  },
  {
    "Nut.sound", GD_TYPE_BOOLEAN, 0,
    N_("Nut"), CAVE_OFFSET(nut_sound), 1,
    N_("If true, falling and cracked nuts have sound.")
  },
  {
    "NitroPack.sound", GD_TYPE_BOOLEAN, 0,
    N_("Nitro pack"), CAVE_OFFSET(nitro_sound), 1,
    N_("If true, falling and pushed nitro packs will have sound.")
  },
  {
    "ExpandingWall.sound", GD_TYPE_BOOLEAN, 0,
    N_("Expanding wall"), CAVE_OFFSET(expanding_wall_sound), 1,
    N_("If true, expanding wall will have sound.")
  },
  {
    "FallingWall.sound", GD_TYPE_BOOLEAN, 0,
    N_("Falling wall"), CAVE_OFFSET(falling_wall_sound), 1,
    N_("If true, falling wall will have sound.")
  },
  {
    "AmoebaProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Amoeba"), CAVE_OFFSET(amoeba_sound), 1,
    N_("Controls if the living amoeba has sound or not.")
  },
  {
    "MagicWallProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Magic wall"), CAVE_OFFSET(magic_wall_sound), 1,
    N_("If true, the activated magic wall will have sound.")
  },
  {
    "SlimeProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Slime"), CAVE_OFFSET(slime_sound), 1,
    N_("If true, the elements passing slime will have sound.")
  },
  {
    "LavaProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Lava"), CAVE_OFFSET(lava_sound), 1,
    N_("If true, the elements sinking in lava will have sound.")
  },
  {
    "ReplicatorProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Replicator"), CAVE_OFFSET(replicator_sound), 1,
    N_("If true, the new element appearing under the replicator will make sound.")
  },
  {
    "AcidProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Acid"), CAVE_OFFSET(acid_spread_sound), 1,
    N_("If true, the acid spreading will have sound.")
  },
  {
    "BiterProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Biter"), CAVE_OFFSET(biter_sound), 1,
    N_("Biters eating something or pushing a stone will have sound.")
  },
  {
    "BladderProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Bladder"), CAVE_OFFSET(bladder_sound), 1,
    N_("Bladders moving and being pushed can have sound.")
  },
  {
    "WaterProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Water"), CAVE_OFFSET(water_sound), 1,
    N_("If true, the cave containing water will have sound.")
  },
  {
    "PneumaticHammer.sound", GD_TYPE_BOOLEAN, 0,
    N_("Pneumatic hammer"), CAVE_OFFSET(pneumatic_hammer_sound), 1,
    N_("If true, using the pneumatic hammer will have sound.")
  },
  {
    "BladderSpender.sound", GD_TYPE_BOOLEAN, 0,
    N_("Bladder spender"), CAVE_OFFSET(bladder_spender_sound), 1,
    N_("If true, the bladder spender will make sound, when the bladder appears.")
  },
  {
    "BladderConvert.sound", GD_TYPE_BOOLEAN, 0,
    N_("Bladder convert"), CAVE_OFFSET(bladder_convert_sound), 1,
    N_("If true, the bladder converting to a clock will make sound.")
  },
  {
    "", GD_LABEL, 0,
    N_("Event sounds")
  },
  {
    "GravityChange.sound", GD_TYPE_BOOLEAN, 0,
    N_("Gravity change"), CAVE_OFFSET(gravity_change_sound), 1,
    N_("If true, the gravity changing will make sound.")
  },
  {
    "EnemyDirectionProperties.sound", GD_TYPE_BOOLEAN, 0,
    N_("Creature direction change"), CAVE_OFFSET(creature_direction_auto_change_sound), 1,
    N_("If this is set to true, creatures changing direction will be signaled by a sound.")
  },

  // COMPATIBILITY
  {
    "", GD_TAB, 0,
    N_("Compatibility")
  },
  {
    "", GD_LABEL, 0,
    N_("Skeleton")
  },
  {
    "SkeletonsWorthDiamonds", GD_TYPE_INT, GD_COMPATIBILITY_SETTING,
    N_("Skeletons worth diamonds"), CAVE_OFFSET(skeletons_worth_diamonds), 1,
    N_("The number of diamonds each skeleton is worth. Normally skeletons are used for letting the player use the pot! They are not intended to be used as a second kind of diamond."), 0, 10
  },
  {
    "", GD_LABEL, 0,
    N_("Borders")
  },
  {
    "BorderProperties.lineshift", GD_TYPE_BOOLEAN, 0,
    N_("Line shifting border"), CAVE_OFFSET(lineshift), 1,
    N_("If this is set to true, the player exiting on either side will appear one row lower or upper on the other side.")
  },
  {
    "BorderProperties.objectwraparound", GD_TYPE_BOOLEAN, 0,
    N_("Objects wrap around"), CAVE_OFFSET(wraparound_objects), 1,
    N_("If true, objects will wrap around the cave borders as well, ie. if you drag a line to the left, part of it will appear on the right hand side of the cave. The drawing in this case is also affected by the line shifting border property. If that one is enabled, too, crossing the left hand side or right hand side boundary will decrement or increment the row, and crossing the top or the bottom boundary will have no effect at all.")
  },
  {
    "BorderProperties.scan", GD_TYPE_BOOLEAN, 0,
    N_("Scan first and last row"), CAVE_OFFSET(border_scan_first_and_last), 1,
    N_("Elements move on first and last row, too. Usually those rows are the border. The games created by the original editor were not allowed to put anything but steel wall there, so it was not apparent that the borders were not processed by the engine. Some old caves need this for compatibility; it is not recommended to change this setting for newly designed caves, though.")
  },
  {
    "", GD_LABEL, 0,
    N_("Other")
  },
  {
    "ShortExplosions", GD_TYPE_BOOLEAN, 0,
    N_("Short explosions"), CAVE_OFFSET(short_explosions), 1,
    N_("In 1stB and newer engines, explosions were longer, they took five cave frames to complete, as opposed to four frames in the original.")
  },
  {
    "GravityAffectsAll", GD_TYPE_BOOLEAN, 0,
    N_("Gravity change affects everything"), CAVE_OFFSET(gravity_affects_all), 1,
    N_("If this is enabled, changing the gravity will also affect bladders (moving and pushing), bladder spenders, falling walls and waiting stones. Otherwise, those elements behave as gravity was always pointing downwards. This is a compatibility setting which is not recommended to change. It is intended for imported caves.")
  },

  {
    NULL
  }
  // end of array
};

// entries.
// type given for each element
const GdStructDescriptor gd_replay_properties[] =
{
  // default data
  { "",             GD_TAB,             0, N_("Replay") },

  { "Level",        GD_TYPE_INT,        0, NULL, STRUCT_OFFSET(GdReplay, level),         1, NULL },
  { "RandomSeed",   GD_TYPE_INT,        0, NULL, STRUCT_OFFSET(GdReplay, seed),          1, NULL },
  // { "Saved",     GD_TYPE_BOOLEAN,    0, NULL, STRUCT_OFFSET(GdReplay, saved),         1, NULL },
  // no need to state in bdcff, as saved replays are saved ones :)
  { "Player",       GD_TYPE_STRING,     0, NULL, STRUCT_OFFSET(GdReplay, player_name),   1, NULL },
  { "Date",         GD_TYPE_STRING,     0, NULL, STRUCT_OFFSET(GdReplay, date),          1, NULL },
  { "Comment",      GD_TYPE_LONGSTRING, 0, NULL, STRUCT_OFFSET(GdReplay, comment),       1, NULL },
  { "RecordedWith", GD_TYPE_STRING,     0, NULL, STRUCT_OFFSET(GdReplay, recorded_with), 1, NULL },
  { "Score",        GD_TYPE_INT,        0, NULL, STRUCT_OFFSET(GdReplay, score),         1, NULL },
  { "Duration",     GD_TYPE_INT,        0, NULL, STRUCT_OFFSET(GdReplay, duration),      1, NULL },
  { "Success",      GD_TYPE_BOOLEAN,    0, NULL, STRUCT_OFFSET(GdReplay, success),       1, NULL },
  { "Checksum",     GD_TYPE_INT,        0, NULL, STRUCT_OFFSET(GdReplay, checksum),      1, NULL },

  { NULL }  // end of array
};

GdPropertyDefault gd_cave_defaults_gdash[] =
{
  // default data
  { CAVE_OFFSET(selectable),					TRUE				},
  { CAVE_OFFSET(intermission),					FALSE				},
  { CAVE_OFFSET(intermission_instantlife),			FALSE				},
  { CAVE_OFFSET(intermission_rewardlife),			TRUE				},
  { CAVE_OFFSET(w),						40				},
  { CAVE_OFFSET(h),						22				},
  { CAVE_OFFSET(x1),						0				},
  { CAVE_OFFSET(y1),						0				},
  { CAVE_OFFSET(x2),						39				},
  { CAVE_OFFSET(y2),						21				},
  { CAVE_OFFSET(color_b),					0				},
  { CAVE_OFFSET(color[0]),					0				},
  { CAVE_OFFSET(color[1]),					8				},
  { CAVE_OFFSET(color[2]),					11				},
  { CAVE_OFFSET(color[3]),					1				},
  { CAVE_OFFSET(color[4]),					5				},
  { CAVE_OFFSET(color[5]),					6				},

  // difficulty
  { CAVE_OFFSET(level_diamonds[0]),				10				},
  { CAVE_OFFSET(diamond_value),					0				},
  { CAVE_OFFSET(extra_diamond_value),				0				},
  { CAVE_OFFSET(level_time[0]),					999				},
  { CAVE_OFFSET(max_time),					999				},
  { CAVE_OFFSET(pal_timing),					FALSE				},
  { CAVE_OFFSET(level_timevalue[0]),				1				},
  { CAVE_OFFSET(scheduling),					GD_SCHEDULING_MILLISECONDS	},
  { CAVE_OFFSET(level_ckdelay[0]),				0				},
  { CAVE_OFFSET(level_hatching_delay_time[0]),			2				},
  { CAVE_OFFSET(level_speed[0]),				200				},
  { CAVE_OFFSET(level_hatching_delay_frame[0]),			21				},
  { CAVE_OFFSET(level_rand[0]),					0				},

  // initial fill
  { CAVE_OFFSET(initial_border),				O_STEEL				},
  { CAVE_OFFSET(initial_fill),					O_DIRT				},
  { CAVE_OFFSET(random_fill[0]),				O_DIRT				},
  { CAVE_OFFSET(random_fill_probability[0]),			0				},
  { CAVE_OFFSET(random_fill[1]),				O_DIRT				},
  { CAVE_OFFSET(random_fill_probability[1]),			0				},
  { CAVE_OFFSET(random_fill[2]),				O_DIRT				},
  { CAVE_OFFSET(random_fill_probability[2]),			0				},
  { CAVE_OFFSET(random_fill[3]),				O_DIRT				},
  { CAVE_OFFSET(random_fill_probability[3]),			0				},

  // PLAYER
  { CAVE_OFFSET(diagonal_movements),				FALSE				},
  { CAVE_OFFSET(active_is_first_found),				TRUE				},
  { CAVE_OFFSET(snap_element),					O_SPACE				},
  { CAVE_OFFSET(pushing_stone_prob),				250000				},
  { CAVE_OFFSET(pushing_stone_prob_sweet),			1000000				},
  { CAVE_OFFSET(mega_stones_pushable_with_sweet),		FALSE				},
  { CAVE_OFFSET(pneumatic_hammer_frame),			5				},
  { CAVE_OFFSET(hammered_walls_reappear),			FALSE				},
  { CAVE_OFFSET(hammered_wall_reappear_frame),			100				},
  { CAVE_OFFSET(voodoo_collects_diamonds),			FALSE				},
  { CAVE_OFFSET(voodoo_disappear_in_explosion),			TRUE				},
  { CAVE_OFFSET(voodoo_dies_by_stone),				FALSE				},
  { CAVE_OFFSET(voodoo_any_hurt_kills_player),			FALSE				},
  { CAVE_OFFSET(level_bonus_time),				30				},
  { CAVE_OFFSET(level_penalty_time),				30				},

  // magic wall
  { CAVE_OFFSET(level_magic_wall_time),				999				},
  { CAVE_OFFSET(magic_diamond_to),				O_STONE_F			},
  { CAVE_OFFSET(magic_stone_to),				O_DIAMOND_F			},
  { CAVE_OFFSET(magic_mega_stone_to),				O_NITRO_PACK_F			},
  { CAVE_OFFSET(magic_light_stone_to),				O_LIGHT_STONE_F			},
  { CAVE_OFFSET(magic_nitro_pack_to),				O_MEGA_STONE_F			},
  { CAVE_OFFSET(magic_nut_to),					O_NUT_F				},
  { CAVE_OFFSET(magic_flying_stone_to),				O_FLYING_DIAMOND_F 		},
  { CAVE_OFFSET(magic_flying_diamond_to),			O_FLYING_STONE_F		},
  { CAVE_OFFSET(magic_wall_stops_amoeba),			TRUE				},
  { CAVE_OFFSET(magic_timer_zero_is_infinite),			TRUE				},
  { CAVE_OFFSET(magic_timer_wait_for_hatching),			FALSE				},

  // amoeba
  { CAVE_OFFSET(amoeba_timer_started_immediately),		TRUE				},
  { CAVE_OFFSET(amoeba_timer_wait_for_hatching),		FALSE				},

  { CAVE_OFFSET(level_amoeba_threshold),			200				},
  { CAVE_OFFSET(level_amoeba_time),				999				},

  { CAVE_OFFSET(amoeba_growth_prob),				31250				},
  { CAVE_OFFSET(amoeba_fast_growth_prob),			250000				},
  { CAVE_OFFSET(amoeba_timer_started_immediately),		TRUE				},
  { CAVE_OFFSET(amoeba_timer_wait_for_hatching),		FALSE				},
  { CAVE_OFFSET(amoeba_too_big_effect),				O_STONE				},
  { CAVE_OFFSET(amoeba_enclosed_effect),			O_DIAMOND			},

  // amoeba
  { CAVE_OFFSET(level_amoeba_2_threshold),			200				},
  { CAVE_OFFSET(level_amoeba_2_time),				999				},

  { CAVE_OFFSET(amoeba_2_growth_prob),				31250				},
  { CAVE_OFFSET(amoeba_2_fast_growth_prob),			250000				},
  { CAVE_OFFSET(amoeba_2_too_big_effect),			O_STONE				},
  { CAVE_OFFSET(amoeba_2_enclosed_effect),			O_DIAMOND			},
  { CAVE_OFFSET(amoeba_2_explodes_by_amoeba),			TRUE				},
  { CAVE_OFFSET(amoeba_2_looks_like),				O_AMOEBA_2			},
  { CAVE_OFFSET(amoeba_2_explosion_effect),			O_SPACE				},

  // water
  { CAVE_OFFSET(water_does_not_flow_down),			FALSE				},

  // nut
  { CAVE_OFFSET(nut_turns_to_when_crushed),			O_NUT_CRACK_1			},

  // expanding wall
  { CAVE_OFFSET(expanding_wall_changed),			FALSE				},

  // replicator
  { CAVE_OFFSET(replicator_delay_frame),			4				},
  { CAVE_OFFSET(replicators_active),				TRUE				},

  // conveyor belt
  { CAVE_OFFSET(conveyor_belts_active),				TRUE				},
  { CAVE_OFFSET(conveyor_belts_direction_changed),		FALSE				},
  { CAVE_OFFSET(conveyor_belts_buggy),				TRUE				},

  // slime
  { CAVE_OFFSET(slime_predictable),				TRUE				},
  { CAVE_OFFSET(level_slime_seed_c64),				-1				},
  { CAVE_OFFSET(level_slime_permeability_c64),			0				},
  { CAVE_OFFSET(level_slime_permeability_old),			0				},
  { CAVE_OFFSET(level_slime_permeability),			1000000				},
  { CAVE_OFFSET(slime_eats_1),					O_DIAMOND			},
  { CAVE_OFFSET(slime_converts_1),				O_DIAMOND_F			},
  { CAVE_OFFSET(slime_eats_2),					O_STONE				},
  { CAVE_OFFSET(slime_converts_2),				O_STONE_F			},
  { CAVE_OFFSET(slime_eats_3),					O_NUT				},
  { CAVE_OFFSET(slime_converts_3),				O_NUT_F				},

  // acid
  { CAVE_OFFSET(acid_eats_this),				O_DIRT				},
  { CAVE_OFFSET(acid_spread_ratio),				31250				},
  { CAVE_OFFSET(acid_turns_to),					O_EXPLODE_3			},

  // biter
  { CAVE_OFFSET(biter_delay_frame),				0				},
  { CAVE_OFFSET(biter_eat),					O_DIAMOND			},

  // bladder
  { CAVE_OFFSET(bladder_converts_by),				O_VOODOO			},

  // teleporter
  { CAVE_OFFSET(buggy_teleporter),				TRUE				},

  // SOUND
  { CAVE_OFFSET(amoeba_sound),					TRUE				},
  { CAVE_OFFSET(magic_wall_sound),				TRUE				},
  { CAVE_OFFSET(slime_sound),					TRUE				},
  { CAVE_OFFSET(lava_sound),					TRUE				},
  { CAVE_OFFSET(replicator_sound),				TRUE				},
  { CAVE_OFFSET(acid_spread_sound),				TRUE				},
  { CAVE_OFFSET(biter_sound),					TRUE				},
  { CAVE_OFFSET(bladder_sound),					TRUE				},
  { CAVE_OFFSET(water_sound),					TRUE				},
  { CAVE_OFFSET(stone_sound),					TRUE				},
  { CAVE_OFFSET(nut_sound),					TRUE				},
  { CAVE_OFFSET(diamond_sound),					TRUE				},
  { CAVE_OFFSET(falling_wall_sound),				TRUE				},
  { CAVE_OFFSET(expanding_wall_sound),				TRUE				},
  { CAVE_OFFSET(nitro_sound),					TRUE				},
  { CAVE_OFFSET(pneumatic_hammer_sound),			TRUE				},
  { CAVE_OFFSET(bladder_spender_sound),				TRUE				},
  { CAVE_OFFSET(bladder_convert_sound),				TRUE				},
  { CAVE_OFFSET(gravity_change_sound),				TRUE				},
  { CAVE_OFFSET(creature_direction_auto_change_sound),		TRUE				},

  // creature effects
  { CAVE_OFFSET(creatures_backwards),				FALSE				},
  { CAVE_OFFSET(creatures_direction_auto_change_time),		0				},
  { CAVE_OFFSET(creatures_direction_auto_change_on_start),	FALSE				},

  // cave effects
  { CAVE_OFFSET(explosion_effect),				O_SPACE				},
  { CAVE_OFFSET(explosion_3_effect),				O_EXPLODE_4			},
  { CAVE_OFFSET(diamond_birth_effect),				O_DIAMOND			},
  { CAVE_OFFSET(bomb_explosion_effect),				O_BRICK				},
  { CAVE_OFFSET(nitro_explosion_effect),			O_SPACE				},
  { CAVE_OFFSET(firefly_explode_to),				O_EXPLODE_1			},
  { CAVE_OFFSET(alt_firefly_explode_to),			O_EXPLODE_1			},
  { CAVE_OFFSET(butterfly_explode_to),				O_PRE_DIA_1			},
  { CAVE_OFFSET(alt_butterfly_explode_to),			O_PRE_DIA_1			},
  { CAVE_OFFSET(stonefly_explode_to),				O_PRE_STONE_1			},
  { CAVE_OFFSET(dragonfly_explode_to),				O_EXPLODE_1			},

  { CAVE_OFFSET(stone_falling_effect),				O_STONE_F			},
  { CAVE_OFFSET(stone_bouncing_effect),				O_STONE				},
  { CAVE_OFFSET(diamond_falling_effect),			O_DIAMOND_F			},
  { CAVE_OFFSET(diamond_bouncing_effect),			O_DIAMOND			},

  // visual effects
  { CAVE_OFFSET(expanding_wall_looks_like),			O_BRICK				},
  { CAVE_OFFSET(dirt_looks_like),				O_DIRT				},

  // gravity
  { CAVE_OFFSET(gravity),					GD_MV_DOWN			},
  { CAVE_OFFSET(gravity_switch_active),				FALSE				},
  { CAVE_OFFSET(skeletons_needed_for_pot),			5				},
  { CAVE_OFFSET(gravity_change_time),				10				},

  // COMPATIBILITY
  { CAVE_OFFSET(border_scan_first_and_last),			TRUE				},
  { CAVE_OFFSET(lineshift),					FALSE				},
  { CAVE_OFFSET(wraparound_objects),				FALSE				},
  { CAVE_OFFSET(short_explosions),				TRUE				},
  { CAVE_OFFSET(skeletons_worth_diamonds),			0				},
  { CAVE_OFFSET(gravity_affects_all),				TRUE				},

  { -1 },
};

// return new element, which appears after elem is hammered.
// returns o_none, if elem is invalid for hammering.
GdElement gd_element_get_hammered(GdElement elem)
{
  switch (elem)
  {
    // what is under the pneumatic hammer?
    case O_WALLED_KEY_1:
      return O_KEY_1;

    case O_WALLED_KEY_2:
      return O_KEY_2;

    case O_WALLED_KEY_3:
      return O_KEY_3;

    case O_WALLED_DIAMOND:
      return O_DIAMOND;

    case O_BRICK:
    case O_BRICK_SLOPED_UP_RIGHT:
    case O_BRICK_SLOPED_UP_LEFT:
    case O_BRICK_SLOPED_DOWN_RIGHT:
    case O_BRICK_SLOPED_DOWN_LEFT:
    case O_BRICK_NON_SLOPED:
    case O_MAGIC_WALL:
    case O_STEEL_EXPLODABLE:
    case O_EXPANDING_WALL:
    case O_V_EXPANDING_WALL:
    case O_H_EXPANDING_WALL:
    case O_FALLING_WALL:
    case O_FALLING_WALL_F:
      return O_SPACE;

    default:
      return O_NONE;
  }
}

void gd_cave_db_init(void)
{
  int i;
  HashTable *pointers;
  boolean lowercase_names = TRUE;

  // TRANSLATORS: some languages (for example, german) do not have lowercase nouns.
  // When gdash generates the list of lowercase element names, this has to be
  // taken into account. Therefore we have a string, which must be changed
  // by the translator to select the behavior.
  // For example, the name of the element is "Brick wall", as in a button, it has to be
  // written with an uppercase initial. But if "Line of brick wall", the B is changed to b.
  // However, this is not allowed in some languages, for example, German.
  // So one writes "Ziegelmauer", and "Linie aus Ziegelmauer", the Z is not changed to z.
  // Set the translated string to "lowercase-element-names-yes", if your language
  // allows writing nouns with lowercase initials. Set it to "lowercase-element-names-no",
  // if not: for example, german. Do not translate the string, but set the behavior!

  if (strEqual(_("lowercase-element-names-yes"), "lowercase-element-names-no"))
    lowercase_names = FALSE;

  // check element database for faults.
  for (i = 0; gd_element_properties[i].element != O_MAX_ALL; i++)
  {
    if (gd_element_properties[i].element != i)
      Fail("invalid element: i: 0x%x != 0x%x ['%s']", i,
           gd_element_properties[i].element,
           gd_element_properties[i].filename);

    // if it has a name, create a lowercase name (of the translated one).
    // will be used by the editor
    if (gd_element_properties[i].name)
    {
      if (lowercase_names)
	// the function allocates a new string, but it is needed as long as the app is running
	gd_element_properties[i].lowercase_name = getStringToLower(gettext(gd_element_properties[i].name));
      else
	// only translate, no lowercase.
	gd_element_properties[i].lowercase_name = gettext(gd_element_properties[i].name);
    }

    // we do not like generated pixbufs for games. only those that are in the png.
    if (ABS(gd_element_properties[i].image_game) > GD_NUM_OF_CELLS_X * GD_NUM_OF_CELLS_Y)
      Error("game pixbuf for element %x (%s) bigger than png size", i, gd_element_properties[i].name);

    if (gd_element_properties[i].image < 0)
      Error("editor pixbuf for element %x (%s) should not be animated", i, gd_element_properties[i].name);

    if (gd_element_properties[i].properties & P_CAN_BE_HAMMERED && gd_element_get_hammered((GdElement) i) == O_NONE)
      Error("element %x (%s) can be hammered, but get_hammered_element does not define another one", i, gd_element_properties[i].name);
  }

  /*
    NOT REALLY NEEDED ANYMORE, as the enum takes care of it.
    maybe to show that there is an unnecessary one.
  */
  /*
    g_print("Free pixbuf indexes: ");
    for (i = GD_NUM_OF_CELLS_X*GD_NUM_OF_CELLS_Y; i<GD_NUM_OF_CELLS; i++)
    {
    if (!cell_used[i])
    g_print("%d ", i);
    }
    g_print("\n");
  */

  // uncomment this, to show free element->character characters.
  /*
    gd_create_char_to_element_table();
    g_print("Free characters: ");
    for (i = 32; i < 128; i++)
    if (gd_char_to_element[i] == O_UNKNOWN)
    g_print("%c", i);
    g_print("\n");
  */

  // check the cave property database for faults.
  pointers = create_hashtable(get_hash_from_integer, hash_key_integers_are_equal, NULL, NULL);

  for (i = 0; gd_cave_properties[i].identifier != NULL; i++)
  {
    GdType type = gd_cave_properties[i].type;

    switch (type)
    {
      case GD_LABEL:
      case GD_TAB:
	// some lines are used for the user interface. these should not have an identifier.
	if (strcmp(gd_cave_properties[i].identifier, "") != 0)
	{
	  Error ("ui lines in cave properties should not have identifiers: %s",
		 gd_cave_properties[i].identifier);
	}
	break;

      case GD_TYPE_STRING:
	// check if any of the properties are designated as string arrays.
	// they are not supported in file read/write and operations,
	// also they do not even make any sense!
	if (gd_cave_properties[i].count != 1)
	{
	  Error ("string arrays have no sense in cave properties: %s",
		 gd_cave_properties[i].identifier);
	}
	break;

      case GD_TYPE_LONGSTRING:
	if (gd_cave_properties[i].count != 1)
	{
	  Error ("longstring arrays have no sense cave properties: %s",
		 gd_cave_properties[i].identifier);
	}
	break;

      case GD_TYPE_EFFECT:
	// the same applies for effects.
	if (gd_cave_properties[i].count != 1)
	{
	  Error ("effect arrays not supported in cave properties: %s",
		 gd_cave_properties[i].identifier);
	}
	break;

      case GD_TYPE_COLOR:
	// the same applies for effects.
	if (gd_cave_properties[i].count != 1)
	{
	  Error ("color arrays not supported in cave properties: %s",
		 gd_cave_properties[i].identifier);
	}
	break;

      default:
	break;
    }

    if (type != GD_LABEL && (gd_cave_properties[i].flags & GD_SHOW_LEVEL_LABEL))
    {
      Error ("show_level_label only for labels: line %d", i);
    }

    if (type != GD_LABEL && type != GD_TAB)
    {
      const char *another_prop;

      // other types
      // check if its pointer is not the same as another one's
      // +1 is added so it is never zero
      if (!(gd_cave_properties[i].flags & GD_DONT_SAVE) && strcmp(gd_cave_properties[i].identifier, "") == 0)
      {
	Error ("property should have a bdcff identifier: line %d, name %s",
	       i, gd_cave_properties[i].name);
      }

      another_prop = hashtable_search(pointers, INT_TO_PTR(gd_cave_properties[i].offset + 1));

      if (another_prop != NULL)
      {
	Error("property %s has the same pointer as property %s",
	      gd_cave_properties[i].identifier, another_prop);
      }
      else
      {
	// value is the identifier, so we can report the OLD one if the check fails
	hashtable_insert(pointers, INT_TO_PTR(gd_cave_properties[i].offset + 1),
			 gd_cave_properties[i].identifier);
      }
    }
  }

  hashtable_destroy(pointers);
}
