/*╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌
 * utils/FuzzyCompare.h is part of Brewtarget, and is copyright the following authors 2024:
 *   • Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * Brewtarget is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 ╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌╌*/
#ifndef UTILS_FUZZYCOMPARE_H
#define UTILS_FUZZYCOMPARE_H
#pragma once

#include <optional>

namespace Utils {
   /**
    * \brief Extends qFuzzyCompare to deal with the case where either value is 0.0
    *
    *        We want to be careful about implicit argument conversion, so we'll use the same trick as in
    *        EditorBase::setEditItem
    */
   bool FuzzyCompare(double lhs, double rhs);

   /**
    * \brief Extends FuzzyCompare to deal with the case where values are optional
    */
   bool FuzzyCompare(std::optional<double> lhs, std::optional<double> rhs);

   /**
    * \brief We want to be careful about implicit argument conversion for FuzzyCompare, so we use the same trick here as
    *        in EditorBase::setEditItem to prevent it
    */
   template <typename D, typename E> void FuzzyCompare(D, E) = delete;

}

#endif
