!.IDENTIFICATION
!	PROCEDURE mxloplot.prg
!.PURPOSE
!	Plot a IUEFA low dispersion spectrum  
!.SYNTAX
!	PLOT/MXLO spectrum [flag] [spectrum]
!
DEFINE/PAR  P1 ?    TABLE "Enter input table: "
DEFINE/PAR  P2 F    CHAR  "Flag: (F/G/N) "  
DEFINE/PAR  P3 NULL CHAR  "Printer device: "
!
!
BRANCH P2(1:1)  F,G,N  FLUX,GROSS,NET
RETURN
!
FLUX:
!                                          Plot FLUX and SIGMA
SET/GRAP    STYPE=0 PMODE=1 LTYPE=1
SET/GRAP    YFORMAT=E
SELECT/TAB 'P1' ALL
PLOT/TAB   'P1' #1 :FLUX
SELECT/TAB 'P1' :SIGMA.GE.0.
SET/GRAP    LTYPE=2
OVER/TAB   'P1' #1 :SIGMA
SELECT/TAB 'P1' ALL
IF P3(1:4) .NE. "NULL" COPY/GRAP 'P3'
RETURN
!
GROSS:
!                                           Plot GROSS, NU-FLAG and BACKGROUND
SET/GRAP    LTYPE=1 STYPE=0  
COMP/TABLE 'P1' :GROSS = :NET+:BACKGROUND
NAME/COL   'P1' :GROSS "FN"
PLOT/TAB   'P1' #1 :GROSS
SET/GRAP    LTYPE=2
OVER/TAB   'P1' #1 :BACKGROUND
SELECT/TAB 'P1' :QUALITY.LT.0
SET/GRAP    STYPE=5
OVER/TAB   'P1' #1 :GROSS
SELECT/TAB 'P1' ALL
SET/GRAP    LTYPE=1 STYPE=0  
IF P3(1:4) .NE. "NULL" COPY/GRAP 'P3'
RETURN
!
NET:
!                                          Plot NET and QUALITY
SET/GRAP   STYPE=0 LTYPE=1 YFORMAT=AUTO
PLOT/TAB   'P1' #1 :NET
!SELECT/TAB 'P1' :QUALITY.LT.-1
SELECT/TAB 'P1' :QUALITY.LT.0
SET/GRAP    STYPE=5
OVER/TAB   'P1' #1 :NET 
SELECT/TAB 'P1' ALL
IF P3(1:4) .NE. "NULL" COPY/GRAP 'P3'
RETURN
