% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairUpDiff.r
\name{pairUpDiff}
\alias{pairUpDiff}
\title{pairUpDiff}
\usage{
pairUpDiff(
  x,
  major = NULL,
  minor = NULL,
  group,
  refgroup,
  lower = NULL,
  upper = NULL,
  minkeep = NULL,
  sortdiff = TRUE,
  conf.int = 0.95
)
}
\arguments{
\item{x}{a numeric vector}

\item{major}{an optional factor or character vector}

\item{minor}{an optional factor or character vector}

\item{group}{a required factor or character vector with two levels}

\item{refgroup}{a character string specifying which level of \code{group} is to be subtracted}

\item{lower}{an optional numeric vector giving the lower \code{conf.int} confidence limit for \code{x}}

\item{upper}{similar to \code{lower} but for the upper limit}

\item{minkeep}{the minimum value of \code{x} required to keep the observation.  An observation is kept if either \code{group} has \code{x} exceeding or equalling \code{minkeep}.  Default is to keep all observations.}

\item{sortdiff}{set to \code{FALSE} to avoid sorting observations by descending between-\code{group} differences}

\item{conf.int}{confidence level; must have been the value used to compute \code{lower} and \code{upper} if they are provided}
}
\value{
a list of two objects both sorted by descending values of differences in \code{x}.  The \code{X} object is a data frame that contains the original variables sorted by descending differences across \code{group} and in addition a variable \code{subscripts} denoting the subscripts of original observations with possible re-sorting and dropping depending on \code{sortdiff} and \code{minkeep}.  The \code{D} data frame contains sorted differences (\code{diff}), \code{major}, \code{minor}, \code{sd} of difference, \code{lower} and \code{upper} confidence limits for the difference, \code{mid}, the midpoint of the two \code{x} values involved in the difference, \code{lowermid}, the midpoint minus 1/2 the width of the confidence interval, and \code{uppermid}, the midpoint plus 1/2 the width of the confidence interval.  Another element returned is \code{dropped} which is a vector of \code{major} / \code{minor} combinations dropped due to \code{minkeep}.
}
\description{
Pair-up and Compute Differences
}
\details{
This function sets up for plotting half-width confidence intervals for differences, sorting by descending order of differences within major categories, especially for dot charts as produced by \code{\link[=dotchartpl]{dotchartpl()}}. Given a numeric vector \code{x} and a grouping (superpositioning) vector \code{group} with exactly two levels, computes differences in possibly transformed \code{x} between levels of \code{group} for the two observations that are equal on \code{major} and \code{minor}.  If \code{lower} and \code{upper} are specified, using \code{conf.int} and approximate normality on the transformed scale to backsolve for the standard errors of estimates, and uses approximate normality to get confidence intervals on differences by taking the square root of the sum of squares of the two standard errors.  Coordinates for plotting half-width confidence intervals are also computed.  These intervals may be plotted on the same scale as \code{x}, having the property that they overlap the two \code{x} values if and only if there is no "significant" difference at the \code{conf.int} level.
}
\examples{
x <- c(1, 4, 7, 2, 5, 3, 6)
pairUpDiff(x, c(rep('A', 4), rep('B', 3)),
  c('u','u','v','v','z','z','q'),
  c('a','b','a','b','a','b','a'), 'a', x-.1, x+.1)
}
\author{
Frank Harrell
}
