// ./tests/catch2-tests [section] -s


/////////////////////// Qt includes
#include <QDebug>
#include <QString>
#include <QDir>


/////////////////////// Catch2 includes
#include <catch2/catch_test_macros.hpp>
#include <catch2/matchers/catch_matchers_floating_point.hpp>


/////////////////////// Local includes
#include "TestUtils.hpp"
#include <libXpertMass/ChemicalGroupRule.hpp>

namespace MsXpS
{

namespace libXpertMassCore
{

SCENARIO("ChemicalGroupRule object can be constructed empty",
         "[ChemicalGroupRule]")
{
  WHEN("Constructing an empty ChemicalGroupRule")
  {
    ChemicalGroupRule chemical_group_rule;

    THEN("The object is invalid")
    {
      REQUIRE_FALSE(chemical_group_rule.isValid());
    }

    AND_WHEN("Setting the name, the entity and the fate")
    {
      chemical_group_rule.setName("Acetylation");
      chemical_group_rule.setEntity("LE_PLM_MODIF");
      chemical_group_rule.setFate(Enums::ChemicalGroupFate::LOST);

      THEN("The ChemicalGroupRule is valid.")
      {
        REQUIRE(chemical_group_rule.isValid());
      }
    }
  }
}


} // namespace libXpertMassCore
} // namespace MsXpS
