function(mapnik_set_dep_version dep var)
    string(TOUPPER ${dep} m_package_name_upc)
    set(m_package_name ${dep})
    if(${m_package_name}_VERSION_STRING)
        set(${var} ${${m_package_name}_VERSION_STRING} PARENT_SCOPE)
    elseif(${m_package_name}_VERSION)
        set(${var} ${${m_package_name}_VERSION} PARENT_SCOPE)
    elseif(${m_package_name_upc}_VERSION_STRING)
        set(${var} ${${m_package_name_upc}_VERSION_STRING} PARENT_SCOPE)
    elseif(${m_package_name_upc}_VERSION)
        set(${var} ${${m_package_name_upc}_VERSION} PARENT_SCOPE)
    endif()
endfunction()

function(mapnik_print_package_info dep)
    message(STATUS "Using ${dep} version: ${mapnik_${dep}_version}")
endfunction()

macro(mapnik_find_package dep)
    find_package(${dep} ${ARGN})
    if(${dep}_FOUND)
        list(APPEND mapnik_deps ${dep})

        if(mapnik_${dep}_find_args)
            list(APPEND mapnik_${dep}_find_args ${ARGN})
        else()
            set(mapnik_${dep}_find_args ${ARGN})
        endif()
        mapnik_set_dep_version(${dep} mapnik_${dep}_version)

        mapnik_print_package_info(${dep})
    else()
        message(STATUS "not found: ${dep}")
    endif()
endmacro()

macro(mapnik_pkg_check_modules dep)
    pkg_check_modules(${dep} ${ARGN})
    if(${dep}_FOUND)
        list(APPEND mapnik_deps ${dep})

        set(mapnik_${dep}_pkg_args ${ARGN})
        mapnik_set_dep_version(${dep} mapnik_${dep}_version)

        mapnik_print_package_info(${dep})
    else()
        message(STATUS "not found: ${dep}")
    endif()
endmacro()

macro(mapnik_find_threads)
    find_package(Threads REQUIRED)
    if(CMAKE_THREAD_LIBS_INIT)
        message(STATUS "Using Threads (system libraries)")
    elseif(CMAKE_USE_WIN32_THREADS_INIT)
        message(STATUS "Using Threads (win32 threads)")
    elseif(CMAKE_USE_PTHREADS_INIT)
        message(STATUS "Using Threads (pthread)")
    elseif(CMAKE_HP_PTHREADS_INIT)
        message(STATUS "Using Threads (HP thread)")
    else()
        message(STATUS "Using Threads (unknown backend)")
    endif()
endmacro()
