/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqlx.devapi;

import com.mysql.cj.api.x.AddStatement;
import com.mysql.cj.api.x.Result;
import com.mysql.cj.api.x.Warning;
import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.io.StatementExecuteOk;
import com.mysql.cj.mysqlx.devapi.CollectionImpl;
import com.mysql.cj.mysqlx.devapi.UpdateResult;
import com.mysql.cj.x.json.DbDoc;
import com.mysql.cj.x.json.JsonParser;
import com.mysql.cj.x.json.JsonString;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AddStatementImpl
implements AddStatement {
    private CollectionImpl collection;
    private List<DbDoc> newDocs;

    AddStatementImpl(CollectionImpl collection, DbDoc newDoc) {
        this.collection = collection;
        this.newDocs = new ArrayList<DbDoc>();
        this.newDocs.add(newDoc);
    }

    AddStatementImpl(CollectionImpl collection, DbDoc[] newDocs) {
        this.collection = collection;
        this.newDocs = Arrays.asList(newDocs);
    }

    @Override
    public AddStatement add(String jsonString) {
        try {
            DbDoc doc = JsonParser.parseDoc(new StringReader(jsonString));
            return this.add(doc);
        }
        catch (IOException ex) {
            throw AssertionFailedException.shouldNotHappen(ex);
        }
    }

    @Override
    public AddStatement add(DbDoc doc) {
        this.newDocs.add(doc);
        return this;
    }

    @Override
    public AddStatement add(DbDoc[] docs) {
        this.newDocs.addAll(Arrays.asList(docs));
        return this;
    }

    private List<String> assignIds() {
        return this.newDocs.stream().filter(d2 -> d2.get("_id") == null).map(d2 -> {
            String newId = UUID.randomUUID().toString().replaceAll("-", "");
            d2.put("_id", new JsonString().setValue(newId));
            return newId;
        }).collect(Collectors.toList());
    }

    private List<String> serializeDocs() {
        return this.newDocs.stream().map(DbDoc::toPackedString).collect(Collectors.toList());
    }

    @Override
    public Result execute() {
        if (this.newDocs.size() == 0) {
            StatementExecuteOk ok = new StatementExecuteOk(0L, null, new ArrayList<Warning>());
            return new UpdateResult(ok, new ArrayList<String>());
        }
        List<String> newIds = this.assignIds();
        StatementExecuteOk ok = this.collection.getSession().getMysqlxSession().addDocs(this.collection.getSchema().getName(), this.collection.getName(), this.serializeDocs());
        return new UpdateResult(ok, newIds);
    }

    @Override
    public CompletableFuture<Result> executeAsync() {
        List<String> newIds = this.assignIds();
        CompletableFuture<StatementExecuteOk> okF = this.collection.getSession().getMysqlxSession().asyncAddDocs(this.collection.getSchema().getName(), this.collection.getName(), this.serializeDocs());
        return okF.thenApply(ok -> new UpdateResult((StatementExecuteOk)ok, newIds));
    }
}

