/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.util.Calendar;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameterHolder;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.Options;

public class DateParameter
extends NotLongDataParameterHolder {
    private Date date;
    private Calendar calendar;
    private Options options;

    public DateParameter(Date date, Calendar cal, Options options) {
        this.date = date;
        this.calendar = cal;
        this.options = options;
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        if (this.options.useLegacyDatetimeCode || this.options.maximizeMysqlCompatibility) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(this.date.getTime());
        ParameterWriter.writeDate(os, this.calendar);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return 16L;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        this.calendar = Calendar.getInstance();
        this.calendar.setTimeInMillis(this.date.getTime());
        writeBuffer.writeDateLength(this.calendar);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.DATE;
    }

    @Override
    public String toString() {
        return "'" + this.date.toString() + "'";
    }
}

