/*
 * @(#)VersionInfo.java	1.0 05/09/2005
 *
 * Copyright (c) 2001 International Business Machines Corp.
 * All rights reserved.
 *
 * This software has been released under the terms of the IBM Public
 * License.  For details, see the LICENSE file in the top-level source
 * directory or online at http://www.openafs.org/dl/license10.html
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.openafs.jafs;

/**
 * Provides version information about the native C library and the JAVA side.
 *
 * At least a <<Class.forName("org.openafs.jafs.Token");>> is necessary before using these methods.
 * Perhaps a redesign would be required because the library initialization occures only in Token.java.
 */
public class VersionInfo
{
  /**
   * Returns java interface version string
   * the native library version should be higher
   */
  public static String getVersionOfJavaInterface() {return "20050905";}

  /**
   * Returns the native library version
   *
   * @exception AFSException if internal (libjafs, libjafsadmin) versions differ
   */
  public static String getVersionOfLibrary() throws AFSException
  {
  	String ver = getVersionOfLibjafs();
	if (!ver.equals(getVersionOfLibjafsadm()))
		throw new AFSException("library versions differ", 0);
	return ver;
  }

  /**
   * Returns build information of the native library.
   * This information is autogenerated by the openafs make system.
   * Example: "@(#) OpenAFS 1.3.87 built  2005-09-06 "
   *
   * @exception AFSException if internal (libjafs, libjafsadmin) versions differ
   */
  public static String getBuildInfo() throws AFSException
  {
  	String info = getBuildInfoOfLibjafs();
	if (!info.equals(getBuildInfoOfLibjafsadm()))
		throw new AFSException("library build info differ", 0);
	return info;
  }

  private static native String getVersionOfLibjafs();
  private static native String getVersionOfLibjafsadm();
  private static native String getBuildInfoOfLibjafs();
  private static native String getBuildInfoOfLibjafsadm();
}
