class oci::redis(
  $bind_host        = undef,
  $cluster_enabled  = false,
  $ip_of_master     = undef,
  $machine_hostname = 'node1.example.com',
  #$pass_redis       = 'a_big_secret',
){

  oci::sslkeypair { 'redis':
    notify_service_name => 'redis-server',
    require_anchor => Package['redis-server'],
  }

  #if $bind_host == $ip_of_master {
  #  $slaveof = undef
  #}else{
  #  $slaveof = "${ip_of_master} 6379"
  #}

  class { 'redis':
    bind                 => $bind_host,
    #masterauth           => $pass_redis,
    tls_port             => 6380,
    tls_cert_file        => "/etc/redis/ssl/public/${machine_hostname}.crt",
    tls_key_file         => "/etc/redis/ssl/private/${machine_hostname}.pem",
    tls_ca_cert_file     => '/etc/ssl/certs/oci-pki-oci-ca-chain.pem',
    ulimit_managed       => false,
    protected_mode       => false,
    #cluster_enabled      => $cluster_enabled,
    #requirepass          => $pass_redis,
    #cluster_config_file  => 'nodes.conf',
    #cluster_node_timeout => 5000,
  }

  #class { 'redis::sentinel':
  #  auth_pass         => $pass_redis,
  #  redis_host        => $machine_hostname,
  #  redis_port        => 6379,
  #  requirepass       => $pass_redis,
  #  quorum            => 1,
  #  sentinel_tls_port => 26380,
  #  sentinel_bind     => $machine_hostname,
  #  tls_cert_file     => "/etc/redis/ssl/public/${machine_hostname}.crt",
  #  tls_key_file      => "/etc/redis/ssl/private/${machine_hostname}.pem",
  #  tls_ca_cert_file  => '/etc/ssl/certs/oci-pki-oci-ca-chain.pem',
  #  tls_replication   => true,
  #}

}
