# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.kusto import KustoManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestKustoManagementDatabaseOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(KustoManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_database_invite_follower(self, resource_group):
        response = self.client.database.invite_follower(
            resource_group_name=resource_group.name,
            cluster_name="str",
            database_name="str",
            parameters={
                "inviteeEmail": "str",
                "tableLevelSharingProperties": {
                    "externalTablesToExclude": ["str"],
                    "externalTablesToInclude": ["str"],
                    "functionsToExclude": ["str"],
                    "functionsToInclude": ["str"],
                    "materializedViewsToExclude": ["str"],
                    "materializedViewsToInclude": ["str"],
                    "tablesToExclude": ["str"],
                    "tablesToInclude": ["str"],
                },
            },
            api_version="2024-04-13",
        )

        # please add some check logic here by yourself
        # ...
