# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import Any, Callable, Dict, Optional, TypeVar

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._vendor import _convert_request
from ...operations._get_operations import (
    build_integration_runtime_enable_interactivequery_request,
    build_integration_runtime_start_request,
    build_integration_runtime_stop_request,
)

if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class GetOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.synapse.aio.SynapseManagementClient`'s
        :attr:`get` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def integration_runtime_start(
        self,
        resource_group_name: str,
        workspace_name: str,
        integration_runtime_name: str,
        integration_runtime_operation_id: str,
        **kwargs: Any
    ) -> _models.IntegrationRuntimeOperationStatus:
        """Get integration runtime start operation status.

        Get an integration runtime start operation status.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param integration_runtime_name: Integration runtime name. Required.
        :type integration_runtime_name: str
        :param integration_runtime_operation_id: Integration runtime Operation Id. Required.
        :type integration_runtime_operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IntegrationRuntimeOperationStatus or the result of cls(response)
        :rtype: ~azure.mgmt.synapse.models.IntegrationRuntimeOperationStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-06-01-preview")
        )
        cls: ClsType[_models.IntegrationRuntimeOperationStatus] = kwargs.pop("cls", None)

        request = build_integration_runtime_start_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            integration_runtime_name=integration_runtime_name,
            integration_runtime_operation_id=integration_runtime_operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.integration_runtime_start.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IntegrationRuntimeOperationStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    integration_runtime_start.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/integrationRuntimes/{integrationRuntimeName}/start/operationstatuses/{integrationRuntimeOperationId}"
    }

    @distributed_trace_async
    async def integration_runtime_stop(
        self,
        resource_group_name: str,
        workspace_name: str,
        integration_runtime_name: str,
        integration_runtime_operation_id: str,
        **kwargs: Any
    ) -> _models.IntegrationRuntimeStopOperationStatus:
        """Get integration runtime stop operation status.

        Get an integration runtime stop operation status.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param integration_runtime_name: Integration runtime name. Required.
        :type integration_runtime_name: str
        :param integration_runtime_operation_id: Integration runtime Operation Id. Required.
        :type integration_runtime_operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IntegrationRuntimeStopOperationStatus or the result of cls(response)
        :rtype: ~azure.mgmt.synapse.models.IntegrationRuntimeStopOperationStatus
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-06-01-preview")
        )
        cls: ClsType[_models.IntegrationRuntimeStopOperationStatus] = kwargs.pop("cls", None)

        request = build_integration_runtime_stop_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            integration_runtime_name=integration_runtime_name,
            integration_runtime_operation_id=integration_runtime_operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.integration_runtime_stop.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IntegrationRuntimeStopOperationStatus", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    integration_runtime_stop.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/integrationRuntimes/{integrationRuntimeName}/stop/operationstatuses/{integrationRuntimeOperationId}"
    }

    @distributed_trace_async
    async def integration_runtime_enable_interactivequery(
        self,
        resource_group_name: str,
        workspace_name: str,
        integration_runtime_name: str,
        integration_runtime_operation_id: str,
        **kwargs: Any
    ) -> _models.IntegrationRuntimeEnableinteractivequery:
        """Get integration runtime enable interactivequery operation status.

        Get an integration runtime enable interactivequery operation status.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param workspace_name: The name of the workspace. Required.
        :type workspace_name: str
        :param integration_runtime_name: Integration runtime name. Required.
        :type integration_runtime_name: str
        :param integration_runtime_operation_id: Integration runtime Operation Id. Required.
        :type integration_runtime_operation_id: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: IntegrationRuntimeEnableinteractivequery or the result of cls(response)
        :rtype: ~azure.mgmt.synapse.models.IntegrationRuntimeEnableinteractivequery
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: Literal["2021-06-01-preview"] = kwargs.pop(
            "api_version", _params.pop("api-version", "2021-06-01-preview")
        )
        cls: ClsType[_models.IntegrationRuntimeEnableinteractivequery] = kwargs.pop("cls", None)

        request = build_integration_runtime_enable_interactivequery_request(
            resource_group_name=resource_group_name,
            workspace_name=workspace_name,
            integration_runtime_name=integration_runtime_name,
            integration_runtime_operation_id=integration_runtime_operation_id,
            subscription_id=self._config.subscription_id,
            api_version=api_version,
            template_url=self.integration_runtime_enable_interactivequery.metadata["url"],
            headers=_headers,
            params=_params,
        )
        request = _convert_request(request)
        request.url = self._client.format_url(request.url)

        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.ErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        deserialized = self._deserialize("IntegrationRuntimeEnableinteractivequery", pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    integration_runtime_enable_interactivequery.metadata = {
        "url": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Synapse/workspaces/{workspaceName}/integrationRuntimes/{integrationRuntimeName}/enableinteractivequery/operationstatuses/{integrationRuntimeOperationId}"
    }
