/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*

 Copyright (C) 2007 Mark Joshi

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file latticerules.cpp

*/


#include <ql/math/randomnumbers/latticerules.hpp>
#include <ql/types.hpp>
#include <ql/errors.hpp>

namespace QuantLib
{


namespace
{

const Real latticeA[] =
{
1   ,
182667  ,
469891  ,
498753  ,
110745  ,
446247  ,
250185  ,
118627  ,
245333  ,
283199  ,
408519  ,
391023  ,
246327  ,
126539  ,
399185  ,
461527  ,
300343  ,
69681   ,
516695  ,
436179  ,
106383  ,
238523  ,
413283  ,
70841   ,
47719   ,
300129  ,
113029  ,
123925  ,
410745  ,
211325  ,
17489   ,
511893  ,
40767   ,
186077  ,
519471  ,
255369  ,
101819  ,
243573  ,
66189   ,
152143  ,
503455  ,
113217  ,
132603  ,
463967  ,
297717  ,
157383  ,
224015  ,
502917  ,
36237   ,
94049   ,
170665  ,
79397   ,
123963  ,
223451  ,
323871  ,
303633  ,
98567   ,
318855  ,
494245  ,
477137  ,
177975  ,
64483   ,
26695   ,
88779   ,
94497   ,
239429  ,
381007  ,
110205  ,
339157  ,
73397   ,
407559  ,
181791  ,
442675  ,
301397  ,
32569   ,
147737  ,
189949  ,
138655  ,
350241  ,
63371   ,
511925  ,
515861  ,
434045  ,
383435  ,
249187  ,
492723  ,
479195  ,
84589   ,
99703   ,
239831  ,
269423  ,
182241  ,
61063   ,
130789  ,
143095  ,
471209  ,
139019  ,
172565  ,
487045  ,
304803  ,
45669   ,
380427  ,
19547   ,
425593  ,
337729  ,
237863  ,
428453  ,
291699  ,
238587  ,
110653  ,
196113  ,
465711  ,
141583  ,
224183  ,
266671  ,
169063  ,
317617  ,
68143   ,
291637  ,
263355  ,
427191  ,
200211  ,
365773  ,
254701  ,
368663  ,
248047  ,
209221  ,
279201  ,
323179  ,
80217   ,
122791  ,
316633  ,
118515  ,
14253   ,
129509  ,
410941  ,
402601  ,
511437  ,
10469   ,
366469  ,
463959  ,
442841  ,
54641   ,
44167   ,
19703   ,
209585  ,
69037   ,
33317   ,
433373  ,
55879   ,
245295  ,
10905   ,
468881  ,
128617  ,
417919  ,
45067   ,
442243  ,
359529  ,
51109   ,
290275  ,
168691  ,
212061  ,
217775  ,
405485  ,
313395  ,
256763  ,
152537  ,
326437  ,
332981  ,
406755  ,
423147  ,
412621  ,
362019  ,
279679  ,
169189  ,
107405  ,
251851  ,
5413    ,
316095  ,
247945  ,
422489  ,
2555    ,
282267  ,
121027  ,
369319  ,
204587  ,
445191  ,
337315  ,
322505  ,
388411  ,
102961  ,
506099  ,
399801  ,
254381  ,
452545  ,
309001  ,
147013  ,
507865  ,
32283   ,
320511  ,
264647  ,
417965  ,
227069  ,
341461  ,
466581  ,
386241  ,
494585  ,
201479  ,
151243  ,
481337  ,
68195   ,
75401   ,
58359   ,
448107  ,
459499  ,
9873    ,
365117  ,
350845  ,
181873  ,
7917    ,
436695  ,
43899   ,
348367  ,
423927  ,
437399  ,
385089  ,
21693   ,
268793  ,
49257   ,
250211  ,
125071  ,
341631  ,
310163  ,
94631   ,
108795  ,
21175   ,
142847  ,
383599  ,
71105   ,
65989   ,
446433  ,
177457  ,
107311  ,
295679  ,
442763  ,
40729   ,
322721  ,
420175  ,
430359  ,
480757  ,
221417  ,
460963  ,
263529  ,
263625  ,
16919   ,
289121  ,
243609  ,
414769  ,
147195  ,
326731  ,
277925  ,
185497  ,
29735   ,
11185   ,
212811  ,
371743  ,
33547   ,
250809  ,
390965  ,
486257  ,
348223  ,
263649  ,
241785  ,
425685  ,
240127  ,
447899  ,
182195  ,
306733  ,
465107  ,
434787  ,
239361  ,
437289  ,
183495  ,
75179   ,
431157  ,
376487  ,
141253  ,
293903  ,
399797  ,
325045  ,
277541  ,
215657  ,
263115  ,
193361  ,
478441  ,
299477  ,
319217  ,
176929  ,
279451  ,
32237   ,
346181  ,
374911  ,
443279  ,
319283  ,
306211  ,
70449   ,
88145   ,
272219  ,
178705  ,
159715  ,
177793  ,
164999  ,
16833   ,
49379   ,
83863   ,
223583  ,
22615   ,
225323  ,
111767  ,
361309  ,
182521  ,
154685  ,
426543  ,
482481  ,
122871  ,
250773  ,
324031  ,
227329  ,
465853  ,
165123  ,
163615  ,
245155  ,
192403  ,
364635  ,
276575  ,
195289  ,
439767  ,
386711  ,
472741  ,
6385    ,
435121  ,
299865  ,
151695  ,
344227  ,
505437  ,
130021  ,
254671  ,
165583  ,
129277  ,
513679  ,
155197  ,
147197  ,
161911  ,
408721  ,
134261  ,
56599   ,
410699  ,
110337  ,
18283   ,
393383  ,
222965  ,
244381  ,
89807   ,
198515  ,
219643  ,
467277  ,
69251   ,
227483  ,
90213   ,
405587  ,
225651  ,
349029  ,
365859  ,
448277  ,
284285  ,
85247   ,
8363    ,
235701  ,
168505  ,
11797   ,
326593  ,
482271  ,
181411  ,
424383  ,
486111  ,
136879  ,
467187  ,
523659  ,
357769  ,
102621  ,
120121  ,
253107  ,
11107   ,
410147  ,
315347  ,
1551    ,
60525   ,
265467  ,
404483  ,
174571  ,
303643  ,
12741   ,
486785  ,
382527  ,
264167  ,
438949  ,
73635   ,
149281  ,
482205  ,
150185  ,
256827  ,
108249  ,
38907   ,
511485  ,
437613  ,
401415  ,
196935  ,
228179  ,
207375  ,
366367  ,
55589   ,
84509   ,
108335  ,
371355  ,
384565  ,
35521   ,
175225  ,
111363  ,
61861   ,
183569  ,
406605  ,
71801   ,
211703  ,
132611  ,
241903  ,
215337  ,
235709  ,
415963  ,
274405  ,
4703    ,
240525  ,
416779  ,
243755  ,
157423  ,
286867  ,
227441  ,
254477  ,
462447  ,
276941  ,
111189  ,
144789  ,
368511  ,
321515  ,
355653  ,
330037  ,
193619  ,
172623  ,
357807  ,
255105  ,
265789  ,
348989  ,
399829  ,
88709   ,
147959  ,
397901  ,
25605   ,
426447  ,
223367  ,
281913  ,
109421  ,
354737  ,
97901   ,
221801  ,
483127  ,
331811  ,
284329  ,
200029  ,
472285  ,
161795  ,
142317  ,
521093  ,
375505  ,
103755  ,
166279  ,
57527   ,
161091  ,
215319  ,
485895  ,
25887   ,
89591   ,
240303  ,
253535  ,
491933  ,
137349  ,
26775   ,
1729    ,
409481  ,
468105  ,
114849  ,
396207  ,
131517  ,
179647  ,
82499   ,
270263  ,
507511  ,
126811  ,
392021  ,
290691  ,
144999  ,
409189  ,
25557   ,
217529  ,
292351  ,
418783  ,
192003  ,
162237  ,
300457  ,
283151  ,
244869  ,
372931  ,
245703  ,
124071  ,
1135    ,
286385  ,
256437  ,
277087  ,
351965  ,
88117   ,
379293  ,
177055  ,
5879    ,
372417  ,
277241  ,
204087  ,
28287   ,
510057  ,
509695  ,
148637  ,
173693  ,
18863   ,
410971  ,
490307  ,
158579  ,
180629  ,
292825  ,
56021   ,
161863  ,
391107  ,
441385  ,
41333   ,
88349   ,
248261  ,
414605  ,
250945  ,
258519  ,
519295  ,
428331  ,
82417   ,
297583  ,
236509  ,
193353  ,
521611  ,
252473  ,
8615    ,
315077  ,
356463  ,
168977  ,
225931  ,
471707  ,
523789  ,
283671  ,
107083  ,
338195  ,
64035   ,
422417  ,
114519  ,
179967  ,
228957  ,
249611  ,
300357  ,
414135  ,
316269  ,
482363  ,
349081  ,
247739  ,
257763  ,
514731  ,
459623  ,
273057  ,
190725  ,
16075   ,
225093  ,
263631  ,
304121  ,
456955  ,
185759  ,
447357  ,
463223  ,
507381  ,
91535   ,
293531  ,
336195  ,
338591  ,
233527  ,
475567  ,
202419  ,
497965  ,
427305  ,
292097  ,
87701   ,
46525   ,
425127  ,
162119  ,
91059   ,
509853  ,
439515  ,
193197  ,
489889  ,
247123  ,
72951   ,
19091   ,
32249   ,
175185  ,
401645  ,
481103  ,
156391  ,
461987  ,
274743  ,
258789  ,
363861  ,
329821  ,
441411  ,
494409  ,
523681  ,
275133  ,
476635  ,
356313  ,
301287  ,
370055  ,
223247  ,
474385  ,
235885  ,
464331  ,
100449  ,
154789  ,
354597  ,
46075   ,
509469  ,
293887  ,
118997  ,
94605   ,
130853  ,
62381   ,
446211  ,
110775  ,
441749  ,
11647   ,
441327  ,
518019  ,
266745  ,
303321  ,
428073  ,
439511  ,
327309  ,
370317  ,
99099   ,
92823   ,
47303   ,
508365  ,
122925  ,
371521  ,
413947  ,
381997  ,
128693  ,
338147  ,
68609   ,
298361  ,
142827  ,
78791   ,
110299  ,
74983   ,
399743  ,
248095  ,
446313  ,
211653  ,
42373   ,
380463  ,
305563  ,
287069  ,
174685  ,
350981  ,
87739   ,
118153  ,
130365  ,
288001  ,
85703   ,
370809  ,
261363  ,
243289  ,
127027  ,
450185  ,
230997  ,
96425   ,
165333  ,
329901  ,
166631  ,
451049  ,
124935  ,
425907  ,
187583  ,
426405  ,
407503  ,
481683  ,
436815  ,
36701   ,
230675  ,
142295  ,
384337  ,
97869   ,
174277  ,
105907  ,
411309  ,
442025  ,
420455  ,
275357  ,
36543   ,
399931  ,
369307  ,
300069  ,
198191  ,
275635  ,
74869   ,
395981  ,
154569  ,
425805  ,
209447  ,
511999  ,
311137  ,
401091  ,
114095  ,
123237  ,
409775  ,
313845  ,
411497  ,
307259  ,
252635  ,
486853  ,
415967  ,
393585  ,
252305  ,
248807  ,
429869  ,
19877   ,
238767  ,
465765  ,
251435  ,
31931   ,
9375    ,
394037  ,
482327  ,
226155  ,
276901  ,
145515  ,
515957  ,
58865   ,
432665  ,
317515  ,
202675  ,
194919  ,
363725  ,
167451  ,
496379  ,
88081   ,
429401  ,
193909  ,
464257  ,
21783   ,
255519  ,
173419  ,
4525    ,
396301  ,
323707  ,
301965  ,
58913   ,
181921  ,
392791  ,
517181  ,
199121  ,
150613  ,
498367  ,
353209  ,
362387  ,
426477  ,
30755   ,
481743  ,
79335   ,
242545  ,
193489  ,
154217  ,
152365  ,
248003  ,
160629  ,
450905  ,
119515  ,
312019  ,
221569  ,
470791  ,
42569   ,
305501  ,
107903  ,
322337  ,
40815   ,
2239    ,
45407   ,
377109  ,
222897  ,
408051  ,
334611  ,
102593  ,
474007  ,
449755  ,
395473  ,
183207  ,
445655  ,
359145  ,
480015  ,
506445  ,
415163  ,
459765  ,
240993  ,
348643  ,
311311  ,
301277  ,
506281  ,
478109  ,
106897  ,
475519  ,
295603  ,
329847  ,
177575  ,
127243  ,
272713  ,
304281  ,
50573   ,
349417  ,
131487  ,
502907  ,
412417  ,
397071  ,
147315  ,
235781  ,
255885  ,
421135  ,
161223  ,
77175   ,
331995  ,
78655   ,
211715  ,
301259  ,
219035  ,
127701  ,
83493   ,
61371   ,
300739  ,
312513  ,
466155  ,
314441  ,
345733  ,
156889  ,
487233  ,
146325  ,
73709   ,
23791   ,
469019  ,
429905  ,
210955  ,
512205  ,
237585  ,
38469   ,
380697  ,
299875  ,
275393  ,
388021  ,
354889  ,
266469  ,
293501  ,
186931  ,
124695  ,
432785  ,
242425  ,
107199  ,
57331   ,
200461  ,
371767  ,
159645  ,
217483  ,
299463  ,
443487  ,
387823  ,
288247  ,
231339  ,
69451   ,
167207  ,
474283  ,
288285  ,
35023   ,
310071  ,
52017   ,
377933  ,
184317  ,
236333  ,
100811  ,
6867    ,
225535  ,
495413  ,
237521  ,
165557  ,
466251  ,
494583  ,
41971   ,
325869  ,
497911  ,
107613  ,
261385  ,
254175  ,
420485  ,
345119  ,
271503  ,
474889  ,
79655   ,
131139  ,
494331  ,
204103  ,
56679   ,
30945   ,
103137  ,
387471  ,
375569  ,
347443  ,
84925   ,
109079  ,
121365  ,
28371   ,
23283   ,
402765  ,
45085   ,
203239  ,
332045  ,
280521  ,
511521  ,
420779  ,
457787  ,
308723  ,
213891  ,
340515  ,
6077    ,
469349  ,
317283  ,
193051  ,
84615   ,
26411   ,
111133  ,
384309  ,
89225   ,
15061   ,
451299  ,
253109  ,
283983  ,
272139  ,
224493  ,
457497  ,
198591  ,
60857   ,
170653  ,
516063  ,
63655   ,
176635  ,
496653  ,
142945  ,
181199  ,
271031  ,
262767  ,
431349  ,
82049   ,
441275  ,
496297  ,
469933  ,
413335  ,
194583  ,
105247  ,
500683  ,
139889  ,
100381  ,
440753  ,
193069  ,
5979    ,
193247  ,
301363  ,
33843   ,
221103  ,
132691  ,
130351  ,
367705  ,
132071  ,
410455  ,
5763    ,
280417  ,
359827  ,
30087   ,
290263  ,
357573  ,
86205   ,
65473   ,
144355  ,
146417  ,
84499   ,
5649    ,
518281  ,
65049   ,
42149   ,
145689  ,
314395  ,
235127  ,
205711  ,
182221  ,
346969  ,
227929  ,
428517  ,
31343   ,
431861  ,
300643  ,
498615  ,
100851  ,
488335  ,
310185  ,
322423  ,
497201  ,
484405  ,
444527  ,
51333   ,
413769  ,
65027   ,
412357  ,
287663  ,
99387   ,
508665  ,
134905  ,
337535  ,
351489  ,
290759  ,
513485  ,
391501  ,
139009  ,
514003  ,
360051  ,
194857  ,
214625  ,
190319  ,
193121  ,
279099  ,
188459  ,
465397  ,
444741  ,
1599    ,
376567  ,
502721  ,
300331  ,
309899  ,
105713  ,
221565  ,
209529  ,
226541  ,
168083  ,
172953  ,
480521  ,
41525   ,
503357  ,
513735  ,
20585   ,
509665  ,
415835  ,
268953  ,
318039  ,
318647  ,
61943   ,
406283  ,
159249  ,
243265  ,
86427   ,
356525  ,
161945  ,
88741   ,
155739  ,
30999   ,
469509  ,
416535  ,
516925  ,
20595   ,
492481  ,
118079  ,
67531   ,
93975   ,
254945  ,
460265  ,
32577   ,
286941  ,
461315  ,
229511  ,
205789  ,
123411  ,
228447  ,
405775  ,
316867  ,
12567   ,
480181  ,
507221  ,
463329  ,
360803  ,
271225  ,
433273  ,
489915  ,
164057  ,
389401  ,
61883   ,
365689  ,
120717  ,
7725    ,
97135   ,
145163  ,
311659  ,
517775  ,
47851   ,
109593  ,
472773  ,
400637  ,
19087   ,
293147  ,
484279  ,
38049   ,
331861  ,
226935  ,
451367  ,
60083   ,
507751  ,
256185  ,
159613  ,
478559  ,
466397  ,
243859  ,
474635  ,
69159   ,
75285   ,
471867  ,
436483  ,
194003  ,
332149  ,
521247  ,
221209  ,
459463  ,
195993  ,
201455  ,
15545   ,
137185  ,
204247  ,
474959  ,
324651  ,
121031  ,
328369  ,
486033  ,
104301  ,
256295  ,
306443  ,
275897  ,
321283  ,
350205  ,
330847  ,
367481  ,
475923  ,
207701  ,
494919  ,
336813  ,
267257  ,
227219  ,
472323  ,
78973   ,
513131  ,
225923  ,
434771  ,
483219  ,
114577  ,
357429  ,
165589  ,
408211  ,
494065  ,
77643   ,
355371  ,
286569  ,
35217   ,
179467  ,
36367   ,
443261  ,
142009  ,
354987  ,
186625  ,
817 ,
243731  ,
383875  ,
40125   ,
13155   ,
367409  ,
468829  ,
447387  ,
13997   ,
356469  ,
285679  ,
92327   ,
419925  ,
442095  ,
392039  ,
176961  ,
146825  ,
175823  ,
88141   ,
199553  ,
14927   ,
123441  ,
90739   ,
241217  ,
53023   ,
264725  ,
283201  ,
143723  ,
408395  ,
481677  ,
348225  ,
320161  ,
37003   ,
522423  ,
70665   ,
340285  ,
146281  ,
445675  ,
385085  ,
250727  ,
502921  ,
399081  ,
199841  ,
400747  ,
180879  ,
442621  ,
338349  ,
376305  ,
286299  ,
298983  ,
148231  ,
188293  ,
312811  ,
374571  ,
15025   ,
80623   ,
460867  ,
71815   ,
191007  ,
370419  ,
285835  ,
103895  ,
34305   ,
366809  ,
137355  ,
312313  ,
393671  ,
123371  ,
211783  ,
492741  ,
371635  ,
68305   ,
448925  ,
491667  ,
390687  ,
469303  ,
455913  ,
131369  ,
23171   ,
387865  ,
229647  ,
357387  ,
44221   ,
85497   ,
497103  ,
331905  ,
63131   ,
522595  ,
121011  ,
512597  ,
367289  ,
91267   ,
72693   ,
40989   ,
83659   ,
344031  ,
323869  ,
453437  ,
226351  ,
29011   ,
274231  ,
396789  ,
439683  ,
397207  ,
341859  ,
374821  ,
213971  ,
20097   ,
174827  ,
437687  ,
205455  ,
109395  ,
309329  ,
32869   ,
284877  ,
333319  ,
167233  ,
157959  ,
389749  ,
484567  ,
265265  ,
99497   ,
288789  ,
319989  ,
133933  ,
487021  ,
278713  ,
323331  ,
450597  ,
404371  ,
135937  ,
311647  ,
363539  ,
486493  ,
440019  ,
414487  ,
232917  ,
851 ,
429267  ,
93357   ,
383357  ,
112977  ,
390981  ,
139493  ,
117513  ,
482133  ,
447549  ,
14093   ,
218813  ,
320407  ,
212417  ,
34553   ,
38101   ,
185693  ,
185261  ,
474591  ,
502403  ,
204315  ,
476157  ,
118695  ,
262023  ,
217349  ,
433597  ,
276007  ,
205027  ,
497981  ,
159879  ,
450003  ,
78073   ,
449741  ,
394723  ,
276655  ,
302909  ,
73193   ,
485803  ,
128453  ,
190853  ,
448625  ,
423923  ,
450751  ,
84341   ,
88515   ,
278945  ,
15023   ,
460179  ,
432595  ,
31905   ,
81855   ,
83211   ,
460571  ,
125237  ,
2637    ,
206799  ,
382775  ,
96453   ,
467767  ,
96071   ,
332519  ,
175269  ,
187643  ,
337227  ,
378167  ,
6565    ,
317723  ,
435053  ,
39425   ,
377629  ,
240171  ,
210049  ,
141119  ,
341063  ,
318885  ,
239455  ,
110491  ,
65875   ,
335251  ,
336349  ,
77589   ,
157821  ,
62429   ,
522025  ,
168735  ,
130331  ,
489131  ,
446475  ,
116305  ,
262001  ,
99991   ,
482961  ,
421499  ,
245947  ,
359321  ,
38481   ,
321173  ,
161151  ,
406195  ,
7507    ,
72795   ,
256199  ,
306699  ,
314195  ,
438761  ,
181227  ,
349763  ,
431907  ,
26319   ,
441141  ,
44541   ,
486865  ,
326673  ,
379261  ,
361973  ,
521935  ,
19205   ,
90667   ,
231881  ,
287905  ,
269053  ,
128239  ,
251485  ,
423591  ,
503993  ,
225627  ,
155339  ,
518847  ,
374369  ,
329871  ,
219073  ,
360565  ,
54941   ,
244749  ,
414575  ,
281531  ,
229491  ,
321177  ,
287485  ,
301621  ,
206741  ,
340997  ,
231751  ,
389515  ,
347819  ,
176747  ,
161639  ,
429653  ,
445151  ,
94467   ,
224415  ,
291995  ,
497733  ,
414631  ,
418071  ,
233485  ,
470293  ,
96223   ,
76519   ,
181327  ,
105741  ,
25159   ,
491531  ,
160453  ,
314353  ,
99767   ,
337271  ,
113963  ,
467495  ,
30361   ,
499149  ,
13275   ,
67849   ,
351547  ,
452929  ,
237379  ,
392947  ,
337257  ,
190073  ,
294111  ,
201073  ,
216495  ,
25003   ,
513811  ,
316363  ,
211719  ,
258485  ,
274409  ,
187933  ,
227047  ,
250167  ,
430745  ,
285839  ,
44841   ,
215175  ,
181493  ,
234721  ,
467439  ,
457019  ,
509077  ,
359201  ,
11027   ,
429903  ,
268385  ,
97401   ,
139475  ,
412901  ,
384039  ,
216497  ,
22511   ,
368699  ,
428213  ,
124377  ,
436615  ,
360837  ,
429077  ,
400709  ,
514399  ,
241011  ,
80915   ,
66531   ,
173107  ,
524193  ,
65449   ,
357243  ,
472359  ,
457421  ,
276537  ,
332615  ,
121161  ,
30523   ,
66625   ,
493851  ,
75357   ,
72053   ,
138243  ,
498569  ,
241009  ,
482601  ,
166199  ,
302657  ,
272589  ,
92643   ,
492011  ,
118737  ,
308979  ,
6617    ,
305097  ,
466585  ,
318419  ,
149945  ,
380153  ,
291261  ,
259013  ,
88595   ,
476949  ,
41391   ,
170045  ,
256319  ,
295207  ,
372873  ,
438169  ,
196221  ,
49225   ,
200173  ,
269399  ,
202607  ,
299353  ,
221825  ,
391325  ,
248509  ,
183861  ,
62937   ,
370937  ,
308047  ,
208963  ,
362413  ,
230899  ,
518307  ,
187739  ,
460067  ,
391577  ,
434663  ,
35647   ,
286715  ,
294589  ,
389463  ,
162933  ,
411537  ,
167093  ,
65127   ,
121753  ,
344463  ,
516765  ,
414291  ,
128981  ,
243439  ,
470701  ,
437981  ,
342493  ,
322629  ,
504431  ,
383423  ,
468615  ,
402015  ,
262491  ,
225053  ,
195803  ,
145011  ,
460657  ,
289933  ,
490493  ,
258547  ,
51845   ,
284765  ,
300867  ,
142667  ,
50691   ,
172085  ,
353993  ,
500573  ,
254085  ,
113615  ,
519945  ,
129487  ,
277663  ,
164767  ,
416047  ,
155579  ,
248353  ,
109161  ,
382985  ,
388793  ,
507679  ,
299015  ,
274125  ,
204053  ,
431273  ,
513631  ,
483277  ,
36177   ,
471323  ,
306393  ,
17351   ,
87967   ,
382551  ,
4019    ,
377623  ,
114051  ,
355573  ,
523977  ,
484437  ,
271457  ,
199003  ,
108197  ,
271007  ,
344501  ,
234951  ,
157225  ,
409627  ,
129345  ,
96097   ,
264835  ,
255921  ,
338915  ,
251267  ,
277093  ,
73221   ,
392169  ,
183719  ,
139877  ,
344877  ,
195725  ,
163315  ,
6783    ,
43537   ,
244069  ,
362533  ,
97361   ,
189961  ,
240165  ,
118595  ,
452911  ,
427757  ,
314895  ,
494405  ,
21653   ,
399265  ,
330607  ,
369479  ,
491155  ,
31265   ,
434459  ,
288753  ,
84455   ,
293565  ,
460293  ,
21425   ,
61805   ,
437609  ,
259113  ,
305619  ,
234341  ,
408429  ,
294183  ,
424917  ,
521281  ,
437047  ,
430353  ,
81257   ,
393247  ,
382355  ,
131613  ,
299665  ,
20109   ,
201617  ,
185989  ,
428861  ,
94113   ,
511567  ,
412233  ,
429035  ,
519411  ,
314931  ,
519951  ,
77705   ,
87461   ,
333213  ,
284637  ,
7935    ,
371921  ,
237783  ,
428329  ,
442883  ,
322605  ,
277795  ,
103027  ,
85391   ,
176447  ,
43693   ,
323725  ,
311337  ,
344439  ,
208419  ,
93071   ,
25893   ,
395859  ,
451291  ,
448075  ,
173979  ,
397339  ,
491231  ,
93091   ,
454985  ,
351989  ,
302041  ,
361357  ,
67663   ,
170813  ,
387243  ,
224899  ,
20489   ,
484965  ,
313779  ,
361233  ,
469957  ,
332483  ,
62329   ,
246513  ,
168613  ,
11503   ,
177541  ,
333063  ,
195349  ,
295523  ,
259807  ,
142231  ,
269037  ,
482291  ,
299483  ,
252479  ,
283629  ,
240193  ,
320163  ,
486023  ,
520959  ,
63111   ,
10213   ,
431655  ,
439659  ,
147217  ,
411661  ,
308157  ,
321907  ,
501265  ,
419839  ,
371177  ,
513683  ,
419235  ,
162683  ,
346933  ,
37079   ,
455955  ,
491201  ,
343417  ,
111105  ,
516529  ,
47713   ,
171791  ,
388113  ,
247363  ,
484029  ,
169773  ,
250871  ,
439705  ,
249861  ,
93563   ,
276649  ,
347735  ,
275159  ,
444463  ,
444457  ,
340165  ,
238219  ,
511421  ,
3711    ,
293153  ,
433595  ,
498467  ,
328597  ,
462993  ,
242767  ,
280633  ,
188319  ,
147243  ,
59519   ,
10371   ,
109385  ,
421289  ,
519729  ,
311493  ,
55557   ,
62243   ,
332767  ,
132337  ,
502769  ,
190475  ,
220289  ,
368661  ,
101033  ,
159287  ,
346783  ,
88817   ,
322189  ,
297843  ,
22851   ,
314555  ,
30719   ,
226467  ,
316875  ,
64935   ,
348957  ,
411789  ,
321345  ,
100427  ,
196969  ,
216519  ,
212671  ,
238033  ,
470295  ,
428273  ,
85607   ,
368793  ,
146055  ,
169169  ,
38043   ,
26807   ,
146255  ,
400421  ,
174601  ,
491897  ,
233119  ,
387201  ,
348875  ,
68805   ,
187145  ,
20447   ,
486529  ,
60531   ,
124855  ,
456157  ,
471813  ,
183515  ,
375031  ,
107323  ,
448423  ,
283509  ,
379319  ,
417789  ,
209295  ,
238877  ,
395877  ,
427147  ,
23411   ,
223803  ,
22595   ,
108801  ,
322185  ,
58469   ,
483411  ,
394163  ,
413329  ,
354901  ,
522441  ,
109481  ,
168295  ,
269339  ,
238611  ,
503677  ,
437089  ,
379373  ,
57093   ,
91041   ,
125787  ,
324727  ,
177279  ,
50247   ,
416961  ,
506185  ,
404993  ,
374955  ,
52633   ,
301157  ,
236643  ,
167913  ,
393529  ,
178293  ,
73215   ,
385523  ,
260125  ,
486055  ,
449495  ,
58677   ,
375277  ,
320979  ,
451277  ,
330395  ,
438251  ,
310281  ,
317481  ,
126541  ,
214215  ,
475315  ,
315097  ,
318983  ,
317505  ,
474263  ,
496911  ,
125405  ,
43067   ,
33517   ,
389253  ,
42313   ,
129447  ,
421007  ,
362237  ,
227073  ,
126017  ,
479819  ,
210921  ,
79791   ,
198363  ,
384549  ,
329489  ,
44665   ,
356461  ,
134445  ,
135127  ,
449099  ,
155947  ,
168329  ,
365601  ,
353765  ,
419155  ,
150437  ,
119517  ,
298069  ,
28947   ,
35443   ,
413727  ,
269677  ,
366217  ,
136227  ,
155333  ,
464397  ,
130865  ,
241509  ,
320225  ,
137493  ,
271105  ,
75223   ,
375527  ,
143779  ,
112229  ,
245705  ,
112867  ,
411037  ,
89325   ,
237307  ,
161365  ,
484761  ,
207255  ,
206127  ,
321743  ,
384985  ,
442877  ,
263129  ,
211505  ,
325823  ,
85081   ,
445183  ,
409583  ,
283329  ,
65059   ,
131307  ,
243747  ,
387529  ,
423355  ,
2995    ,
491469  ,
125507  ,
411969  ,
27743   ,
437423  ,
506305  ,
259567  ,
3309    ,
286473  ,
358905  ,
160297  ,
4615    ,
42525   ,
152491  ,
237177  ,
171253  ,
356853  ,
320371  ,
66075   ,
134765  ,
365639  ,
276209  ,
498613  ,
353187  ,
176017  ,
29435   ,
113007  ,
501773  ,
207885  ,
370521  ,
345009  ,
148935  ,
43737   ,
36005   ,
386465  ,
137591  ,
20111   ,
52163   ,
84625   ,
67001   ,
244925  ,
408647  ,
90653   ,
112981  ,
416825  ,
192987  ,
291471  ,
408537  ,
370213  ,
487317  ,
195075  ,
484829  ,
452531  ,
491715  ,
175131  ,
296705  ,
182743  ,
401533  ,
145133  ,
47655   ,
106901  ,
385389  ,
333105  ,
495649  ,
198013  ,
490969  ,
15769   ,
517559  ,
360277  ,
99815   ,
523297  ,
61605   ,
140317  ,
140553  ,
206363  ,
373783  ,
441221  ,
331555  ,
53047   ,
15759   ,
252725  ,
100597  ,
410343  ,
471953  ,
159549  ,
327959  ,
441471  ,
110655  ,
283353  ,
356177  ,
63757   ,
264055  ,
154289  ,
234919  ,
175549  ,
66581   ,
218069  ,
47281   ,
185375  ,
94719   ,
117301  ,
486893  ,
239833  ,
54185   ,
320917  ,
67735   ,
104983  ,
304465  ,
440313  ,
470631  ,
28787   ,
381879  ,
207727  ,
98081   ,
119355  ,
141793  ,
522435  ,
499393  ,
95157   ,
251465  ,
93685   ,
247587  ,
462773  ,
360895  ,
193175  ,
47033   ,
421069  ,
240597  ,
9847    ,
496635  ,
353401  ,
21525   ,
514603  ,
215633  ,
324941  ,
266803  ,
195843  ,
457817  ,
297245  ,
87983   ,
247833  ,
404853  ,
209401  ,
130941  ,
371029  ,
274429  ,
141599  ,
340233  ,
402543  ,
243355  ,
502569  ,
219343  ,
316665  ,
409117  ,
467413  ,
167563  ,
8767    ,
490011  ,
31969   ,
244789  ,
173937  ,
488819  ,
279215  ,
331 ,
31395   ,
79851   ,
360451  ,
91743   ,
453003  ,
247647  ,
50239   ,
130511  ,
266153  ,
436609  ,
305001  ,
386119  ,
51055   ,
391537  ,
118293  ,
189295  ,
436559  ,
6587    ,
484879  ,
185985  ,
369453  ,
39209   ,
85417   ,
61079   ,
515227  ,
378617  ,
369691  ,
289961  ,
417129  ,
216939  ,
66181   ,
161249  ,
221775  ,
523799  ,
291817  ,
170383  ,
418119  ,
363171  ,
454299  ,
207721  ,
447149  ,
456603  ,
391507  ,
36489   ,
152227  ,
75227   ,
172843  ,
68107   ,
452955  ,
145421  ,
150221  ,
246009  ,
78407   ,
287993  ,
399961  ,
344161  ,
224507  ,
296827  ,
435787  ,
373389  ,
405083  ,
299121  ,
224369  ,
86133   ,
289307  ,
341689  ,
380379  ,
247229  ,
111781  ,
193173  ,
381567  ,
90409   ,
87017   ,
379085  ,
195549  ,
328503  ,
448819  ,
521439  ,
523211  ,
317559  ,
508697  ,
435439  ,
31307   ,
300425  ,
516943  ,
337803  ,
476487  ,
78833   ,
168493  ,
82991   ,
1813    ,
279039  ,
139735  ,
212037  ,
507637  ,
27191   ,
342299  ,
333581  ,
217225  ,
361105  ,
141349  ,
217139  ,
455297  ,
22027   ,
208285  ,
105195  ,
343399  ,
365187  ,
166003  ,
267747  ,
173265  ,
104309  ,
263875  ,
437963  ,
390657  ,
186295  ,
221165  ,
285495  ,
385165  ,
350075  ,
373929  ,
47901   ,
362017  ,
223307  ,
221823  ,
171781  ,
317267  ,
452633  ,
120487  ,
425947  ,
71937   ,
144669  ,
30537   ,
320807  ,
496709  ,
36143   ,
35249   ,
54399   ,
457465  ,
374257  ,
259027  ,
434899  ,
192051  ,
107773  ,
215557  ,
272847  ,
145053  ,
179531  ,
149193  ,
455445  ,
7111    ,
146859  ,
325841  ,
500423  ,
330427  ,
332067  ,
224651  ,
142941  ,
281513  ,
524213  ,
43221   ,
44235   ,
440259  ,
330081  ,
413537  ,
455371  ,
58199   ,
47729   ,
95937   ,
211567  ,
206227  ,
427361  ,
466909  ,
1005    ,
206647  ,
104791  ,
257555  ,
255555  ,
236197  ,
24417   ,
47507   ,
357477  ,
347973  ,
131241  ,
452411  ,
494475  ,
342379  ,
489111  ,
6675    ,
509787  ,
329523  ,
142947  ,
212759  ,
502533  ,
12323   ,
499179  ,
353173  ,
5519    ,
146257  ,
136979  ,
333593  ,
242981  ,
76435   ,
369869  ,
520221  ,
170155  ,
299129  ,
373969  ,
297759  ,
168945  ,
258359  ,
383557  ,
73439   ,
304311  ,
488225  ,
185907  ,
242127  ,
479013  ,
296237  ,
143831  ,
376901  ,
384261  ,
70843   ,
267839  ,
390079  ,
207373  ,
336845  ,
188153  ,
441483  ,
502729  ,
144489  ,
143595  ,
521973  ,
347585  ,
174495  ,
362967  ,
195351  ,
430933  ,
331571  ,
155305  ,
78807   ,
252037  ,
67461   ,
105441  ,
204725  ,
517849  ,
236481  ,
441255  ,
272255  ,
396343  ,
120681  ,
105631  ,
236671  ,
192703  ,
130503  ,
470853  ,
156907  ,
370583  ,
346321  ,
412653  ,
332919  ,
284217  ,
395281  ,
283305  ,
108461  ,
518885  ,
321629  ,
465913  ,
138519  ,
499083  ,
391627  ,
318493  ,
146001  ,
167501  ,
478239  ,
469563  ,
311423  ,
82501   ,
337647  ,
462381  ,
496957  ,
417031  ,
449591  ,
322099  ,
110997  ,
361467  ,
124215  ,
310941  ,
457079  ,
343763  ,
274689  ,
454023  ,
196851  ,
140011  ,
329071  ,
387481  ,
408773  ,
40235   ,
351537  ,
463559  ,
73109   ,
366319  ,
370429  ,
61679   ,
399063  ,
252481  ,
429989  ,
58691   ,
470643  ,
485623  ,
402333  ,
225503  ,
144559  ,
121153  ,
76475   ,
350553  ,
3935    ,
31375   ,
94239   ,
302415  ,
401575  ,
211757  ,
271075  ,
159559  ,
463171  ,
251429  ,
357403  ,
432513  ,
106507  ,
255729  ,
429641  ,
291489  ,
71215   ,
99219   ,
45203   ,
83541   ,
203975  ,
337455  ,
142077  ,
129255  ,
466479  ,
110353  ,
222145  ,
184543  ,
4223    ,
61693   ,
480821  ,
124743  ,
487855  ,
176403  ,
194931  ,
380825  ,
487637  ,
337069  ,
508087  ,
497721  ,
181339  ,
398547  ,
516409  ,
139969  ,
185615  ,
25049   ,
51321   ,
279923  ,
195797  ,
80977   ,
520641  ,
206053  ,
51091   ,
226235  ,
475763  ,
449191  ,
25233   ,
390933  ,
365715  ,
114355  ,
336241  ,
345473  ,
253533  ,
170419  ,
276927  ,
52391   ,
192871  ,
348987  ,
404949  ,
365431  ,
150615  ,
363203  ,
273999  ,
25469   ,
341535  ,
197597  ,
491999  ,
191295  ,
360335  ,
436757  ,
400821  ,
488647  ,
292951  ,
164863  ,
419047  ,
410339  ,
364887  ,
447227  ,
312255  ,
401577  ,
491153  ,
520151  ,
28657   ,
137485  ,
288963  ,
172713  ,
366519  ,
293067  ,
505061  ,
221561  ,
376689  ,
209791  ,
274969  ,
61145   ,
143303  ,
157459  ,
518153  ,
349473  ,
169179  ,
3579    ,
364721  ,
142975  ,
311275  ,
474695  ,
85031   ,
14031   ,
57731   ,
399487  ,
51707   ,
103261  ,
38863   ,
356271  ,
472975  ,
160727  ,
168239  ,
468851  ,
130069  ,
188281  ,
515097  ,
119167  ,
74835   ,
62219   ,
81827   ,
573 ,
464349  ,
323045  ,
201719  ,
332681  ,
131117  ,
288875  ,
509111  ,
341827  ,
59475   ,
352861  ,
83495   ,
3797    ,
30739   ,
454485  ,
411881  ,
167767  ,
168457  ,
268881  ,
425747  ,
186685  ,
351955  ,
108987  ,
475831  ,
222691  ,
399295  ,
422525  ,
353383  ,
397973  ,
200631  ,
91443   ,
267695  ,
217305  ,
454703  ,
479915  ,
357239  ,
383125  ,
425711  ,
449165  ,
505985  ,
470431  ,
12239   ,
514817  ,
348329  ,
304277  ,
465579  ,
128661  ,
238205  ,
432041  ,
30891   ,
324155  ,
486707  ,
189683  ,
124635  ,
76543   ,
335841  ,
330153  ,
42873   ,
33289   ,
404423  ,
432881  ,
372293  ,
56239   ,
22533   ,
479905  ,
378149  ,
245273  ,
141797  ,
343875  ,
146241  ,
271381  ,
297861  ,
424403  ,
36713   ,
211755  ,
387069  ,
243775  ,
216099  ,
258397  ,
100383  ,
459721  ,
415609  ,
330499  ,
417793  ,
87947   ,
314485  ,
5171    ,
472093  ,
133175  ,
517795  ,
57461   ,
159591  ,
518095  ,
385625  ,
477059  ,
301889  ,
278983  ,
449397  ,
430415  ,
484097  ,
214421  ,
64161   ,
484031  ,
252913  ,
147907  ,
497375  ,
79797   ,
321555  ,
36029   ,
403759  ,
306137  ,
106975  ,
278317  ,
352455  ,
311517  ,
257131  ,
98943   ,
513449  ,
68961   ,
295611  ,
9281    ,
106999  ,
37679   ,
410957  ,
356071  ,
237009  ,
452951  ,
120029  ,
4327    ,
299495  ,
302453  ,
266965  ,
75049   ,
299435  ,
33105   ,
105635  ,
58447   ,
468661  ,
49143   ,
184387  ,
304455  ,
161973  ,
383407  ,
161591  ,
99557   ,
136555  ,
227539  ,
53703   ,
183421  ,
1309    ,
219647  ,
181273  ,
225657  ,
499885  ,
7793    ,
316853  ,
203725  ,
510555  ,
439029  ,
140139  ,
226933  ,
53193   ,
426793  ,
323911  ,
197289  ,
451239  ,
400865  ,
186897  ,
415817  ,
247495  ,
338897  ,
81519   ,
508191  ,
51431   ,
138341  ,
168981  ,
509307  ,
425997  ,
31671   ,
466107  ,
107807  ,
119149  ,
45445   ,
463293  ,
169005  ,
494957  ,
233889  ,
379071  ,
56207   ,
370557  ,
190641  ,
313037  ,
409251  ,
115275  ,
432787  ,
149865  ,
128547  ,
387723  ,
208827  ,
513141  ,
342985  ,
451773  ,
123373  ,
266837  ,
356005  ,
210101  ,
222037  ,
309733  ,
291245  ,
198909  ,
109053  ,
338203  ,
358821  ,
315763  ,
260497  ,
270577  ,
50711   ,
16659   ,
432321  ,
426009  ,
363977  ,
169873  ,
397129  ,
506275  ,
34723   ,
406577  ,
512633  ,
446285  ,
126645  ,
359527  ,
234217  ,
248385  ,
72351   ,
490133  ,
353629  ,
275083  ,
257899  ,
286679  ,
506675  ,
392463  ,
64919   ,
304447  ,
167823  ,
469789  ,
128867  ,
341797  ,
269127  ,
139817  ,
73833   ,
474985  ,
146207  ,
259459  ,
514783  ,
225979  ,
379661  ,
65709   ,
159455  ,
68921   ,
406531  ,
165331  ,
162783  ,
134373  ,
524181  ,
325319  ,
382207  ,
374607  ,
459885  ,
110169  ,
109615  ,
207343  ,
242825  ,
26893   ,
304861  ,
271033  ,
39067   ,
69399   ,
398623  ,
82457   ,
68137   ,
30655   ,
357523  ,
110607  ,
70321   ,
200023  ,
333595  ,
519989  ,
406867  ,
454885  ,
371469  ,
181747  ,
287901  ,
328919  ,
452885  ,
268871  ,
114371  ,
174289  ,
204689  ,
339681  ,
244961  ,
138059  ,
23775   ,
157431  ,
364049  ,
168241  ,
386843  ,
304593  ,
244153  ,
455883  ,
135783  ,
189137  ,
72541   ,
436449  ,
17323   ,
184745  ,
281281  ,
392061  ,
349459  ,
451941  ,
36721   ,
442071  ,
215979  ,
96757   ,
148521  ,
45921   ,
77641   ,
362129  ,
362027  ,
1419    ,
213361  ,
206533  ,
416007  ,
304031  ,
432157  ,
55333   ,
318205  ,
399399  ,
259627  ,
269895  ,
113389  ,
470083  ,
267011  ,
224557  ,
4671    ,
387213  ,
73547   ,
288035  ,
267849  ,
439837  ,
294697  ,
236133  ,
59493   ,
188573  ,
453863  ,
27265   ,
422439  ,
183715  ,
310065  ,
436519  ,
347411  ,
378187  ,
92151   ,
444977  ,
215793  ,
388667  ,
346607  ,
219657  ,
470907  ,
105075  ,
382637  ,
318467  ,
193169  ,
405245  ,
304635  ,
140987  ,
100999  ,
44247   ,
193987  ,
333067  ,
504099  ,
458487  ,
78945   ,
113979  ,
327675  ,
182731  ,
190221  ,
109961  ,
47721   ,
137905  ,
509935  ,
415927  ,
296613  ,
151271  ,
397933  ,
475833  ,
209163  ,
122023  ,
121877  ,
7681    ,
390363  ,
188591  ,
37265   ,
102951  ,
510389  ,
491125  ,
184595  ,
150425  ,
174379  ,
496253  ,
397359  ,
142605  ,
32063   ,
278813  ,
176873  ,
85853   ,
234275  ,
234797  ,
377841  ,
484883  ,
342529  ,
218631  ,
200297  ,
328805  ,
400701  ,
223069  ,
181567  ,
309437  ,
405825  ,
205209  ,
296555  ,
308911  ,
411577  ,
410949  ,
13167   ,
272245  ,
163751  ,
136507  ,
110507  ,
165829  ,
435515  ,
63761   ,
474227  ,
445641  ,
163547  ,
311013  ,
18131   ,
189441  ,
78087   ,
390825  ,
491063  ,
154625  ,
445825  ,
178395  ,
160541  ,
129953  ,
17663   ,
59561   ,
259215  ,
418625  ,
345359  ,
268621  ,
225865  ,
102075  ,
372677  ,
227767  ,
437373  ,
403481  ,
151031  ,
477203  ,
150857  ,
147693  ,
245381  ,
231701  ,
201019  ,
284969  ,
41339   ,
430169  ,
7919    ,
243345  ,
9655    ,
391383  ,
345769  ,
58521   ,
329835  ,
178569  ,
474807  ,
66627   ,
231369  ,
439087  ,
298597  ,
200877  ,
512175  ,
352351  ,
87387   ,
269711  ,
458703  ,
369055  ,
402877  ,
252607  ,
197639  ,
213247  ,
232615  ,
92657   ,
429865  ,
91295   ,
60675   ,
515225  ,
394623  ,
167027  ,
91441   ,
168589  ,
407489  ,
61537   ,
12727   ,
419841  ,
116529  ,
431501  ,
27431   ,
59541   ,
422421  ,
352663  ,
160503  ,
105091  ,
440027  ,
391909  ,
499147  ,
227823  ,
356185  ,
209859  ,
237757  ,
294719  ,
198541  ,
93801   ,
193925  ,
226339  ,
449107  ,
131637  ,
385919  ,
191353  ,
507939  ,
119171  ,
120225  ,
194801  ,
420895  ,
390275  ,
357333  ,
82391   ,
369141  ,
57705   ,
477633  ,
468597  ,
497491  ,
329805  ,
363165  ,
314103  ,
41947   ,
217175  ,
456325  ,
508435  ,
370641  ,
149311  ,
377971  ,
492869  ,
88373   ,
220541  ,
269265  ,
519127  ,
302535  ,
450231  ,
114681  ,
439607  ,
48657   ,
195225  ,
441259  ,
270287  ,
123281  ,
157339  ,
24067   ,
277467  ,
23209   ,
480037  ,
75733   ,
120049  ,
74375   ,
308017  ,
289173  ,
95853   ,
45987   ,
115339  ,
466973  ,
506551  ,
254681  ,
334965  ,
243101  ,
238815  ,
326495  ,
172489  ,
73113   ,
119345  ,
79275   ,
119931  ,
30161   ,
240745  ,
428825  ,
47675   ,
121967  ,
233195  ,
123165  ,
479149  ,
97037   ,
142089  ,
257253  ,
214405  ,
251141  ,
119029  ,
514015  ,
248751  ,
517863  ,
142393  ,
154935  ,
12367   ,
106931  ,
267209  ,
416673  ,
176893  ,
384475  ,
119825  ,
164611  ,
358501  ,
357389  ,
452533  ,
460727  ,
142831  ,
31497   ,
408089  ,
392383  ,
67637   ,
288857  ,
175585  ,
266747  ,
41765   ,
393901  ,
72789   ,
107687  ,
30391   ,
285671  ,
213485  ,
146743  ,
428499  ,
168767  ,
73743   ,
253675  ,
333159  ,
40307   ,
454903  ,
474825  ,
437973  ,
44739   ,
308231  ,
179883  ,
134153  ,
475069  ,
188537  ,
508973  ,
220637  ,
188005  ,
192269  ,
383763  ,
408723  ,
173275  ,
34577   ,
399119  ,
84701   ,
198817  ,
328407  ,
198645  ,
90179   ,
468431  ,
116563  ,
333127  ,
211005  ,
246461  ,
268813  ,
96113   ,
3447    ,
212257  ,
39265   ,
168843  ,
281933  ,
149947  ,
392735  ,
194069  ,
418871  ,
378107  ,
399309  ,
45741   ,
396531  ,
448939  ,
388199  ,
474421  ,
41241   ,
213887  ,
56587   ,
177657  ,
494225  ,
278607  ,
176267  ,
59741   ,
270589  ,
165791  ,
155361  ,
6473    ,
162547  ,
115111  ,
453061  ,
50925   ,
405033  ,
489907  ,
471277  ,
514717  ,
267253  ,
417221  ,
300903  ,
482243  ,
48449   ,
322747  ,
130635  ,
506133  ,
206951  ,
93809   ,
511615  ,
106977  ,
511393  ,
165785  ,
289257  ,
105363  ,
293217  ,
30345   ,
79175   ,
60301   ,
461261  ,
401323  ,
5943    ,
491845  ,
148305  ,
104025  ,
39305   ,
474573  ,
341611  ,
274603  ,
441219  ,
334337  ,
195011  ,
183303  ,
96023   ,
495489  ,
380921  ,
203041  ,
388783  ,
235133  ,
281039  ,
38607   ,
62285   ,
123401  ,
89741   ,
410791  ,
32253   ,
173905  ,
342407  ,
315951  ,
33885   ,
336275  ,
243533  ,
283835  ,
290881  ,
183377  ,
305311  ,
467285  ,
464893  ,
197217  ,
61965   ,
45613   ,
517645  ,
313339  ,
450115  ,
167999  ,
514009  ,
68119   ,
32235   ,
77667   ,
29657   ,
462767  ,
231101  ,
236467  ,
173483  ,
378741  ,
437545  ,
428441  ,
487347  ,
125753  ,
439559  ,
313519  ,
176115  ,
203733  ,
361193  ,
66291   ,
372245  ,
228819  ,
457165  ,
353889  ,
271861  ,
2961    ,
290687  ,
114523  ,
106185  ,
115973  ,
301141  ,
143421  ,
471109  ,
499515  ,
398857  ,
512545  ,
331319  ,
159897  ,
309705  ,
426123  ,
196201  ,
253965  ,
441231  ,
363183  ,
413997  ,
72719   ,
418185  ,
136949  ,
84053   ,
66205   ,
385911  ,
166495  ,
440155  ,
428225  ,
19885   ,
56283   ,
138471  ,
26285   ,
381021  ,
465113  ,
266033  ,
496847  ,
419331  ,
494525  ,
10463   ,
460669  ,
63139   ,
441583  ,
144601  ,
151503  ,
503305  ,
84051   ,
24255   ,
497473  ,
97709   ,
184819  ,
263255  ,
115365  ,
308643  ,
199949  ,
261511  ,
227647  ,
83109   ,
144957  ,
254307  ,
102661  ,
95753   ,
392433  ,
310997  ,
203229  ,
308719  ,
240017  ,
138373  ,
29295   ,
254391  ,
16235   ,
143789  ,
257247  ,
265947  ,
92127   ,
110075  ,
164045  ,
455097  ,
122351  ,
305117  ,
137161  ,
84205   ,
512991  ,
422887  ,
442063  ,
75573   ,
292001  ,
141359  ,
14853   ,
306481  ,
102725  ,
81015   ,
14697   ,
86609   ,
146273  ,
238385  ,
385869  ,
485749  ,
60087   ,
147359  ,
62247   ,
117087  ,
352319  ,
38317   ,
404431  ,
361969  ,
148009
};


const Real latticeB[] =
{

    1   ,
182667  ,
213731  ,
255351  ,
96013   ,
116671  ,
479315  ,
424089  ,
271103  ,
464421  ,
124483  ,
230887  ,
392877  ,
162965  ,
109125  ,
168491  ,
216103  ,
5613    ,
207895  ,
506745  ,
189519  ,
114879  ,
133967  ,
374257  ,
254597  ,
502087  ,
298245  ,
191333  ,
242099  ,
285991  ,
397887  ,
507051  ,
511437  ,
129779  ,
406987  ,
345291  ,
225123  ,
511175  ,
432153  ,
306191  ,
116577  ,
809 ,
370175  ,
402615  ,
485791  ,
201053  ,
366959  ,
54087   ,
395609  ,
211615  ,
68543   ,
443345  ,
327293  ,
290819  ,
278623  ,
362043  ,
236117  ,
11091   ,
216837  ,
31545   ,
325799  ,
503877  ,
410523  ,
88371   ,
240077  ,
423807  ,
479855  ,
330835  ,
134517  ,
329989  ,
473381  ,
59205   ,
337775  ,
355995  ,
372243  ,
279827  ,
367217  ,
277741  ,
267077  ,
417971  ,
152599  ,
184949  ,
511773  ,
397077  ,
520041  ,
98063   ,
52983   ,
91233   ,
363069  ,
23829   ,
424377  ,
225285  ,
171171  ,
496765  ,
352791  ,
223231  ,
253273  ,
296195  ,
273379  ,
407265  ,
305849  ,
215121  ,
489851  ,
245893  ,
397947  ,
174723  ,
329797  ,
213325  ,
357759  ,
346031  ,
131433  ,
110731  ,
487615  ,
371877  ,
330799  ,
124595  ,
48775   ,
273275  ,
405083  ,
436731  ,
465257  ,
158265  ,
82033   ,
67805   ,
203565  ,
190785  ,
351165  ,
19555   ,
210139  ,
236211  ,
197333  ,
217457  ,
437623  ,
304987  ,
461169  ,
470529  ,
457011  ,
91823   ,
40575   ,
513857  ,
238575  ,
149779  ,
163017  ,
355521  ,
438395  ,
429151  ,
510607  ,
252661  ,
255753  ,
219989  ,
146583  ,
138783  ,
262887  ,
22765   ,
313675  ,
329005  ,
198699  ,
239305  ,
416211  ,
305549  ,
185961  ,
343313  ,
485961  ,
333207  ,
400975  ,
334381  ,
317357  ,
270221  ,
175403  ,
179303  ,
341251  ,
11983   ,
497027  ,
145741  ,
431637  ,
27489   ,
460319  ,
288665  ,
178737  ,
120329  ,
99851   ,
97789   ,
446355  ,
398323  ,
320921  ,
399735  ,
301009  ,
58221   ,
20499   ,
496019  ,
201021  ,
18141   ,
401811  ,
7615    ,
13797   ,
56685   ,
35433   ,
143763  ,
221013  ,
111635  ,
398843  ,
450531  ,
503423  ,
37261   ,
130555  ,
159743  ,
114359  ,
283841  ,
168217  ,
148271  ,
69501   ,
450607  ,
283473  ,
13641   ,
443385  ,
338995  ,
8113    ,
30043   ,
442875  ,
502897  ,
336337  ,
110527  ,
514381  ,
200349  ,
27787   ,
38955   ,
214547  ,
231515  ,
315083  ,
458703  ,
136455  ,
23359   ,
247081  ,
448209  ,
421023  ,
417125  ,
314287  ,
335073  ,
315409  ,
131405  ,
495049  ,
459151  ,
444599  ,
458887  ,
36639   ,
512851  ,
431191  ,
257755  ,
336191  ,
80771   ,
209571  ,
201763  ,
476611  ,
66875   ,
216789  ,
426571  ,
477141  ,
57497   ,
346643  ,
312477  ,
195855  ,
283913  ,
134259  ,
78007   ,
206851  ,
367259  ,
297197  ,
90095   ,
58027   ,
222687  ,
186773  ,
376291  ,
266565  ,
363313  ,
98609   ,
5093    ,
46873   ,
456783  ,
466755  ,
490973  ,
141089  ,
63909   ,
470491  ,
143957  ,
522397  ,
185037  ,
338677  ,
119827  ,
200753  ,
221811  ,
286559  ,
19683   ,
27881   ,
220993  ,
110561  ,
446047  ,
44727   ,
380733  ,
246933  ,
320283  ,
259667  ,
313171  ,
307877  ,
498659  ,
369629  ,
382795  ,
233291  ,
503271  ,
236669  ,
451281  ,
517257  ,
180291  ,
186613  ,
331481  ,
487085  ,
427909  ,
70661   ,
661 ,
239429  ,
410193  ,
522557  ,
21083   ,
455269  ,
4565    ,
481763  ,
323253  ,
365757  ,
158517  ,
193295  ,
469623  ,
242289  ,
442553  ,
488709  ,
420303  ,
151555  ,
339289  ,
37947   ,
66323   ,
499459  ,
87281   ,
126697  ,
508883  ,
241119  ,
301537  ,
39779   ,
164315  ,
242521  ,
309569  ,
92317   ,
16541   ,
169075  ,
405649  ,
68865   ,
133371  ,
472995  ,
161715  ,
408445  ,
431781  ,
347007  ,
16627   ,
43341   ,
293235  ,
328005  ,
391913  ,
402789  ,
157951  ,
374641  ,
116455  ,
479091  ,
434001  ,
434035  ,
79739   ,
142549  ,
237507  ,
210925  ,
162389  ,
228837  ,
247477  ,
315617  ,
346365  ,
47207   ,
167439  ,
396005  ,
374115  ,
286879  ,
385 ,
221261  ,
157281  ,
307311  ,
469771  ,
13813   ,
307393  ,
261209  ,
397203  ,
314125  ,
373317  ,
230179  ,
253641  ,
229057  ,
451969  ,
386679  ,
90819   ,
444013  ,
269043  ,
475501  ,
132587  ,
287719  ,
89359   ,
217833  ,
304275  ,
408981  ,
277515  ,
465275  ,
122287  ,
420485  ,
204893  ,
485847  ,
335899  ,
197479  ,
131951  ,
489045  ,
116391  ,
182133  ,
132935  ,
260647  ,
470223  ,
24317   ,
370505  ,
300645  ,
221855  ,
95761   ,
228733  ,
287833  ,
389923  ,
313019  ,
295237  ,
381513  ,
196435  ,
15297   ,
294871  ,
267369  ,
117033  ,
110951  ,
402061  ,
322613  ,
508607  ,
310683  ,
245311  ,
212345  ,
213887  ,
242907  ,
189185  ,
52609   ,
63933   ,
214337  ,
322033  ,
267229  ,
421453  ,
6973    ,
84411   ,
504749  ,
445067  ,
183923  ,
459639  ,
199471  ,
460365  ,
140433  ,
355647  ,
299899  ,
487325  ,
362609  ,
105365  ,
459579  ,
481643  ,
147665  ,
306379  ,
368397  ,
34909   ,
469315  ,
104801  ,
410927  ,
175983  ,
434559  ,
254987  ,
411307  ,
426343  ,
462991  ,
174309  ,
200421  ,
225891  ,
218575  ,
52419   ,
382181  ,
302103  ,
242249  ,
468593  ,
459953  ,
15831   ,
74367   ,
203123  ,
352331  ,
2005    ,
190473  ,
245795  ,
298933  ,
27529   ,
132969  ,
133047  ,
375829  ,
333711  ,
14119   ,
145605  ,
121537  ,
64059   ,
403317  ,
452145  ,
93347   ,
417051  ,
438969  ,
314237  ,
33733   ,
514883  ,
132369  ,
305087  ,
50959   ,
6337    ,
451059  ,
44985   ,
142405  ,
47877   ,
223185  ,
431527  ,
416269  ,
177905  ,
104629  ,
121643  ,
111869  ,
180353  ,
284651  ,
79301   ,
60863   ,
91103   ,
260269  ,
230541  ,
374483  ,
412137  ,
455965  ,
249339  ,
97557   ,
140627  ,
135139  ,
173453  ,
123149  ,
141603  ,
192959  ,
370693  ,
18775   ,
291473  ,
385945  ,
275749  ,
496805  ,
8101    ,
79711   ,
311263  ,
426829  ,
157149  ,
37451   ,
143299  ,
186791  ,
209431  ,
524243  ,
74461   ,
55645   ,
135181  ,
315485  ,
502423  ,
474101  ,
237307  ,
310243  ,
350465  ,
10019   ,
504175  ,
337413  ,
113193  ,
363299  ,
295729  ,
310337  ,
166319  ,
432275  ,
166973  ,
339435  ,
12247   ,
447019  ,
380275  ,
194937  ,
128651  ,
143805  ,
178135  ,
327333  ,
226949  ,
504321  ,
364595  ,
78335   ,
479411  ,
229765  ,
159241  ,
204819  ,
349963  ,
198305  ,
410643  ,
73239   ,
13693   ,
422801  ,
388511  ,
191007  ,
346475  ,
435997  ,
70713   ,
356555  ,
432927  ,
64895   ,
247217  ,
450335  ,
101675  ,
45787   ,
386437  ,
514125  ,
110117  ,
272779  ,
448801  ,
235571  ,
29195   ,
20745   ,
186335  ,
36895   ,
122491  ,
394385  ,
410515  ,
38815   ,
188947  ,
284779  ,
268037  ,
336379  ,
334445  ,
345131  ,
387203  ,
103939  ,
356691  ,
412439  ,
197791  ,
214179  ,
330283  ,
13415   ,
399359  ,
350885  ,
188877  ,
99061   ,
488839  ,
239833  ,
114249  ,
123727  ,
481273  ,
328851  ,
289745  ,
380837  ,
2529    ,
188891  ,
62413   ,
403801  ,
9985    ,
310643  ,
496949  ,
36107   ,
284497  ,
164259  ,
491755  ,
281677  ,
449805  ,
482373  ,
300299  ,
416795  ,
379247  ,
215901  ,
424107  ,
63211   ,
180719  ,
259389  ,
155667  ,
298797  ,
33981   ,
183927  ,
241719  ,
319255  ,
194057  ,
65251   ,
293893  ,
487781  ,
104299  ,
62957   ,
192351  ,
249741  ,
231127  ,
291341  ,
374771  ,
198513  ,
152229  ,
493687  ,
247777  ,
133951  ,
483219  ,
131327  ,
442749  ,
365247  ,
26349   ,
364135  ,
53985   ,
271773  ,
272979  ,
401987  ,
323297  ,
322967  ,
178989  ,
372741  ,
355981  ,
489943  ,
359819  ,
323785  ,
315067  ,
340603  ,
293149  ,
144065  ,
179791  ,
353571  ,
359391  ,
263865  ,
237627  ,
391821  ,
128613  ,
22741   ,
202125  ,
496305  ,
347621  ,
280839  ,
453131  ,
125859  ,
335319  ,
328921  ,
261875  ,
475275  ,
42949   ,
83187   ,
277481  ,
513825  ,
177693  ,
217725  ,
131305  ,
7415    ,
416971  ,
165421  ,
472571  ,
391313  ,
506561  ,
135019  ,
190013  ,
70753   ,
366987  ,
523515  ,
62497   ,
20667   ,
515797  ,
185765  ,
276083  ,
225101  ,
354605  ,
299467  ,
475077  ,
251119  ,
309515  ,
370931  ,
279461  ,
191153  ,
70277   ,
31851   ,
266209  ,
69867   ,
41527   ,
329215  ,
325119  ,
19951   ,
244651  ,
423763  ,
490805  ,
102763  ,
360783  ,
157485  ,
181171  ,
250549  ,
348159  ,
376619  ,
424555  ,
411083  ,
120849  ,
292387  ,
220143  ,
135245  ,
313547  ,
236925  ,
14541   ,
42625   ,
499187  ,
492767  ,
463587  ,
437049  ,
150239  ,
340937  ,
109219  ,
5537    ,
404167  ,
27333   ,
457997  ,
512891  ,
149587  ,
45325   ,
400001  ,
410747  ,
312933  ,
35217   ,
254355  ,
438227  ,
28987   ,
341989  ,
268939  ,
39717   ,
480331  ,
97805   ,
64169   ,
426903  ,
221619  ,
233027  ,
194659  ,
65033   ,
482401  ,
357965  ,
192877  ,
442829  ,
84845   ,
411581  ,
222481  ,
189141  ,
56321   ,
259061  ,
287213  ,
228301  ,
67101   ,
441469  ,
504907  ,
286941  ,
34405   ,
115557  ,
438613  ,
507491  ,
211201  ,
225171  ,
327647  ,
292307  ,
27565   ,
36219   ,
52945   ,
448235  ,
330693  ,
77533   ,
458459  ,
176801  ,
477597  ,
30227   ,
116843  ,
48689   ,
365109  ,
400427  ,
399227  ,
35919   ,
193531  ,
185437  ,
495707  ,
66497   ,
51829   ,
414757  ,
185531  ,
177869  ,
205659  ,
278647  ,
6851    ,
241547  ,
411435  ,
193033  ,
149285  ,
330963  ,
191219  ,
483163  ,
151605  ,
488243  ,
89829   ,
395475  ,
1381    ,
291993  ,
179267  ,
17159   ,
16195   ,
101507  ,
85171   ,
40411   ,
423093  ,
301261  ,
129437  ,
76009   ,
103109  ,
177167  ,
337333  ,
19621   ,
30365   ,
339997  ,
497917  ,
4367    ,
86245   ,
255867  ,
39757   ,
11037   ,
403117  ,
159581  ,
63219   ,
60197   ,
176671  ,
234085  ,
340013  ,
360333  ,
443 ,
179475  ,
507459  ,
197457  ,
51877   ,
458085  ,
470697  ,
423181  ,
29467   ,
71357   ,
452103  ,
381853  ,
350749  ,
33837   ,
141039  ,
39473   ,
144683  ,
52899   ,
172499  ,
518881  ,
75897   ,
2385    ,
428299  ,
494799  ,
228181  ,
408085  ,
145427  ,
287243  ,
366685  ,
220623  ,
26827   ,
117995  ,
287045  ,
245829  ,
273409  ,
151837  ,
96073   ,
70805   ,
425149  ,
153789  ,
472299  ,
488189  ,
166709  ,
43605   ,
389917  ,
43693   ,
165147  ,
125695  ,
510797  ,
474877  ,
114777  ,
352529  ,
200923  ,
266085  ,
124811  ,
450925  ,
182643  ,
319955  ,
356675  ,
134683  ,
446687  ,
373853  ,
236239  ,
331691  ,
82181   ,
150005  ,
340367  ,
472941  ,
106107  ,
116129  ,
116549  ,
100159  ,
97203   ,
324227  ,
19717   ,
18373   ,
378173  ,
406703  ,
156321  ,
42837   ,
407291  ,
514159  ,
74829   ,
144851  ,
138323  ,
111983  ,
233429  ,
168813  ,
9575    ,
269407  ,
493421  ,
192197  ,
459933  ,
74595   ,
233637  ,
185559  ,
414111  ,
418093  ,
307539  ,
24147   ,
347063  ,
422451  ,
21139   ,
152563  ,
328989  ,
109121  ,
117807  ,
385019  ,
208541  ,
323725  ,
234055  ,
221237  ,
231765  ,
152037  ,
320181  ,
219981  ,
518989  ,
389219  ,
290317  ,
312379  ,
403405  ,
507885  ,
498833  ,
329757  ,
74263   ,
224493  ,
260227  ,
481261  ,
419931  ,
440079  ,
305035  ,
206491  ,
287125  ,
1221    ,
198365  ,
505909  ,
383069  ,
513091  ,
452597  ,
483019  ,
24969   ,
499547  ,
41099   ,
124431  ,
44429   ,
311213  ,
32285   ,
7727    ,
136995  ,
241949  ,
241333  ,
165341  ,
190123  ,
38877   ,
181819  ,
503485  ,
354267  ,
212459  ,
355941  ,
253627  ,
242555  ,
326571  ,
343469  ,
342887  ,
52877   ,
56123   ,
480005  ,
136619  ,
12945   ,
29669   ,
380709  ,
235693  ,
22691   ,
43191   ,
135661  ,
27635   ,
307443  ,
225885  ,
265003  ,
133183  ,
274369  ,
434699  ,
161229  ,
484283  ,
363693  ,
505779  ,
208033  ,
374109  ,
433107  ,
381805  ,
275101  ,
417613  ,
401921  ,
55107   ,
425037  ,
521857  ,
260701  ,
402307  ,
42587   ,
59475   ,
271851  ,
53453   ,
382947  ,
234899  ,
237259  ,
103075  ,
310843  ,
345373  ,
148397  ,
349217  ,
503419  ,
63357   ,
6611    ,
523429  ,
461491  ,
19499   ,
439379  ,
42925   ,
218915  ,
147571  ,
234205  ,
349457  ,
356795  ,
448197  ,
503331  ,
237789  ,
13091   ,
258825  ,
483437  ,
155115  ,
490443  ,
117725  ,
367005  ,
129761  ,
394445  ,
443749  ,
156709  ,
265315  ,
254821  ,
361187  ,
441331  ,
61563   ,
416729  ,
505253  ,
129357  ,
284931  ,
176765  ,
420515  ,
207563  ,
467093  ,
124275  ,
402669  ,
147117  ,
108079  ,
150515  ,
230897  ,
413805  ,
233897  ,
388931  ,
366653  ,
32569   ,
346229  ,
229537  ,
64109   ,
64613   ,
441859  ,
13955   ,
411549  ,
92617   ,
475177  ,
349443  ,
164085  ,
482893  ,
129979  ,
141101  ,
404193  ,
47375   ,
403469  ,
100021  ,
419637  ,
414429  ,
326277  ,
267867  ,
277579  ,
375925  ,
208753  ,
316523  ,
189323  ,
379107  ,
166389  ,
207189  ,
208701  ,
307039  ,
228427  ,
407965  ,
120277  ,
489683  ,
418765  ,
406531  ,
319661  ,
334415  ,
162945  ,
307177  ,
478021  ,
446339  ,
99133   ,
21165   ,
5005    ,
322907  ,
302495  ,
74203   ,
210133  ,
394363  ,
410529  ,
35211   ,
247301  ,
366349  ,
236501  ,
353205  ,
250285  ,
282101  ,
23219   ,
198605  ,
21891   ,
523695  ,
214659  ,
416235  ,
121597  ,
86325   ,
205155  ,
304405  ,
152515  ,
380939  ,
302683  ,
411717  ,
436993  ,
341875  ,
1315    ,
30667   ,
98363   ,
361457  ,
486659  ,
314139  ,
273669  ,
143987  ,
301379  ,
306061  ,
243117  ,
304173  ,
48031   ,
513457  ,
345965  ,
343075  ,
237803  ,
342593  ,
281485  ,
344467  ,
345121  ,
234195  ,
3681    ,
121005  ,
161517  ,
505793  ,
217137  ,
188771  ,
498275  ,
45499   ,
463565  ,
101923  ,
6063    ,
90565   ,
47531   ,
515491  ,
112697  ,
127405  ,
374309  ,
14621   ,
482255  ,
64333   ,
5649    ,
269973  ,
48063   ,
89573   ,
489445  ,
469029  ,
154853  ,
68333   ,
377307  ,
170831  ,
327421  ,
43505   ,
163939  ,
327765  ,
132115  ,
496643  ,
7893    ,
187469  ,
322597  ,
435871  ,
287147  ,
340017  ,
153539  ,
497955  ,
215477  ,
345125  ,
477475  ,
48897   ,
181587  ,
439025  ,
117091  ,
403839  ,
427133  ,
2211    ,
169621  ,
154165  ,
18173   ,
91755   ,
21613   ,
207109  ,
476459  ,
285123  ,
226867  ,
469373  ,
416685  ,
319995  ,
444763  ,
452337  ,
389803  ,
168829  ,
509811  ,
274933  ,
236395  ,
472687  ,
357957  ,
332061  ,
446555  ,
140573  ,
275349  ,
220549  ,
306051  ,
93169   ,
404795  ,
71931   ,
191253  ,
352291  ,
255475  ,
498625  ,
488063  ,
83551   ,
158525  ,
462577  ,
466549  ,
373515  ,
447037  ,
204595  ,
441075  ,
362579  ,
269123  ,
21163   ,
461777  ,
292941  ,
311131  ,
329301  ,
10691   ,
348189  ,
403579  ,
383453  ,
124397  ,
467219  ,
419867  ,
323827  ,
77835   ,
157309  ,
523419  ,
381363  ,
115043  ,
52157   ,
16899   ,
324323  ,
265253  ,
274787  ,
261491  ,
393469  ,
229869  ,
154975  ,
259165  ,
509405  ,
347163  ,
133537  ,
77361   ,
280525  ,
382813  ,
407763  ,
68429   ,
32799   ,
422173  ,
98509   ,
154621  ,
507157  ,
521853  ,
424069  ,
454059  ,
235077  ,
105349  ,
264563  ,
171333  ,
144701  ,
420677  ,
479755  ,
224611  ,
11179   ,
150675  ,
258351  ,
258853  ,
264927  ,
207205  ,
185997  ,
84885   ,
342901  ,
470053  ,
263731  ,
293269  ,
81197   ,
465109  ,
354291  ,
394283  ,
514419  ,
108411  ,
33387   ,
53845   ,
216833  ,
123075  ,
231821  ,
88879   ,
288187  ,
315875  ,
354701  ,
501901  ,
270949  ,
367403  ,
278227  ,
184485  ,
399339  ,
257181  ,
298171  ,
289883  ,
389349  ,
404785  ,
183675  ,
3005    ,
283327  ,
381717  ,
195581  ,
269469  ,
95341   ,
65457   ,
277021  ,
371867  ,
361811  ,
387883  ,
280579  ,
166021  ,
347293  ,
469869  ,
177855  ,
482653  ,
404433  ,
112003  ,
76787   ,
242561  ,
41917   ,
513573  ,
410607  ,
500461  ,
137707  ,
264475  ,
163901  ,
167853  ,
480069  ,
87563   ,
202511  ,
375269  ,
504779  ,
72187   ,
182987  ,
376339  ,
120269  ,
322453  ,
37443   ,
482387  ,
158051  ,
395211  ,
484595  ,
347475  ,
111411  ,
146783  ,
240333  ,
476339  ,
203791  ,
475389  ,
270117  ,
248933  ,
352515  ,
366523  ,
134491  ,
285891  ,
296893  ,
259675  ,
372291  ,
57583   ,
211475  ,
390397  ,
273533  ,
124243  ,
290693  ,
111749  ,
226479  ,
75923   ,
275011  ,
214413  ,
270591  ,
199019  ,
189771  ,
158291  ,
508717  ,
286051  ,
166469  ,
368909  ,
107091  ,
337967  ,
379395  ,
168205  ,
199645  ,
416989  ,
376613  ,
140971  ,
150091  ,
471723  ,
274915  ,
253163  ,
486405  ,
277755  ,
59041   ,
132509  ,
87709   ,
82115   ,
463541  ,
49059   ,
447421  ,
42109   ,
161117  ,
199173  ,
444245  ,
364747  ,
402571  ,
262893  ,
497183  ,
190179  ,
235085  ,
263619  ,
514661  ,
33451   ,
224643  ,
281905  ,
304741  ,
85451   ,
511101  ,
352811  ,
71299   ,
428749  ,
287821  ,
415123  ,
405275  ,
488083  ,
61067   ,
329715  ,
466893  ,
95953   ,
500005  ,
242733  ,
26163   ,
368701  ,
88771   ,
416659  ,
265139  ,
295005  ,
386331  ,
366893  ,
65989   ,
142917  ,
259795  ,
5075    ,
291661  ,
452651  ,
158965  ,
474333  ,
346235  ,
227859  ,
10603   ,
119027  ,
415811  ,
159725  ,
430289  ,
398877  ,
466885  ,
129803  ,
129795  ,
385069  ,
370941  ,
73315   ,
438995  ,
335259  ,
85915   ,
57091   ,
79811   ,
68653   ,
282565  ,
412155  ,
443701  ,
67197   ,
435237  ,
160703  ,
28413   ,
298645  ,
230563  ,
219189  ,
382241  ,
517723  ,
49765   ,
278901  ,
218085  ,
468173  ,
489837  ,
368773  ,
18187   ,
380845  ,
363021  ,
409221  ,
481411  ,
440319  ,
339163  ,
509093  ,
225949  ,
381443  ,
200539  ,
331219  ,
6591    ,
105153  ,
412063  ,
451213  ,
236451  ,
33357   ,
36085   ,
422587  ,
415227  ,
58939   ,
176013  ,
460941  ,
464061  ,
97669   ,
84285   ,
395011  ,
297757  ,
115315  ,
346469  ,
507731  ,
257909  ,
465541  ,
277299  ,
92269   ,
337901  ,
224467  ,
196883  ,
77571   ,
180645  ,
454901  ,
521203  ,
47845   ,
123221  ,
411677  ,
385125  ,
36923   ,
401693  ,
515901  ,
391613  ,
425685  ,
504227  ,
139585  ,
278767  ,
506381  ,
111295  ,
371613  ,
407131  ,
15715   ,
124989  ,
72645   ,
461691  ,
319573  ,
512299  ,
120155  ,
20197   ,
360269  ,
79317   ,
87957   ,
163307  ,
381571  ,
132229  ,
149685  ,
130499  ,
261749  ,
100051  ,
436667  ,
2917    ,
26293   ,
84893   ,
42803   ,
372333  ,
231967  ,
317825  ,
241869  ,
10149   ,
499037  ,
312317  ,
314101  ,
78387   ,
254227  ,
487555  ,
48445   ,
424333  ,
136659  ,
220477  ,
387149  ,
318869  ,
368941  ,
182501  ,
118915  ,
510803  ,
135317  ,
340117  ,
500499  ,
458805  ,
362049  ,
408197  ,
334645  ,
171003  ,
164495  ,
195051  ,
143027  ,
328573  ,
385397  ,
208621  ,
330211  ,
145701  ,
306637  ,
306611  ,
238655  ,
198205  ,
299333  ,
475237  ,
179637  ,
347123  ,
68051   ,
336995  ,
34785   ,
198723  ,
202251  ,
452611  ,
106181  ,
413445  ,
366429  ,
144621  ,
36379   ,
449059  ,
343157  ,
450331  ,
265875  ,
428235  ,
45773   ,
38275   ,
64717   ,
199291  ,
113595  ,
76571   ,
251621  ,
310477  ,
200693  ,
388421  ,
299059  ,
491741  ,
282603  ,
169507  ,
372421  ,
128123  ,
407389  ,
484037  ,
127371  ,
48589   ,
263131  ,
446917  ,
290525  ,
212035  ,
53085   ,
369549  ,
411611  ,
457429  ,
456147  ,
456595  ,
330365  ,
320949  ,
441491  ,
314693  ,
253219  ,
74437   ,
403091  ,
437179  ,
380403  ,
266269  ,
264787  ,
260379  ,
456453  ,
378075  ,
253229  ,
90333   ,
205205  ,
392803  ,
288283  ,
371563  ,
88829   ,
3493    ,
368045  ,
338555  ,
370691  ,
179027  ,
474109  ,
468325  ,
107917  ,
484701  ,
507925  ,
35925   ,
109843  ,
113899  ,
119267  ,
299867  ,
133547  ,
425005  ,
494109  ,
405989  ,
134595  ,
323413  ,
120077  ,
496693  ,
325659  ,
133797  ,
99427   ,
99173   ,
256261  ,
102211  ,
136499  ,
253003  ,
269507  ,
289997  ,
222627  ,
493811  ,
18259   ,
39973   ,
72405   ,
202973  ,
132643  ,
89797   ,
213747  ,
335173  ,
44611   ,
95115   ,
323189  ,
398269  ,
56691   ,
17645   ,
14043   ,
259301  ,
469195  ,
3453    ,
415443  ,
49203   ,
78957   ,
12517   ,
485707  ,
33435   ,
56891   ,
204237  ,
459899  ,
339189  ,
69997   ,
242501  ,
456955  ,
343355  ,
115203  ,
419373  ,
504251  ,
75315   ,
66483   ,
190587  ,
443235  ,
518691  ,
504397  ,
397563  ,
79397   ,
225349  ,
40941   ,
288685  ,
164749  ,
10341   ,
448605  ,
41699   ,
345365  ,
340229  ,
173099  ,
202715  ,
169469  ,
476229  ,
117907  ,
416381  ,
16859   ,
514435  ,
450035  ,
500869  ,
200813  ,
209141  ,
233493  ,
264195  ,
454251  ,
166533  ,
53347   ,
401379  ,
332499  ,
200715  ,
436781  ,
148917  ,
252765  ,
493595  ,
160661  ,
370011  ,
398509  ,
432835  ,
28877   ,
185563  ,
65051   ,
59109   ,
295491  ,
445341  ,
215675  ,
193893  ,
472067  ,
109475  ,
102181  ,
518157  ,
243965  ,
302691  ,
93605   ,
120429  ,
39173   ,
521365  ,
70995   ,
268451  ,
48931   ,
27803   ,
269587  ,
425285  ,
289827  ,
443989  ,
522915  ,
363685  ,
123669  ,
5133    ,
406109  ,
29659   ,
318669  ,
482035  ,
511381  ,
156597  ,
105763  ,
161067  ,
341181  ,
445043  ,
132011  ,
17955   ,
204989  ,
37693   ,
333283  ,
522453  ,
45005   ,
33163   ,
39349   ,
371283  ,
379949  ,
474901  ,
445557  ,
68035   ,
108301  ,
261661  ,
109509  ,
358853  ,
134723  ,
321997  ,
41475   ,
60731   ,
519963  ,
343501  ,
197141  ,
227499  ,
347507  ,
138427  ,
338171  ,
412739  ,
145925  ,
256467  ,
386779  ,
422067  ,
333603  ,
28357   ,
485325  ,
246213  ,
107749  ,
4755    ,
251187  ,
135741  ,
372293  ,
108243  ,
270275  ,
117637  ,
209091  ,
438555  ,
501933  ,
37997   ,
301259  ,
497323  ,
57285   ,
459499  ,
487693  ,
164509  ,
248699  ,
459365  ,
283571  ,
510717  ,
252501  ,
182275  ,
15003   ,
361091  ,
417813  ,
471515  ,
223909  ,
40685   ,
47589   ,
458387  ,
493477  ,
249077  ,
451667  ,
463747  ,
145077  ,
464613  ,
83835   ,
237419  ,
138195  ,
402285  ,
60347   ,
443779  ,
336869  ,
99827   ,
452571  ,
209763  ,
81701   ,
258541  ,
117381  ,
172237  ,
184843  ,
71293   ,
237083  ,
15267   ,
355443  ,
178203  ,
334685  ,
405395  ,
369883  ,
195691  ,
222307  ,
387165  ,
314987  ,
301907  ,
136347  ,
4451    ,
145395  ,
364573  ,
109869  ,
508237  ,
163821  ,
94907   ,
465309  ,
158331  ,
403827  ,
161669  ,
181875  ,
449965  ,
134299  ,
128763  ,
52509   ,
502235  ,
5419    ,
336899  ,
56133   ,
174667  ,
481731  ,
168629  ,
20619   ,
309955  ,
158795  ,
296797  ,
273907  ,
442197  ,
179051  ,
154107  ,
156829  ,
42451   ,
179811  ,
207275  ,
95581   ,
281557  ,
515723  ,
401397  ,
230419  ,
435973  ,
448051  ,
321747  ,
45915   ,
175395  ,
310149  ,
190387  ,
33213   ,
402709  ,
125405  ,
483187  ,
138645  ,
430789  ,
46861   ,
455109  ,
193499  ,
53197   ,
189405  ,
513627  ,
69995   ,
9229    ,
414485  ,
284893  ,
41205   ,
240827  ,
165805  ,
455219  ,
63781   ,
513083  ,
126323  ,
36181   ,
335389  ,
446693  ,
63317   ,
43475   ,
7485    ,
360389  ,
220227  ,
483059  ,
347491  ,
304011  ,
43675   ,
103379  ,
53643   ,
517891  ,
134011  ,
382141  ,
72365   ,
83291   ,
487189  ,
314989  ,
362443  ,
319419  ,
282829  ,
167741  ,
137213  ,
497483  ,
440147  ,
487707  ,
86501   ,
297301  ,
110771  ,
312059  ,
129651  ,
410893  ,
86531   ,
65093   ,
327491  ,
84251   ,
78467   ,
140381  ,
382021  ,
42805   ,
171971  ,
96851   ,
101581  ,
369115  ,
41179   ,
429133  ,
327365  ,
439933  ,
164973  ,
278629  ,
437997  ,
419707  ,
161829  ,
21731   ,
17283   ,
32509   ,
221797  ,
228499  ,
29501   ,
321509  ,
231565  ,
485045  ,
424573  ,
511869  ,
474437  ,
172781  ,
321235  ,
9787    ,
18483   ,
492763  ,
116987  ,
283795  ,
83323   ,
225803  ,
142237  ,
503659  ,
97043   ,
365731  ,
234339  ,
9739    ,
174981  ,
89275   ,
344933  ,
432499  ,
312619  ,
372717  ,
501923  ,
185851  ,
247899  ,
483821  ,
427635  ,
137643  ,
312245  ,
162333  ,
220899  ,
482795  ,
224547  ,
146597  ,
319349  ,
244691  ,
204355  ,
25859   ,
308797  ,
51787   ,
263819  ,
230573  ,
25917   ,
480405  ,
324331  ,
347581  ,
410053  ,
167915  ,
227331  ,
330243  ,
517883  ,
46309   ,
474893  ,
365701  ,
28781   ,
140347  ,
445013  ,
290211  ,
417139  ,
459371  ,
59299   ,
439653  ,
314683  ,
442139  ,
196387  ,
221349  ,
461477  ,
22067   ,
87389   ,
178253  ,
300075  ,
413667  ,
345555  ,
310941  ,
261235  ,
434227  ,
340027  ,
430997  ,
482605  ,
341171  ,
316037  ,
385419  ,
200035  ,
243541  ,
29451   ,
213781  ,
102515  ,
35371   ,
476901  ,
439389  ,
336861  ,
85453   ,
28477   ,
187125  ,
450829  ,
6485    ,
193539  ,
440541  ,
384539  ,
396629  ,
306965  ,
41373   ,
276003  ,
459115  ,
143565  ,
54267   ,
231133  ,
205115  ,
190875  ,
277037  ,
11301   ,
317731  ,
215355  ,
283877  ,
282525  ,
61659   ,
380563  ,
238387  ,
129083  ,
496613  ,
381677  ,
380371  ,
374373  ,
202915  ,
377965  ,
217691  ,
296205  ,
379013  ,
520957  ,
59461   ,
75603   ,
366211  ,
1061    ,
255373  ,
47701   ,
425371  ,
301357  ,
220485  ,
187315  ,
21531   ,
143069  ,
164059  ,
313285  ,
176019  ,
495301  ,
442189  ,
130253  ,
41365   ,
469115  ,
357837  ,
367845  ,
47677   ,
235885  ,
48125   ,
451365  ,
496525  ,
149179  ,
470877  ,
1949    ,
517243  ,
434803  ,
325261  ,
174869  ,
180155  ,
311083  ,
480979  ,
246515  ,
461797  ,
162779  ,
3059    ,
242221  ,
312579  ,
172165  ,
437821  ,
61701   ,
75949   ,
356389  ,
179389  ,
81979   ,
162405  ,
492621  ,
65427   ,
194437  ,
301653  ,
39731   ,
71043   ,
508219  ,
63147   ,
219427  ,
403619  ,
449765  ,
398171  ,
489221  ,
254909  ,
68147   ,
91749   ,
355859  ,
245157  ,
83163   ,
275565  ,
88469   ,
103027  ,
11171   ,
119963  ,
476045  ,
511301  ,
156221  ,
219 ,
398675  ,
294587  ,
267069  ,
56677   ,
395437  ,
343995  ,
491901  ,
402429  ,
93197   ,
88325   ,
22893   ,
224283  ,
483541  ,
149491  ,
307101  ,
304605  ,
281835  ,
69509   ,
19419   ,
51501   ,
458659  ,
174021  ,
455939  ,
335501  ,
105637  ,
13893   ,
21773   ,
505965  ,
448379  ,
435277  ,
408371  ,
122085  ,
170275  ,
389925  ,
146963  ,
296059  ,
404867  ,
66627   ,
220315  ,
400941  ,
227013  ,
458003  ,
372573  ,
320923  ,
225299  ,
46853   ,
170611  ,
278299  ,
365269  ,
355675  ,
205357  ,
136875  ,
235499  ,
144027  ,
200253  ,
125491  ,
243739  ,
193109  ,
79187   ,
230851  ,
231907  ,
407483  ,
214131  ,
7685    ,
270781  ,
202421  ,
169549  ,
22267   ,
40053   ,
58179   ,
182355  ,
335813  ,
521787  ,
225459  ,
151907  ,
264435  ,
204197  ,
235925  ,
228379  ,
98477   ,
450885  ,
449277  ,
326851  ,
23717   ,
308237  ,
460589  ,
489509  ,
309781  ,
280765  ,
436357  ,
78125   ,
292453  ,
412019  ,
427253  ,
236779  ,
36973   ,
444707  ,
445333  ,
162661  ,
338877  ,
511877  ,
50179   ,
396109  ,
142299  ,
352699  ,
326765  ,
144603  ,
420387  ,
50483   ,
138509  ,
238949  ,
117531  ,
353619  ,
117293  ,
379557  ,
354467  ,
270485  ,
250069  ,
242893  ,
155747  ,
190443  ,
289885  ,
355029  ,
139357  ,
81579   ,
504947  ,
291525  ,
73101   ,
422139  ,
484763  ,
302157  ,
493349  ,
481773  ,
290757  ,
149051  ,
455293  ,
70331   ,
359875  ,
185805  ,
380667  ,
36419   ,
331461  ,
440685  ,
460419  ,
478709  ,
458995  ,
85429   ,
434195  ,
251875  ,
368869  ,
372909  ,
173221  ,
241067  ,
71667   ,
337989  ,
446899  ,
22661   ,
297315  ,
348371  ,
101339  ,
37315   ,
505371  ,
294445  ,
475811  ,
103643  ,
355093  ,
392179  ,
428475  ,
152085  ,
286237  ,
301219  ,
208101  ,
1173    ,
405795  ,
340885  ,
97075   ,
72101   ,
263013  ,
402909  ,
245011  ,
223917  ,
165211  ,
259045  ,
261123  ,
219259  ,
55923   ,
520597  ,
24205   ,
508571  ,
457029  ,
403565  ,
119501  ,
268795  ,
58483   ,
145387  ,
358875  ,
83  ,
29891   ,
344379  ,
303949  ,
260003  ,
432187  ,
260995  ,
287475  ,
479685  ,
24877   ,
346715  ,
111317  ,
331677  ,
247595  ,
208747  ,
472131  ,
334165  ,
102731  ,
284451  ,
294627  ,
202509  ,
498571  ,
179611  ,
336435  ,
92869   ,
240899  ,
451971  ,
272877  ,
54349   ,
48891   ,
435157  ,
258979  ,
241413  ,
120557  ,
132261  ,
102845  ,
428867  ,
57739   ,
82139   ,
348717  ,
512573  ,
182099  ,
173019  ,
521109  ,
164493  ,
206171  ,
518499  ,
468549  ,
521533  ,
206053  ,
447837  ,
108365  ,
268219  ,
186501  ,
348965  ,
278557  ,
518741  ,
298525  ,
126523  ,
72909   ,
146667  ,
241373  ,
426651  ,
241773  ,
12309   ,
77987   ,
385389  ,
314355  ,
19611   ,
15741   ,
379355  ,
386347  ,
391579  ,
14355   ,
129557  ,
518333  ,
422373  ,
391853  ,
477125  ,
280235  ,
193651  ,
213499  ,
147699  ,
509859  ,
275853  ,
399499  ,
63173   ,
374995  ,
358251  ,
470819  ,
243307  ,
401779  ,
303717  ,
249011  ,
74875   ,
216333  ,
73053   ,
125787  ,
275603  ,
300181  ,
438043  ,
388163  ,
228813  ,
9915    ,
167037  ,
415621  ,
159917  ,
80741   ,
1747    ,
288483  ,
198917  ,
490221  ,
123093  ,
242795  ,
250211  ,
236541  ,
42021   ,
277811  ,
157029  ,
79491   ,
232773  ,
314715  ,
471123  ,
522685  ,
115483  ,
20317   ,
51907   ,
196155  ,
191723  ,
244813  ,
267483  ,
308691  ,
392773  ,
376107  ,
215677  ,
342259  ,
152619  ,
472667  ,
215261  ,
434043  ,
279155  ,
498499  ,
157445  ,
267059  ,
117077  ,
515805  ,
34837   ,
390237  ,
465549  ,
263707  ,
437363  ,
38299   ,
292923  ,
432019  ,
458155  ,
430555  ,
297235  ,
310813  ,
468597  ,
304565  ,
414381  ,
39005   ,
483643  ,
190445  ,
97539   ,
274763  ,
448363  ,
248845  ,
51875   ,
44421   ,
315021  ,
239587  ,
158203  ,
201883  ,
17341   ,
204627  ,
357733  ,
101611  ,
8971    ,
91285   ,
255245  ,
252067  ,
192533  ,
430925  ,
293317  ,
3533    ,
402749  ,
316997  ,
68907   ,
251619  ,
478555  ,
291555  ,
250773  ,
121819  ,
377581  ,
493923  ,
378021  ,
387981  ,
179243  ,
59171   ,
124133  ,
335531  ,
219619  ,
30963   ,
210235  ,
219669  ,
380829  ,
473499  ,
209309  ,
180515  ,
287963  ,
15507   ,
153659  ,
441549  ,
384845  ,
172293  ,
486477  ,
296443  ,
462235  ,
426659  ,
213891  ,
423531  ,
420315  ,
28371   ,
45613   ,
189891  ,
511555  ,
55419   ,
349611  ,
270829  ,
407685  ,
129477  ,
357373  ,
123507  ,
98789   ,
68131   ,
134803  ,
179803  ,
20229   ,
236531  ,
23363   ,
79147   ,
487213  ,
274747  ,
462059  ,
417357  ,
189083  ,
208803  ,
302235  ,
124819  ,
273293  ,
102907  ,
421203  ,
298869  ,
450709  ,
499075  ,
395101  ,
519515  ,
124739  ,
480909  ,
374571  ,
439131  ,
303347  ,
197403  ,
515755  ,
440339  ,
138347  ,
981 ,
509731  ,
417965  ,
154445  ,
57365   ,
420195  ,
148331  ,
282339  ,
377365  ,
300493  ,
61883   ,
170691  ,
169339  ,
183259  ,
286771  ,
21093   ,
227299  ,
207331  ,
285411  ,
410075  ,
143035  ,
333069  ,
395181  ,
122205  ,
62683   ,
488141  ,
221883  ,
304195  ,
23979   ,
465715  ,
12347   ,
393477  ,
461443  ,
312891  ,
349459  ,
391387  ,
60493   ,
472693  ,
508349  ,
417003  ,
433299  ,
394597  ,
131363  ,
433765  ,
191091  ,
180539  ,
405371  ,
489885  ,
291541  ,
360355  ,
46941   ,
502939  ,
281971  ,
235299  ,
35333   ,
126067  ,
268139  ,
254051  ,
33899   ,
352597  ,
138859  ,
359331  ,
459819  ,
108787  ,
189093  ,
151675  ,
121203  ,
258027  ,
211789  ,
142875  ,
127331  ,
287973  ,
185683  ,
311469  ,
402843  ,
176803  ,
337061  ,
404493  ,
200955  ,
398803  ,
173573  ,
257763  ,
227219  ,
75109   ,
323101  ,
10803   ,
245051  ,
449835  ,
294611  ,
440795  ,
59605   ,
443123  ,
359995  ,
412877  ,
279267  ,
21541   ,
407501  ,
16205   ,
241221  ,
111299  ,
418667  ,
287525  ,
329437  ,
73565   ,
371947  ,
303325  ,
205029  ,
281715  ,
243653  ,
210851  ,
100011  ,
236437  ,
123827  ,
500861  ,
417643  ,
246043  ,
422845  ,
305477  ,
420517  ,
488269  ,
379901  ,
186107  ,
225523  ,
373333  ,
60827   ,
16403   ,
234893  ,
25643   ,
140563  ,
381797  ,
286365  ,
102421  ,
264163  ,
245475  ,
250171  ,
496989  ,
142635  ,
126181  ,
110963  ,
16109   ,
173627  ,
165251  ,
214221  ,
430485  ,
258693  ,
144573  ,
247931  ,
352477  ,
227195  ,
80883   ,
339301  ,
349299  ,
62981   ,
219621  ,
497501  ,
129813  ,
256483  ,
472221  ,
60323   ,
314829  ,
315733  ,
296101  ,
59451   ,
440211  ,
457581  ,
324005  ,
338013  ,
137659  ,
288851  ,
369085  ,
247003  ,
49837   ,
203739  ,
311123  ,
343357  ,
287253  ,
390293  ,
129971  ,
461275  ,
434477  ,
124251  ,
154581  ,
51101   ,
228459  ,
85773   ,
120219  ,
368349  ,
46691   ,
201221  ,
513323  ,
301107  ,
17139   ,
9829    ,
266979  ,
352005  ,
523085  ,
335419  ,
2723    ,
151701  ,
35611   ,
32141   ,
452051  ,
469347  ,
186581  ,
55275   ,
104611  ,
363365  ,
239331  ,
504069  ,
190093  ,
127197  ,
320141  ,
326299  ,
264981  ,
278869  ,
244195  ,
384205  ,
264789  ,
405899  ,
38003   ,
450053  ,
514227  ,
326341  ,
249139  ,
47829   ,
90205   ,
326549  ,
333419  ,
101309  ,
449957  ,
343451  ,
350771  ,
408259  ,
315451  ,
523701  ,
307885  ,
93917   ,
308443  ,
289211  ,
297699  ,
34683   ,
163597  ,
372061  ,
122565  ,
246605  ,
498611  ,
480091  ,
437595  ,
91805   ,
433195  ,
340877  ,
382523  ,
249107  ,
98083   ,
60565   ,
340453  ,
176291  ,
285925  ,
380819  ,
417619  ,
353963  ,
118635  ,
400149  ,
227347  ,
406653  ,
463717  ,
494387  ,
491995  ,
300771  ,
276851  ,
25243   ,
77803   ,
488435  ,
294157  ,
155323  ,
206123  ,
195043  ,
386949  ,
190557  ,
290845  ,
501547  ,
332907  ,
460899  ,
411021  ,
256517  ,
39789   ,
422501  ,
350883  ,
9179    ,
507603  ,
308067  ,
267045  ,
82483   ,
364627  ,
6395    ,
401629  ,
308181  ,
241813  ,
410197  ,
514389  ,
393165  ,
50755   ,
51845   ,
278115  ,
357147  ,
358157  ,
37317   ,
115709  ,
460485  ,
119629  ,
245395  ,
35077   ,
66213   ,
345949  ,
445205  ,
339037  ,
117645  ,
248667  ,
280285  ,
444771  ,
272795  ,
2995    ,
471765  ,
220763  ,
326037  ,
14227   ,
393349  ,
175461  ,
196323  ,
230083  ,
176187  ,
154419  ,
226115  ,
437355  ,
379387  ,
101531  ,
506813  ,
256371  ,
364987  ,
326669  ,
252579  ,
260835  ,
389595  ,
147477  ,
60883   ,
174613  ,
505171  ,
182755  ,
261531  ,
489565  ,
155307  ,
60685   ,
461285  ,
475789  ,
39133   ,
461781  ,
478059  ,
288595  ,
221021  ,
432581  ,
365797  ,
214195  ,
29581   ,
174805  ,
25253   ,
349403  ,
96819   ,
414323  ,
56555   ,
76091   ,
186611  ,
430293  ,
28523   ,
55005   ,
335517  ,
237285  ,
486125  ,
225947  ,
1179    ,
15565   ,
10219   ,
60843   ,
254691  ,
257869  ,
152683  ,
510051  ,
212731  ,
10181   ,
233187  ,
303133  ,
123981  ,
372859  ,
40029   ,
446139  ,
38861   ,
260437  ,
176349  ,
50139   ,
377507  ,
281189  ,
456261  ,
416883  ,
398515  ,
502213  ,
283965  ,
311203  ,
439595  ,
153195  ,
520029  ,
422405  ,
273949  ,
17243   ,
332787  ,
11499   ,
228869  ,
62157   ,
176483  ,
288091  ,
44685   ,
512475  ,
54995   ,
6011    ,
299885  ,
279595  ,
436243  ,
410843  ,
178861  ,
447717  ,
73619   ,
63739   ,
307867  ,
417501  ,
2197    ,
214755  ,
523059  ,
120619  ,
513131  ,
111155  ,
187789  ,
228509  ,
1435    ,
317099  ,
365299  ,
466459  ,
78045   ,
502435  ,
420083  ,
88939   ,
419131  ,
242403  ,
396403  ,
132395  ,
283803  ,
340061  ,
122717  ,
492467  ,
448827  ,
39701   ,
514461  ,
362949  ,
295091  ,
347677  ,
289627  ,
195355  ,
338765  ,
196549  ,
308099  ,
394757  ,
185277  ,
422259  ,
361851  ,
215061  ,
18077   ,
288941  ,
27605   ,
118443  ,
330285  ,
467651  ,
84565   ,
131989  ,
183091  ,
396635  ,
207515  ,
184035  ,
395347  ,
201149  ,
212859  ,
430885  ,
315443  ,
450781  ,
61589   ,
132059  ,
440763  ,
142747  ,
436787  ,
435981  ,
270075  ,
356253  ,
296285  ,
22419   ,
452283  ,
50061   ,
199109  ,
101077  ,
53851   ,
244659  ,
127139  ,
221589  ,
26747   ,
230115  ,
453907  ,
478605  ,
183451  ,
515621  ,
309155  ,
465741  ,
5853    ,
140957  ,
367109  ,
34131   ,
32357   ,
384541  ,
261829  ,
513259  ,
459093  ,
326387  ,
56213   ,
520987  ,
460579  ,
180373  ,
130859  ,
107163  ,
230413  ,
237589  ,
322909  ,
269611  ,
174733  ,
181205  ,
17523   ,
369445  ,
124829  ,
470221  ,
266181  ,
136259  ,
295747  ,
481893  ,
311547  ,
142189  ,
64677   ,
345741  ,
134867  ,
256677  ,
182445  ,
315845  ,
224573  ,
276195  ,
328555  ,
452771  ,
451123  ,
345627  ,
235915  ,
381171  ,
324091  ,
3149    ,
445285  ,
242005  ,
88157   ,
147235  ,
33557   ,
389011  ,
133603  ,
376187  ,
189261  ,
89669   ,
98861   ,
389787  ,
279323  ,
409245  ,
217827  ,
307491  ,
416661  ,
37589   ,
241531  ,
378829  ,
334805  ,
139877  ,
240755  ,
433915  ,
437867  ,
171357  ,
353075  ,
331925  ,
132523  ,
156333  ,
103205  ,
501389  ,
260117  ,
182189  ,
120387  ,
265787  ,
49291   ,
173739  ,
171747  ,
451035  ,
258675  ,
223291  ,
186147  ,
379443  ,
215717  ,
278691  ,
315515  ,
314291  ,
3771    ,
462141  ,
165709  ,
269245  ,
41275   ,
320667  ,
2461    ,
78613   ,
69875   ,
487517  ,
372253  ,
333099  ,
387947  ,
468147  ,
204005  ,
125595  ,
266067  ,
360093  ,
340581  ,
318571  ,
33059   ,
326861  ,
75259   ,
463987  ,
211683  ,
166747  ,
366805  ,
312509  ,
252971  ,
298667  ,
421213  ,
477035  ,
130821  ,
201389  ,
56051   ,
49563   ,
158707  ,
385477  ,
353555  ,
145245  ,
401389  ,
165083  ,
372515  ,
131477  ,
25899   ,
422021  ,
200333  ,
24525   ,
366853  ,
402587  ,
7949    ,
377339  ,
177891  ,
189533  ,
56667   ,
211571  ,
168725
};

const Real latticeC[] =
{
1   ,
433461  ,
103659  ,
481853  ,
186513  ,
108043  ,
230553  ,
308877  ,
315969  ,
296357  ,
353965  ,
295469  ,
444083  ,
157735  ,
467587  ,
203427  ,
204263  ,
164809  ,
489653  ,
41405   ,
496131  ,
272087  ,
73491   ,
235561  ,
178769  ,
217689  ,
266071  ,
521481  ,
63271   ,
443461  ,
316261  ,
516253  ,
89115   ,
54647   ,
112249  ,
97299   ,
523441  ,
308253  ,
125789  ,
44077   ,
70947   ,
60683   ,
264777  ,
447505  ,
64759   ,
506649  ,
215695  ,
518815  ,
16797   ,
468629  ,
202995  ,
412831  ,
76121   ,
416853  ,
96081   ,
437065  ,
259709  ,
428573  ,
383439  ,
319275  ,
487901  ,
464497  ,
475393  ,
33931   ,
372939  ,
491373  ,
331895  ,
255395  ,
52697   ,
239895  ,
366669  ,
472501  ,
71227   ,
163163  ,
380373  ,
335707  ,
160831  ,
124297  ,
224891  ,
404583  ,
219553  ,
420601  ,
272947  ,
13717   ,
253503  ,
326931  ,
44105   ,
211527  ,
319891  ,
397453  ,
168727  ,
438433  ,
314087  ,
483533  ,
392737  ,
438969  ,
153185  ,
244261  ,
59037   ,
1809    ,
116459  ,
451073  ,
352463  ,
206885  ,
77509   ,
162047  ,
408541  ,
470673  ,
249707  ,
330079  ,
440047  ,
134989  ,
454647  ,
228473  ,
461803  ,
8057    ,
53241   ,
118723  ,
222419  ,
170893  ,
34227   ,
82487   ,
10745   ,
348035  ,
351657  ,
174399  ,
351845  ,
407519  ,
341039  ,
54831   ,
375049  ,
337439  ,
54985   ,
444189  ,
340879  ,
441537  ,
372823  ,
159401  ,
220815  ,
168037  ,
59563   ,
323579  ,
187423  ,
277905  ,
396619  ,
512807  ,
453567  ,
414535  ,
364741  ,
219825  ,
312825  ,
166915  ,
494881  ,
505401  ,
256691  ,
250985  ,
151739  ,
376053  ,
146931  ,
180871  ,
146119  ,
253215  ,
324235  ,
155381  ,
414363  ,
162745  ,
145489  ,
420901  ,
377229  ,
181139  ,
279805  ,
374641  ,
509097  ,
393915  ,
379287  ,
15681   ,
71601   ,
405779  ,
109451  ,
194301  ,
65311   ,
273707  ,
230433  ,
315607  ,
477163  ,
212285  ,
272579  ,
281401  ,
111767  ,
407901  ,
252591  ,
335355  ,
468063  ,
444991  ,
102179  ,
370771  ,
462313  ,
175387  ,
339517  ,
155701  ,
262321  ,
27051   ,
122837  ,
190141  ,
139191  ,
312805  ,
246401  ,
133851  ,
228763  ,
182081  ,
144779  ,
151931  ,
283849  ,
445871  ,
349453  ,
353469  ,
399293  ,
427983  ,
358475  ,
107377  ,
210837  ,
153295  ,
500997  ,
459611  ,
395829  ,
450219  ,
229503  ,
49653   ,
112431  ,
50669   ,
477569  ,
513247  ,
455319  ,
365793  ,
206985  ,
446099  ,
113971  ,
474865  ,
232703  ,
38191   ,
340465  ,
128111  ,
40335   ,
179703  ,
413263  ,
244639  ,
234363  ,
436155  ,
171099  ,
290567  ,
239449  ,
68165   ,
388391  ,
490591  ,
175015  ,
161843  ,
375419  ,
14957   ,
318737  ,
287331  ,
84735   ,
319677  ,
40241   ,
14989   ,
254183  ,
221603  ,
153997  ,
354639  ,
291603  ,
130359  ,
412893  ,
207669  ,
9133    ,
11813   ,
275185  ,
172357  ,
233811  ,
28561   ,
195741  ,
55133   ,
43931   ,
97099   ,
448457  ,
134383  ,
237723  ,
294007  ,
288889  ,
199535  ,
238137  ,
63135   ,
28631   ,
187445  ,
448111  ,
429183  ,
117251  ,
172117  ,
46399   ,
281259  ,
85165   ,
217897  ,
103073  ,
259903  ,
203051  ,
136219  ,
49713   ,
9757    ,
24565   ,
275317  ,
131509  ,
509157  ,
72073   ,
306219  ,
247433  ,
521903  ,
191667  ,
238223  ,
85243   ,
263995  ,
296251  ,
41989   ,
1231    ,
148051  ,
442007  ,
393567  ,
65245   ,
191363  ,
499957  ,
379769  ,
16853   ,
131887  ,
63463   ,
52903   ,
30833   ,
493385  ,
317771  ,
104333  ,
249987  ,
385767  ,
118489  ,
72339   ,
23057   ,
450457  ,
41233   ,
370821  ,
421463  ,
267189  ,
97167   ,
22525   ,
92383   ,
428995  ,
284873  ,
71733   ,
174551  ,
444231  ,
19405   ,
462209  ,
218243  ,
244345  ,
144467  ,
225945  ,
283369  ,
286181  ,
183491  ,
168507  ,
204691  ,
378633  ,
106253  ,
83149   ,
498907  ,
396313  ,
243075  ,
222247  ,
216093  ,
330581  ,
372679  ,
212575  ,
508339  ,
6919    ,
521883  ,
523795  ,
327989  ,
223759  ,
138929  ,
280549  ,
138869  ,
33491   ,
121161  ,
448053  ,
351297  ,
410209  ,
194001  ,
149887  ,
383533  ,
396101  ,
358107  ,
406337  ,
77477   ,
437035  ,
187333  ,
372105  ,
40517   ,
40417   ,
277003  ,
376981  ,
311557  ,
233427  ,
299237  ,
202241  ,
395259  ,
361795  ,
10819   ,
84513   ,
343795  ,
340221  ,
186693  ,
187315  ,
499695  ,
346533  ,
20679   ,
358759  ,
522997  ,
437615  ,
252791  ,
467957  ,
363433  ,
267123  ,
113203  ,
39607   ,
105639  ,
117533  ,
296913  ,
217181  ,
331999  ,
84795   ,
319315  ,
190569  ,
42051   ,
193615  ,
411957  ,
284211  ,
392759  ,
146351  ,
435039  ,
496371  ,
130307  ,
259165  ,
110827  ,
95245   ,
139131  ,
75711   ,
145503  ,
475863  ,
232007  ,
127529  ,
171115  ,
320035  ,
151837  ,
120557  ,
218103  ,
380301  ,
135105  ,
274445  ,
87877   ,
118645  ,
340269  ,
472999  ,
502109  ,
423807  ,
62223   ,
288099  ,
476567  ,
130007  ,
298957  ,
365445  ,
169089  ,
384761  ,
503495  ,
470441  ,
228947  ,
470355  ,
32739   ,
180347  ,
233579  ,
245253  ,
460835  ,
343947  ,
100633  ,
517051  ,
94589   ,
25593   ,
248275  ,
465643  ,
396459  ,
493159  ,
408625  ,
318315  ,
510901  ,
173703  ,
293479  ,
75761   ,
271723  ,
125457  ,
500637  ,
23015   ,
433129  ,
338697  ,
257829  ,
58945   ,
449535  ,
344797  ,
266029  ,
87025   ,
339979  ,
453687  ,
398143  ,
262725  ,
307367  ,
191075  ,
253135  ,
346857  ,
237751  ,
312209  ,
444307  ,
249391  ,
500009  ,
248227  ,
280585  ,
258023  ,
242997  ,
108383  ,
375331  ,
159685  ,
70151   ,
387801  ,
127929  ,
344495  ,
22541   ,
247035  ,
264571  ,
142901  ,
447093  ,
373163  ,
5361    ,
457435  ,
7965    ,
361391  ,
18137   ,
259021  ,
513439  ,
231571  ,
41207   ,
249151  ,
73365   ,
23097   ,
519687  ,
152685  ,
403345  ,
216735  ,
225249  ,
432825  ,
106855  ,
185011  ,
517419  ,
446635  ,
321457  ,
461325  ,
330773  ,
163533  ,
69833   ,
52989   ,
494435  ,
487145  ,
461843  ,
235923  ,
508041  ,
431767  ,
315087  ,
258449  ,
149291  ,
166053  ,
24817   ,
290233  ,
211379  ,
479715  ,
369247  ,
203147  ,
223587  ,
275107  ,
115477  ,
433721  ,
6021    ,
54787   ,
83655   ,
491877  ,
131479  ,
396507  ,
66059   ,
289503  ,
396235  ,
201661  ,
262517  ,
67501   ,
1889    ,
48859   ,
423507  ,
144071  ,
37731   ,
243491  ,
195699  ,
337859  ,
145315  ,
17185   ,
381691  ,
365721  ,
274385  ,
304049  ,
469591  ,
279115  ,
67973   ,
484335  ,
464083  ,
320311  ,
509893  ,
205403  ,
246361  ,
88475   ,
190683  ,
329551  ,
108053  ,
325883  ,
329099  ,
415045  ,
57149   ,
173129  ,
177529  ,
17917   ,
524207  ,
117473  ,
358895  ,
430145  ,
477931  ,
446885  ,
136369  ,
107557  ,
305253  ,
77647   ,
410449  ,
166209  ,
504335  ,
423273  ,
312887  ,
203801  ,
322601  ,
481415  ,
404883  ,
116321  ,
293471  ,
107133  ,
111777  ,
145679  ,
469223  ,
462609  ,
175517  ,
470203  ,
324749  ,
237681  ,
373275  ,
11105   ,
35107   ,
1795    ,
3219    ,
253971  ,
282315  ,
439953  ,
364129  ,
327625  ,
168409  ,
92941   ,
192959  ,
124005  ,
183025  ,
329625  ,
18921   ,
125215  ,
135373  ,
419493  ,
106747  ,
173797  ,
444359  ,
11383   ,
412657  ,
382319  ,
209309  ,
145205  ,
399913  ,
498915  ,
301783  ,
84717   ,
131167  ,
247707  ,
314807  ,
179351  ,
111479  ,
373487  ,
135195  ,
379729  ,
105495  ,
50665   ,
519453  ,
524195  ,
121135  ,
160009  ,
3593    ,
523091  ,
467947  ,
220305  ,
440171  ,
363299  ,
129 ,
328563  ,
152625  ,
336357  ,
497143  ,
349533  ,
238559  ,
273797  ,
440195  ,
125227  ,
486735  ,
234061  ,
67047   ,
385037  ,
104511  ,
450883  ,
361433  ,
61583   ,
519729  ,
304125  ,
116961  ,
432671  ,
376853  ,
152541  ,
22735   ,
240321  ,
113741  ,
255577  ,
338401  ,
342115  ,
97809   ,
313361  ,
403825  ,
18393   ,
349485  ,
274713  ,
214369  ,
451135  ,
67927   ,
486355  ,
406157  ,
304505  ,
149331  ,
434055  ,
168979  ,
492381  ,
410553  ,
267847  ,
478213  ,
25609   ,
226105  ,
336333  ,
495887  ,
13211   ,
512075  ,
231271  ,
227669  ,
432165  ,
487401  ,
430671  ,
381369  ,
114073  ,
90397   ,
370949  ,
71173   ,
298389  ,
348637  ,
213723  ,
472611  ,
481797  ,
248255  ,
160065  ,
349241  ,
24359   ,
320837  ,
346113  ,
241335  ,
340739  ,
240703  ,
154691  ,
334205  ,
433617  ,
12893   ,
346439  ,
83583   ,
171349  ,
413877  ,
462819  ,
260741  ,
324253  ,
159647  ,
402601  ,
452243  ,
437295  ,
263601  ,
446393  ,
302093  ,
27535   ,
259267  ,
323661  ,
47659   ,
132021  ,
489293  ,
69321   ,
75097   ,
461643  ,
43309   ,
75753   ,
242791  ,
507129  ,
492239  ,
330035  ,
122917  ,
212995  ,
99927   ,
519303  ,
63191   ,
255743  ,
353497  ,
6477    ,
71835   ,
219585  ,
96523   ,
394825  ,
328055  ,
259539  ,
516587  ,
285249  ,
119379  ,
134113  ,
70113   ,
444665  ,
343283  ,
425077  ,
139645  ,
203445  ,
427193  ,
42221   ,
450905  ,
70775   ,
449137  ,
59709   ,
268785  ,
453923  ,
513597  ,
363703  ,
355787  ,
366033  ,
125047  ,
383821  ,
446993  ,
326395  ,
521999  ,
27057   ,
105317  ,
148343  ,
202201  ,
139717  ,
464885  ,
148379  ,
320363  ,
475903  ,
450073  ,
374371  ,
225587  ,
460135  ,
476171  ,
200689  ,
60905   ,
99725   ,
140411  ,
277635  ,
217473  ,
98189   ,
224431  ,
266749  ,
511455  ,
143043  ,
395991  ,
279695  ,
138825  ,
258847  ,
247309  ,
297383  ,
484591  ,
96287   ,
309043  ,
405325  ,
207613  ,
147101  ,
269543  ,
58561   ,
394505  ,
520765  ,
268603  ,
204075  ,
46905   ,
229529  ,
137153  ,
268317  ,
142053  ,
29427   ,
54275   ,
354807  ,
142989  ,
160491  ,
303369  ,
213919  ,
295245  ,
401795  ,
274567  ,
92911   ,
312453  ,
40705   ,
365879  ,
504053  ,
299541  ,
119681  ,
76653   ,
135839  ,
129709  ,
53213   ,
364681  ,
400727  ,
284629  ,
7569    ,
369361  ,
190943  ,
492069  ,
468139  ,
403011  ,
454557  ,
351555  ,
70213   ,
6433    ,
349531  ,
175869  ,
247315  ,
389311  ,
305065  ,
115799  ,
336047  ,
174485  ,
159627  ,
215137  ,
503147  ,
143299  ,
383103  ,
396929  ,
406955  ,
203961  ,
332885  ,
27291   ,
515565  ,
484967  ,
456267  ,
308345  ,
452561  ,
511967  ,
169193  ,
248919  ,
98473   ,
32605   ,
328949  ,
336717  ,
523461  ,
232229  ,
473317  ,
417129  ,
189111  ,
74751   ,
225779  ,
268193  ,
228865  ,
492485  ,
171729  ,
522593  ,
40801   ,
292779  ,
253313  ,
197017  ,
222801  ,
360537  ,
265891  ,
108487  ,
111923  ,
489465  ,
502043  ,
441179  ,
456861  ,
396033  ,
416539  ,
509391  ,
239015  ,
491429  ,
425751  ,
5579    ,
53585   ,
454367  ,
375625  ,
389403  ,
59181   ,
498633  ,
496955  ,
509213  ,
20873   ,
154661  ,
106385  ,
327445  ,
49599   ,
316335  ,
305789  ,
319473  ,
514439  ,
36683   ,
298185  ,
517237  ,
108809  ,
227645  ,
520555  ,
163775  ,
230273  ,
427511  ,
80301   ,
158917  ,
435331  ,
317393  ,
108571  ,
28877   ,
149243  ,
415281  ,
37111   ,
66611   ,
196827  ,
432883  ,
90051   ,
404243  ,
236889  ,
275495  ,
9035    ,
446311  ,
507877  ,
195031  ,
356509  ,
305767  ,
396753  ,
113717  ,
471483  ,
443159  ,
173117  ,
73145   ,
315647  ,
7077    ,
199343  ,
83179   ,
248709  ,
435447  ,
329505  ,
378143  ,
517363  ,
489217  ,
429643  ,
128097  ,
312867  ,
292621  ,
399143  ,
135765  ,
217575  ,
206199  ,
522363  ,
482127  ,
256397  ,
338849  ,
466367  ,
32283   ,
469005  ,
431635  ,
506087  ,
304611  ,
101269  ,
4915    ,
522973  ,
202989  ,
215551  ,
147091  ,
45915   ,
248181  ,
466633  ,
102271  ,
284313  ,
192189  ,
77527   ,
306553  ,
419905  ,
323495  ,
163545  ,
24307   ,
341469  ,
66815   ,
74075   ,
98731   ,
389901  ,
259237  ,
219641  ,
303659  ,
410343  ,
256113  ,
132541  ,
267955  ,
475475  ,
407587  ,
318869  ,
437207  ,
112657  ,
182329  ,
502755  ,
518219  ,
6359    ,
241309  ,
56251   ,
180875  ,
302767  ,
364707  ,
309001  ,
472033  ,
42893   ,
142503  ,
358455  ,
427169  ,
221143  ,
429825  ,
347459  ,
452911  ,
151135  ,
516537  ,
336039  ,
53643   ,
287021  ,
190325  ,
33663   ,
214669  ,
307625  ,
19749   ,
398191  ,
281007  ,
161525  ,
346477  ,
377251  ,
434803  ,
55763   ,
170243  ,
515629  ,
274237  ,
105711  ,
373643  ,
139185  ,
247891  ,
322411  ,
100637  ,
49827   ,
28465   ,
473231  ,
38463   ,
178987  ,
323505  ,
331861  ,
453233  ,
181575  ,
464793  ,
61001   ,
433121  ,
476695  ,
426805  ,
82223   ,
89081   ,
302943  ,
33267   ,
186845  ,
395777  ,
288209  ,
78907   ,
281177  ,
356771  ,
488297  ,
406223  ,
86543   ,
251719  ,
85523   ,
234701  ,
75303   ,
208371  ,
108835  ,
38277   ,
481121  ,
102347  ,
403259  ,
105575  ,
43235   ,
223925  ,
101905  ,
117385  ,
224823  ,
275115  ,
362735  ,
220755  ,
78987   ,
312759  ,
373105  ,
400127  ,
284177  ,
24837   ,
106081  ,
189001  ,
70029   ,
513127  ,
82965   ,
168309  ,
188557  ,
248583  ,
12973   ,
310167  ,
294071  ,
160439  ,
345897  ,
331667  ,
475463  ,
513673  ,
516513  ,
194697  ,
159701  ,
100349  ,
519031  ,
235989  ,
380415  ,
23145   ,
96237   ,
167705  ,
101767  ,
163965  ,
81331   ,
108005  ,
392387  ,
152931  ,
348233  ,
198359  ,
92537   ,
256237  ,
166425  ,
293587  ,
137877  ,
389531  ,
152467  ,
41605   ,
424171  ,
503805  ,
190321  ,
304035  ,
388161  ,
294021  ,
338877  ,
239577  ,
11647   ,
436627  ,
26837   ,
406945  ,
497119  ,
220961  ,
280889  ,
356083  ,
308977  ,
24909   ,
278787  ,
361783  ,
442487  ,
17453   ,
289811  ,
262955  ,
488677  ,
388097  ,
204737  ,
184315  ,
108085  ,
357245  ,
39853   ,
212559  ,
377787  ,
167633  ,
260043  ,
300921  ,
123109  ,
484045  ,
518345  ,
145541  ,
404069  ,
36469   ,
144315  ,
419413  ,
379415  ,
70475   ,
293869  ,
299409  ,
402857  ,
380521  ,
434809  ,
2417    ,
441879  ,
430341  ,
103895  ,
137389  ,
176279  ,
135249  ,
174095  ,
418405  ,
387633  ,
248823  ,
87547   ,
439333  ,
338689  ,
296757  ,
57879   ,
500239  ,
411995  ,
2943    ,
248447  ,
381495  ,
387829  ,
304149  ,
458701  ,
493059  ,
459153  ,
211809  ,
494667  ,
133779  ,
349283  ,
193477  ,
95729   ,
401301  ,
508309  ,
186959  ,
523595  ,
96455   ,
371277  ,
138561  ,
107799  ,
89061   ,
190881  ,
61515   ,
449131  ,
369953  ,
270165  ,
522813  ,
64171   ,
272461  ,
315881  ,
265031  ,
69639   ,
345651  ,
478965  ,
60229   ,
190285  ,
504059  ,
451965  ,
292883  ,
110839  ,
367407  ,
520753  ,
377081  ,
496019  ,
479885  ,
226649  ,
71849   ,
103079  ,
375823  ,
383609  ,
504049  ,
170933  ,
49577   ,
512399  ,
211361  ,
199381  ,
461125  ,
282503  ,
377641  ,
154745  ,
176089  ,
366877  ,
268855  ,
456605  ,
199391  ,
273081  ,
107793  ,
373171  ,
270877  ,
109111  ,
199975  ,
453969  ,
188273  ,
522549  ,
175469  ,
400337  ,
119919  ,
140011  ,
257131  ,
76229   ,
504741  ,
40059   ,
493907  ,
177677  ,
241555  ,
467441  ,
335357  ,
375173  ,
437253  ,
76331   ,
284679  ,
432079  ,
406387  ,
364477  ,
147425  ,
260561  ,
246635  ,
256189  ,
127523  ,
460455  ,
366709  ,
473133  ,
138127  ,
497811  ,
152387  ,
88065   ,
367663  ,
410933  ,
217739  ,
389887  ,
332351  ,
388659  ,
201207  ,
21335   ,
287191  ,
511257  ,
105231  ,
105387  ,
64561   ,
518379  ,
328599  ,
210885  ,
73669   ,
80779   ,
350299  ,
71411   ,
37715   ,
519311  ,
503661  ,
188361  ,
134911  ,
377017  ,
114055  ,
436127  ,
408775  ,
224965  ,
381155  ,
182983  ,
470415  ,
244187  ,
433107  ,
91509   ,
398657  ,
309379  ,
273189  ,
60345   ,
453465  ,
474957  ,
84247   ,
438465  ,
478421  ,
92491   ,
199473  ,
202071  ,
340655  ,
188229  ,
374993  ,
167299  ,
275691  ,
255521  ,
314367  ,
430059  ,
90577   ,
381209  ,
163027  ,
334891  ,
284461  ,
145549  ,
240553  ,
198235  ,
16955   ,
358571  ,
173373  ,
84429   ,
128555  ,
242441  ,
416973  ,
225095  ,
237089  ,
106889  ,
284835  ,
431213  ,
92009   ,
385423  ,
473047  ,
179715  ,
235485  ,
181635  ,
364139  ,
353051  ,
497413  ,
222127  ,
192991  ,
168967  ,
349677  ,
452273  ,
400449  ,
495149  ,
140563  ,
9519    ,
396285  ,
287009  ,
85025   ,
182671  ,
57057   ,
489239  ,
355043  ,
20369   ,
433623  ,
350047  ,
439749  ,
195173  ,
206819  ,
263891  ,
222021  ,
413227  ,
210731  ,
468665  ,
344195  ,
469517  ,
281519  ,
156027  ,
108831  ,
239083  ,
513833  ,
60363   ,
284913  ,
447919  ,
174925  ,
349415  ,
278243  ,
374283  ,
302321  ,
345993  ,
44867   ,
46773   ,
477667  ,
293777  ,
417021  ,
204095  ,
31317   ,
305185  ,
380315  ,
254619  ,
480299  ,
132707  ,
517733  ,
18359   ,
499503  ,
379971  ,
259671  ,
403479  ,
9965    ,
516887  ,
387269  ,
303487  ,
198273  ,
500307  ,
303795  ,
105189  ,
113885  ,
273383  ,
329573  ,
476359  ,
46091   ,
418189  ,
208915  ,
453559  ,
336613  ,
258881  ,
318835  ,
40721   ,
249691  ,
443363  ,
315475  ,
1567    ,
123211  ,
109323  ,
332039  ,
258149  ,
266943  ,
307067  ,
471867  ,
434945  ,
267455  ,
374397  ,
212675  ,
186199  ,
441095  ,
112153  ,
375075  ,
280289  ,
169133  ,
151581  ,
120543  ,
399815  ,
82995   ,
429563  ,
221251  ,
516105  ,
47735   ,
317719  ,
177571  ,
161825  ,
312945  ,
361415  ,
160977  ,
411883  ,
234199  ,
472387  ,
193033  ,
390687  ,
383975  ,
100103  ,
412479  ,
268929  ,
454435  ,
130481  ,
402541  ,
236495  ,
49973   ,
493475  ,
112459  ,
355385  ,
443531  ,
462721  ,
155929  ,
196503  ,
476261  ,
321681  ,
7483    ,
504071  ,
72877   ,
332067  ,
237575  ,
255013  ,
158107  ,
354333  ,
130971  ,
428609  ,
197507  ,
290041  ,
201169  ,
407481  ,
246959  ,
149805  ,
394821  ,
440845  ,
521189  ,
246849  ,
409837  ,
367453  ,
42203   ,
388947  ,
123179  ,
329105  ,
439261  ,
104653  ,
89175   ,
275359  ,
399861  ,
511469  ,
332049  ,
515117  ,
145767  ,
186755  ,
424161  ,
111693  ,
316385  ,
424745  ,
214533  ,
40247   ,
234629  ,
211925  ,
264261  ,
393055  ,
479945  ,
242485  ,
179469  ,
203585  ,
310953  ,
17265   ,
238719  ,
428653  ,
27379   ,
328273  ,
89507   ,
305995  ,
456185  ,
327891  ,
299365  ,
201623  ,
313795  ,
102979  ,
276565  ,
102329  ,
76091   ,
235863  ,
493145  ,
373649  ,
24889   ,
480495  ,
24923   ,
356955  ,
146721  ,
180633  ,
50613   ,
284861  ,
470705  ,
179733  ,
207837  ,
228691  ,
466255  ,
281051  ,
481791  ,
46339   ,
324559  ,
499987  ,
475543  ,
324431  ,
182707  ,
123643  ,
458727  ,
213133  ,
377949  ,
420993  ,
133259  ,
81167   ,
385717  ,
494899  ,
160235  ,
453081  ,
444163  ,
431005  ,
450565  ,
127089  ,
34867   ,
360205  ,
455305  ,
22397   ,
13659   ,
228005  ,
404687  ,
345381  ,
193121  ,
310813  ,
462403  ,
76737   ,
45527   ,
233019  ,
509635  ,
474185  ,
130873  ,
478757  ,
444059  ,
503431  ,
82659   ,
373683  ,
191625  ,
198237  ,
24223   ,
211611  ,
294111  ,
77369   ,
172235  ,
410747  ,
432791  ,
468773  ,
229433  ,
348285  ,
410845  ,
332591  ,
347699  ,
204839  ,
385307  ,
465441  ,
38623   ,
494403  ,
225947  ,
368335  ,
65605   ,
513377  ,
144289  ,
242567  ,
35467   ,
478717  ,
356685  ,
299947  ,
159667  ,
471273  ,
263755  ,
410093  ,
327101  ,
249765  ,
209813  ,
124989  ,
96139   ,
234021  ,
395691  ,
267419  ,
491997  ,
440699  ,
273579  ,
285401  ,
524149  ,
33637   ,
515189  ,
404887  ,
457965  ,
350601  ,
223207  ,
31031   ,
15031   ,
391293  ,
37293   ,
63499   ,
137415  ,
205559  ,
202257  ,
192235  ,
512293  ,
77503   ,
35589   ,
96575   ,
418005  ,
6783    ,
376579  ,
319459  ,
179389  ,
308757  ,
216531  ,
191917  ,
504707  ,
202099  ,
348723  ,
237019  ,
43693   ,
51581   ,
26061   ,
63705   ,
186457  ,
464279  ,
28011   ,
141019  ,
446783  ,
205019  ,
309599  ,
123765  ,
149163  ,
523069  ,
197597  ,
334197  ,
136727  ,
65165   ,
346597  ,
92115   ,
287049  ,
202819  ,
302991  ,
3233    ,
508535  ,
248849  ,
27373   ,
268267  ,
248247  ,
267657  ,
65523   ,
82773   ,
371311  ,
161029  ,
50165   ,
494101  ,
50483   ,
522321  ,
368605  ,
186543  ,
233813  ,
388083  ,
55953   ,
249905  ,
413747  ,
105931  ,
523185  ,
122043  ,
98027   ,
491553  ,
64445   ,
485899  ,
106119  ,
91769   ,
60289   ,
507385  ,
251779  ,
523921  ,
84213   ,
442731  ,
123713  ,
147637  ,
404359  ,
194665  ,
317953  ,
494179  ,
34135   ,
308885  ,
345507  ,
84055   ,
422337  ,
249833  ,
455179  ,
356003  ,
512123  ,
148217  ,
404315  ,
358549  ,
77979   ,
345839  ,
350981  ,
244673  ,
73131   ,
248811  ,
52861   ,
399925  ,
219017  ,
71287   ,
416601  ,
281829  ,
279243  ,
309553  ,
364439  ,
156277  ,
150585  ,
507243  ,
111999  ,
394559  ,
434105  ,
235979  ,
101777  ,
261371  ,
55003   ,
206603  ,
31125   ,
139177  ,
466437  ,
214429  ,
198393  ,
464223  ,
176287  ,
370493  ,
188107  ,
497091  ,
208751  ,
490769  ,
31727   ,
160095  ,
128405  ,
127517  ,
323239  ,
333483  ,
156943  ,
206181  ,
305157  ,
169265  ,
165141  ,
518271  ,
431091  ,
44887   ,
90983   ,
137043  ,
387685  ,
294957  ,
226093  ,
7733    ,
33503   ,
271363  ,
145769  ,
100731  ,
287693  ,
91361   ,
396775  ,
369917  ,
481003  ,
107963  ,
197427  ,
498675  ,
481855  ,
186691  ,
498635  ,
14107   ,
456731  ,
265909  ,
144125  ,
61765   ,
458391  ,
149103  ,
157023  ,
105837  ,
41869   ,
409027  ,
388533  ,
259581  ,
277593  ,
398539  ,
419003  ,
351781  ,
140345  ,
420409  ,
133143  ,
482333  ,
131855  ,
138391  ,
272693  ,
169385  ,
367307  ,
274241  ,
269923  ,
337481  ,
517193  ,
64419   ,
140231  ,
350663  ,
74823   ,
285441  ,
34453   ,
24317   ,
116359  ,
365541  ,
518681  ,
132959  ,
291549  ,
205635  ,
194705  ,
468715  ,
14881   ,
102651  ,
225305  ,
458141  ,
58259   ,
186903  ,
507745  ,
196055  ,
437903  ,
242565  ,
379693  ,
400869  ,
362929  ,
223075  ,
195119  ,
330857  ,
354095  ,
42737   ,
475383  ,
382259  ,
452573  ,
294441  ,
207889  ,
36339   ,
437865  ,
220783  ,
38201   ,
151033  ,
333735  ,
48981   ,
505133  ,
435305  ,
290047  ,
465411  ,
292705  ,
128493  ,
191031  ,
324911  ,
43257   ,
208483  ,
296793  ,
469173  ,
198603  ,
472533  ,
67363   ,
42065   ,
510431  ,
139475  ,
6163    ,
317795  ,
401245  ,
378379  ,
69177   ,
440767  ,
295813  ,
329639  ,
477679  ,
20895   ,
428151  ,
480577  ,
387655  ,
62449   ,
99237   ,
277507  ,
426801  ,
381233  ,
305317  ,
172149  ,
92257   ,
94301   ,
83799   ,
406991  ,
37607   ,
37095   ,
333099  ,
223657  ,
488255  ,
390233  ,
280561  ,
406115  ,
275481  ,
57913   ,
140841  ,
475233  ,
462489  ,
351037  ,
15181   ,
449875  ,
241389  ,
460151  ,
423385  ,
471319  ,
161715  ,
420827  ,
461593  ,
167933  ,
152371  ,
193171  ,
272871  ,
355899  ,
280535  ,
58841   ,
91117   ,
168765  ,
333007  ,
124015  ,
24833   ,
487609  ,
46233   ,
82347   ,
367911  ,
450539  ,
232567  ,
316587  ,
112637  ,
240557  ,
49415   ,
434145  ,
244675  ,
321179  ,
216029  ,
238391  ,
6215    ,
380205  ,
234275  ,
502055  ,
383141  ,
287613  ,
438777  ,
520033  ,
165031  ,
461 ,
409841  ,
26253   ,
291061  ,
134797  ,
311951  ,
67657   ,
59677   ,
377831  ,
186315  ,
474531  ,
28987   ,
56845   ,
158577  ,
85139   ,
36233   ,
87713   ,
16707   ,
26619   ,
65913   ,
320847  ,
118355  ,
324363  ,
521965  ,
275499  ,
406623  ,
294513  ,
32381   ,
179187  ,
41069   ,
82579   ,
418651  ,
476331  ,
21497   ,
116477  ,
40763   ,
5267    ,
433555  ,
43137   ,
413383  ,
154521  ,
90975   ,
512103  ,
339947  ,
460247  ,
361003  ,
96067   ,
193933  ,
23975   ,
514671  ,
124539  ,
473895  ,
431299  ,
515183  ,
281709  ,
14443   ,
421087  ,
406995  ,
66387   ,
468855  ,
466077  ,
466357  ,
430529  ,
56939   ,
222471  ,
317189  ,
273961  ,
445787  ,
87147   ,
313157  ,
2157    ,
216003  ,
408239  ,
198955  ,
225679  ,
7697    ,
377769  ,
197053  ,
374589  ,
245965  ,
199437  ,
436151  ,
309707  ,
75653   ,
74495   ,
9559    ,
189481  ,
523253  ,
507981  ,
475539  ,
5725    ,
393869  ,
44375   ,
438871  ,
388147  ,
370661  ,
350547  ,
378489  ,
272115  ,
129595  ,
89977   ,
243041  ,
113197  ,
76859   ,
403151  ,
249483  ,
344079  ,
225763  ,
75033   ,
414717  ,
345973  ,
254125  ,
384639  ,
87699   ,
314057  ,
127795  ,
160021  ,
435963  ,
158769  ,
513179  ,
188511  ,
139433  ,
11569   ,
414731  ,
210907  ,
522929  ,
254625  ,
308971  ,
377795  ,
350133  ,
386191  ,
201173  ,
121071  ,
3257    ,
215579  ,
258737  ,
303915  ,
142837  ,
436691  ,
140791  ,
406783  ,
273131  ,
5141    ,
377143  ,
511163  ,
353387  ,
413783  ,
328249  ,
431501  ,
160893  ,
277207  ,
508919  ,
140069  ,
516471  ,
177331  ,
348745  ,
364697  ,
22637   ,
119295  ,
29991   ,
331359  ,
244253  ,
225417  ,
451041  ,
4053    ,
326129  ,
723 ,
49483   ,
426051  ,
364411  ,
183119  ,
53675   ,
342963  ,
213139  ,
63745   ,
128471  ,
211273  ,
223131  ,
212809  ,
86549   ,
267941  ,
399789  ,
46889   ,
518729  ,
470331  ,
511975  ,
257139  ,
216361  ,
383169  ,
214099  ,
70523   ,
226659  ,
272263  ,
323785  ,
474447  ,
290855  ,
308887  ,
110451  ,
69423   ,
215861  ,
515515  ,
388497  ,
73135   ,
48281   ,
183607  ,
88149   ,
78851   ,
512225  ,
304971  ,
511621  ,
474149  ,
164407  ,
13537   ,
412733  ,
430593  ,
55641   ,
362163  ,
22303   ,
280677  ,
399253  ,
425419  ,
189991  ,
148579  ,
5081    ,
126737  ,
286495  ,
266715  ,
366959  ,
243259  ,
510985  ,
376779  ,
106477  ,
22715   ,
224915  ,
311933  ,
340613  ,
377319  ,
111427  ,
193307  ,
322501  ,
442373  ,
67747   ,
360985  ,
164457  ,
63483   ,
116317  ,
308675  ,
171887  ,
62131   ,
159803  ,
23363   ,
2683    ,
139535  ,
22571   ,
292837  ,
105045  ,
117041  ,
170851  ,
2603    ,
434685  ,
56851   ,
58147   ,
50419   ,
148993  ,
74459   ,
90047   ,
352247  ,
224893  ,
486707  ,
105461  ,
42485   ,
7445    ,
215715  ,
211265  ,
225131  ,
75227   ,
67991   ,
316181  ,
12411   ,
398107  ,
459093  ,
107869  ,
492245  ,
40063   ,
203203  ,
258625  ,
282281  ,
281649  ,
227011  ,
240965  ,
132371  ,
427023  ,
155331  ,
219203  ,
11553   ,
152497  ,
519697  ,
507751  ,
185459  ,
199153  ,
288819  ,
106203  ,
366855  ,
28317   ,
21265   ,
256455  ,
284585  ,
4659    ,
116209  ,
111623  ,
380047  ,
60635   ,
517927  ,
214789  ,
23787   ,
356549  ,
441125  ,
492477  ,
370745  ,
92525   ,
290517  ,
85337   ,
411105  ,
26241   ,
11467   ,
285197  ,
349113  ,
12355   ,
374905  ,
343875  ,
256229  ,
360599  ,
137447  ,
378095  ,
418919  ,
412257  ,
316859  ,
59635   ,
19269   ,
509207  ,
6753    ,
137341  ,
88275   ,
264781  ,
293097  ,
259483  ,
207057  ,
392589  ,
121273  ,
289495  ,
241043  ,
196239  ,
59119   ,
351011  ,
226073  ,
477747  ,
16429   ,
362953  ,
516829  ,
42629   ,
351921  ,
35607   ,
117521  ,
173075  ,
118387  ,
414199  ,
155827  ,
149221  ,
98363   ,
210547  ,
233149  ,
302009  ,
315625  ,
47201   ,
183879  ,
203245  ,
113573  ,
133011  ,
238183  ,
456815  ,
470605  ,
173549  ,
426659  ,
435005  ,
412499  ,
406303  ,
369817  ,
411355  ,
392083  ,
355287  ,
226081  ,
493709  ,
123899  ,
51623   ,
254481  ,
181017  ,
445123  ,
498271  ,
282677  ,
423447  ,
476681  ,
206849  ,
460811  ,
53521   ,
72357   ,
267649  ,
520761  ,
171581  ,
112703  ,
118621  ,
110139  ,
456779  ,
357323  ,
89927   ,
46221   ,
465309  ,
222443  ,
400595  ,
66523   ,
240387  ,
450559  ,
87887   ,
20979   ,
103419  ,
447401  ,
47491   ,
453147  ,
360701  ,
221939  ,
206083  ,
446771  ,
459987  ,
109747  ,
198283  ,
427127  ,
470887  ,
189379  ,
107207  ,
296005  ,
272411  ,
464293  ,
347147  ,
354413  ,
265437  ,
266771  ,
382653  ,
127629  ,
213221  ,
300899  ,
376411  ,
240659  ,
57463   ,
357449  ,
291387  ,
481571  ,
448543  ,
208867  ,
516803  ,
511897  ,
65883   ,
82719   ,
276365  ,
105005  ,
243425  ,
333253  ,
304177  ,
199317  ,
83907   ,
322099  ,
160853  ,
267461  ,
111591  ,
54441   ,
406533  ,
79409   ,
249197  ,
66083   ,
340255  ,
509187  ,
26337   ,
195645  ,
22681   ,
214043  ,
490207  ,
303433  ,
433651  ,
430737  ,
215709  ,
169289  ,
337037  ,
201481  ,
385977  ,
133389  ,
35717   ,
454869  ,
195147  ,
445607  ,
505157  ,
89415   ,
89107   ,
8763    ,
202953  ,
48395   ,
169187  ,
368723  ,
210301  ,
277509  ,
464903  ,
262163  ,
411531  ,
276309  ,
150403  ,
507701  ,
510957  ,
299251  ,
271683  ,
230905  ,
519329  ,
298317  ,
267133  ,
404633  ,
369869  ,
378947  ,
325365  ,
358467  ,
276137  ,
477923  ,
193147  ,
360023  ,
265657  ,
157953  ,
123133  ,
436597  ,
375699  ,
506329  ,
388213  ,
145377  ,
124497  ,
15507   ,
191887  ,
214829  ,
305479  ,
453267  ,
516759  ,
317959  ,
435467  ,
296493  ,
188823  ,
384507  ,
137845  ,
331437  ,
396497  ,
117571  ,
398947  ,
298805  ,
48925   ,
61535   ,
212863  ,
213179  ,
409117  ,
33387   ,
296629  ,
382695  ,
59199   ,
96683   ,
179333  ,
262229  ,
414977  ,
416903  ,
409509  ,
203345  ,
63013   ,
62583   ,
62727   ,
272655  ,
501107  ,
70581   ,
483009  ,
386243  ,
506751  ,
171019  ,
501211  ,
319509  ,
253675  ,
501829  ,
426363  ,
189941  ,
412603  ,
36975   ,
295639  ,
460681  ,
441013  ,
337715  ,
120339  ,
447277  ,
285389  ,
290539  ,
239605  ,
356573  ,
219949  ,
224713  ,
40355   ,
54595   ,
329411  ,
196649  ,
468455  ,
186115  ,
266217  ,
159125  ,
208323  ,
33117   ,
52765   ,
290699  ,
75731   ,
89621   ,
380075  ,
91639   ,
38909   ,
104817  ,
387215  ,
392773  ,
518945  ,
429863  ,
404467  ,
314085  ,
456231  ,
165565  ,
510555  ,
210507  ,
226039  ,
338229  ,
166813  ,
174581  ,
165755  ,
382501  ,
309649  ,
499191  ,
308621  ,
259723  ,
513339  ,
340587  ,
380819  ,
378181  ,
57923   ,
286279  ,
231615  ,
279113  ,
424659  ,
37007   ,
441201  ,
129931  ,
208001  ,
303189  ,
385313  ,
477125  ,
487179  ,
475011  ,
94639   ,
66981   ,
474661  ,
487661  ,
330713  ,
304565  ,
449935  ,
350911  ,
439621  ,
250651  ,
433605  ,
362115  ,
328081  ,
429645  ,
4221    ,
283871  ,
285293  ,
265739  ,
91389   ,
481871  ,
256677  ,
376187  ,
125175  ,
330313  ,
159661  ,
462597  ,
334093  ,
442561  ,
220049  ,
355675  ,
124287  ,
434043  ,
67551   ,
161517  ,
241373  ,
50541   ,
362633  ,
373437  ,
98773   ,
275173  ,
22115   ,
64671   ,
146381  ,
198759  ,
138155  ,
99341   ,
448257  ,
240583  ,
270629  ,
207515  ,
323467  ,
303171  ,
403885  ,
181707  ,
104053  ,
75767   ,
282943  ,
146711  ,
469177  ,
131989  ,
322957  ,
333603  ,
394899  ,
86123   ,
135803  ,
13779   ,
222349  ,
116607  ,
514707  ,
68517   ,
275063  ,
311091  ,
302235  ,
406471  ,
477863  ,
172781  ,
313867  ,
37917   ,
158301  ,
433389  ,
463443  ,
150115  ,
451273  ,
103161  ,
169381  ,
117957  ,
428227  ,
443637  ,
192523  ,
502387  ,
342819  ,
359005  ,
455829  ,
73093   ,
47435   ,
388179  ,
9013    ,
217203  ,
152109  ,
139429  ,
125891  ,
427235  ,
64629   ,
146983  ,
109897  ,
305107  ,
186709  ,
75557   ,
32741   ,
517283  ,
421199  ,
452283  ,
220733  ,
288661  ,
337901  ,
289475  ,
107573  ,
482595  ,
91381   ,
194733  ,
123411  ,
267023  ,
442133  ,
174389  ,
402733  ,
123439  ,
177779  ,
209835  ,
259317  ,
333393  ,
446119  ,
270773  ,
301551  ,
82139   ,
482815  ,
438069  ,
223295  ,
281189  ,
437955  ,
441827  ,
1061    ,
136069  ,
398773  ,
512885  ,
83389   ,
460957  ,
262189  ,
5415    ,
266527  ,
67147   ,
413951  ,
196389  ,
484117  ,
193143  ,
449765  ,
166917  ,
401191  ,
487117  ,
362275  ,
452155  ,
425465  ,
188115  ,
49195   ,
263207  ,
454693  ,
362117  ,
46005   ,
391175  ,
127641  ,
21169   ,
134811  ,
115783  ,
417793  ,
523261  ,
195043  ,
156651  ,
521557  ,
432047  ,
336075  ,
496811  ,
312445  ,
222347  ,
143443  ,
356779  ,
193955  ,
89251   ,
459343  ,
474597  ,
476191  ,
317425  ,
38129   ,
466677  ,
327971  ,
419881  ,
319511  ,
127957  ,
374395  ,
24303   ,
149903  ,
202481  ,
143045  ,
413499  ,
145925  ,
493127  ,
36955   ,
214551  ,
295607  ,
371635  ,
231593  ,
204699  ,
101563  ,
122997  ,
137659  ,
381377  ,
151411  ,
517891  ,
445679  ,
203019  ,
243005  ,
222011  ,
290453  ,
438525  ,
160605  ,
483253  ,
224221  ,
272709  ,
413187  ,
29775   ,
330693  ,
127571  ,
371639  ,
41881   ,
422559  ,
300909  ,
431477  ,
447291  ,
280453  ,
25139   ,
197033  ,
341085  ,
71913   ,
267415  ,
45001   ,
338605  ,
225225  ,
76721   ,
431613  ,
34313   ,
374199  ,
488405  ,
264717  ,
457469  ,
88791   ,
67193   ,
371227  ,
299303  ,
40773   ,
389675  ,
432579  ,
327277  ,
214491  ,
219621  ,
127733  ,
420923  ,
42047   ,
320279  ,
302975  ,
479355  ,
253615  ,
371745  ,
416003  ,
459247  ,
291015  ,
350949  ,
360193  ,
50717   ,
198265  ,
434549  ,
424333  ,
324093  ,
419613  ,
443075  ,
11437   ,
479877  ,
487213  ,
419941  ,
464165  ,
207347  ,
311413  ,
57795   ,
192285  ,
113259  ,
64029   ,
310233  ,
274533  ,
408997  ,
505547  ,
184087  ,
84567   ,
188245  ,
7259    ,
364437  ,
411759  ,
329439  ,
453909  ,
397995  ,
310653  ,
65353   ,
65753   ,
36155   ,
276147  ,
441229  ,
263837  ,
436813  ,
46333   ,
12995   ,
17749   ,
455109  ,
117587  ,
273877  ,
197141  ,
220027  ,
5635    ,
133317  ,
152029  ,
194515  ,
451803  ,
436381  ,
59175   ,
42261   ,
307153  ,
375113  ,
482445  ,
385365  ,
418485  ,
297567  ,
30673   ,
226761  ,
432187  ,
173773  ,
164669  ,
343787  ,
75395   ,
269955  ,
402587  ,
429211  ,
241365  ,
110907  ,
253101  ,
301571  ,
157387  ,
177403  ,
212859  ,
260445  ,
56299   ,
155365  ,
147087  ,
56293   ,
46483   ,
86517   ,
513627  ,
257077  ,
116249  ,
416427  ,
127811  ,
352229  ,
270485  ,
213435  ,
65831   ,
398597  ,
433299  ,
33693   ,
311899  ,
390819  ,
90557   ,
209871  ,
201769  ,
266155  ,
275617  ,
212653  ,
454685  ,
407707  ,
425645  ,
274981  ,
125813  ,
74835   ,
458779  ,
60883   ,
522667  ,
409741  ,
160713  ,
261435  ,
482605  ,
19509   ,
350387  ,
522805  ,
462603  ,
333155  ,
124407  ,
185337  ,
514379  ,
208587  ,
492467  ,
239987  ,
316617  ,
251875  ,
200641  ,
324845  ,
471765  ,
253203  ,
82021   ,
199805  ,
120877  ,
178445  ,
444725  ,
469905  ,
332765  ,
410475  ,
412485  ,
169897  ,
241559  ,
336281  ,
146325  ,
316575  ,
118941  ,
478659  ,
506867  ,
504213  ,
206705  ,
146181  ,
114967  ,
49563   ,
499389  ,
136813  ,
440909  ,
216391  ,
84013   ,
136221  ,
467061  ,
437341  ,
372275  ,
491151  ,
336625  ,
429285  ,
81285   ,
399773  ,
330751  ,
300003  ,
326299  ,
364773  ,
90197   ,
190557  ,
314929  ,
130711  ,
150163  ,
275487  ,
489251  ,
1435    ,
417813  ,
309509  ,
364429  ,
143293  ,
58589   ,
335801  ,
516273  ,
520611  ,
98423   ,
307167  ,
144667  ,
220443  ,
97027   ,
176731  ,
288807  ,
406575  ,
181883  ,
282073  ,
80271   ,
87379   ,
58453   ,
507483  ,
465723  ,
215925  ,
274405  ,
198725  ,
49835   ,
254051  ,
444627  ,
326979  ,
248017  ,
171763  ,
202961  ,
127681  ,
353115  ,
176365  ,
139933  ,
421091  ,
469631  ,
474243  ,
9241    ,
385269  ,
473959  ,
402257  ,
153165  ,
318117  ,
1931    ,
322539  ,
175347  ,
36741   ,
428715  ,
218691  ,
517393  ,
365005  ,
376843  ,
348647  ,
251965  ,
501441  ,
238539  ,
120805  ,
395019  ,
396803  ,
65427   ,
387251  ,
453907  ,
370955  ,
72971   ,
420541  ,
127623  ,
96851   ,
468299  ,
215355  ,
196387  ,
388077  ,
112413  ,
210051  ,
142875  ,
269093  ,
190701  ,
498259  ,
401653  ,
274211  ,
397355  ,
282911  ,
451971  ,
451733  ,
27635   ,
347581  ,
415339  ,
399955  ,
189661  ,
8863    ,
428475  ,
109475  ,
301357  ,
84251   ,
386611  ,
160971  ,
112485  ,
248921  ,
408051  ,
78699   ,
286327  ,
174379  ,
58591   ,
419625  ,
224347  ,
101949  ,
38663   ,
446341  ,
329941  ,
281909  ,
69759   ,
342259  ,
97913   ,
316315  ,
328907  ,
303861  ,
16035   ,
491307  ,
358357  ,
21483   ,
386501  ,
361925  ,
116797  ,
215769  ,
17071   ,
365797  ,
110155  ,
286209  ,
187183  ,
240729  ,
457841  ,
54791   ,
214949  ,
506679  ,
403659  ,
355859  ,
125173  ,
343293  ,
51891   ,
455505  ,
385613  ,
329091  ,
281715  ,
38573   ,
99487   ,
311131  ,
271189  ,
127373  ,
294445  ,
63549   ,
242395  ,
164509  ,
439653  ,
478167  ,
477587  ,
188651  ,
205357  ,
308325  ,
415779  ,
169339  ,
27317   ,
303347  ,
167347  ,
328923  ,
448643  ,
520581  ,
104975  ,
174613  ,
69869   ,
62981   ,
180539  ,
479061  ,
286111  ,
178253  ,
219475  ,
510101  ,
205539  ,
343221  ,
227891  ,
257795  ,
246033  ,
46941   ,
34197   ,
504099  ,
101795  ,
225341  ,
186725  ,
337309  ,
359651  ,
3771    ,
63147   ,
327383  ,
410197  ,
478987  ,
454431  ,
515763  ,
157653  ,
50131   ,
406229  ,
366535  ,
393109  ,
324869  ,
412381  ,
286771  ,
207331  ,
201943  ,
408611  ,
167867  ,
378867  ,
419131  ,
147405  ,
363189  ,
345577  ,
142797  ,
203189  ,
429787  ,
425031  ,
25629   ,
317643  ,
465315  ,
507569  ,
378323  ,
447891  ,
43659   ,
26453   ,
512307  ,
383411  ,
102731  ,
518885  ,
421853  ,
173807  ,
463115  ,
71775   ,
354749  ,
51727   ,
65269   ,
177445  ,
99371   ,
398675  ,
419393  ,
233627  ,
255599  ,
264653  ,
137949  ,
394723  ,
27605   ,
201491  ,
187101  ,
164859  ,
147905  ,
419285  ,
396747  ,
314989  ,
143317  ,
460589  ,
251667  ,
477035  ,
301107  ,
512723  ,
270837  ,
395195  ,
411013  ,
175621  ,
468597  ,
355601  ,
70263   ,
17789   ,
284159  ,
51741   ,
99281   ,
108705  ,
173289  ,
295553  ,
490249  ,
302683  ,
285607  ,
481973  ,
390225
};


const Real latticeD[] =
{
    1   ,
182667  ,
279195  ,
223491  ,
205755  ,
359329  ,
198937  ,
246491  ,
466233  ,
379083  ,
36369   ,
64937   ,
66771   ,
316939  ,
133085  ,
123053  ,
117393  ,
150849  ,
249011  ,
84523   ,
488607  ,
302459  ,
166527  ,
320003  ,
389385  ,
167853  ,
500963  ,
29137   ,
272065  ,
191127  ,
236801  ,
33547   ,
493351  ,
287131  ,
123975  ,
144279  ,
469429  ,
303333  ,
241475  ,
464325  ,
222725  ,
461957  ,
36889   ,
302837  ,
375867  ,
330661  ,
317387  ,
251717  ,
204691  ,
448709  ,
230903  ,
332451  ,
199565  ,
505759  ,
183713  ,
259639  ,
252645  ,
399425  ,
263827  ,
335179  ,
122001  ,
461335  ,
404323  ,
105409  ,
66413   ,
311477  ,
175313  ,
279735  ,
394009  ,
17815   ,
53097   ,
38027   ,
472745  ,
410105  ,
68809   ,
473045  ,
165945  ,
267937  ,
55141   ,
62791   ,
285995  ,
126173  ,
176985  ,
427547  ,
454863  ,
424625  ,
240079  ,
78133   ,
409009  ,
115825  ,
430717  ,
382943  ,
375529  ,
515661  ,
426131  ,
456381  ,
219683  ,
316389  ,
259059  ,
84999   ,
275415  ,
304479  ,
409707  ,
420535  ,
40537   ,
385491  ,
518771  ,
167559  ,
34663   ,
130747  ,
248377  ,
104613  ,
91679   ,
490637  ,
155525  ,
80879   ,
294657  ,
383837  ,
10835   ,
208567  ,
305071  ,
308645  ,
516997  ,
266997  ,
512799  ,
174311  ,
424585  ,
128073  ,
195057  ,
237501  ,
125311  ,
338563  ,
380199  ,
116405  ,
436269  ,
454173  ,
265837  ,
463933  ,
480925  ,
227027  ,
88187   ,
6497    ,
38863   ,
462129  ,
213739  ,
345055  ,
263405  ,
474909  ,
183125  ,
37731   ,
121641  ,
254439  ,
299429  ,
517895  ,
54023   ,
42101   ,
249273  ,
410233  ,
77471   ,
362157  ,
434577  ,
364387  ,
90051   ,
501895  ,
161773  ,
97223   ,
377405  ,
89045   ,
100783  ,
171781  ,
201015  ,
496317  ,
375069  ,
143075  ,
228303  ,
321907  ,
120085  ,
230031  ,
99207   ,
465275  ,
104317  ,
499999  ,
24531   ,
464037  ,
201809  ,
494815  ,
72657   ,
335957  ,
245969  ,
148673  ,
94087   ,
121875  ,
129677  ,
180341  ,
519361  ,
119379  ,
322575  ,
354793  ,
258519  ,
484809  ,
98843   ,
73253   ,
394657  ,
471803  ,
492369  ,
90557   ,
430259  ,
93761   ,
522833  ,
221917  ,
158575  ,
261395  ,
112329  ,
377149  ,
217515  ,
198073  ,
75717   ,
477551  ,
435439  ,
284929  ,
55347   ,
139209  ,
252695  ,
167221  ,
358873  ,
497693  ,
428953  ,
468787  ,
408703  ,
367823  ,
405757  ,
444591  ,
235183  ,
416013  ,
66009   ,
271273  ,
341093  ,
343443  ,
166341  ,
63021   ,
197067  ,
175515  ,
466911  ,
413481  ,
365193  ,
8263    ,
185349  ,
196911  ,
498843  ,
141121  ,
135583  ,
486891  ,
382525  ,
9063    ,
352399  ,
283599  ,
315551  ,
250563  ,
96993   ,
439847  ,
136091  ,
122787  ,
203509  ,
65351   ,
187257  ,
27769   ,
427271  ,
504637  ,
191661  ,
198269  ,
394483  ,
25177   ,
83859   ,
30345   ,
215055  ,
380913  ,
230161  ,
479181  ,
108969  ,
428919  ,
126755  ,
220703  ,
510299  ,
59911   ,
114963  ,
248543  ,
37939   ,
79295   ,
364755  ,
302091  ,
80313   ,
422925  ,
197755  ,
500403  ,
101531  ,
419123  ,
271697  ,
502003  ,
312361  ,
514831  ,
521401  ,
185055  ,
129339  ,
59165   ,
114625  ,
215711  ,
63075   ,
89761   ,
320147  ,
325119  ,
57131   ,
94267   ,
91433   ,
363963  ,
286515  ,
363251  ,
401965  ,
440515  ,
104899  ,
153825  ,
278581  ,
416851  ,
236221  ,
321839  ,
247525  ,
500365  ,
441647  ,
37373   ,
12319   ,
268763  ,
316051  ,
71955   ,
514707  ,
453643  ,
323493  ,
128445  ,
78293   ,
184279  ,
107867  ,
396051  ,
171839  ,
362571  ,
259205  ,
25101   ,
268495  ,
237747  ,
47979   ,
272407  ,
191595  ,
171981  ,
42021   ,
247787  ,
491947  ,
320915  ,
80579   ,
157853  ,
258825  ,
359873  ,
433855  ,
44673   ,
161663  ,
182079  ,
389495  ,
366571  ,
453023  ,
468271  ,
413995  ,
426689  ,
151245  ,
326401  ,
366697  ,
147595  ,
227185  ,
387605  ,
248899  ,
476075  ,
339543  ,
113653  ,
314071  ,
295563  ,
393417  ,
120633  ,
163665  ,
73853   ,
467443  ,
507309  ,
216283  ,
333613  ,
372967  ,
432743  ,
157767  ,
85517   ,
455655  ,
242613  ,
322455  ,
25163   ,
370943  ,
430493  ,
292603  ,
189657  ,
291811  ,
181135  ,
207599  ,
492047  ,
6053    ,
353161  ,
125759  ,
514021  ,
423021  ,
466607  ,
232713  ,
207657  ,
130225  ,
135877  ,
392103  ,
379395  ,
476243  ,
134231  ,
25945   ,
369449  ,
131503  ,
472207  ,
511859  ,
514887  ,
77995   ,
47653   ,
133207  ,
84845   ,
20441   ,
102367  ,
138477  ,
487849  ,
224589  ,
294717  ,
109759  ,
11619   ,
368801  ,
395915  ,
425041  ,
442875  ,
466719  ,
454977  ,
72281   ,
277871  ,
159921  ,
303087  ,
244501  ,
973 ,
60543   ,
370197  ,
17679   ,
489259  ,
365419  ,
22953   ,
297023  ,
22671   ,
108539  ,
85689   ,
362371  ,
386935  ,
472617  ,
334103  ,
106459  ,
100587  ,
469771  ,
322173  ,
336187  ,
67711   ,
22869   ,
50965   ,
435003  ,
28367   ,
264497  ,
366641  ,
106841  ,
220997  ,
206503  ,
495937  ,
453679  ,
137489  ,
246043  ,
484323  ,
184559  ,
238477  ,
300211  ,
274035  ,
297761  ,
38895   ,
315033  ,
231841  ,
163567  ,
169615  ,
104565  ,
394295  ,
250265  ,
295669  ,
187311  ,
444711  ,
403003  ,
243195  ,
276421  ,
162165  ,
367729  ,
309171  ,
198663  ,
7271    ,
218409  ,
5983    ,
247915  ,
172293  ,
17573   ,
325043  ,
270827  ,
32945   ,
118549  ,
36997   ,
369399  ,
263483  ,
423215  ,
368077  ,
497581  ,
258921  ,
460685  ,
61743   ,
301617  ,
113157  ,
327921  ,
124941  ,
297323  ,
145877  ,
54709   ,
38929   ,
27339   ,
128757  ,
76771   ,
238359  ,
83565   ,
355027  ,
476807  ,
285225  ,
472113  ,
65087   ,
372319  ,
221281  ,
195207  ,
350389  ,
415559  ,
56815   ,
380817  ,
143789  ,
335599  ,
489931  ,
398779  ,
282373  ,
159847  ,
350679  ,
160827  ,
279455  ,
193221  ,
230783  ,
178137  ,
353601  ,
89131   ,
372527  ,
306613  ,
187635  ,
285943  ,
213411  ,
178247  ,
116839  ,
355263  ,
437211  ,
478175  ,
235229  ,
93181   ,
256077  ,
177767  ,
349129  ,
483023  ,
484377  ,
54149   ,
402791  ,
411761  ,
473191  ,
302665  ,
414165  ,
391943  ,
215413  ,
42439   ,
164179  ,
478661  ,
213699  ,
145967  ,
444679  ,
342919  ,
212673  ,
273953  ,
251103  ,
515897  ,
318935  ,
229211  ,
511509  ,
450425  ,
133341  ,
477953  ,
154761  ,
63629   ,
38241   ,
459731  ,
175653  ,
292523  ,
401697  ,
464209  ,
81013   ,
492621  ,
50661   ,
152797  ,
248287  ,
239605  ,
51385   ,
3995    ,
206337  ,
504387  ,
6897    ,
265993  ,
480881  ,
487651  ,
365977  ,
17007   ,
497063  ,
33017   ,
518381  ,
353339  ,
334697  ,
31837   ,
477683  ,
60229   ,
50521   ,
27711   ,
513291  ,
502955  ,
115989  ,
436395  ,
423777  ,
375133  ,
495757  ,
280685  ,
338207  ,
295325  ,
234961  ,
58219   ,
286889  ,
228337  ,
322029  ,
473911  ,
442473  ,
307413  ,
272747  ,
145539  ,
441983  ,
470407  ,
107473  ,
151113  ,
248115  ,
170119  ,
404949  ,
264353  ,
87883   ,
307267  ,
324999  ,
268229  ,
256873  ,
80671   ,
199761  ,
354715  ,
21373   ,
352653  ,
225405  ,
433479  ,
61055   ,
113889  ,
85071   ,
78983   ,
17469   ,
376889  ,
261557  ,
79723   ,
305367  ,
113291  ,
231557  ,
460795  ,
138085  ,
343379  ,
373633  ,
135091  ,
95143   ,
416939  ,
1867    ,
163033  ,
315087  ,
104749  ,
206771  ,
20523   ,
282333  ,
464727  ,
140291  ,
165519  ,
41495   ,
413679  ,
315671  ,
459185  ,
179753  ,
135905  ,
455265  ,
131877  ,
423681  ,
109311  ,
415037  ,
266789  ,
491689  ,
493251  ,
238009  ,
443517  ,
222871  ,
33431   ,
12013   ,
208609  ,
471445  ,
363403  ,
170271  ,
176697  ,
180717  ,
477707  ,
422793  ,
151921  ,
414663  ,
309501  ,
366117  ,
495637  ,
477065  ,
262635  ,
211351  ,
519309  ,
415943  ,
400885  ,
91777   ,
119437  ,
123309  ,
437735  ,
250837  ,
378947  ,
345941  ,
309463  ,
515587  ,
202835  ,
412869  ,
280297  ,
224391  ,
370787  ,
134435  ,
239103  ,
266605  ,
163713  ,
71279   ,
76743   ,
470977  ,
251523  ,
326495  ,
293343  ,
325467  ,
51321   ,
55723   ,
135025  ,
459611  ,
291687  ,
173839  ,
393501  ,
114527  ,
52317   ,
367845  ,
225941  ,
32665   ,
440195  ,
261525  ,
407707  ,
236641  ,
376465  ,
389157  ,
217829  ,
29189   ,
377825  ,
41749   ,
179179  ,
37589   ,
186701  ,
90007   ,
395815  ,
521441  ,
176571  ,
310985  ,
183271  ,
195219  ,
35251   ,
97913   ,
250955  ,
20787   ,
291487  ,
327111  ,
88079   ,
295131  ,
424357  ,
267469  ,
258175  ,
148467  ,
288319  ,
495589  ,
289443  ,
122673  ,
418069  ,
298821  ,
459515  ,
174257  ,
291885  ,
498655  ,
111895  ,
224215  ,
320387  ,
432019  ,
66591   ,
170297  ,
388675  ,
459079  ,
221401  ,
211777  ,
79255   ,
222239  ,
273591  ,
293041  ,
305967  ,
109451  ,
213281  ,
362061  ,
243813  ,
446129  ,
253825  ,
25213   ,
488773  ,
515477  ,
190121  ,
497957  ,
215113  ,
322645  ,
208811  ,
474059  ,
357415  ,
152143  ,
498349  ,
510633  ,
323631  ,
409179  ,
272657  ,
463553  ,
81323   ,
224157  ,
374547  ,
143541  ,
154893  ,
154197  ,
120599  ,
67741   ,
395209  ,
253363  ,
482161  ,
321509  ,
466093  ,
150295  ,
190977  ,
330313  ,
135939  ,
399093  ,
227589  ,
447823  ,
502057  ,
198185  ,
149417  ,
135051  ,
159355  ,
510597  ,
412727  ,
186807  ,
39281   ,
131465  ,
42761   ,
268121  ,
437971  ,
71183   ,
438315  ,
275503  ,
264179  ,
276861  ,
342383  ,
486597  ,
449347  ,
311777  ,
388497  ,
164553  ,
217097  ,
175749  ,
47951   ,
31523   ,
297375  ,
299179  ,
37835   ,
270757  ,
389697  ,
245537  ,
363457  ,
268861  ,
413151  ,
475105  ,
348137  ,
364063  ,
492357  ,
117265  ,
464109  ,
250715  ,
239433  ,
264203  ,
447969  ,
279911  ,
132605  ,
333703  ,
69165   ,
57627   ,
112067  ,
371633  ,
39183   ,
315421  ,
273391  ,
324063  ,
143161  ,
194707  ,
419699  ,
24075   ,
267023  ,
308889  ,
247465  ,
77197   ,
506681  ,
211631  ,
222895  ,
192329  ,
243105  ,
195475  ,
113055  ,
390153  ,
310785  ,
61017   ,
289467  ,
401727  ,
53805   ,
461517  ,
14427   ,
24715   ,
56663   ,
168371  ,
207193  ,
475777  ,
193161  ,
122377  ,
429559  ,
222127  ,
346177  ,
107321  ,
179577  ,
141691  ,
183241  ,
250423  ,
487073  ,
174197  ,
44187   ,
311549  ,
440989  ,
322729  ,
283979  ,
519819  ,
449753  ,
242449  ,
410373  ,
264071  ,
107951  ,
228971  ,
269389  ,
221149  ,
44121   ,
523673  ,
173437  ,
144953  ,
278889  ,
103969  ,
349365  ,
29649   ,
465625  ,
95867   ,
406545  ,
188777  ,
519193  ,
40241   ,
513425  ,
145087  ,
390337  ,
451845  ,
29779   ,
434803  ,
217143  ,
18357   ,
361835  ,
145719  ,
49927   ,
200599  ,
473709  ,
105611  ,
174227  ,
470341  ,
50465   ,
330983  ,
212585  ,
319569  ,
425401  ,
273989  ,
388307  ,
455053  ,
397497  ,
375483  ,
166781  ,
12159   ,
88149   ,
75919   ,
163327  ,
519671  ,
405491  ,
390223  ,
352693  ,
261045  ,
83743   ,
480267  ,
283295  ,
99057   ,
45457   ,
192883  ,
118377  ,
84019   ,
288675  ,
377663  ,
452711  ,
397545  ,
394377  ,
18959   ,
373267  ,
276533  ,
211237  ,
86655   ,
240803  ,
410009  ,
377071  ,
134527  ,
511099  ,
18659   ,
412973  ,
56189   ,
412001  ,
254749  ,
72513   ,
160593  ,
455737  ,
334855  ,
162101  ,
149925  ,
201541  ,
262853  ,
328791  ,
58641   ,
259929  ,
250457  ,
128179  ,
56981   ,
234859  ,
102467  ,
275051  ,
508797  ,
94943   ,
499673  ,
308705  ,
168137  ,
386261  ,
116313  ,
188507  ,
324967  ,
129767  ,
92829   ,
336905  ,
377247  ,
108619  ,
191445  ,
181581  ,
398197  ,
23499   ,
408987  ,
494223  ,
33817   ,
182103  ,
5075    ,
397515  ,
394073  ,
486147  ,
5175    ,
101399  ,
321665  ,
280695  ,
390843  ,
352837  ,
304455  ,
157441  ,
133257  ,
321429  ,
112387  ,
459783  ,
100153  ,
193329  ,
463851  ,
420287  ,
93365   ,
374881  ,
219965  ,
291403  ,
261767  ,
214861  ,
86509   ,
185311  ,
7583    ,
323057  ,
406763  ,
398601  ,
223347  ,
115125  ,
159607  ,
446883  ,
313461  ,
92339   ,
303531  ,
257771  ,
237085  ,
305897  ,
517521  ,
118975  ,
173411  ,
447737  ,
403219  ,
197493  ,
430807  ,
418181  ,
314187  ,
51299   ,
19509   ,
315649  ,
120981  ,
495093  ,
396379  ,
295781  ,
131767  ,
378735  ,
512195  ,
13541   ,
158833  ,
274333  ,
397167  ,
236079  ,
245881  ,
449831  ,
239741  ,
376719  ,
93953   ,
105691  ,
380131  ,
321059  ,
379373  ,
58395   ,
215325  ,
194999  ,
241585  ,
176759  ,
206967  ,
192005  ,
190553  ,
106597  ,
17881   ,
32307   ,
361319  ,
280487  ,
325699  ,
418281  ,
354251  ,
184885  ,
462289  ,
9763    ,
342399  ,
331151  ,
433705  ,
455853  ,
305397  ,
181523  ,
360103  ,
469473  ,
432323  ,
42249   ,
413843  ,
485081  ,
467487  ,
520541  ,
97623   ,
255867  ,
129479  ,
320093  ,
47805   ,
523653  ,
300859  ,
440653  ,
274945  ,
163229  ,
87107   ,
428865  ,
171439  ,
96483   ,
325155  ,
459429  ,
445165  ,
66881   ,
514347  ,
55927   ,
419023  ,
338517  ,
118583  ,
283203  ,
448181  ,
62139   ,
200669  ,
307089  ,
169567  ,
163951  ,
452141  ,
245605  ,
89273   ,
407063  ,
287859  ,
135743  ,
447509  ,
296941  ,
240397  ,
81397   ,
101709  ,
478033  ,
260819  ,
375967  ,
304633  ,
384311  ,
204955  ,
28243   ,
509645  ,
24947   ,
199633  ,
83393   ,
509449  ,
8455    ,
470931  ,
290775  ,
288383  ,
93373   ,
384775  ,
468881  ,
444509  ,
199787  ,
330465  ,
37883   ,
392265  ,
8381    ,
70185   ,
373659  ,
115443  ,
464021  ,
93335   ,
500483  ,
41717   ,
367449  ,
438781  ,
152941  ,
203289  ,
9843    ,
463453  ,
163011  ,
454333  ,
239677  ,
364903  ,
420335  ,
72615   ,
141753  ,
10593   ,
82569   ,
32023   ,
388071  ,
153721  ,
311671  ,
296829  ,
455379  ,
113735  ,
433791  ,
520963  ,
67893   ,
376997  ,
84971   ,
52503   ,
68441   ,
221303  ,
7181    ,
197447  ,
53125   ,
316865  ,
344107  ,
225075  ,
168075  ,
298361  ,
433023  ,
72779   ,
277543  ,
484595  ,
262819  ,
193807  ,
119755  ,
293991  ,
310897  ,
389753  ,
115601  ,
358305  ,
375563  ,
517213  ,
55013   ,
372401  ,
327911  ,
285357  ,
425641  ,
270877  ,
28941   ,
76919   ,
321123  ,
410893  ,
473851  ,
483787  ,
82249   ,
188481  ,
484907  ,
236999  ,
462013  ,
105123  ,
39355   ,
223579  ,
57929   ,
330967  ,
275771  ,
323407  ,
287169  ,
49701   ,
86049   ,
509977  ,
212873  ,
115297  ,
164257  ,
53485   ,
498267  ,
360079  ,
227657  ,
409779  ,
345191  ,
252953  ,
510735  ,
226921  ,
455665  ,
437983  ,
449333  ,
111597  ,
152813  ,
467059  ,
160725  ,
508851  ,
58147   ,
32289   ,
191399  ,
352671  ,
85981   ,
354397  ,
193731  ,
251937  ,
3713    ,
273231  ,
354739  ,
22427   ,
171039  ,
15141   ,
216295  ,
492677  ,
376207  ,
303563  ,
214685  ,
376363  ,
185261  ,
150931  ,
53747   ,
168427  ,
450793  ,
397921  ,
155871  ,
283539  ,
318211  ,
252271  ,
268635  ,
298635  ,
31723   ,
203643  ,
134751  ,
14757   ,
147677  ,
450959  ,
241819  ,
355289  ,
69119   ,
302781  ,
69551   ,
52301   ,
480849  ,
160631  ,
164887  ,
177239  ,
288619  ,
240037  ,
305921  ,
74391   ,
445091  ,
192659  ,
48895   ,
51643   ,
239211  ,
192633  ,
310473  ,
455115  ,
94453   ,
105767  ,
92771   ,
253651  ,
389777  ,
171823  ,
366475  ,
140101  ,
431451  ,
172413  ,
177095  ,
507113  ,
159725  ,
49119   ,
49955   ,
339823  ,
345417  ,
421625  ,
85885   ,
313139  ,
129031  ,
150955  ,
156921  ,
66499   ,
74107   ,
419587  ,
288337  ,
476939  ,
337779  ,
491665  ,
114535  ,
411197  ,
452069  ,
228787  ,
225377  ,
371671  ,
69655   ,
331117  ,
109235  ,
324041  ,
327019  ,
487719  ,
109859  ,
439143  ,
40663   ,
300913  ,
299321  ,
15997   ,
239813  ,
332605  ,
140733  ,
123549  ,
384635  ,
476411  ,
292045  ,
483357  ,
110545  ,
483567  ,
350001  ,
493079  ,
396643  ,
259575  ,
312177  ,
424107  ,
232351  ,
329253  ,
497971  ,
295739  ,
495537  ,
15075   ,
469197  ,
295893  ,
202043  ,
511275  ,
114199  ,
160313  ,
454001  ,
19939   ,
513523  ,
22265   ,
202279  ,
232721  ,
43757   ,
95135   ,
351153  ,
428573  ,
250817  ,
333337  ,
78329   ,
334349  ,
270453  ,
482047  ,
340823  ,
333785  ,
402001  ,
129211  ,
60727   ,
175813  ,
125169  ,
486677  ,
511667  ,
38479   ,
413521  ,
132061  ,
40981   ,
410723  ,
475287  ,
225035  ,
439983  ,
217407  ,
208109  ,
5835    ,
334579  ,
493189  ,
41001   ,
241117  ,
81281   ,
173003  ,
202367  ,
61447   ,
273257  ,
74651   ,
391655  ,
322347  ,
242471  ,
24163   ,
226369  ,
9165    ,
517635  ,
469107  ,
155109  ,
346451  ,
509223  ,
294959  ,
137869  ,
192363  ,
43397   ,
489467  ,
223141  ,
457815  ,
3505    ,
373125  ,
485785  ,
71521   ,
143985  ,
405163  ,
421287  ,
25707   ,
330939  ,
336447  ,
338149  ,
155673  ,
398035  ,
243559  ,
428931  ,
417489  ,
212083  ,
178895  ,
415075  ,
480393  ,
175221  ,
93977   ,
399445  ,
230587  ,
142597  ,
385055  ,
134123  ,
356217  ,
211201  ,
225271  ,
161381  ,
387637  ,
286377  ,
43015   ,
349403  ,
317479  ,
331293  ,
213477  ,
255471  ,
18935   ,
69031   ,
267373  ,
78237   ,
283733  ,
214833  ,
323597  ,
2839    ,
228443  ,
491607  ,
118363  ,
486247  ,
354135  ,
107939  ,
454441  ,
501175  ,
58359   ,
508403  ,
221869  ,
50675   ,
295423  ,
103117  ,
96121   ,
368287  ,
120693  ,
476377  ,
68565   ,
364431  ,
313125  ,
294837  ,
291611  ,
206393  ,
277065  ,
241793  ,
371587  ,
335935  ,
39559   ,
229279  ,
31959   ,
63843   ,
103707  ,
410131  ,
192219  ,
395945  ,
389283  ,
19577   ,
82895   ,
131453  ,
287275  ,
431701  ,
63349   ,
83479   ,
427465  ,
47715   ,
522389  ,
412847  ,
244141  ,
393571  ,
312577  ,
265967  ,
255627  ,
312549  ,
513811  ,
443419  ,
177669  ,
177553  ,
64499   ,
72413   ,
123423  ,
386683  ,
415871  ,
393735  ,
86469   ,
516871  ,
476671  ,
262787  ,
117993  ,
342647  ,
213545  ,
251143  ,
99821   ,
57769   ,
521991  ,
216025  ,
166691  ,
69143   ,
436535  ,
133013  ,
339279  ,
128787  ,
336389  ,
268895  ,
57005   ,
278393  ,
435855  ,
178415  ,
429197  ,
172617  ,
61599   ,
429061  ,
9303    ,
304857  ,
346935  ,
18973   ,
405623  ,
436833  ,
249459  ,
154907  ,
95857   ,
320225  ,
135493  ,
363105  ,
113855  ,
117917  ,
239255  ,
340919  ,
150987  ,
122175  ,
321247  ,
253167  ,
148405  ,
32557   ,
192495  ,
162513  ,
388829  ,
173343  ,
232613  ,
244591  ,
172975  ,
508757  ,
211589  ,
356483  ,
503367  ,
411677  ,
351957  ,
164111  ,
183947  ,
353721  ,
361329  ,
2263    ,
163977  ,
12045   ,
431589  ,
320787  ,
365165  ,
26347   ,
491227  ,
420171  ,
382611  ,
153853  ,
501981  ,
119735  ,
477147  ,
467229  ,
185919  ,
34765   ,
510553  ,
311337  ,
266857  ,
59433   ,
519691  ,
4505    ,
113497  ,
121129  ,
177945  ,
406467  ,
474619  ,
304203  ,
252523  ,
205847  ,
405007  ,
444147  ,
387171  ,
213847  ,
237255  ,
226025  ,
68937   ,
337829  ,
61145   ,
111781  ,
117931  ,
100467  ,
255595  ,
90719   ,
216037  ,
237633  ,
249963  ,
93411   ,
122307  ,
404157  ,
378681  ,
68269   ,
174549  ,
402559  ,
314859  ,
491967  ,
328585  ,
413931  ,
327351  ,
141299  ,
20555   ,
56155   ,
329427  ,
418345  ,
87991   ,
209537  ,
81605   ,
409993  ,
65323   ,
56607   ,
179695  ,
311063  ,
383549  ,
168475  ,
406023  ,
29311   ,
473889  ,
54041   ,
57317   ,
342055  ,
254801  ,
325273  ,
289659  ,
331409  ,
96907   ,
1321    ,
506499  ,
4837    ,
255125  ,
492123  ,
498511  ,
319015  ,
454679  ,
346963  ,
310115  ,
118087  ,
486799  ,
101747  ,
160849  ,
352805  ,
284263  ,
144851  ,
357727  ,
158523  ,
478977  ,
41231   ,
372841  ,
400651  ,
481979  ,
297505  ,
407825  ,
326863  ,
164631  ,
64317   ,
468669  ,
317463  ,
254959  ,
309203  ,
430519  ,
147369  ,
94757   ,
24357   ,
206669  ,
437917  ,
174873  ,
91829   ,
296881  ,
311639  ,
21145   ,
16801   ,
37111   ,
71045   ,
177373  ,
499959  ,
165601  ,
186933  ,
469917  ,
190385  ,
77265   ,
483671  ,
327839  ,
473095  ,
221715  ,
497773  ,
98491   ,
167251  ,
202973  ,
96073   ,
215753  ,
286707  ,
395745  ,
335567  ,
104299  ,
69711   ,
264415  ,
97775   ,
217781  ,
61409   ,
426345  ,
43385   ,
283667  ,
387933  ,
418295  ,
175875  ,
374085  ,
274271  ,
242359  ,
153789  ,
141937  ,
369863  ,
27791   ,
92241   ,
106663  ,
306207  ,
461453  ,
460163  ,
152737  ,
280019  ,
383481  ,
474885  ,
207249  ,
133331  ,
7565    ,
468465  ,
523129  ,
336291  ,
283811  ,
143135  ,
291509  ,
300875  ,
335207  ,
321527  ,
70741   ,
220063  ,
330089  ,
170681  ,
341245  ,
64521   ,
312869  ,
44711   ,
147769  ,
440615  ,
360831  ,
497927  ,
214723  ,
38847   ,
277603  ,
143325  ,
162193  ,
260499  ,
155319  ,
374011  ,
171677  ,
130385  ,
442807  ,
251555  ,
98215   ,
189323  ,
506435  ,
478407  ,
204327  ,
357623  ,
239907  ,
448125  ,
283959  ,
358201  ,
115561  ,
39651   ,
508905  ,
10369   ,
339713  ,
406589  ,
247277  ,
43819   ,
439873  ,
242149  ,
142483  ,
59267   ,
229723  ,
278661  ,
517093  ,
454113  ,
504987  ,
453855  ,
87231   ,
58165   ,
37241   ,
238351  ,
309683  ,
7107    ,
348175  ,
26833   ,
124917  ,
52413   ,
459945  ,
443529  ,
140523  ,
505875  ,
58525   ,
371471  ,
278813  ,
18707   ,
304235  ,
28101   ,
373387  ,
379859  ,
478731  ,
436197  ,
372153  ,
183459  ,
173745  ,
42851   ,
97563   ,
208181  ,
453111  ,
219593  ,
155199  ,
236033  ,
97613   ,
464405  ,
22161   ,
460785  ,
83491   ,
38967   ,
116431  ,
79443   ,
395179  ,
427905  ,
210613  ,
493325  ,
349883  ,
379927  ,
222205  ,
63001   ,
203759  ,
405841  ,
106981  ,
483861  ,
64205   ,
20947   ,
170575  ,
280819  ,
49939   ,
450189  ,
26737   ,
340655  ,
470235  ,
482349  ,
513879  ,
413143  ,
224265  ,
186487  ,
391551  ,
470227  ,
249647  ,
243773  ,
496503  ,
38493   ,
400967  ,
251239  ,
518319  ,
1617    ,
431069  ,
177209  ,
193641  ,
17275   ,
433663  ,
314241  ,
5541    ,
59731   ,
33415   ,
451395  ,
502395  ,
107981  ,
37821   ,
126575  ,
419963  ,
151957  ,
260515  ,
3069    ,
231473  ,
212377  ,
187619  ,
110835  ,
109023  ,
322275  ,
259281  ,
329705  ,
443485  ,
446735  ,
209017  ,
185145  ,
102057  ,
1565    ,
124749  ,
6163    ,
439673  ,
51077   ,
118489  ,
487433  ,
483145  ,
372999  ,
316537  ,
396757  ,
65707   ,
223629  ,
205369  ,
509029  ,
148033  ,
152847  ,
354609  ,
402315  ,
253629  ,
78073   ,
82363   ,
167035  ,
406341  ,
501133  ,
229133  ,
222661  ,
160449  ,
368523  ,
280503  ,
244371  ,
250641  ,
195241  ,
189629  ,
108997  ,
26363   ,
133767  ,
522127  ,
344875  ,
467109  ,
174071  ,
316677  ,
310525  ,
104103  ,
493709  ,
418705  ,
385589  ,
442661  ,
505935  ,
208435  ,
458121  ,
411977  ,
454097  ,
55163   ,
103793  ,
355667  ,
149399  ,
248823  ,
471633  ,
57271   ,
272795  ,
160229  ,
465969  ,
30475   ,
462329  ,
332719  ,
242113  ,
83025   ,
503945  ,
459875  ,
85203   ,
229933  ,
493859  ,
8967    ,
480727  ,
391227  ,
276197  ,
476791  ,
375577  ,
441169  ,
244943  ,
459577  ,
419877  ,
435809  ,
512563  ,
407961  ,
378557  ,
70857   ,
413025  ,
212713  ,
154567  ,
416155  ,
276101  ,
452833  ,
97897   ,
40035   ,
199793  ,
113449  ,
361467  ,
390611  ,
470963  ,
384007  ,
116727  ,
520613  ,
140107  ,
56541   ,
441659  ,
279417  ,
414467  ,
424121  ,
256789  ,
446147  ,
323985  ,
140597  ,
36057   ,
410299  ,
28921   ,
196919  ,
64239   ,
102137  ,
484071  ,
395535  ,
490411  ,
408009  ,
399287  ,
344139  ,
107185  ,
114001  ,
127099  ,
152875  ,
125723  ,
387017  ,
176777  ,
144667  ,
202195  ,
74469   ,
285613  ,
22793   ,
452029  ,
28515   ,
497425  ,
155391  ,
418683  ,
415269  ,
464183  ,
114949  ,
419341  ,
24065   ,
85127   ,
424923  ,
465139  ,
417679  ,
507857  ,
196391  ,
168307  ,
422303  ,
520973  ,
219121  ,
53655   ,
517563  ,
345675  ,
305733  ,
479527  ,
460041  ,
153689  ,
289393  ,
326921  ,
416081  ,
340441  ,
31197   ,
428841  ,
392281  ,
25423   ,
428599  ,
55597   ,
127619  ,
83105   ,
338227  ,
4141    ,
65743   ,
519067  ,
134929  ,
297059  ,
198111  ,
219585  ,
178713  ,
233671  ,
515489  ,
313237  ,
188757  ,
469201  ,
451959  ,
214769  ,
508181  ,
400155  ,
247509  ,
162487  ,
245041  ,
10361   ,
153405  ,
196865  ,
253941  ,
135681  ,
110785  ,
286641  ,
490941  ,
184035  ,
98793   ,
316605  ,
110647  ,
243479  ,
67801   ,
238443  ,
478347  ,
239635  ,
184939  ,
117515  ,
488251  ,
402047  ,
74305   ,
491479  ,
356293  ,
184855  ,
184521  ,
314643  ,
37027   ,
517425  ,
108779  ,
120749  ,
370853  ,
283153  ,
416615  ,
15191   ,
25737   ,
1001    ,
129825  ,
98405   ,
472335  ,
293647  ,
169349  ,
71989   ,
112535  ,
51833   ,
127941  ,
12565   ,
212035  ,
480715  ,
30005   ,
112499  ,
261803  ,
413229  ,
33721   ,
69433   ,
207523  ,
420951  ,
143097  ,
297745  ,
44219   ,
463727  ,
519477  ,
495441  ,
223287  ,
242883  ,
241741  ,
8685    ,
402467  ,
467843  ,
121771  ,
522169  ,
399597  ,
478775  ,
68781   ,
199203  ,
403631  ,
492733  ,
284285  ,
182363  ,
304389  ,
418487  ,
156471  ,
31971   ,
34625   ,
422515  ,
510911  ,
205111  ,
97691   ,
504195  ,
79617   ,
403707  ,
178621  ,
417043  ,
11459   ,
333277  ,
400709  ,
468575  ,
443091  ,
432229  ,
39041   ,
486671  ,
64473   ,
240215  ,
243305  ,
71791   ,
242485  ,
193597  ,
42191   ,
203883  ,
433699  ,
395705  ,
400001  ,
419869  ,
150567  ,
174571  ,
7517    ,
254269  ,
419351  ,
117151  ,
245661  ,
273767  ,
422863  ,
508925  ,
329365  ,
84801   ,
330591  ,
449923  ,
490263  ,
458975  ,
134823  ,
281237  ,
203241  ,
339249  ,
153071  ,
420247  ,
374595  ,
476179  ,
216433  ,
487469  ,
49753   ,
269271  ,
249395  ,
148019  ,
282721  ,
70099   ,
172243  ,
502859  ,
513961  ,
292683  ,
381649  ,
483415  ,
513437  ,
93515   ,
77337   ,
177419  ,
359985  ,
16317   ,
179223  ,
208859  ,
258069  ,
429715  ,
142205  ,
232911  ,
112299  ,
96361   ,
438207  ,
386235  ,
277047  ,
398625  ,
282067  ,
235665  ,
227855  ,
135201  ,
13029   ,
427639  ,
17927   ,
284337  ,
82467   ,
397367  ,
55255   ,
434485  ,
132709  ,
200257  ,
429791  ,
27445   ,
291067  ,
47167   ,
199145  ,
192837  ,
40933   ,
315985  ,
95759   ,
484099  ,
248751  ,
316737  ,
417999  ,
267433  ,
89209   ,
309315  ,
184865  ,
119353  ,
174589  ,
235089  ,
150035  ,
179687  ,
442275  ,
394123  ,
424335  ,
335283  ,
152329  ,
118735  ,
155937  ,
330139  ,
31019   ,
289079  ,
81175   ,
477921  ,
491995  ,
406525  ,
347983  ,
376697  ,
502829  ,
338539  ,
342953  ,
457275  ,
360083  ,
277099  ,
482035  ,
389663  ,
205271  ,
155175  ,
134045  ,
172999  ,
405583  ,
71703   ,
285837  ,
301081  ,
364587  ,
21897   ,
126967  ,
265695  ,
300203  ,
322067  ,
170399  ,
234215  ,
57967   ,
250079  ,
182137  ,
234153  ,
27313   ,
325527  ,
93863   ,
347501  ,
512989  ,
329285  ,
357991  ,
237391  ,
86409   ,
459763  ,
53133   ,
311737  ,
264293  ,
492021  ,
30699   ,
475533  ,
128839  ,
78377   ,
488725  ,
372567  ,
402853  ,
395007  ,
236253  ,
520031  ,
431793  ,
253491  ,
28037   ,
245337  ,
198829  ,
199823  ,
435177  ,
269609  ,
77133   ,
523833  ,
410485  ,
197705  ,
263515  ,
259453  ,
348583  ,
493223  ,
491675  ,
262573  ,
102787  ,
503669  ,
257005  ,
303223  ,
103439  ,
69741   ,
176441  ,
279603  ,
357995  ,
362251  ,
432799  ,
263763  ,
378847  ,
390797  ,
447417  ,
508557  ,
319763  ,
423707  ,
188063  ,
38513   ,
308035  ,
63955   ,
501165  ,
29595   ,
80709   ,
323535  ,
269927  ,
335261  ,
158753  ,
229777  ,
80749   ,
406863  ,
460611  ,
511291  ,
418223  ,
210309  ,
430995  ,
162427  ,
217183  ,
509923  ,
484919  ,
258589  ,
177831  ,
324639  ,
343127  ,
135299  ,
203205  ,
241301  ,
262463  ,
138115  ,
270683  ,
282839  ,
117185  ,
417349  ,
387775  ,
31629   ,
282661  ,
342799  ,
101549  ,
90819   ,
289015  ,
14495   ,
318665  ,
202601  ,
386487  ,
417841  ,
516115  ,
346475  ,
242543  ,
291259  ,
90895   ,
477363  ,
499051  ,
494051  ,
468041  ,
220423  ,
425817  ,
237817  ,
171117  ,
28609   ,
238145  ,
240289  ,
53423   ,
141317  ,
483159  ,
258379  ,
383763  ,
3633    ,
2249    ,
197459  ,
239127  ,
260251  ,
335773  ,
325141  ,
318341  ,
520347  ,
138883  ,
146093  ,
157179  ,
502153  ,
494329  ,
502789  ,
520491  ,
261355  ,
48247   ,
468331  ,
162309  ,
340225  ,
49011   ,
365127  ,
449699  ,
458873  ,
428649  ,
80495   ,
62271   ,
356775  ,
191453  ,
102181  ,
46069   ,
98719   ,
389717  ,
460235  ,
294787  ,
387521  ,
178041  ,
466963  ,
250883  ,
141551  ,
178167  ,
344253  ,
157103  ,
230705  ,
245629  ,
414217  ,
310375  ,
467141  ,
138281  ,
156579  ,
25845   ,
2739    ,
494469  ,
216313  ,
272151  ,
347713  ,
227639  ,
248509  ,
444385  ,
477767  ,
474893  ,
421547  ,
348833  ,
201629  ,
218437  ,
338749  ,
160029  ,
514235  ,
213095  ,
127639  ,
84167   ,
427053  ,
201331  ,
503161  ,
153375  ,
420409  ,
375307  ,
189581  ,
28221   ,
259719  ,
15205   ,
196701  ,
473905  ,
266925  ,
224911  ,
429741  ,
85083   ,
110157  ,
96869   ,
102791  ,
47619   ,
432247  ,
212241  ,
463435  ,
358319  ,
178585  ,
44395   ,
100191  ,
429023  ,
65259   ,
362471  ,
170151  ,
381113  ,
62765   ,
152349  ,
388105  ,
225523  ,
78419   ,
487637  ,
347373  ,
468045  ,
214469  ,
514843  ,
130001  ,
343683  ,
50085   ,
73399   ,
468159  ,
211825  ,
89539   ,
187483  ,
79681   ,
159241  ,
140181  ,
1749    ,
303279  ,
388683  ,
391989  ,
285585  ,
167137  ,
442045  ,
146513  ,
425487  ,
98261   ,
87957   ,
432449  ,
309723  ,
193519  ,
26843   ,
249425  ,
418377  ,
127923  ,
206597  ,
351445  ,
327519  ,
488459  ,
27085   ,
331365  ,
263653  ,
137291  ,
222949  ,
445639  ,
433915  ,
171805  ,
265277  ,
334781  ,
171645  ,
477135  ,
499563  ,
257155  ,
32231   ,
60499   ,
467661  ,
345813  ,
73517   ,
166577  ,
441835  ,
128295  ,
494277  ,
180273  ,
361943  ,
333997  ,
124885  ,
470239  ,
361597  ,
48103   ,
386367  ,
441849  ,
73587   ,
337643  ,
518205  ,
237583  ,
283031  ,
355807  ,
41375   ,
339785  ,
455623  ,
150795  ,
444637  ,
387209  ,
144819  ,
403033  ,
191613  ,
158895  ,
397075  ,
337075  ,
294523  ,
264269  ,
211917  ,
245419  ,
75547   ,
357089  ,
455959  ,
449507  ,
514437  ,
277203  ,
509859  ,
396659  ,
89857   ,
184239  ,
435779  ,
291233  ,
420915  ,
345657  ,
107693  ,
392169  ,
503677  ,
222429  ,
358689  ,
11403   ,
384031  ,
199139  ,
217769  ,
157881  ,
90827   ,
98059   ,
22361   ,
516337  ,
441369  ,
514565  ,
238725  ,
183833  ,
24763   ,
78251   ,
93009   ,
452801  ,
64993   ,
315969  ,
138293  ,
507289  ,
420365  ,
126877  ,
182965  ,
137651  ,
478307  ,
100743  ,
264969  ,
95733   ,
23065   ,
50591   ,
197383  ,
313007  ,
422201  ,
287705  ,
440079  ,
345037  ,
162917  ,
383599  ,
220629  ,
112849  ,
398329  ,
466793  ,
155843  ,
241219  ,
519891  ,
192369  ,
351651  ,
242665  ,
259891  ,
251459  ,
470287  ,
175593  ,
309593  ,
181931  ,
429039  ,
174903  ,
347811  ,
510725  ,
133049  ,
321359  ,
342035  ,
126533  ,
196041  ,
8321    ,
94905   ,
234455  ,
193373  ,
99559   ,
496281  ,
226539  ,
470055  ,
499397  ,
486021  ,
60155   ,
24099   ,
320979  ,
329205  ,
421323  ,
433257  ,
13349   ,
251297  ,
376315  ,
263069  ,
443555  ,
502319  ,
209333  ,
6869    ,
134943  ,
74383   ,
329347  ,
375919  ,
249167  ,
13163   ,
349431  ,
154483  ,
365491  ,
346495  ,
481773  ,
249585  ,
423283  ,
478689  ,
321805  ,
489813  ,
372781  ,
130357  ,
297693  ,
217465  ,
334645  ,
144365  ,
208997  ,
448069  ,
515101  ,
293129  ,
221351  ,
407743  ,
490009  ,
406719  ,
453515  ,
254385  ,
425465  ,
229179  ,
159465  ,
105707  ,
430067  ,
449633  ,
69451   ,
353373  ,
516397  ,
501629  ,
399549  ,
323047  ,
19689   ,
122843  ,
476347  ,
503001  ,
355197  ,
138449  ,
488703  ,
477295  ,
97109   ,
233041  ,
430443  ,
136923  ,
235197  ,
202027  ,
38327   ,
120463  ,
174813  ,
338113  ,
441609  ,
263569  ,
221227  ,
113241  ,
273045  ,
282137  ,
171241  ,
41935   ,
31357   ,
118557  ,
67523   ,
292579  ,
134857  ,
343061  ,
229697  ,
218763  ,
135455  ,
60099   ,
11847   ,
107231  ,
276853  ,
162985  ,
172751  ,
312815  ,
61633   ,
120047  ,
396785  ,
475097  ,
303555  ,
13285   ,
172863  ,
70155   ,
63681   ,
239515  ,
345621  ,
290689  ,
298239  ,
103763  ,
415895  ,
120915  ,
23679   ,
139497  ,
361121  ,
334841  ,
144355  ,
2305    ,
440733  ,
383935  ,
254301  ,
241531  ,
34457   ,
415979  ,
415007  ,
478885  ,
258619  ,
49075   ,
353083  ,
452907  ,
174499  ,
458573  ,
443723  ,
507043  ,
439707  ,
347831  ,
449725  ,
202075  ,
43859   ,
158609  ,
63897   ,
339185  ,
274843  ,
459317  ,
159709  ,
126621  ,
245805  ,
267279  ,
497903  ,
249887  ,
18591   ,
49351   ,
7053    ,
59145   ,
514923  ,
364455  ,
324795  ,
462971  ,
110679  ,
254491  ,
372685  ,
436451  ,
399995  ,
43123   ,
357971  ,
187845  ,
191289  ,
376213  ,
274327  ,
70685   ,
496117  ,
436651  ,
98781   ,
84685   ,
496219  ,
381455  ,
519227  ,
105139  ,
134361  ,
119783  ,
520601  ,
182993  ,
426961  ,
484215  ,
266397  ,
92063   ,
337611  ,
71971   ,
182159  ,
188661  ,
365617  ,
384753  ,
240767  ,
101409  ,
161327  ,
506943  ,
256027  ,
302137  ,
67645   ,
348261  ,
345987  ,
82821   ,
150803  ,
325899  ,
404195  ,
188267  ,
359553  ,
201053  ,
451231  ,
122159  ,
428825  ,
300001  ,
239827  ,
240505  ,
111697  ,
114993  ,
382993  ,
504095  ,
92953   ,
31055   ,
12415   ,
471701  ,
523843  ,
399053  ,
142157  ,
463061  ,
344901  ,
15261   ,
77597   ,
53621   ,
348477  ,
251199  ,
157473  ,
509391  ,
210805  ,
15897   ,
393641  ,
220813  ,
261059  ,
410533  ,
208967  ,
61221   ,
324269  ,
255081  ,
243429  ,
472605  ,
340355  ,
342415  ,
290549  ,
19233   ,
231415  ,
38129   ,
336093  ,
95105   ,
356135  ,
266969  ,
175567  ,
220899  ,
50559   ,
152993  ,
420781  ,
147901  ,
340071  ,
433337  ,
296001  ,
97643   ,
82999   ,
153235  ,
232469  ,
484127  ,
509209  ,
225935  ,
165029  ,
280795  ,
178743  ,
396733  ,
187401  ,
476681  ,
427987  ,
371647  ,
442333  ,
252751  ,
500279  ,
505525  ,
86069   ,
302563  ,
4211    ,
523349  ,
478235  ,
74715   ,
9811    ,
79187   ,
415707  ,
152677  ,
8705    ,
65633   ,
512413  ,
321389  ,
286109  ,
76449   ,
425091  ,
150889  ,
479623  ,
390699  ,
265491  ,
419375  ,
339093  ,
204437  ,
403761  ,
63611   ,
196023  ,
5275    ,
100891  ,
487817  ,
177757  ,
274609  ,
422595  ,
278453  ,
449891  ,
313533  ,
416379  ,
287459  ,
271185  ,
15157   ,
23899   ,
108647  ,
186121  ,
401865  ,
55575   ,
137257  ,
80251   ,
355575  ,
42785   ,
390551  ,
341507  ,
96395   ,
388869  ,
312861  ,
428629  ,
345403  ,
453043  ,
520185  ,
340719  ,
89113   ,
456847  ,
26443   ,
395151  ,
400067  ,
104043  ,
331805  ,
31851   ,
436119  ,
267453  ,
426859  ,
420975  ,
222361  ,
228719  ,
314499  ,
253255  ,
179205  ,
21913   ,
237367  ,
446799  ,
55215   ,
87065   ,
354759  ,
312269  ,
380985  ,
314597  ,
375011  ,
427975  ,
442223  ,
200205  ,
355365  ,
159521  ,
433587  ,
37009   ,
384581  ,
517681  ,
265183  ,
507793  ,
485677  ,
406795  ,
521221  ,
42905   ,
42801   ,
367403  ,
213261  ,
231513  ,
327445  ,
90737   ,
146609  ,
384599  ,
177263  ,
315803  ,
420995  ,
324535  ,
149045  ,
255307  ,
353567  ,
484105  ,
258643  ,
247651  ,
510129  ,
367611  ,
171533  ,
99737   ,
463885  ,
342199  ,
260187  ,
323999  ,
281565  ,
499463  ,
265363  ,
205191  ,
218005  ,
480559  ,
311857  ,
184369  ,
507099  ,
447181  ,
76885   ,
489651  ,
460399  ,
155405  ,
97045   ,
479457  ,
91797   ,
307625  ,
439111  ,
508425  ,
280013  ,
356537  ,
389131  ,
401625  ,
260063  ,
220893  ,
68101   ,
225739  ,
507077  ,
280249  ,
267057  ,
290483  ,
88615   ,
268599  ,
489411  ,
124139  ,
442543  ,
360803  ,
108283  ,
27551   ,
365841  ,
400361  ,
515937  ,
222079  ,
187495  ,
295913  ,
278573  ,
253391  ,
244133  ,
149387  ,
113547  ,
72625   ,
359225  ,
21411   ,
66215   ,
358143  ,
154407  ,
310129  ,
311171  ,
336777  ,
387059  ,
392637  ,
20983   ,
215445  ,
73507   ,
480539  ,
146005  ,
358205  ,
337089  ,
216223  ,
237273  ,
311809  ,
160077  ,
196261  ,
219291  ,
295297  ,
145157  ,
192731  ,
501031  ,
117053  ,
283741  ,
233405  ,
374815  ,
459171  ,
247821  ,
97833   ,
400387  ,
110309  ,
371049  ,
82621   ,
21431   ,
95263   ,
311871  ,
278233  ,
492421  ,
357303  ,
420073  ,
249513  ,
85899   ,
74725   ,
192237  ,
392317  ,
319873  ,
400469  ,
477939  ,
444613  ,
193859  ,
307227  ,
462421  ,
256599  ,
116289  ,
144621  ,
120265  ,
292939  ,
14845   ,
449191  ,
466665  ,
46143   ,
423743  ,
407169  ,
477021  ,
229859  ,
163795  ,
20811   ,
436485  ,
25865   ,
342363  ,
245583  ,
400783  ,
466897  ,
212751  ,
459887  ,
272911  ,
440337  ,
132387  ,
474461  ,
18991   ,
467455  ,
492867  ,
451837  ,
241561  ,
252139  ,
91121   ,
263195  ,
127091  ,
501831  ,
285761  ,
359443  ,
116241  ,
116905  ,
351067  ,
289347  ,
292953  ,
59193   ,
440405  ,
315411  ,
470201  ,
154737  ,
361361  ,
160249  ,
110323  ,
49813   ,
87771   ,
66963   ,
222943  ,
449669  ,
40209   ,
17381   ,
484171  ,
120117  ,
492279  ,
230625  ,
318761  ,
369741  ,
414375  ,
207479  ,
189357  ,
200417  ,
354391  ,
364879  ,
72915   ,
226439  ,
457299  ,
253769  ,
175007  ,
203497  ,
463903  ,
284083  ,
386061  ,
132227  ,
287853
};

}

void LatticeRule::getRule(type name, std::vector<Real>& Z, Integer N)
{

    Size ruleLength = 3600;
    Z.resize(ruleLength);

    QL_REQUIRE( N >= 1024 && N <= std::pow(2.9,20),
        "N must be between 2 to 10 and 2 to the 20 for these lattice rules ");

    // put in check that N is a power of 2


    const Real* dumbPointer = nullptr;

    switch (name)
    {
        case A:
            dumbPointer = latticeA;
            break;
        case  B:
            dumbPointer = latticeB;
            break;
        case  C:
            dumbPointer = latticeC;
            break;
        case  D:
            dumbPointer = latticeD;

    }

    QL_REQUIRE(dumbPointer != nullptr, "unknown lattice rule requested");


    std::copy(dumbPointer, dumbPointer+ruleLength,Z.begin());

}

}
