% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latte-count.R
\name{latte-count}
\alias{latte-count}
\alias{count_core}
\alias{latte_count}
\alias{latte_fcount}
\title{Count integer points in a polytope}
\usage{
count_core(spec, dir = tempdir(), quiet = TRUE, mpoly = TRUE, ...)

latte_count(spec, dir = tempdir(), quiet = TRUE, mpoly = TRUE, ...)

latte_fcount(spec, dir = tempdir(), quiet = TRUE, mpoly = TRUE, ...)
}
\arguments{
\item{spec}{Specification, see details and examples}

\item{dir}{Directory to place the files in, without an ending /}

\item{quiet}{Show latte output?}

\item{mpoly}{When opts = "--ehrhart-polynomial", return the mpoly version of
it}

\item{...}{Additional arguments to pass to the function, see count --help at
the command line to see examples.  Note that dashes - should be specified
with underscores _}
}
\value{
The count.  If the count is a number has less than 10 digits, an
integer is returned.  If the number has 10 or more digits, an integer in a
character string is returned. You may want to use the gmp package's as.bigz
to parse it.
}
\description{
\code{latte_count} uses LattE's count function to count the (integer) lattice
points in a polytope and compute Ehrhart polynomials.
}
\details{
The specification should be one of the following: (1) a character string or
strings containing an inequality in the mpoly expression format (see
examples), (2) a list of vertices, (3) a list of A and b for the equation Ax
<= b (see examples), or (4) raw code for LattE's count program. If a
character vector is supplied, (1) and (4) are distinguished by the number of
strings.

Behind the scenes, count works by writing a latte file and running count on
it.  If a specification other than a length one character is given to it
(which is considered to be the code), count attempts to convert it into LattE
code and then run count on it.
}
\examples{

if (has_latte()) {

spec <- c("x + y <= 10", "x >= 1", "y >= 1")
latte_count(spec) # 45
latte_count(spec, quiet = FALSE) # 45
latte_count(spec, dilation = 10) # 3321
latte_count(spec, homog = TRUE) # 45

# by default, the output from LattE is in
list.files(tempdir())
list.files(tempdir(), recursive = TRUE)

# ehrhart polynomials
latte_count(spec, ehrhart_polynomial = TRUE)
latte_count(spec, ehrhart_polynomial = TRUE, mpoly = FALSE)

# ehrhart series (raw since mpoly can't handle rational functions)
latte_count(spec, ehrhart_series = TRUE)

# simplified ehrhart series - not yet implemented
#latte_count(spec, simplified_ehrhart_polynomial = TRUE)

# first terms of the ehrhart series
latte_count(spec, ehrhart_taylor = 1)
# latte_count(spec, ehrhart_taylor = 2)
# latte_count(spec, ehrhart_taylor = 3)
# latte_count(spec, ehrhart_taylor = 4)

# multivariate generating function
latte_count(spec, multivariate_generating_function = TRUE)


# by vertices
spec <- list(c(1,1), c(10,1), c(1,10), c(10,10))
latte_count(spec)
latte_count(spec, vrep = TRUE)

code <- "
5 3
1 -1  0
1  0 -1
1 -1 -1
0  1  0
0  0  1
"
latte_count(code)


# for Ax <= b, see this example from the latte manual p.10
A <- matrix(c(
   1,  0,
   0,  1,
   1,  1,
  -1,  0,
   0, -1
), nrow = 5, byrow = TRUE)
b <- c(1, 1, 1, 0, 0)
latte_count(list(A = A, b = b))









}


}
