% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_quality_assurance.R
\name{testPackage}
\alias{testPackage}
\title{Test and Validate the rpact Package Installation}
\usage{
testPackage(
  outDir = ".",
  ...,
  completeUnitTestSetEnabled = TRUE,
  connection = list(token = NULL, secret = NULL),
  testFileDirectory = NA_character_,
  downloadTestsOnly = FALSE,
  addWarningDetailsToReport = TRUE,
  reportType = c("compact", "detailed", "Rout"),
  testInstalledBasicPackages = TRUE,
  scope = c("basic", "devel", "both", "internet", "all"),
  openHtmlReport = TRUE,
  keepSourceFiles = FALSE
)
}
\arguments{
\item{outDir}{The absolute path to the output directory where all test results will be saved.
By default, the current working directory is used.}

\item{...}{Ensures that all arguments (starting from the "...") are to be named and
that a warning will be displayed if unknown arguments are passed.}

\item{completeUnitTestSetEnabled}{If \code{TRUE} (default), all existing unit tests will
be executed; if \code{FALSE}, only a subset of tests is run.}

\item{connection}{A \code{list} allowing owners of the rpact validation documentation
to provide \code{token} and \code{secret} credentials for full access to unit tests,
enabling them to meet regulatory requirements (see \href{https://www.rpact.com}{www.rpact.com} for more information).}

\item{testFileDirectory}{An optional path pointing to a local directory containing test files.}

\item{downloadTestsOnly}{If \code{TRUE}, the unit test files are only downloaded and not executed.
Default is \code{FALSE}.}

\item{addWarningDetailsToReport}{If \code{TRUE}, additional warning details are included in the test report.
Default is \code{TRUE}.}

\item{reportType}{The type of report to generate.
Can be \code{"compact"}, \code{"detailed"}, or \code{"Rout"}.}

\item{testInstalledBasicPackages}{If \code{TRUE}, tests for installed
basic R packages are included, default is \code{TRUE}.
For more information, see \code{\link[tools]{testInstalledBasic}}.}

\item{scope}{The scope of the basic R package tests to run. Can be \code{"basic"},
\code{"devel"}, \code{"both"}, \code{"internet"}, or \code{"all"}. Default is \code{"basic"}.
For more information, see \code{\link[tools]{testInstalledBasic}}.
Only available if \code{testInstalledBasicPackages = TRUE}.}

\item{openHtmlReport}{If \code{TRUE}, the HTML report is opened after the tests are completed, default is \code{TRUE}.}

\item{keepSourceFiles}{If \code{TRUE}, the source files are kept after the tests are completed.
A copy of them can be found in the subdirectory \code{src}.}
}
\value{
Invisibly returns the value of \code{completeUnitTestSetEnabled}.
}
\description{
This function ensures the correct installation of the \code{rpact} package by performing
various tests. It supports a comprehensive validation process, essential for GxP compliance
and other regulatory requirements.
}
\details{
This function is integral to the installation qualification (IQ) process of the \code{rpact} package,
ensuring it meets quality standards and functions as expected. A directory named \code{rpact-tests}
is created within the specified output directory, where all test files are downloaded from a secure
resource and executed. Results are saved in the file \code{testthat.Rout}, located in the
\code{rpact-tests} directory.

Installation qualification is a critical step in the validation process. Without successful IQ,
the package cannot be considered fully validated. To gain access to the full set of unit tests,
users must provide \code{token} and \code{secret} credentials, which are distributed to
members of the rpact user group as part of the validation documentation.
For more information, see vignette \href{https://www.rpact.org/vignettes/utilities/rpact_installation_qualification/}{rpact_installation_qualification}.
}
\examples{
\dontrun{
# Set the output directory
setwd("/path/to/output")

# Basic usage
testPackage()

# Perform all unit tests with access credentials
testPackage(
    connection = list(
        token = "your_token_here",
        secret = "your_secret_here"
    )
)

# Download test files without executing them
testPackage(downloadTestsOnly = TRUE)
}

}
\references{
For more information, please visit: \url{https://www.rpact.org/vignettes/utilities/rpact_installation_qualification/}
}
