// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from ModbusCfg.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {
  public class ModbusCfg : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.ModbusCfg:1.0.0", null);

    public ModbusCfg(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public ModbusCfg(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new ModbusCfg StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new ModbusCfg(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class SerialSettings : ICloneable {
      public object Clone() {
        SerialSettings copy = new SerialSettings();
        copy.baud = this.baud;
        copy.parity = this.parity;
        copy.dataBits = this.dataBits;
        copy.stopBits = this.stopBits;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["baud"] = this.baud;
        json["parity"] = (int)this.parity;
        json["dataBits"] = this.dataBits;
        json["stopBits"] = this.stopBits;
        return json;
      }

      public static SerialSettings Decode(LightJson.JsonObject json, Agent agent) {
        SerialSettings inst = new SerialSettings();
        inst.baud = (int)json["baud"];
        inst.parity = (Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings.Parity)(int)json["parity"];
        inst.dataBits = (int)json["dataBits"];
        inst.stopBits = (int)json["stopBits"];
        return inst;
      }


      public enum Parity {
        NONE,
        EVEN,
        ODD,
      }
      public int baud = 0;
      public Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings.Parity parity = Com.Raritan.Idl.peripheral.ModbusCfg.SerialSettings.Parity.NONE;
      public int dataBits = 0;
      public int stopBits = 0;
    }

    public enum ModbusFunction {
      COIL,
      DISCRETE_INPUT,
      HOLDING_REGISTER,
      INPUT_REGISTER,
    }

    public const int EXCEPTION_ILLEGAL_FUNCTION = 1;

    public const int EXCEPTION_ILLEGAL_DATA_ADDRESS = 2;

    public const int EXCEPTION_ILLEGAL_DATA_VALUE = 3;

    public const int EXCEPTION_SLAVE_OR_SERVER_FAILURE = 4;

    public const int EXCEPTION_ACKNOWLEDGE = 5;

    public const int EXCEPTION_SLAVE_OR_SERVER_BUSY = 6;

    public const int EXCEPTION_NEGATIVE_ACKNOWLEDGE = 7;

    public const int EXCEPTION_MEMORY_PARITY = 8;

    public const int EXCEPTION_GATEWAY_PATH = 10;

    public const int EXCEPTION_GATEWAY_TARGET = 11;

    public enum SpecificModbusErrors {
      ERROR_BADCRC,
      ERROR_BADDATA,
      ERROR_BADEXC,
      ERROR_UNKEXC,
      ERROR_MDATA,
      ERROR_OTHER,
    }

  }
}
