// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2025 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from TacPlusManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.auth {
  public class TacPlusManager_1_0_1 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("auth.TacPlusManager:1.0.1", null);

    public TacPlusManager_1_0_1(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public TacPlusManager_1_0_1(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new TacPlusManager_1_0_1 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new TacPlusManager_1_0_1(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum AuthenType {
      ASCII,
      PAP,
      CHAP,
      MSCHAP,
    }

    public class ServerSettings : ICloneable {
      public object Clone() {
        ServerSettings copy = new ServerSettings();
        copy.server = this.server;
        copy.port = this.port;
        copy.timeoutSeconds = this.timeoutSeconds;
        copy.retries = this.retries;
        copy.sharedSecret = this.sharedSecret;
        copy.authenType = this.authenType;
        copy.disableAccounting = this.disableAccounting;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["server"] = this.server;
        json["port"] = this.port;
        json["timeoutSeconds"] = this.timeoutSeconds;
        json["retries"] = this.retries;
        json["sharedSecret"] = this.sharedSecret;
        json["authenType"] = (int)this.authenType;
        json["disableAccounting"] = this.disableAccounting;
        return json;
      }

      public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
        ServerSettings inst = new ServerSettings();
        inst.server = (string)json["server"];
        inst.port = (int)json["port"];
        inst.timeoutSeconds = (int)json["timeoutSeconds"];
        inst.retries = (int)json["retries"];
        inst.sharedSecret = (string)json["sharedSecret"];
        inst.authenType = (Com.Raritan.Idl.auth.TacPlusManager_1_0_1.AuthenType)(int)json["authenType"];
        inst.disableAccounting = (bool)json["disableAccounting"];
        return inst;
      }

      public string server = "";
      public int port = 0;
      public int timeoutSeconds = 0;
      public int retries = 0;
      public string sharedSecret = "";
      public Com.Raritan.Idl.auth.TacPlusManager_1_0_1.AuthenType authenType = Com.Raritan.Idl.auth.TacPlusManager_1_0_1.AuthenType.ASCII;
      public bool disableAccounting = false;
    }

    public const int ERR_INVALID_CFG = 1;

    public const int ERR_SERVER_UNSPECIFIED = 2;

    public const int ERR_INVALID_SHARED_SECRET = 3;

    public const int ERR_SERVER_UNREACHABLE = 4;

    public const int ERR_AUTHENTICATION_FAILED = 5;

    public const int ERR_NO_ROLES = 6;

    public const int ERR_NO_KNOWN_ROLES = 7;

    public class GetTacPlusServersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings> _ret_;
    }

    public GetTacPlusServersResult getTacPlusServers() {
      JsonObject _parameters = null;
      var _result = RpcCall("getTacPlusServers", _parameters);
      var _ret = new GetTacPlusServersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings.Decode(_value, agent)));
      return _ret;
    }

    public AsyncRequest getTacPlusServers(AsyncRpcResponse<GetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getTacPlusServers(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getTacPlusServers(AsyncRpcResponse<GetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getTacPlusServers", _parameters,
        _result => {
          try {
            var _ret = new GetTacPlusServersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings.Decode(_value, agent)));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetTacPlusServersResult {
      public int _ret_;
    }

    public SetTacPlusServersResult setTacPlusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings> serverList) {
      var _parameters = new LightJson.JsonObject();
      _parameters["serverList"] = new JsonArray(serverList.Select(
        _value => (JsonValue)(_value.Encode())));

      var _result = RpcCall("setTacPlusServers", _parameters);
      var _ret = new SetTacPlusServersResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setTacPlusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings> serverList, AsyncRpcResponse<SetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setTacPlusServers(serverList, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setTacPlusServers(System.Collections.Generic.IEnumerable<Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings> serverList, AsyncRpcResponse<SetTacPlusServersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["serverList"] = new JsonArray(serverList.Select(
          _value => (JsonValue)(_value.Encode())));
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setTacPlusServers", _parameters,
        _result => {
          try {
            var _ret = new SetTacPlusServersResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class TestTacPlusServerResult {
      public int _ret_;
    }

    public TestTacPlusServerResult testTacPlusServer(string username, string password, Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings settings) {
      var _parameters = new LightJson.JsonObject();
      _parameters["username"] = username;
      _parameters["password"] = password;
      _parameters["settings"] = settings.Encode();

      var _result = RpcCall("testTacPlusServer", _parameters);
      var _ret = new TestTacPlusServerResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest testTacPlusServer(string username, string password, Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings settings, AsyncRpcResponse<TestTacPlusServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return testTacPlusServer(username, password, settings, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest testTacPlusServer(string username, string password, Com.Raritan.Idl.auth.TacPlusManager_1_0_1.ServerSettings settings, AsyncRpcResponse<TestTacPlusServerResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["username"] = username;
        _parameters["password"] = password;
        _parameters["settings"] = settings.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("testTacPlusServer", _parameters,
        _result => {
          try {
            var _ret = new TestTacPlusServerResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
