# How you can help: your first commits!

If you're interested in contributing to Bundler, that's awesome! We'd love your help.

If at any point you get stuck, here's how to [get in touch with the Bundler team for help](https://slack.bundler.io).

## First contribution suggestions

We track [small bugs and features](https://github.com/rubygems/rubygems/issues?q=is%3Aissue+is%3Aopen+label%3Abundler+label%3A%22good+first+issue%22) so that anyone who wants to help can start with something that's not too overwhelming.

Generally, great ways to get started helping out with Bundler are:

  - using prerelease versions (run `gem install bundler --pre`)
  - [reporting bugs you encounter or suggesting new features](https://github.com/rubygems/rubygems/issues/new?labels=Bundler&template=bundler-related-issue.md)
    - see the [new features documentation](../development/NEW_FEATURES.md) for more
  - adding to or editing [the Bundler documentation website](https://bundler.io) and [Bundler man pages](https://bundler.io/man/bundle.1.html)
  - [checking issues for completeness](BUG_TRIAGE.md)
  - closing issues that are not complete
  - adding a failing test for reproducible [reported bugs](https://github.com/rubygems/rubygems/issues)
  - reviewing [pull requests](https://github.com/rubygems/rubygems/pulls) and suggesting improvements
  - improving existing code, including suggestions from [CodeClimate](https://codeclimate.com/github/rubygems/rubygems)
  - writing code (no patch is too small! fix typos or bad whitespace)
    - get started setting up your dev environment with [these instructions](../development/SETUP.md)
  - backfilling [unit tests](https://github.com/rubygems/rubygems/tree/master/bundler/spec/bundler) for modules that lack coverage.

If nothing on those lists looks good, [talk to us](https://slack.bundler.io/), and we'll figure out what you can help with. We can absolutely use your help, no matter what level of programming skill you have at the moment.
