# 2021-09-14 Triage Log

Fairly busy week, with some large improvements on several benchmarks. Several
larger rollups landed, in part due to recovery from a temporary CI outage, which
has complicated some of the performance monitoring work. These should, however,
now be resolved.

Triage done by **@simulacrum**.
Revision range: [69c4aa2901ffadf69deaf91b2f90604bcbc2eb36..9f85cd6f2ab2769c16e89dcdddb3e11d9736b351](https://perf.rust-lang.org/?start=69c4aa2901ffadf69deaf91b2f90604bcbc2eb36&end=9f85cd6f2ab2769c16e89dcdddb3e11d9736b351&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 5 Mixed; 2 of them in rollups

31 comparisons made in total

#### Regressions

Encode spans relative to the enclosing item [#84373](https://github.com/rust-lang/rust/issues/84373)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=8c2b6ea37d7719a0370bd404030eef9702c1752c&end=547d9374d26f203ab963b3ffe1ed36bd70f16633&stat=instructions:u) (up to 2.1% on `incr-unchanged` builds of `tuple-stress`)
- Regressions are much smaller on "full" benchmarks (<0.5%). This support has
  also landed gated behind a -Z flag, so the incremental cost is being paid
  without the possible wins.

Rollup of 7 pull requests [#88881](https://github.com/rust-lang/rust/issues/88881)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=9ef27bf7dc50a8b51435579b4f2e86f7ee3f7a94&end=c7dbe7a830100c70d59994fd940bf75bb6e39b39&stat=instructions:u) (up to 2.1% on `full` builds of `inflate`)
- No clear cause. Investigation is partially ongoing, but may warrant an
  assignee -- there's several possible candidates.

#### Improvements

Rollup of 10 pull requests [#88857](https://github.com/rust-lang/rust/issues/88857)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=641e02f388acc6b1d316a59c605a32d1711a8758&end=43769af69e43d0fb9770f0a392671f000595df78&stat=instructions:u) (up to -45.0% on `full` builds of `coercions`)
- Unexpected improvement, though certainly nice to see. Suspected cause is
  [#88147](https://github.com/rust-lang/rust/pull/88147), but this has not been
  verified.

Use FxHashSet instead of Vec for well formed tys [#88771](https://github.com/rust-lang/rust/issues/88771)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=0212c70b1df2aa542aef48d5fcde0af3734970c6&end=9ef27bf7dc50a8b51435579b4f2e86f7ee3f7a94&stat=instructions:u) (up to -2.6% on `full` builds of `externs`)


#### Mixed

Split rustc_mir [#80522](https://github.com/rust-lang/rust/issues/80522)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=47ae8deb8a35030bdc4e502b03400800864cc264&end=97032a6dfacdd3548e4bff98c90a6b3875a14077&stat=instructions:u) (up to -2.0% on `full` builds of `deeply-nested-async`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=47ae8deb8a35030bdc4e502b03400800864cc264&end=97032a6dfacdd3548e4bff98c90a6b3875a14077&stat=instructions:u) (up to 0.8% on `full` builds of `await-call-tree`)
- Mixed results. Noted in a comment that this also was a slight regression in
  bootstrap time as measured by perf.rust-lang.org, which seems unfortunate and
  may merit some investigation.

Rollup of 15 pull requests [#88824](https://github.com/rust-lang/rust/issues/88824)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=b69fe57261086e70aea9d5b58819a1794bf7c121&end=22719efcc570b043f2e519d6025e5f36eab38fe2&stat=instructions:u) (up to -0.7% on `incr-patched: println` builds of `html5ever`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=b69fe57261086e70aea9d5b58819a1794bf7c121&end=22719efcc570b043f2e519d6025e5f36eab38fe2&stat=instructions:u) (up to 1.0% on `incr-unchanged` builds of `derive`)
- Report seems a little bit close to noise, and is definitely mixed. No clear
  cause, but also a fairly large rollup.

Refactor query forcing [#78780](https://github.com/rust-lang/rust/issues/78780)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=43769af69e43d0fb9770f0a392671f000595df78&end=8c2b6ea37d7719a0370bd404030eef9702c1752c&stat=instructions:u) (up to -0.9% on `incr-full` builds of `unused-warnings`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=43769af69e43d0fb9770f0a392671f000595df78&end=8c2b6ea37d7719a0370bd404030eef9702c1752c&stat=instructions:u) (up to 1.3% on `incr-patched: println` builds of `coercions`)
- Solid improvement in rustc_query_impl compile times (8%). Overall looks like
  results are overall more of an improvement than a regression.

Update LLVM submodule [#88765](https://github.com/rust-lang/rust/issues/88765)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=0273e3bce7a0ce49e96a9662163e2380cb87e0be&end=0212c70b1df2aa542aef48d5fcde0af3734970c6&stat=instructions:u) (up to -0.7% on `full` builds of `ctfe-stress-4`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=0273e3bce7a0ce49e96a9662163e2380cb87e0be&end=0212c70b1df2aa542aef48d5fcde0af3734970c6&stat=instructions:u) (up to 0.7% on `incr-unchanged` builds of `ripgrep`)
- Fairly mixed results, no clear picture either way.

#### Untriaged Pull Requests

- [#88881 Rollup of 7 pull requests](https://github.com/rust-lang/rust/pull/88881)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88765 Update LLVM submodule](https://github.com/rust-lang/rust/pull/88765)
- [#88710 Use index newtyping for TyVid](https://github.com/rust-lang/rust/pull/88710)
- [#88597 Move global analyses from lowering to resolution](https://github.com/rust-lang/rust/pull/88597)
- [#88552 Stop allocating vtable entries for non-object-safe methods](https://github.com/rust-lang/rust/pull/88552)
- [#88533 Concrete regions can show up in mir borrowck if the originated from there](https://github.com/rust-lang/rust/pull/88533)
- [#88530 Shrink Session a bit](https://github.com/rust-lang/rust/pull/88530)
- [#88435 Avoid invoking the hir_crate query to traverse the HIR](https://github.com/rust-lang/rust/pull/88435)
- [#87815 encode `generics_of` for fields and ty params](https://github.com/rust-lang/rust/pull/87815)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87688 Introduce `let...else`](https://github.com/rust-lang/rust/pull/87688)
- [#87640 Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/87640)
- [#87587 Various refactorings of the TAIT infrastructure](https://github.com/rust-lang/rust/pull/87587)
- [#87244 Better diagnostics with mismatched types due to implicit static lifetime](https://github.com/rust-lang/rust/pull/87244)
- [#86898 Add fast path for Path::cmp that skips over long shared prefixes](https://github.com/rust-lang/rust/pull/86898)
- [#86777 Include terminators in instance size estimate](https://github.com/rust-lang/rust/pull/86777)
- [#86698 Move OnDiskCache to rustc_query_impl.](https://github.com/rust-lang/rust/pull/86698)
- [#86588 Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/86588)
- [#86034 Change entry point to 🛡️ against 💥 💥-payloads](https://github.com/rust-lang/rust/pull/86034)
- [#85556 Warn about unreachable code following an expression with an uninhabited type](https://github.com/rust-lang/rust/pull/85556)
- [#84560 Inline Iterator as IntoIterator.](https://github.com/rust-lang/rust/pull/84560)
- [#84373 Encode spans relative to the enclosing item](https://github.com/rust-lang/rust/pull/84373)
- [#83302 Get piece unchecked in `write`](https://github.com/rust-lang/rust/pull/83302)
- [#80522 Split rustc_mir](https://github.com/rust-lang/rust/pull/80522)
