# 2023-03-14 Triage Log

A fairly mixed week, with several significant improvements and a few
significant regressions. On average, this week saw a slight increase in compile
times.

Triage done by **@simulacrum**.
Revision range: [8f9e09ac3ef3fa85d23ad6a0c920d49987144b13..0058748944abb3282aba0e0a74823c6411703565](https://perf.rust-lang.org/?start=8f9e09ac3ef3fa85d23ad6a0c920d49987144b13&end=0058748944abb3282aba0e0a74823c6411703565&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.8%  | [0.3%, 6.7%]    | 52    |
| Regressions ❌ <br /> (secondary)  | 12.3% | [0.2%, 139.9%]  | 45    |
| Improvements ✅ <br /> (primary)   | -0.9% | [-2.8%, -0.2%]  | 45    |
| Improvements ✅ <br /> (secondary) | -2.2% | [-11.2%, -0.2%] | 52    |
| All ❌✅ (primary)                 | 0.5%  | [-2.8%, 6.7%]   | 97    |


4 Regressions, 6 Improvements, 4 Mixed; 2 of them in rollups
39 artifact comparisons made in total

#### Regressions

Update cargo [#108665](https://github.com/rust-lang/rust/pull/108665) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7c306f6dcd600b1fcc74439c780e8ebef338d84c&end=900c3540378c8422b8087ffa3db60fa6c8abfcad&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.3%, 0.4%]   | 8     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.1%, 0.5%]   | 13    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.3%  | [0.3%, 0.4%]   | 8     |

Noise, most likely, based on small deltas. Marked as triaged.

Make RPITITs simple cases work when using lower_impl_trait_in_trait_to_assoc_ty [#108700](https://github.com/rust-lang/rust/pull/108700) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=542ed2bf72b232b245ece058fc11aebb1ca507d7&end=9455a5591b1435dfc9a88b2922d0dfc155d9614f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.6%  | [0.2%, 1.2%]   | 93    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.2%, 2.9%]   | 45    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.5% | [-1.5%, -1.5%] | 1     |
| All ❌✅ (primary)                 | 0.6%  | [0.2%, 1.2%]   | 93    |

Regressions largely resolved in
[#109057](https://github.com/rust-lang/rust/pull/109057); essentially all
regressions are to incremental workloads.

Move `Option::as_slice` to an always-sound implementation [#108623](https://github.com/rust-lang/rust/pull/108623) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f1b1ed7e18f1fbe5226a96626827c625985f8285&end=cf8d98b227fd3c7e50aa5a9453141c5edbf5df38&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.8%, 0.9%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.4%, 0.7%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.8%, 0.9%] | 3     |

Minor regressions in incremental scenarios for a few workloads; not concerning
enough to warrant further investigation.

Rollup of 9 pull requests [#109097](https://github.com/rust-lang/rust/pull/109097) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=22f247c6f3ed388cb702d01c2ff27da658a8b353&end=c54af457d05722321ca88c2ae0e5706ef803c5fb&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.9%  | [0.3%, 2.7%]   | 17    |
| Regressions ❌ <br /> (secondary)  | 3.6%  | [0.6%, 11.4%]  | 17    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.4%, -0.3%] | 2     |
| All ❌✅ (primary)                 | 0.9%  | [0.3%, 2.7%]   | 17    |

Regression triaged to "Treat projections with infer as placeholder during fast
reject in new solver" [#108830](https://github.com/rust-lang/rust/pull/108830).
Pinged author/reviewer on that PR.

#### Improvements

Move dep graph methods to DepGraphData to avoid branches and `unwrap`s [#108417](https://github.com/rust-lang/rust/pull/108417) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8a73f50d875840b8077b8ec080fa41881d7ce40d&end=542ed2bf72b232b245ece058fc11aebb1ca507d7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 5     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 6     |


Avoid unnecessary hashing [#108794](https://github.com/rust-lang/rust/pull/108794) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=501ad021b9a4fb2cd6a39e0302d22f169f6166b0&end=150cb381471533050751111e5faf1d9f05c02f77&stat=instructions:u)

| (instructions:u)                   | mean  | range           | count |
|:----------------------------------:|:-----:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -               | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -               | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.9%, -0.2%]  | 68    |
| Improvements ✅ <br /> (secondary) | -2.0% | [-11.3%, -0.2%] | 53    |
| All ❌✅ (primary)                 | -0.8% | [-2.9%, -0.2%]  | 68    |


rustdoc: reduce allocs in FnDecl::inner_full_print [#109011](https://github.com/rust-lang/rust/pull/109011) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b05bb2900825e4d063ebf3f0f11afb08baed3bc6&end=d610b0c514b9ccb0dad5d0b77ce4c518f71b92c8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-1.0%, -0.4%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-2.3%, -0.3%] | 8     |
| All ❌✅ (primary)                 | -0.7% | [-1.0%, -0.4%] | 7     |


:arrow_up: `rust-analyzer` [#109069](https://github.com/rust-lang/rust/pull/109069) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cf8d98b227fd3c7e50aa5a9453141c5edbf5df38&end=8efa635b40ce6569e12f4988b7a9bcb7f3f0ed0c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.7%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.3%] | 2     |
| All ❌✅ (primary)                 | -0.7% | [-0.8%, -0.7%] | 3     |


resolve: Querify most cstore access methods (subset) [#108992](https://github.com/rust-lang/rust/pull/108992) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c54af457d05722321ca88c2ae0e5706ef803c5fb&end=bd43458d4c2a01af55f7032f7c47d7c8fecfe560&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.5%, 0.5%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.2%, -0.2%] | 15    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-2.1%, -1.1%] | 2     |
| All ❌✅ (primary)                 | -0.4% | [-1.2%, 0.5%]  | 16    |


Don't `opt_rpitit_info` as a separate query [#109057](https://github.com/rust-lang/rust/pull/109057) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=bd43458d4c2a01af55f7032f7c47d7c8fecfe560&end=0058748944abb3282aba0e0a74823c6411703565&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.1%, -0.2%] | 86    |
| Improvements ✅ <br /> (secondary) | -1.2% | [-2.7%, -0.2%] | 38    |
| All ❌✅ (primary)                 | -0.5% | [-1.1%, -0.2%] | 86    |


#### Mixed

always resolve to universal regions if possible [#108121](https://github.com/rust-lang/rust/pull/108121) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=60445fda58fc9f9aa413752530d6756ae5570f2f&end=7c306f6dcd600b1fcc74439c780e8ebef338d84c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.7%, 0.7%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.7%, -0.7%] | 9     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 3     |


Do not consider `&mut *x` as mutating `x` in `CopyProp` [#108178](https://github.com/rust-lang/rust/pull/108178) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6a179026decb823e6ad8ba1c81729528bc5d695f&end=66a2d6221069e0d08ceacf2a3201600e2092d2e0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 18    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.3%  | [-0.3%, 1.0%]  | 20    |


Rollup of 8 pull requests [#108934](https://github.com/rust-lang/rust/pull/108934) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f37f8549940386a9d066ba199983affff47afbb4&end=104f4300cfddbd956e32820ef202a732f06ec848&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.5%, 1.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.7%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.9% | [-1.0%, -0.7%] | 2     |


Strengthen state tracking in const-prop [#108872](https://github.com/rust-lang/rust/pull/108872) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7b4f48927dce585f747a58083b45ab62b9d73a53&end=b05bb2900825e4d063ebf3f0f11afb08baed3bc6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.4%  | [0.6%, 6.3%]   | 30    |
| Regressions ❌ <br /> (secondary)  | 41.6% | [0.3%, 139.3%] | 12    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | [-1.9%, -1.0%] | 2     |
| All ❌✅ (primary)                 | 2.4%  | [0.6%, 6.3%]   | 30    |

Regression triaged in [this comment](https://github.com/rust-lang/rust/pull/108178#issuecomment-1461875685).
