# 2024-04-16 Triage Log

A quiet week, with slightly more improvements than regressions.
There were a few noise spikes, but other than that nothing too interesting.

Triage done by **@Kobzol**.
Revision
range: [86b603cd..ccfcd950b](https://perf.rust-lang.org/?start=86b603cd792b3f6172ba4f676d7b586c1af7630a&end=ccfcd950b333fed046275dd8d54fe736ca498aa7&absolute=false&stat=instructions%3Au)

**Summary**:

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.5%  |  [0.3%, 1.4%]  |   9   |
| Regressions ❌ <br /> (secondary)  | 0.4%  |  [0.2%, 1.1%]  |  20   |
|  Improvements ✅ <br /> (primary)  | -0.6% | [-2.5%, -0.2%] |  41   |
| Improvements ✅ <br /> (secondary) | -0.8% | [-1.4%, -0.2%] |   4   |
|         All ❌✅ (primary)          | -0.4% | [-2.5%, 1.4%]  |  50   |

1 Regression, 3 Improvements, 6 Mixed; 5 of them in rollups
62 artifact comparisons made in total

#### Regressions

Implement syntax for `impl Trait` to specify its captures
explicitly (`feature(precise_capturing)`) [#123468](https://github.com/rust-lang/rust/pull/123468) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ccfcd950b333fed046275dd8d54fe736ca498aa7&end=26e6a2fdaa9443dfe37c77489bd4122119e3c900&stat=instructions:u)

|         (instructions:u)          | mean |    range     | count |
|:---------------------------------:|:----:|:------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.2% | [0.2%, 0.2%] |   5   |
| Regressions ❌ <br /> (secondary)  |  -   |      -       |   0   |
|  Improvements ✅ <br /> (primary)  |  -   |      -       |   0   |
| Improvements ✅ <br /> (secondary) |  -   |      -       |   0   |
|         All ❌✅ (primary)          | 0.2% | [0.2%, 0.2%] |   5   |

* A tiny regression on a stress test, introduced by a new feature.
* Marked as triaged.

#### Improvements

Remove my `scalar_copy_backend_type` optimization
attempt [#123185](https://github.com/rust-lang/rust/pull/123185) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5974fe87c4d711949caa64fc1e8366685c8fc190&end=c2239bca5b89a8d3573cc0fc0f2fa65c50edb79c&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -0.7% | [-0.7%, -0.7%] |   4   |
| Improvements ✅ <br /> (secondary) | -2.0% | [-2.7%, -1.2%] |   2   |
|         All ❌✅ (primary)          | -0.7% | [-0.7%, -0.7%] |   4   |

Rollup of 8 pull
requests [#123823](https://github.com/rust-lang/rust/pull/123823) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=616a8f85f153033d798b583c0ad0431924a738b0&end=a07f3eb43acc5df851e15176c7081a900a30a4d7&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -0.4% | [-1.1%, -0.2%] |  20   |
| Improvements ✅ <br /> (secondary) |   -   |       -        |   0   |
|         All ❌✅ (primary)          | -0.4% | [-1.1%, -0.2%] |  20   |

Rollup of 4 pull
requests [#123982](https://github.com/rust-lang/rust/pull/123982) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=99d0186b1d0547eae913eff04be272c9d348b9b8&end=3493a56529b3f972205f2cdda920132deef4b475&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -0.6% | [-0.8%, -0.3%] |   8   |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] |   1   |
|         All ❌✅ (primary)          | -0.6% | [-0.8%, -0.3%] |   8   |

#### Mixed

Only collect mono items from reachable
blocks [#123272](https://github.com/rust-lang/rust/pull/123272) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=86b603cd792b3f6172ba4f676d7b586c1af7630a&end=bb78dba64ca4158ef2f3488d0d41a82c75a504f2&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.4%  |  [0.2%, 1.5%]  |   8   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -0.8% | [-1.5%, -0.3%] |   6   |
| Improvements ✅ <br /> (secondary) |   -   |       -        |   0   |
|         All ❌✅ (primary)          | -0.1% | [-1.5%, 1.5%]  |  14   |

* Fixed an important bug, and results were mixed anyway.

Rollup of 7 pull
requests [#123725](https://github.com/rust-lang/rust/pull/123725) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e908cfd125ae9d98550edb9ffd8d7eae4be601ac&end=5974fe87c4d711949caa64fc1e8366685c8fc190&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.2%  |  [0.2%, 0.2%]  |   2   |
| Regressions ❌ <br /> (secondary)  | 0.9%  |  [0.2%, 2.6%]  |   7   |
|  Improvements ✅ <br /> (primary)  | -0.4% | [-0.6%, -0.2%] |   2   |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.6%, -0.6%] |   1   |
|         All ❌✅ (primary)          | -0.1% | [-0.6%, 0.2%]  |   4   |

* The largest regressions were noise, the rest was mixed.
* Marked as triaged.

Rollup of 8 pull
requests [#123762](https://github.com/rust-lang/rust/pull/123762) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aa067fb984d36462548bb785da221bfaf38253f0&end=4435924bb62cda0131e38dd5d2bba36f9616039f&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.4%  |  [0.2%, 0.5%]  |   2   |
| Regressions ❌ <br /> (secondary)  | 0.5%  |  [0.3%, 1.7%]  |   9   |
|  Improvements ✅ <br /> (primary)  |   -   |       -        |   0   |
| Improvements ✅ <br /> (secondary) | -2.8% | [-4.2%, -1.4%] |   2   |
|         All ❌✅ (primary)          | 0.4%  |  [0.2%, 0.5%]  |   2   |

* The largest regression on the `coercions` benchmark is noise.
* The rest were small regressions on `doc` benchmarks.
* Marked as triaged.

Rollup of 4 pull
requests [#123884](https://github.com/rust-lang/rust/pull/123884) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6cfd80942e4599a6e429e8a2aa27af38f5987aa0&end=59c38c06049fc3fba98bb046701eb2ab1777d998&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.4%  |  [0.4%, 0.4%]  |   1   |
| Regressions ❌ <br /> (secondary)  |   -   |       -        |   0   |
|  Improvements ✅ <br /> (primary)  | -1.0% | [-1.0%, -1.0%] |   1   |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] |   6   |
|         All ❌✅ (primary)          | -0.3% | [-1.0%, 0.4%]  |   2   |

* The single regression was immediately reverted, the rest were small improvements.
* Marked as triaged.

Re-enable `has_thread_local` for
i686-msvc [#123257](https://github.com/rust-lang/rust/pull/123257) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=59c38c06049fc3fba98bb046701eb2ab1777d998&end=f96442b4482fef6a50b65f2284bcfb8921320183&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   |   -   |       -        |   0   |
| Regressions ❌ <br /> (secondary)  | 0.3%  |  [0.3%, 0.4%]  |   6   |
|  Improvements ✅ <br /> (primary)  | -0.3% | [-0.3%, -0.3%] |   1   |
| Improvements ✅ <br /> (secondary) |   -   |       -        |   0   |
|         All ❌✅ (primary)          | -0.3% | [-0.3%, -0.3%] |   1   |

* This has to be noise, since the PR did not modify x64 Linux.

Get rid of `USIZE_MARKER` in formatting
infrastructure [#123819](https://github.com/rust-lang/rust/pull/123819) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0bf471f339837af930ec90ef5e1e9cb232e99f29&end=7ab5eb8fe7aee35aea8ed4aed8c34f6abd988cc5&stat=instructions:u)

|         (instructions:u)          | mean  |     range      | count |
|:---------------------------------:|:-----:|:--------------:|:-----:|
|  Regressions ❌ <br /> (primary)   | 0.6%  |  [0.4%, 0.9%]  |   2   |
| Regressions ❌ <br /> (secondary)  | 1.5%  |  [1.5%, 1.5%]  |   1   |
|  Improvements ✅ <br /> (primary)  | -0.4% | [-0.6%, -0.3%] |   5   |
| Improvements ✅ <br /> (secondary) |   -   |       -        |   0   |
|         All ❌✅ (primary)          | -0.1% | [-0.6%, 0.9%]  |   7   |

* More improvements than regressions.
