# 2021-05-25 Triage Log

A somewhat quiet week. Some PRs had performance runs performed on them, but the changes were merged despite this. Also, we still have issues with certain benchmarks being noisy. 

Triage done by **@rylev**.
Revision range: [25a277f03df7e44643ddfcc240d034409cb2f505..cdbe2888979bb8797b05f0d58a6f6e60753983d2](https://perf.rust-lang.org/?start=25a277f03df7e44643ddfcc240d034409cb2f505&end=cdbe2888979bb8797b05f0d58a6f6e60753983d2&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 1 Mixed
0 of them in rollups

#### Regressions

Make building THIR a stealable query [#85273](https://github.com/rust-lang/rust/issues/85273)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=126561cb31e8ebe1e2dd9dfd0d3ca621308dc56f&end=d568d63b1f9f5fc47e4202e2a2a84142ff6202d8&stat=instructions:u) (up to 3.7% on `incr-full` builds of `tuple-stress-check`)
- Work needed for other work to land. A performance run was performed, but still the change was allowed to land. I've asked [why](https://github.com/rust-lang/rust/pull/85273#issuecomment-848017988).

Implement the new desugaring from `try_trait_v2` [#84767](https://github.com/rust-lang/rust/issues/84767)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=491cf5561efb1f5ff33c3234ccd0bc5cacbebe3e&end=4e3e6db011c5b482d2bef8ba02274657f93b5e0d&stat=instructions:u) (up to 2.9% on `full` builds of `cranelift-codegen-check`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=491cf5561efb1f5ff33c3234ccd0bc5cacbebe3e&end=4e3e6db011c5b482d2bef8ba02274657f93b5e0d&stat=instructions:u) (up to -1.8% on `full` builds of `deeply-nested-async-check`)
- A much larger performance hit than when the performance suite was run while the pull request was open. This is largely a performance regression with only one non-volatile benchmark showing improvement. 
- Biggest change seems to be in the `mir_built` query which seems to make sense given that probably more mir will be produced by this change.
- Follow-up happening [here](https://github.com/rust-lang/rust/pull/84767#issuecomment-848036325).

#### Improvements

fix deallocation of immutable allocations [#85599](https://github.com/rust-lang/rust/issues/85599)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=6e92fb409816c65cd0a78a1fbcc71e2fbabdf50a&end=0f8cd43ee8c3614e04b5c624dd8a45758d7023da&stat=instructions:u) (up to -1.9% on `full` builds of `deeply-nested-async-check`)

std: Attempt again to inline thread-local-init across crates [#84876](https://github.com/rust-lang/rust/issues/84876)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e827cc21e0734edd26170e8d1481f0d66a1426b&end=3bcaeb0bf9e1c29d18abc32928fd2f23d1bed0bd&stat=instructions:u) (up to -1.8% on `incr-full` builds of `externs-debug`)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3e827cc21e0734edd26170e8d1481f0d66a1426b&end=3bcaeb0bf9e1c29d18abc32928fd2f23d1bed0bd&stat=instructions:u) (up to 1.3% on `full` builds of `regex-opt`)

#### Mixed

Avoid zero-length memcpy in formatting [#85391](https://github.com/rust-lang/rust/issues/85391)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=df70463ea5d701489d6f53dc780a2c16294d6143&end=a426fc37f2269093ef1a4dbb3e31b3247980fccc&stat=instructions:u) (up to 3.8% on `incr-patched: println` builds of `cargo-opt`)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=df70463ea5d701489d6f53dc780a2c16294d6143&end=a426fc37f2269093ef1a4dbb3e31b3247980fccc&stat=instructions:u) (up to -1.8% on `full` builds of `deeply-nested-async-debug`)
- This seems to have some interactions with LLVM codegen that cause certain benchmarks to fluctuate in performance. These largely cancel each other out.

#### Nags requiring follow up

- Follow-up:
    [#84767](https://github.com/rust-lang/rust/pull/84767#issuecomment-848036325).


