# 2024-10-08 Triage Log

One regression dominated this week (dealing with a correctness fix around type system caching that was deemed necessary), but it luckily did not produce large regressions in any benchmarks. Overall, performance still ended up relatively in the same place as the beginning of the week.

Triage done by **@rylev**.
Revision range: [c87004a1..e6c46db4](https://perf.rust-lang.org/?start=c87004a1f5be671e3f03f69fb13d8915bdbb6a52&end=e6c46db4e9fd11e3183c397a59d946731034ede6&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.1%, 1.0%]   | 63    |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [0.1%, 3.4%]   | 81    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-3.0%, -0.1%] | 19    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.5%, -0.1%] | 46    |
| All ❌✅ (primary)                 | 0.1%  | [-3.0%, 1.0%]  | 82    |


2 Regressions, 3 Improvements, 7 Mixed; 3 of them in rollups
57 artifact comparisons made in total

#### Regressions

Rollup of 4 pull requests [#131111](https://github.com/rust-lang/rust/pull/131111) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c817d5dc2050ec443516f9700c19b1419593a83d&end=06bb8364aaffefb0ce67e5f5445e66ec99c1f66e&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2% | [0.2%, 0.2%] | 4     |
| Regressions ❌ <br /> (secondary)  | -    | -            | 0     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.2% | [0.2%, 0.2%] | 4     |
- It seems like https://github.com/rust-lang/rust/pull/130005 would be the only PR that could possibly have introduced any perf variation here though it's not clear to me why. 


add caching to most type folders, rm region uniquification [#130821](https://github.com/rust-lang/rust/pull/130821) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5384697e9e73709301850a414e1cc40324e6460b&end=18b1161ec9eeab8927f91405bca0ddf59a4a26c9&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3% | [0.1%, 0.5%] | 44    |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.2%, 2.1%] | 44    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.3% | [0.1%, 0.5%] | 44    |
- Perf regressions were seen before merge and deemed acceptable [here](https://github.com/rust-lang/rust/pull/130821#issuecomment-2386298339). 


#### Improvements

Update hashbrown to 0.15 and adjust some methods [#131148](https://github.com/rust-lang/rust/pull/131148) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=9c7013c15c189a6978ac8b9dac638581495527de&end=ad9c494835e746fb7c8a26eeed0ad90e4e834058&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.1%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-2.3%, -0.1%] | 14    |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.1%] | 2     |


Make opaque types regular HIR nodes [#129244](https://github.com/rust-lang/rust/pull/129244) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d30c3924a4ef6ab4f331134562c145d5cec0179a&end=5a4ee43c387110736440cecc375cb5aedc441dbc&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.1%  | [0.1%, 0.1%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.1%] | 13    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.4%, -0.2%] | 23    |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.1%] | 13    |


Rollup of 7 pull requests [#131372](https://github.com/rust-lang/rust/pull/131372) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7caad6925314911eefe54b040d4bc5be940e8f92&end=baaf3e65abab5a281715230bcb1785610629ae7d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.3%, -0.1%] | 9     |
| All ❌✅ (primary)                 | -0.3% | [-0.3%, -0.2%] | 3     |


#### Mixed

rustdoc: rewrite stability inheritance as a doc pass [#131076](https://github.com/rust-lang/rust/pull/131076) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f79ef02e4bc87eb6dc8374cd4bde8e86f9695cf9&end=07f08ffb2dbc864d2127abedf7a5917b965c0a4b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 0.8%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.1%, 0.2%]   | 7     |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.9%, -0.2%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -0.1% | [-0.9%, 0.8%]  | 6     |
- Documentation correctness fix, but the results are a wash anyway, especially on primary benchmarks.


Rollup of 5 pull requests [#131098](https://github.com/rust-lang/rust/pull/131098) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8dd5cd0bc1d683c30805e1dc831cac546b621a75&end=c817d5dc2050ec443516f9700c19b1419593a83d&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.3%  | [0.2%, 0.3%]   | 5     |
| Regressions ❌ <br /> (secondary)  | 0.2%  | [0.2%, 0.2%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.2%] | 6     |
| All ❌✅ (primary)                 | 0.3%  | [0.2%, 0.3%]   | 5     |
- The regressions are small and largely a jump back to a previous baseline so I don't think this merits investigation.


interpret: always enable write_immediate sanity checks [#131006](https://github.com/rust-lang/rust/pull/131006) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=18b1161ec9eeab8927f91405bca0ddf59a4a26c9&end=9c7013c15c189a6978ac8b9dac638581495527de&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.2%, 2.3%]   | 15    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -2.0% | [-2.0%, -2.0%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |
- The perf regressions were deemed acceptable [here](https://github.com/rust-lang/rust/pull/131006#issuecomment-2383332832).


Handle `librustdoc` cases of `rustc::potential_query_instability` lint [#131259](https://github.com/rust-lang/rust/pull/131259) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=96d9d8aa7de9396fe22702ff6df33816ae4d01b6&end=373971abe48287f47ead6304b19279f34b6fcce5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.2%, 1.4%]   | 9     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.4%] | 2     |
| All ❌✅ (primary)                 | 0.5%  | [0.2%, 1.4%]   | 9     |
- 1% regression in exchange for a reproducible build improvement. If we want to claw it back, we need to iterate over hash maps less.


`rustc_infer` cleanups [#131226](https://github.com/rust-lang/rust/pull/131226) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a964a9227787447016894268152bff79ee76a36b&end=8841a3daddd4013c52e8b6de0407fd9b5902583c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.8%  | [0.4%, 1.0%]   | 8     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 40    |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.5%, -0.2%] | 15    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 40    |
- Perf improvements outweigh the regressions so marking this as triaged


Remove `CombineFields` [#131343](https://github.com/rust-lang/rust/pull/131343) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=baaf3e65abab5a281715230bcb1785610629ae7d&end=3ae715c8c63f9aeac47cbf7d8d9dadb3fa32c638&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 0.3%  | [0.2%, 0.3%]   | 3     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | 0.2%  | [0.2%, 0.2%]   | 3     |
- Regressions were determined as acceptable [here](https://github.com/rust-lang/rust/pull/131343#issuecomment-2396836003).


Add precondition checks to ptr::offset, ptr::add, ptr::sub [#130251](https://github.com/rust-lang/rust/pull/130251) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3ae715c8c63f9aeac47cbf7d8d9dadb3fa32c638&end=b8495e5dd22fa16fc86d6871b34c7891a6a3ee27&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.3%, 0.5%]   | 2     |
| Improvements ✅ <br /> (primary)   | -3.2% | [-3.2%, -3.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.2% | [-0.2%, -0.2%] | 1     |
| All ❌✅ (primary)                 | -3.2% | [-3.2%, -3.2%] | 1     |
-  Results are net neutral and not significant enough to worry about. Alternatively, the slowdown is justified by finding bugs in real code.

