#### Note: this error code is no longer emitted by the compiler.

`impl Trait` is not allowed in path parameters.

Erroneous code example:

```ignore (removed error code)
fn some_fn(mut x: impl Iterator) -> <impl Iterator>::Item { // error!
    x.next().unwrap()
}
```

You cannot use `impl Trait` in path parameters. If you want something
equivalent, you can do this instead:

```ignore (removed error code)
fn some_fn<T: Iterator>(mut x: T) -> T::Item { // ok!
    x.next().unwrap()
}
```
