# 2020 Triage Logs

See the [README](README.md) for details on how these logs are collated. They
are in reverse chronological order.

## 2020-07-07

Triage done by njn. Latest revision: 0c03aee8b81185d65b5821518661c30ecdb42de5.
One unimportant regression, on a rollup; six improvements, two on rollups.

Regressions
- [Rollup of 12 pull requests #74073](https://github.com/rust-lang/rust/pull/74073)
  ([instructions](https://perf.rust-lang.org/compare.html?start=2753fab7ce3647033146b07c8b6c9f4856a910b0&end=0c03aee8b81185d65b5821518661c30ecdb42de5&stat=instructions:u)):
  Up to 1.9% losses, but only on the synthetic `wf-projection-stress-65510`
  benchmark, which doesn't matter that much.

Improvements
- [Serialize all foreign `SourceFile`s into proc-macro crate metadata #73706](https://github.com/rust-lang/rust/pull/73706)
  ([instructions](https://perf.rust-lang.org/compare.html?start=16957bd4d3a5377263f76ed74c572aad8e4b7e59&end=d462551a8600e57d8b6f87e71ea56868bc5da6cf&stat=instructions:u)):
  Up to 7.5% wins across numerous benchmarks, mostly the shorter-running ones.
- [Handle inactive enum variants in `MaybeUninitializedPlaces` #73879](https://github.com/rust-lang/rust/pull/73879)
  ([instructions](https://perf.rust-lang.org/compare.html?start=0cd7ff7ddfb75a38dca81ad3e76b1e984129e939&end=2753fab7ce3647033146b07c8b6c9f4856a910b0&stat=instructions:u)):
  Up to 7.1% wins across numerous benchmarks, mostly on opt builds. (Plus one
  21% improvement, but that benchmark has high variability.)
- [Rollup of 16 pull requests #73950](https://github.com/rust-lang/rust/pull/73950)
  ([instructions](https://perf.rust-lang.org/compare.html?start=9491f18c5de3ff1c4bf9c3fdacf52d9859e26f7c&end=b7856f695d65a8ebc846754f97d15814bcb1c244&stat=instructions:u)):
  Up to 1.9% wins across numerous benchmarks.
- [Avoid `unwrap_or_else` in `RawVec::allocate_in`. #73882](https://github.com/rust-lang/rust/pull/73882)
  ([instructions](https://perf.rust-lang.org/compare.html?start=5f4abc16e1b2cb035eee6a5079ce45ce924c1f33&end=cd1a46d644791c79433db934ad4e6131c577efcc&stat=instructions:u)):
  Up to 1.2% wins across a few benchmarks, mostly on debug builds. Maybe
  [#73345](https://github.com/rust-lang/rust/pull/73345) or
  [#73569](https://github.com/rust-lang/rust/pull/73569) is responsible?
- [Remove `TypeckTables::empty(None)` and make hir_owner non-optional. #73751](https://github.com/rust-lang/rust/pull/73751)
  ([instructions](https://perf.rust-lang.org/compare.html?start=8a6d4342be6a6acbade8e7ef65e73d27ee8c9144&end=3503f565e1fb7296983757d2716346f48a4a262b&stat=instructions:u)):
  Up to 3.8% wins, mostly on `unused-warnings`.
- [Rollup of 17 pull requests #73924](https://github.com/rust-lang/rust/pull/73924)
  ([instructions](https://perf.rust-lang.org/compare.html?start=d462551a8600e57d8b6f87e71ea56868bc5da6cf&end=f781babf87dea29c44f93842b7ac9eb809549d29&stat=instructions:u)):
  Up to 1.9% wins, mostly on `clap-rs`. Unclear which PR is responsible.

## 2020-06-30

Triage done by njn. Latest revision: 0ca7f74dbd23a3e8ec491cd3438f490a3ac22741.
Three regressions, two of them on rollups; two improvements, one on a rollup.

Regressions
- [Rollup of 13 pull requests](https://github.com/rust-lang/rust/pull/73756)
  ([instructions](https://perf.rust-lang.org/compare.html?start=14e65d5e95da0f7e4f9127cf1598fa46f33972e8&end=9672b5e95c520774cc17bffc7031c80a1bcf4b4c&stat=instructions:u)):
  Up to 1.7% losses on many benchmarks, affecting `incr-unchanged` runs the
  most. Might be due to [#73102](https://github.com/rust-lang/rust/pull/73102)
  or [#73597](https://github.com/rust-lang/rust/pull/73597).
- [Rollup of 11 pull requests](https://github.com/rust-lang/rust/pull/73669)
  ([instructions](https://github.com/rust-lang/rust/compare/ff5b446d2fdbd898bc97a751f2f72858de185cf1...0c04344d86f9598f20d9ec86fe87ea2a5d6ff8e6)):
  Up to 2.1% losses on a few benchmarks, mostly on `incr-unchanged` runs.
- [Always capture tokens for `macro_rules!` arguments](https://github.com/rust-lang/rust/pull/73293)
  ([instructions](https://github.com/rust-lang/rust/compare/0c04344d86f9598f20d9ec86fe87ea2a5d6ff8e6...3c90ae8404b6b83bc3cba35840ddf7edd500cc86), [max-rss](https://perf.rust-lang.org/compare.html?start=0c04344d86f9598f20d9ec86fe87ea2a5d6ff8e6&end=3c90ae8404b6b83bc3cba35840ddf7edd500cc86&stat=max-rss)):
  Up to 6.1% losses on the artificial `deep-vector` benchmark, and memory
  increases on the same benchmark.

Improvements
- [Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/73643)
  ([instructions](https://github.com/rust-lang/rust/compare/3b1c08c68ccc2c222f84384c836b5e167e2bc241...1557fb031b272b4c5bfcc7de5df7eddc7b36a584)):
  Up to 13.6% wins on `wg-grammar`, tiny wins on a couple of other benchmarks.
- [Revert PR #72389 - "Explain move errors that occur due to method calls involving `self`"](https://github.com/rust-lang/rust/pull/73594)
  ([instructions](https://github.com/rust-lang/rust/compare/6bb3dbfc6c6d8992d08431f320ba296a0c2f7498...cbf356a1a5677b1c073f09ba833d8247c7ed01aa)):
  Up to 3.1% wins on a few benchmarks.

## 2020-06-23

Triage done by njn. Latest revision: 6bb3dbfc6c6d8992d08431f320ba296a0c2f7498.
Lots of improvements this week!

Having done this for a few weeks now, I see that close to half of the PRs with
significant performance effects are rollups.

Regressions
- None.

Improvements
- [Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/73563)
  ([instructions](https://perf.rust-lang.org/compare.html?start=f455e46eae1a227d735091091144601b467e1565&end=7058471adec80a2a1e6092443e08546768c9c894&stat=instructions:u), [max-rss](https://perf.rust-lang.org/compare.html?start=f455e46eae1a227d735091091144601b467e1565&end=7058471adec80a2a1e6092443e08546768c9c894&stat=max-rss)):
  Up to 33.6% instruction wins on a stress test, and up to 10.3% instructions
  wins on several real-world benchmarks. Also a max-rss win.
  [#72788](https://github.com/rust-lang/rust/pull/72788) may be the cause?
- [Cache flags and escaping vars for predicates](https://github.com/rust-lang/rust/pull/73180)
  ([instructions](https://perf.rust-lang.org/compare.html?start=a8cf3991177f30694200002cd9479ffbbe6d9a1a&end=1a4e2b6f9c75a0e21722c88a0e3b610d6ffc3ae3&stat=instructions:u)):
  Up to 4.9% wins across numerous benchmarks.
- [store `ObligationCause` on the heap](https://github.com/rust-lang/rust/pull/72962)
  ([instructions](https://perf.rust-lang.org/compare.html?start=f315c35a77e40bd11ce81fedc0556be0f410bbf4&end=c8a9c340de32cb70c8bad8af1a4474f805c5a969&stat=instructions:u)):
  Up to 3.5% wins across numerous benchmarks.
- [Upgrade Chalk](https://github.com/rust-lang/rust/pull/72936)
  ([instructions](https://perf.rust-lang.org/compare.html?start=349f6bfb11d73ebb6a272f9a3d00883484f8218c&end=a8cf3991177f30694200002cd9479ffbbe6d9a1a&stat=instructions:u)):
  Up to 1.5% wins across numerous benchmarks.
- [Rollup of 13 pull requests](https://github.com/rust-lang/rust/pull/73511)
  ([instructions](https://perf.rust-lang.org/compare.html?start=2d8bd9b74dc0cf06d881bac645698ccbcf9d9c5e&end=34c5cd9a64d8537236626c4ccbed39a924cd38e2&stat=instructions:u)):
  Up to 1.5% wins across numerous benchmarks.
- [Rollup of 16 pull requests](https://github.com/rust-lang/rust/pull/73528)
  ([instructions](https://perf.rust-lang.org/compare.html?start=34c5cd9a64d8537236626c4ccbed39a924cd38e2&end=033013cab3a861224fd55f494c8be1cb0349eb49&stat=instructions:u)):
  Up to 3.4% wins on `wg-grammar`, little change elsewhere.

## 2020-06-16

Triage done by njn.

Some bustage involving Cargo meant that some merges in this period didn't get
measured.

Regressions
- [Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/73367)
  ([instructions](https://perf.rust-lang.org/compare.html?start=ce6d3a73b514e9649e57cee812ad129bb2112016&end=d4ecf31efc2309fb6df8c2a8af9aaf8176ab1c8d&stat=instructions:u)):
  Regressed up to 3.5% on multiple benchmarks. Maybe
  [#71824](https://github.com/rust-lang/rust/pull/71824) is the cause?
- [Disable the `SimplifyArmIdentity` pass](https://github.com/rust-lang/rust/pull/73262)
  ([instructions](https://perf.rust-lang.org/compare.html?start=7c78a5f97de07a185eebae5a5de436c80d8ba9d4&end=f4fbb93113aa4f0a0cd08e74afb35381bbfbc7f0&stat=instructions:u)):
  A small regression on a couple of benchmarks from disabling a buggy pass,
  which may be re-enabled in the future?
- A small regression occurred for `syn-opt`, but I can't tell which PR was
  responsible because the improvement occurred in one of the merges that wasn't
  measured due to the Cargo bustage.

Improvements
- Some huge improvements occurred for `clap-rs-opt`, but I can't tell which PR
  was responsible because the improvement occurred in one of the merges that
  wasn't measured due to the Cargo bustage.
- [Rollup of 8 pull requests](https://github.com/rust-lang/rust/pull/73316)
  ([instructions](https://perf.rust-lang.org/compare.html?start=1fb612bd15bb3ef098fd24c20d0727de573b4410&end=06e47688bf15d0215edbe05b21603062f6d2eb5d&stat=instructions:u)):
  A small improvement on `many-assoc-items`, and a tiny regression on a couple
  of other benchmarks.

## 2020-06-09

Triage done by njn.

Regressions
- [Update LLVM submodule to include lld NOLOAD fix](https://github.com/rust-lang/rust/pull/73072)
  ([instructions](https://perf.rust-lang.org/compare.html?start=450abe80f193ccefbfcd48214d70520f2d507f0e&end=a2fc33e0c87a258542cd12d6ffae52c43aa3785a&stat=instructions:u)):
  A small regression in debug builds due to LLVM. Pulling in [this LLVM
  change](https://reviews.llvm.org/D80964) may fix it.
- [Rollup of 5 pull requests](https://github.com/rust-lang/rust/pull/73081)
  ([instructions](https://perf.rust-lang.org/compare.html?start=9c1857fad849ad56d38327b9bc11377a0bdbb4cf&end=450abe80f193ccefbfcd48214d70520f2d507f0e&stat=instructions:u)):
  Possibly due to [#72989](https://github.com/rust-lang/rust/pull/72989).

Improvements
- None.

## 2020-06-02

Triage done by njn.

Regressions
- Nothing of note!

Improvements
- [perf: Revert accidental inclusion of a part of #69218](https://github.com/rust-lang/rust/pull/71996)
  ([instructions](https://perf.rust-lang.org/compare.html?start=2873165725c15e96dae521a412065c144d9c7a25&end=664fcd3f046e2a6824602da0fad81e3e2bb0d409&stat=instructions:u))
- [Pass more `Copy` types by value.](https://github.com/rust-lang/rust/pull/72494)
  ([instructions](https://perf.rust-lang.org/compare.html?start=664fcd3f046e2a6824602da0fad81e3e2bb0d409&end=45127211566c53bac386b66909a830649182ab7a&stat=instructions:u)):
  This fixes part of the regression from
  [#72055](https://github.com/rust-lang/rust/pull/72055) from last week.
- [Rollup of 9 pull requests](https://github.com/rust-lang/rust/pull/72778)
  ([instructions](https://perf.rust-lang.org/compare.html?start=91fb72a8a9f53de2bcc5638c1358fcb552dba8ce&end=74e80468347471779be6060d8d7d6d04e98e467f&stat=instructions:u))

## 2020-05-26

Triage done by njn.

Regressions
- [Update to LLVM 10](https://github.com/rust-lang/rust/pull/67759)
  ([instructions](https://perf.rust-lang.org/compare.html?start=0aa6751c19d3ba80df5b0b02c00bf44e13c97e80&end=82911b3bba76e73afe2881b732fe6b0edb35d5d3&stat=instructions:u)):
  Lots of grumbling about this. wg-prioritization will consider at their next meeting?
- [Intern predicates](https://github.com/rust-lang/rust/pull/72055)
  ([instructions](https://perf.rust-lang.org/compare.html?start=9310e3bd4f425f84fc27878ebf2bda1f30935a63&end=d9417b385145af1cabd0be8a95c65075d2fc30ff&stat=instructions:u)):
  @lcnr has promised a follow-up to at least partly fix it, currently in
  [#72494](https://github.com/rust-lang/rust/pull/72494).

Improvements
- [Remove ReScope](https://github.com/rust-lang/rust/pull/72362)
  ([instructions](https://perf.rust-lang.org/compare.html?start=3137f8e2d141d7d7c65040a718a9193f50e1282e&end=52b605c8cb2f730e607de0777a694cd1b9bb3e15&stat=instructions:u))
- [Dumb NRVO](https://github.com/rust-lang/rust/pull/72205)
  ([instructions](https://perf.rust-lang.org/compare.html?start=963bf528292d8f97104515e32908e30c2467b6a8&end=7f79e98c0356642db62e5113327e436c951e843d&stat=instructions:u))


