# 2021-10-12 Triage Log

A relatively quiet week: two smallish regressions, and one largish regression that is isolated to doc builds. A couple of nice small wins as well.

Triage done by **@pnkfelix**.
Revision range: [25ec8273855fde2d72ae877b397e054de5300e10..9475e609b8458fff9e444934a6017d2e590642cf](https://perf.rust-lang.org/?start=25ec8273855fde2d72ae877b397e054de5300e10&end=9475e609b8458fff9e444934a6017d2e590642cf&absolute=false&stat=instructions%3Au)

2 Regressions, 2 Improvements, 2 Mixed; 1 of them in rollups
42 comparisons made in total

#### Regressions

Rollup of 12 pull requests [#89608](https://github.com/rust-lang/rust/issues/89608)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d480ceff384f80394e9367b5e9d3596d62f20585&end=0eabf25b90396dead0b2a1aaa275af18a1ae6008&stat=instructions:u) (up to 0.8% on `incr-unchanged` builds of `externs`)
- A large number of `doc` targets regressed very slightly here.
- Apart from that, biggest changes were to `externs` and `deeply-nested-async`.
- Left [comment](https://github.com/rust-lang/rust/pull/89608#issuecomment-941365151) noting the above

Move top part of print_item to Tera templates [#89695](https://github.com/rust-lang/rust/issues/89695)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=6928fafe06e4ab29317f75194e1bf67c119dccdc&end=c1cb97481a633bdfdf3d6b57c6dcebfdfadbcfdf&stat=instructions:u) (up to 3.7% on `full` builds of `externs`)
- Large regression for certain doc builds.
- Fix posted in PR [#89732](https://github.com/rust-lang/rust/issues/89732); thanks @**GuillaumeGomez** !

Apply clippy suggestions for rustc and core [#89709](https://github.com/rust-lang/rust/issues/89709)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=86d6d2b7389fe1b339402c1798edae8b695fc9ef&end=6ae8912a3e7d2c4c775024f58a7ba4b1aedc4073&stat=instructions:u) (up to 2.8% on `full` builds of `keccak`)
- instruction-count regressions in the 1.1% to 2.7% range in keccak and inflate
- Left [comment](https://github.com/rust-lang/rust/pull/89709#issuecomment-941560787)

#### Improvements

perf: only check for `rustc_trivial_field_reads` attribute on traits, not items, impls, etc. [#89454](https://github.com/rust-lang/rust/issues/89454)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=0eabf25b90396dead0b2a1aaa275af18a1ae6008&end=d3e6770efbd76c4ad1e17468895b538a2efec4bd&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `derive`)

rustdoc: Cleanup various `clean` types [#88379](https://github.com/rust-lang/rust/issues/88379)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=bc8ad24020a160e1acd7ac9f7671947dcc01264c&end=a8f2463c68a6532d74a13ec402ec5b513e4e2726&stat=instructions:u) (up to -0.8% on `full` builds of `issue-46449`)


#### Mixed

Add two inline annotations for hot functions [#89495](https://github.com/rust-lang/rust/issues/89495)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=d3e6770efbd76c4ad1e17468895b538a2efec4bd&end=ca8078d7b2e40c24a39e5fe2a910afef4c91ebfc&stat=instructions:u) (up to -7.1% on `full` builds of `inflate`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=d3e6770efbd76c4ad1e17468895b538a2efec4bd&end=ca8078d7b2e40c24a39e5fe2a910afef4c91ebfc&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)


Introduce `tcx.get_diagnostic_name` [#89534](https://github.com/rust-lang/rust/issues/89534)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=680ff86391f19e12b485293f01372036e85ba87c&end=0157cc977fd71297ce73e2f249321f5ba2555d42&stat=instructions:u) (up to -3.4% on `incr-full` builds of `ctfe-stress-4`)
- Small regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=680ff86391f19e12b485293f01372036e85ba87c&end=0157cc977fd71297ce73e2f249321f5ba2555d42&stat=instructions:u) (up to 0.4% on `incr-unchanged` builds of `helloworld`)

#### Untriaged Pull Requests

- [#89709 Apply clippy suggestions for rustc and core](https://github.com/rust-lang/rust/pull/89709)
- [#89695 Move top part of print_item to Tera templates](https://github.com/rust-lang/rust/pull/89695)
- [#89608 Rollup of 12 pull requests](https://github.com/rust-lang/rust/pull/89608)
- [#89534 Introduce `tcx.get_diagnostic_name`](https://github.com/rust-lang/rust/pull/89534)
- [#89495 Add two inline annotations for hot functions](https://github.com/rust-lang/rust/pull/89495)
- [#89435 Rollup of 6 pull requests](https://github.com/rust-lang/rust/pull/89435)
- [#89405 Fix clippy lints](https://github.com/rust-lang/rust/pull/89405)
- [#89263 Suggest both of immutable and mutable trait implementations](https://github.com/rust-lang/rust/pull/89263)
- [#89165 Fix read_to_end to not grow an exact size buffer](https://github.com/rust-lang/rust/pull/89165)
- [#89125 Don't use projection cache or candidate cache in intercrate mode](https://github.com/rust-lang/rust/pull/89125)
- [#89103 Migrate in-tree crates to 2021](https://github.com/rust-lang/rust/pull/89103)
- [#89047 Rollup of 10 pull requests](https://github.com/rust-lang/rust/pull/89047)
- [#89030 Introduce `Rvalue::ShallowInitBox`](https://github.com/rust-lang/rust/pull/89030)
- [#88945 Remove concept of 'completion' from the projection cache](https://github.com/rust-lang/rust/pull/88945)
- [#88880 Rework HIR API to make invocations of the hir_crate query harder.](https://github.com/rust-lang/rust/pull/88880)
- [#88824 Rollup of 15 pull requests](https://github.com/rust-lang/rust/pull/88824)
- [#88804 Revise never type fallback algorithm](https://github.com/rust-lang/rust/pull/88804)
- [#88719 Point at argument instead of call for their obligations](https://github.com/rust-lang/rust/pull/88719)
- [#88703 Gather module items after lowering.](https://github.com/rust-lang/rust/pull/88703)
- [#88627 Do not preallocate HirIds](https://github.com/rust-lang/rust/pull/88627)
- [#88575 Querify `FnAbi::of_{fn_ptr,instance}` as `fn_abi_of_{fn_ptr,instance}`.](https://github.com/rust-lang/rust/pull/88575)
- [#88308 Morph `layout_raw` query into `layout_of`.](https://github.com/rust-lang/rust/pull/88308)
- [#87781 Remove box syntax from compiler and tools](https://github.com/rust-lang/rust/pull/87781)
- [#87064 Support `#[track_caller]` on closures and generators](https://github.com/rust-lang/rust/pull/87064)
- [#83302 Get piece unchecked in `write`](https://github.com/rust-lang/rust/pull/83302)
