# 2022-08-09 Triage Log

A pretty quiet week for performance. Unfortunately, by far the biggest change was a regression introduced by increasing the minimum libc version for linux-gnu targets. The exact reason for why this happened in this case is unclear, and it's not easy to investigate. Luckily, the average regression introduced by this change was 0.4% which is fairly small, and many of the larger regressions were limited to doc builds.

Triage done by **@rylev**.
Revision range: [792bc5a0..cc4dd6fc](https://perf.rust-lang.org/?start=792bc5a0102d0973d42183a2b267850bb905236f&end=cc4dd6fc9f1a5c798df269933c7e442b79661a86&absolute=false&stat=instructions%3Au)

**Summary**:

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.5% | 1.4% | 146   |
| Regressions ❌ <br /> (secondary) | 0.8% | 1.6% | 78    |
| Improvements ✅ <br /> (primary) | N/A  | N/A | 0     |
| Improvements ✅ <br /> (secondary) | -2.0% | -4.0% | 9     |
| All ❌✅ (primary) | 0.5% | 1.4% | 146   |


1 Regressions, 2 Improvements, 2 Mixed; 1 of them in rollups
42 artifact comparisons made in total

#### Regressions

Increase the minimum linux-gnu versions [#95026](https://github.com/rust-lang/rust/pull/95026) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f6f9d5e73d5524b6281c10a5c89b7db35c330634&end=2da8820470817bfd3053be969fb38be9645e1a3d&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.4% | 1.6% | 137   |
| Regressions ❌ <br /> (secondary) | 0.7% | 1.6% | 65    |
| Improvements ✅ <br /> (primary) | N/A  | N/A | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | -0.6% | 2     |
| All ❌✅ (primary) | 0.4% | 1.6% | 137   |
- This is difficult to debug as there was no change to code in the project, just in how things are built.
- Most of the larger regressions are in doc builds where we have slightly higher tolerance for performance issues. 
- This means the regressions are something we can probably live with.


#### Improvements

remove `commit_unconditionally` [#99509](https://github.com/rust-lang/rust/pull/99509) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e4417cf020fbcd6182c11637bc6b8694434bd81a&end=b759b2efad2d9c713eeab19bf90736a12ff0d74c&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | N/A  | N/A | 0     |
| Regressions ❌ <br /> (secondary) | N/A  | N/A | 0     |
| Improvements ✅ <br /> (primary) | -0.5% | -1.0% | 8     |
| Improvements ✅ <br /> (secondary) | -0.8% | -0.8% | 1     |
| All ❌✅ (primary) | -0.5% | -1.0% | 8     |


Rollup of 6 pull requests [#100304](https://github.com/rust-lang/rust/pull/100304) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=8d1fa7105b2ad3154f63d8f0641fd7da87e20e8f&end=5af97e8b0b9649ed14b0b4528a610ff841b6365e&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | N/A  | N/A | 0     |
| Regressions ❌ <br /> (secondary) | 1.5% | 1.5% | 1     |
| Improvements ✅ <br /> (primary) | N/A  | N/A | 0     |
| Improvements ✅ <br /> (secondary) | -1.9% | -4.0% | 13    |
| All ❌✅ (primary) | N/A  | N/A | 0     |


#### Mixed

Warn about dead tuple struct fields [#95977](https://github.com/rust-lang/rust/pull/95977) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=cdfd675a63090182fd1c5f2ff58d8eaa115da156&end=9bbbf60b0442f1d56fc39f30274be77acc79164c&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | N/A  | N/A | 0     |
| Regressions ❌ <br /> (secondary) | 1.2% | 1.5% | 3     |
| Improvements ✅ <br /> (primary) | N/A  | N/A | 0     |
| Improvements ✅ <br /> (secondary) | -1.4% | -1.6% | 6     |
| All ❌✅ (primary) | N/A  | N/A | 0     |
- The regressions are only in secondary tests and are more or less a wash (tipping slightly towards more improvements)


Add option to `mir::MutVisitor` to not invalidate CFG. [#100089](https://github.com/rust-lang/rust/pull/100089) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5af97e8b0b9649ed14b0b4528a610ff841b6365e&end=cc4dd6fc9f1a5c798df269933c7e442b79661a86&stat=instructions:u)

|            | mean | max | count |
|:----------:|:----:|:---:|:-----:|
| Regressions ❌ <br /> (primary) | 0.3% | 0.4% | 3     |
| Regressions ❌ <br /> (secondary) | 1.3% | 1.5% | 6     |
| Improvements ✅ <br /> (primary) | N/A  | N/A | 0     |
| Improvements ✅ <br /> (secondary) | -1.5% | -1.5% | 1     |
| All ❌✅ (primary) | 0.3% | 0.4% | 3     |
- This is a small enough regression that I don't think we need to investigate it deeply.
- It seems there's more calls in type unification, but I don't see how this change would impact that. 
- Left [a comment on the PR](https://github.com/rust-lang/rust/pull/100089#issuecomment-1209611594)
