// Copyright 2002 - 2008, 2010, 2011 National Technology Engineering
// Solutions of Sandia, LLC (NTESS). Under the terms of Contract
// DE-NA0003525 with NTESS, the U.S. Government retains certain rights
// in this software.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//
//     * Redistributions in binary form must reproduce the above
//       copyright notice, this list of conditions and the following
//       disclaimer in the documentation and/or other materials provided
//       with the distribution.
//
//     * Neither the name of NTESS nor the names of its contributors
//       may be used to endorse or promote products derived from this
//       software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#ifndef STK_MESH_NGP_HPP
#define STK_MESH_NGP_HPP

#include "Kokkos_Core.hpp"
#include "stk_util/stk_kokkos_macros.h"
#include <stk_util/ngp/NgpSpaces.hpp>

#if defined(STK_DEBUG_FIELD_SYNC) && !defined(STK_USE_DEVICE_MESH)
static_assert(false, "The STK field sync debugger does nothing unless you also have enabled the DeviceMesh/DeviceField."
                     " To enable these, pass -DSTK_USE_DEVICE_MESH on the configure line.");
#endif

namespace stk {
namespace mesh {

template<typename NgpMemSpace> class HostMeshT;
template<typename NgpMemSpace> class DeviceMeshT;

class StkFieldSyncDebugger;
class EmptyStkFieldSyncDebugger;
template <typename T, typename NgpMemSpace> class NgpFieldSyncDebugger;
template <typename T, typename NgpMemSpace> class EmptyNgpFieldSyncDebugger;

#ifdef STK_DEBUG_FIELD_SYNC
  using DefaultStkFieldSyncDebugger = StkFieldSyncDebugger;
  template <typename T, typename NgpMemSpace>
  using DefaultNgpFieldSyncDebugger = NgpFieldSyncDebugger<T, NgpMemSpace>;
#else
  using DefaultStkFieldSyncDebugger = EmptyStkFieldSyncDebugger;
  template <typename T, typename NgpMemSpace>
  using DefaultNgpFieldSyncDebugger = EmptyNgpFieldSyncDebugger<T, NgpMemSpace>;
#endif

#ifdef STK_USE_DEVICE_MESH
  using NgpMeshDefaultMemSpace = stk::ngp::MemSpace;
#else
  using NgpMeshDefaultMemSpace = stk::ngp::HostMemSpace;
#endif

template<typename T, typename NgpMemSpace = NgpMeshDefaultMemSpace, template <typename, typename> class NgpDebugger = DefaultNgpFieldSyncDebugger>
class HostField;
template<typename T, typename NgpMemSpace = NgpMeshDefaultMemSpace, template <typename, typename> class NgpDebugger = DefaultNgpFieldSyncDebugger>
class DeviceField;

#ifdef STK_USE_DEVICE_MESH
  template<typename NgpMemSpace>
    using NgpMeshT = stk::mesh::DeviceMeshT<NgpMemSpace>;
  using NgpMesh = NgpMeshT<NgpMeshDefaultMemSpace>;

  template <typename T, typename NgpMemSpace = NgpMeshDefaultMemSpace, template <typename, typename> class NgpDebugger = DefaultNgpFieldSyncDebugger>
  using NgpField = stk::mesh::DeviceField<T, NgpMemSpace, NgpDebugger>;

#else
  template<typename NgpMemSpace>
    using NgpMeshT = stk::mesh::HostMeshT<NgpMemSpace>;
  using NgpMesh = NgpMeshT<NgpMeshDefaultMemSpace>;

  template <typename T, typename NgpMemSpace = NgpMeshDefaultMemSpace, template <typename, typename> class NgpDebugger = DefaultNgpFieldSyncDebugger>
  using NgpField = stk::mesh::HostField<T, NgpMemSpace, NgpDebugger>;
#endif

}
}

#endif
