// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

/*****************************************************************************/
#ifndef HARDWARE_INTRINSIC
#error Define HARDWARE_INTRINSIC before including this file
#endif
/*****************************************************************************/

// clang-format off

#ifdef FEATURE_HW_INTRINSICS
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector64 Intrinsics
HARDWARE_INTRINSIC(Vector64,      Abs,                                                               8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Add,                                                               8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      AndNot,                                                            8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      As,                                                                8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsByte,                                                            8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsDouble,                                                          8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsInt16,                                                           8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsInt32,                                                           8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsInt64,                                                           8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsNInt,                                                            8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsNUInt,                                                           8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsSByte,                                                           8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsSingle,                                                          8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsUInt16,                                                          8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsUInt32,                                                          8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      AsUInt64,                                                          8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      BitwiseAnd,                                                        8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      BitwiseOr,                                                         8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Ceiling,                                                           8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ConditionalSelect,                                                 8,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ConvertToDouble,                                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      ConvertToInt32,                                                    8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      ConvertToInt64,                                                    8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      ConvertToSingle,                                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      ConvertToUInt32,                                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      ConvertToUInt64,                                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      Create,                                                            8,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      CreateScalar,                                                      8,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      CreateScalarUnsafe,                                                8,      1,      true,  {INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_invalid,        INS_invalid,        INS_fmov,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(Vector64,      Divide,                                                            8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Dot,                                                               8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Equals,                                                            8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      EqualsAll,                                                         8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      EqualsAny,                                                         8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ExtractMostSignificantBits,                                        8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Floor,                                                             8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      get_AllBitsSet,                                                    8,      0,      true,  {INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni},        HW_Category_Helper,                HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      get_One,                                                           8,      0,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      get_Zero,                                                          8,      0,      true,  {INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi},        HW_Category_Helper,                HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      GetElement,                                                        8,      2,      true,  {INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_umov,           INS_umov,           INS_dup,            INS_dup},         HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      GreaterThan,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      GreaterThanAll,                                                    8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      GreaterThanAny,                                                    8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      GreaterThanOrEqual,                                                8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      GreaterThanOrEqualAll,                                             8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      GreaterThanOrEqualAny,                                             8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LessThan,                                                          8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LessThanAll,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LessThanAny,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LessThanOrEqual,                                                   8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LessThanOrEqualAll,                                                8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LessThanOrEqualAny,                                                8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Load,                                                              8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LoadAligned,                                                       8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LoadAlignedNonTemporal,                                            8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      LoadUnsafe,                                                        8,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Max,                                                               8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Min,                                                               8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Multiply,                                                          8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Narrow,                                                            8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Negate,                                                            8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      OnesComplement,                                                    8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_Addition,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_BitwiseAnd,                                                     8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector64,      op_BitwiseOr,                                                      8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector64,      op_Division,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_Equality,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector64,      op_ExclusiveOr,                                                    8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_Inequality,                                                     8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector64,      op_LeftShift,                                                      8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_Multiply,                                                       8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_OnesComplement,                                                 8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_RightShift,                                                     8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_Subtraction,                                                    8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_UnaryNegation,                                                  8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_UnaryPlus,                                                      8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      op_UnsignedRightShift,                                             8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ShiftLeft,                                                         8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ShiftRightArithmetic,                                              8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ShiftRightLogical,                                                 8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Shuffle,                                                           8,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Sqrt,                                                              8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Store,                                                             8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      StoreAligned,                                                      8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      StoreAlignedNonTemporal,                                           8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      StoreUnsafe,                                                       8,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Subtract,                                                          8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      Sum,                                                               8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector64,      ToScalar,                                                          8,      1,      true,  {INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_umov,           INS_umov,           INS_dup,            INS_dup},         HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Vector64,      ToVector128,                                                       8,      1,      true,  {INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov},         HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Vector64,      ToVector128Unsafe,                                                 8,      1,      true,  {INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov},         HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Vector64,      WidenLower,                                                        8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      WidenUpper,                                                        8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector64,      WithElement,                                                       8,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector64,      Xor,                                                               8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Vector128 Intrinsics

HARDWARE_INTRINSIC(Vector128,     Abs,                                                              16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Add,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     AndNot,                                                           16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     As,                                                               16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsByte,                                                           16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsDouble,                                                         16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsInt16,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsInt32,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsInt64,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsNInt,                                                           16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsNUInt,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsSByte,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsSingle,                                                         16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsUInt16,                                                         16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsUInt32,                                                         16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsUInt64,                                                         16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsVector,                                                         16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsVector2,                                                        16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsVector3,                                                        16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_mov,            INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsVector4,                                                        16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     AsVector128,                                                      -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     BitwiseAnd,                                                       16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     BitwiseOr,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Ceiling,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ConditionalSelect,                                                16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ConvertToDouble,                                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     ConvertToInt32,                                                   16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     ConvertToInt64,                                                   16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     ConvertToSingle,                                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     ConvertToUInt32,                                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     ConvertToUInt64,                                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     Create,                                                           16,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     CreateScalar,                                                     16,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     CreateScalarUnsafe,                                               16,      1,      true,  {INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_fmov,           INS_fmov},        HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(Vector128,     Divide,                                                           16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Dot,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Equals,                                                           16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     EqualsAll,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     EqualsAny,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ExtractMostSignificantBits,                                       16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Floor,                                                            16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     get_AllBitsSet,                                                   16,      0,      true,  {INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni,           INS_mvni},        HW_Category_Helper,                HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     get_One,                                                          16,      0,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     get_Zero,                                                         16,      0,      true,  {INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi,           INS_movi},        HW_Category_Helper,                HW_Flag_NoCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     GetElement,                                                       16,      2,      true,  {INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_umov,           INS_umov,           INS_dup,            INS_dup},         HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     GetLower,                                                         16,      1,      true,  {INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov,            INS_mov},         HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Vector128,     GetUpper,                                                         16,      1,      true,  {INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext},         HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Vector128,     GreaterThan,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     GreaterThanAll,                                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     GreaterThanAny,                                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     GreaterThanOrEqual,                                               16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     GreaterThanOrEqualAll,                                            16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     GreaterThanOrEqualAny,                                            16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LessThan,                                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LessThanAll,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LessThanAny,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LessThanOrEqual,                                                  16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LessThanOrEqualAll,                                               16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LessThanOrEqualAny,                                               16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Load,                                                             16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LoadAligned,                                                      16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LoadAlignedNonTemporal,                                           16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     LoadUnsafe,                                                       16,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Max,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Min,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Multiply,                                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Narrow,                                                           16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Negate,                                                           16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     OnesComplement,                                                   16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_Addition,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_BitwiseAnd,                                                    16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector128,     op_BitwiseOr,                                                     16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector128,     op_Division,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_Equality,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector128,     op_ExclusiveOr,                                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_Inequality,                                                    16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Vector128,     op_LeftShift,                                                     16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_RightShift,                                                    16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_UnsignedRightShift,                                            16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_Multiply,                                                      16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_OnesComplement,                                                16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_Subtraction,                                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_UnaryNegation,                                                 16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     op_UnaryPlus,                                                     16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ShiftLeft,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ShiftRightArithmetic,                                             16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ShiftRightLogical,                                                16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Shuffle,                                                          16,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Sqrt,                                                             16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Store,                                                            16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     StoreAligned,                                                     16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     StoreAlignedNonTemporal,                                          16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     StoreUnsafe,                                                      16,     -1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Subtract,                                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Sum,                                                              16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     ToScalar,                                                         16,      1,      true,  {INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_umov,           INS_umov,           INS_dup,            INS_dup},         HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Vector128,     WidenLower,                                                       16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     WidenUpper,                                                       16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen|HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(Vector128,     WithElement,                                                      16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(Vector128,     WithLower,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     WithUpper,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(Vector128,     Xor,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  AdvSimd Intrinsics
HARDWARE_INTRINSIC(AdvSimd,       Abs,                                                              -1,      1,      true,  {INS_abs,            INS_invalid,        INS_abs,            INS_invalid,        INS_abs,            INS_invalid,        INS_invalid,        INS_invalid,        INS_fabs,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       AbsSaturate,                                                      -1,      1,      true,  {INS_sqabs,          INS_invalid,        INS_sqabs,          INS_invalid,        INS_sqabs,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       AbsScalar,                                                         8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fabs,           INS_fabs},        HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteCompareGreaterThan,                                       -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facgt,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteCompareGreaterThanOrEqual,                                -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facge,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteCompareLessThan,                                          -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facgt,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteCompareLessThanOrEqual,                                   -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facge,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteDifference,                                               -1,      2,      true,  {INS_sabd,           INS_uabd,           INS_sabd,           INS_uabd,           INS_sabd,           INS_uabd,           INS_invalid,        INS_invalid,        INS_fabd,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteDifferenceAdd,                                            -1,      3,      true,  {INS_saba,           INS_uaba,           INS_saba,           INS_uaba,           INS_saba,           INS_uaba,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteDifferenceWideningLower,                                   8,      2,      true,  {INS_sabdl,          INS_uabdl,          INS_sabdl,          INS_uabdl,          INS_sabdl,          INS_uabdl,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteDifferenceWideningLowerAndAdd,                             8,      3,      true,  {INS_sabal,          INS_uabal,          INS_sabal,          INS_uabal,          INS_sabal,          INS_uabal,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteDifferenceWideningUpper,                                  16,      2,      true,  {INS_sabdl2,         INS_uabdl2,         INS_sabdl2,         INS_uabdl2,         INS_sabdl2,         INS_uabdl2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AbsoluteDifferenceWideningUpperAndAdd,                            16,      3,      true,  {INS_sabal2,         INS_uabal2,         INS_sabal2,         INS_uabal2,         INS_sabal2,         INS_uabal2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       Add,                                                              -1,      2,      true,  {INS_add,            INS_add,            INS_add,            INS_add,            INS_add,            INS_add,            INS_add,            INS_add,            INS_fadd,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AddHighNarrowingLower,                                             8,      2,      true,  {INS_addhn,          INS_addhn,          INS_addhn,          INS_addhn,          INS_addhn,          INS_addhn,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AddHighNarrowingUpper,                                            16,      3,      true,  {INS_addhn2,         INS_addhn2,         INS_addhn2,         INS_addhn2,         INS_addhn2,         INS_addhn2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       AddPairwise,                                                       8,      2,      true,  {INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_invalid,        INS_invalid,        INS_faddp,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       AddPairwiseWidening,                                              -1,      1,      true,  {INS_saddlp,         INS_uaddlp,         INS_saddlp,         INS_uaddlp,         INS_saddlp,         INS_uaddlp,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       AddPairwiseWideningAndAdd,                                        -1,      2,      true,  {INS_sadalp,         INS_uadalp,         INS_sadalp,         INS_uadalp,         INS_sadalp,         INS_uadalp,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       AddPairwiseWideningAndAddScalar,                                   8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sadalp,         INS_uadalp,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       AddPairwiseWideningScalar,                                         8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_saddlp,         INS_uaddlp,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       AddRoundedHighNarrowingLower,                                      8,      2,      true,  {INS_raddhn,         INS_raddhn,         INS_raddhn,         INS_raddhn,         INS_raddhn,         INS_raddhn,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AddRoundedHighNarrowingUpper,                                     16,      3,      true,  {INS_raddhn2,        INS_raddhn2,        INS_raddhn2,        INS_raddhn2,        INS_raddhn2,        INS_raddhn2,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       AddSaturate,                                                      -1,      2,      true,  {INS_sqadd,          INS_uqadd,          INS_sqadd,          INS_uqadd,          INS_sqadd,          INS_uqadd,          INS_sqadd,          INS_uqadd,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       AddSaturateScalar,                                                 8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqadd,          INS_uqadd,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       AddScalar,                                                         8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_add,            INS_add,            INS_fadd,           INS_fadd},        HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       AddWideningLower,                                                  8,      2,      true,  {INS_saddl,          INS_uaddl,          INS_saddl,          INS_uaddl,          INS_saddl,          INS_uaddl,          INS_saddw,          INS_uaddw,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       AddWideningUpper,                                                 16,      2,      true,  {INS_saddl2,         INS_uaddl2,         INS_saddl2,         INS_uaddl2,         INS_saddl2,         INS_uaddl2,         INS_saddw2,         INS_uaddw2,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       And,                                                              -1,      2,      true,  {INS_and,            INS_and,            INS_and,            INS_and,            INS_and,            INS_and,            INS_and,            INS_and,            INS_and,            INS_and},         HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       BitwiseClear,                                                     -1,      2,      true,  {INS_bic,            INS_bic,            INS_bic,            INS_bic,            INS_bic,            INS_bic,            INS_bic,            INS_bic,            INS_bic,            INS_bic},         HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       BitwiseSelect,                                                    -1,      3,      true,  {INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl,            INS_bsl},         HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       Ceiling,                                                          -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintp,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       CeilingScalar,                                                     8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintp,         INS_frintp},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       CompareEqual,                                                     -1,      2,      true,  {INS_cmeq,           INS_cmeq,           INS_cmeq,           INS_cmeq,           INS_cmeq,           INS_cmeq,           INS_invalid,        INS_invalid,        INS_fcmeq,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd,       CompareGreaterThan,                                               -1,      2,      true,  {INS_cmgt,           INS_cmhi,           INS_cmgt,           INS_cmhi,           INS_cmgt,           INS_cmhi,           INS_invalid,        INS_invalid,        INS_fcmgt,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd,       CompareGreaterThanOrEqual,                                        -1,      2,      true,  {INS_cmge,           INS_cmhs,           INS_cmge,           INS_cmhs,           INS_cmge,           INS_cmhs,           INS_invalid,        INS_invalid,        INS_fcmge,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd,       CompareLessThan,                                                  -1,      2,      true,  {INS_cmgt,           INS_cmhi,           INS_cmgt,           INS_cmhi,           INS_cmgt,           INS_cmhi,           INS_invalid,        INS_invalid,        INS_fcmgt,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       CompareLessThanOrEqual,                                           -1,      2,      true,  {INS_cmge,           INS_cmhs,           INS_cmge,           INS_cmhs,           INS_cmge,           INS_cmhs,           INS_invalid,        INS_invalid,        INS_fcmge,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       CompareTest,                                                      -1,      2,      true,  {INS_cmtst,          INS_cmtst,          INS_cmtst,          INS_cmtst,          INS_cmtst,          INS_cmtst,          INS_invalid,        INS_invalid,        INS_cmtst,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundAwayFromZero,                                  -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtas,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundAwayFromZeroScalar,                             8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtas,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToEven,                                        -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtns,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToEvenScalar,                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtns,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToNegativeInfinity,                            -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtms,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToNegativeInfinityScalar,                       8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtms,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToPositiveInfinity,                            -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtps,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToPositiveInfinityScalar,                       8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtps,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToZero,                                        -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzs,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToInt32RoundToZeroScalar,                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzs,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToSingle,                                                  -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_scvtf,          INS_ucvtf,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToSingleScalar,                                             8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_scvtf,          INS_ucvtf,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundAwayFromZero,                                 -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtau,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundAwayFromZeroScalar,                            8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtau,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToEven,                                       -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtnu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToEvenScalar,                                  8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtnu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToNegativeInfinity,                           -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtmu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToNegativeInfinityScalar,                      8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtmu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToPositiveInfinity,                           -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtpu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToPositiveInfinityScalar,                      8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtpu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToZero,                                       -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ConvertToUInt32RoundToZeroScalar,                                  8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzu,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       DivideScalar,                                                      8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fdiv,           INS_fdiv},        HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       DuplicateSelectedScalarToVector64,                                -1,      2,      true,  {INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_invalid,        INS_invalid,        INS_dup,            INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       DuplicateSelectedScalarToVector128,                               -1,      2,      true,  {INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_invalid,        INS_invalid,        INS_dup,            INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       DuplicateToVector64,                                               8,      1,      true,  {INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_invalid,        INS_invalid,        INS_dup,            INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd,       DuplicateToVector128,                                             16,      1,      true,  {INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_dup,            INS_invalid,        INS_invalid,        INS_dup,            INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd,       Extract,                                                          -1,      2,      true,  {INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_smov,           INS_umov,           INS_umov,           INS_umov,           INS_dup,            INS_dup},         HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       ExtractNarrowingLower,                                             8,      1,      true,  {INS_xtn,            INS_xtn,            INS_xtn,            INS_xtn,            INS_xtn,            INS_xtn,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ExtractNarrowingSaturateLower,                                     8,      1,      true,  {INS_sqxtn,          INS_uqxtn,          INS_sqxtn,          INS_uqxtn,          INS_sqxtn,          INS_uqxtn,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ExtractNarrowingSaturateUnsignedLower,                             8,      1,      true,  {INS_invalid,        INS_sqxtun,         INS_invalid,        INS_sqxtun,         INS_invalid,        INS_sqxtun,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ExtractNarrowingSaturateUnsignedUpper,                            16,      2,      true,  {INS_invalid,        INS_sqxtun2,        INS_invalid,        INS_sqxtun2,        INS_invalid,        INS_sqxtun2,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ExtractNarrowingSaturateUpper,                                    16,      2,      true,  {INS_sqxtn2,         INS_uqxtn2,         INS_sqxtn2,         INS_uqxtn2,         INS_sqxtn2,         INS_uqxtn2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ExtractNarrowingUpper,                                            16,      2,      true,  {INS_xtn2,           INS_xtn2,           INS_xtn2,           INS_xtn2,           INS_xtn2,           INS_xtn2,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ExtractVector64,                                                   8,      3,      true,  {INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_invalid,        INS_invalid,        INS_ext,            INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasImmediateOperand|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       ExtractVector128,                                                 16,      3,      true,  {INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext,            INS_ext},         HW_Category_SIMD,                  HW_Flag_HasImmediateOperand|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       Floor,                                                            -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintm,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       FloorScalar,                                                       8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintm,         INS_frintm},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       FusedAddHalving,                                                  -1,      2,      true,  {INS_shadd,          INS_uhadd,          INS_shadd,          INS_uhadd,          INS_shadd,          INS_uhadd,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       FusedAddRoundedHalving,                                           -1,      2,      true,  {INS_srhadd,         INS_urhadd,         INS_srhadd,         INS_urhadd,         INS_srhadd,         INS_urhadd,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       FusedMultiplyAdd,                                                 -1,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmla,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       FusedMultiplyAddScalar,                                            8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmadd,          INS_fmadd},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       FusedMultiplyAddNegatedScalar,                                     8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fnmadd,         INS_fnmadd},      HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       FusedMultiplySubtract,                                            -1,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmls,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       FusedMultiplySubtractScalar,                                       8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmsub,          INS_fmsub},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       FusedMultiplySubtractNegatedScalar,                                8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fnmsub,         INS_fnmsub},      HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       FusedSubtractHalving,                                             -1,      2,      true,  {INS_shsub,          INS_uhsub,          INS_shsub,          INS_uhsub,          INS_shsub,          INS_uhsub,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       Insert,                                                           -1,      3,      true,  {INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins},         HW_Category_SIMD,                  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd,       InsertScalar,                                                     16,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ins,            INS_ins,            INS_invalid,        INS_ins},         HW_Category_SIMD,                  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       LeadingSignCount,                                                 -1,      1,      true,  {INS_cls,            INS_invalid,        INS_cls,            INS_invalid,        INS_cls,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       LeadingZeroCount,                                                 -1,      1,      true,  {INS_clz,            INS_clz,            INS_clz,            INS_clz,            INS_clz,            INS_clz,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       LoadAndInsertScalar,                                              -1,      3,      true,  {INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1},         HW_Category_MemoryLoad,            HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       LoadAndReplicateToVector64,                                        8,      1,      true,  {INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_invalid,        INS_invalid,        INS_ld1r,           INS_invalid},     HW_Category_MemoryLoad,            HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       LoadAndReplicateToVector128,                                      16,      1,      true,  {INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_ld1r,           INS_invalid,        INS_invalid,        INS_ld1r,           INS_invalid},     HW_Category_MemoryLoad,            HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       LoadVector64,                                                      8,      1,      true,  {INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1},         HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       LoadVector128,                                                    16,      1,      true,  {INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1,            INS_ld1},         HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       Max,                                                              -1,      2,      true,  {INS_smax,           INS_umax,           INS_smax,           INS_umax,           INS_smax,           INS_umax,           INS_invalid,        INS_invalid,        INS_fmax,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MaxNumber,                                                        -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxnm,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MaxNumberScalar,                                                   8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxnm,         INS_fmaxnm},      HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       MaxPairwise,                                                       8,      2,      true,  {INS_smaxp,          INS_umaxp,          INS_smaxp,          INS_umaxp,          INS_smaxp,          INS_umaxp,          INS_invalid,        INS_invalid,        INS_fmaxp,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       Min,                                                              -1,      2,      true,  {INS_smin,           INS_umin,           INS_smin,           INS_umin,           INS_smin,           INS_umin,           INS_invalid,        INS_invalid,        INS_fmin,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MinNumber,                                                        -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminnm,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MinNumberScalar,                                                   8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminnm,         INS_fminnm},      HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       MinPairwise,                                                       8,      2,      true,  {INS_sminp,          INS_uminp,          INS_sminp,          INS_uminp,          INS_sminp,          INS_uminp,          INS_invalid,        INS_invalid,        INS_fminp,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       Multiply,                                                         -1,      2,      true,  {INS_mul,            INS_mul,            INS_mul,            INS_mul,            INS_mul,            INS_mul,            INS_invalid,        INS_invalid,        INS_fmul,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyAdd,                                                      -1,      3,      true,  {INS_mla,            INS_mla,            INS_mla,            INS_mla,            INS_mla,            INS_mla,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyAddByScalar,                                              -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_mla,            INS_mla,            INS_mla,            INS_mla,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyAddBySelectedScalar,                                      -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_mla,            INS_mla,            INS_mla,            INS_mla,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyByScalar,                                                 -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_mul,            INS_mul,            INS_mul,            INS_mul,            INS_invalid,        INS_invalid,        INS_fmul,           INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalar,                                         -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_mul,            INS_mul,            INS_mul,            INS_mul,            INS_invalid,        INS_invalid,        INS_fmul,           INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalarWideningLower,                             8,      3,      true,  {INS_invalid,        INS_invalid,        INS_smull,          INS_umull,          INS_smull,          INS_umull,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalarWideningLowerAndAdd,                       8,      4,      true,  {INS_invalid,        INS_invalid,        INS_smlal,          INS_umlal,          INS_smlal,          INS_umlal,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalarWideningLowerAndSubtract,                  8,      4,      true,  {INS_invalid,        INS_invalid,        INS_smlsl,          INS_umlsl,          INS_smlsl,          INS_umlsl,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalarWideningUpper,                            16,      3,      true,  {INS_invalid,        INS_invalid,        INS_smull2,         INS_umull2,         INS_smull2,         INS_umull2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalarWideningUpperAndAdd,                      16,      4,      true,  {INS_invalid,        INS_invalid,        INS_smlal2,         INS_umlal2,         INS_smlal2,         INS_umlal2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyBySelectedScalarWideningUpperAndSubtract,                 16,      4,      true,  {INS_invalid,        INS_invalid,        INS_smlsl2,         INS_umlsl2,         INS_smlsl2,         INS_umlsl2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingByScalarSaturateHigh,                             -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingBySelectedScalarSaturateHigh,                     -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingSaturateHigh,                                     -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningLowerAndAddSaturate,                       8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningLowerAndSubtractSaturate,                  8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningLowerByScalarAndAddSaturate,               8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningLowerByScalarAndSubtractSaturate,          8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate,       8,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate,  8,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningSaturateLower,                             8,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningSaturateLowerByScalar,                     8,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningSaturateLowerBySelectedScalar,             8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningSaturateUpper,                            16,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull2,       INS_invalid,        INS_sqdmull2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningSaturateUpperByScalar,                    16,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull2,       INS_invalid,        INS_sqdmull2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningSaturateUpperBySelectedScalar,            16,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull2,       INS_invalid,        INS_sqdmull2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningUpperAndAddSaturate,                      16,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal2,       INS_invalid,        INS_sqdmlal2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningUpperAndSubtractSaturate,                 16,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl2,       INS_invalid,        INS_sqdmlsl2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningUpperByScalarAndAddSaturate,              16,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal2,       INS_invalid,        INS_sqdmlal2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningUpperByScalarAndSubtractSaturate,         16,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl2,       INS_invalid,        INS_sqdmlsl2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate,      16,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal2,       INS_invalid,        INS_sqdmlal2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate, 16,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl2,       INS_invalid,        INS_sqdmlsl2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyRoundedDoublingByScalarSaturateHigh,                      -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyRoundedDoublingBySelectedScalarSaturateHigh,              -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyRoundedDoublingSaturateHigh,                              -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyScalar,                                                    8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmul,           INS_fmul},        HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyScalarBySelectedScalar,                                    8,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmul,           INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       MultiplySubtract,                                                 -1,      3,      true,  {INS_mls,            INS_mls,            INS_mls,            INS_mls,            INS_mls,            INS_mls,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplySubtractByScalar,                                         -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_mls,            INS_mls,            INS_mls,            INS_mls,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplySubtractBySelectedScalar,                                 -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_mls,            INS_mls,            INS_mls,            INS_mls,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyWideningLower,                                             8,      2,      true,  {INS_smull,          INS_umull,          INS_smull,          INS_umull,          INS_smull,          INS_umull,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyWideningLowerAndAdd,                                       8,      3,      true,  {INS_smlal,          INS_umlal,          INS_smlal,          INS_umlal,          INS_smlal,          INS_umlal,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyWideningLowerAndSubtract,                                  8,      3,      true,  {INS_smlsl,          INS_umlsl,          INS_smlsl,          INS_umlsl,          INS_smlsl,          INS_umlsl,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyWideningUpper,                                            16,      2,      true,  {INS_smull2,         INS_umull2,         INS_smull2,         INS_umull2,         INS_smull2,         INS_umull2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyWideningUpperAndAdd,                                      16,      3,      true,  {INS_smlal2,         INS_umlal2,         INS_smlal2,         INS_umlal2,         INS_smlal2,         INS_umlal2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       MultiplyWideningUpperAndSubtract,                                 16,      3,      true,  {INS_smlsl2,         INS_umlsl2,         INS_smlsl2,         INS_umlsl2,         INS_smlsl2,         INS_umlsl2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       Negate,                                                           -1,      1,      true,  {INS_neg,            INS_invalid,        INS_neg,            INS_invalid,        INS_neg,            INS_invalid,        INS_invalid,        INS_invalid,        INS_fneg,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       NegateSaturate,                                                   -1,      1,      true,  {INS_sqneg,          INS_invalid,        INS_sqneg,          INS_invalid,        INS_sqneg,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       NegateScalar,                                                      8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fneg,           INS_fneg},        HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       Not,                                                              -1,      1,      true,  {INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn,            INS_mvn},         HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       Or,                                                               -1,      2,      true,  {INS_orr,            INS_orr,            INS_orr,            INS_orr,            INS_orr,            INS_orr,            INS_orr,            INS_orr,            INS_orr,            INS_orr},         HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       OrNot,                                                            -1,      2,      true,  {INS_orn,            INS_orn,            INS_orn,            INS_orn,            INS_orn,            INS_orn,            INS_orn,            INS_orn,            INS_orn,            INS_orn},         HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       PolynomialMultiply,                                               -1,      2,      true,  {INS_pmul,           INS_pmul,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       PolynomialMultiplyWideningLower,                                   8,      2,      true,  {INS_pmull,          INS_pmull,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       PolynomialMultiplyWideningUpper,                                  16,      2,      true,  {INS_pmull2,         INS_pmull2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       PopCount,                                                         -1,      1,      true,  {INS_cnt,            INS_cnt,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ReciprocalEstimate,                                               -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_urecpe,         INS_invalid,        INS_invalid,        INS_frecpe,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ReciprocalSquareRootEstimate,                                     -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ursqrte,        INS_invalid,        INS_invalid,        INS_frsqrte,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ReciprocalSquareRootStep,                                         -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frsqrts,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       ReciprocalStep,                                                   -1,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frecps,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       ReverseElement16,                                                 -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_rev32,          INS_rev32,          INS_rev64,          INS_rev64,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       ReverseElement32,                                                 -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_rev64,          INS_rev64,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       ReverseElement8,                                                  -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_rev16,          INS_rev16,          INS_rev32,          INS_rev32,          INS_rev64,          INS_rev64,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       RoundAwayFromZero,                                                -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frinta,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       RoundAwayFromZeroScalar,                                           8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frinta,         INS_frinta},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       RoundToNearest,                                                   -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintn,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       RoundToNearestScalar,                                              8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintn,         INS_frintn},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       RoundToNegativeInfinity,                                          -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintm,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       RoundToNegativeInfinityScalar,                                     8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintm,         INS_frintm},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       RoundToPositiveInfinity,                                          -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintp,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       RoundToPositiveInfinityScalar,                                     8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintp,         INS_frintp},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       RoundToZero,                                                      -1,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintz,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       RoundToZeroScalar,                                                 8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintz,         INS_frintz},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmetic,                                                  -1,      2,      true,  {INS_sshl,           INS_invalid,        INS_sshl,           INS_invalid,        INS_sshl,           INS_invalid,        INS_sshl,           INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticRounded,                                           -1,      2,      true,  {INS_srshl,          INS_invalid,        INS_srshl,          INS_invalid,        INS_srshl,          INS_invalid,        INS_srshl,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticRoundedSaturate,                                   -1,      2,      true,  {INS_sqrshl,         INS_invalid,        INS_sqrshl,         INS_invalid,        INS_sqrshl,         INS_invalid,        INS_sqrshl,         INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticRoundedSaturateScalar,                              8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqrshl,         INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticRoundedScalar,                                      8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_srshl,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticSaturate,                                          -1,      2,      true,  {INS_sqshl,          INS_invalid,        INS_sqshl,          INS_invalid,        INS_sqshl,          INS_invalid,        INS_sqshl,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticSaturateScalar,                                     8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqshl,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftArithmeticScalar,                                             8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sshl,           INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftAndInsert,                                               -1,      3,      true,  {INS_sli,            INS_sli,            INS_sli,            INS_sli,            INS_sli,            INS_sli,            INS_sli,            INS_sli,            INS_sli,            INS_sli},         HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftAndInsertScalar,                                          8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sli,            INS_sli,            INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogical,                                                 -1,      2,      true,  {INS_shl,            INS_shl,            INS_shl,            INS_shl,            INS_shl,            INS_shl,            INS_shl,            INS_shl,            INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalSaturate,                                         -1,      2,      true,  {INS_sqshl,          INS_uqshl,          INS_sqshl,          INS_uqshl,          INS_sqshl,          INS_uqshl,          INS_sqshl,          INS_uqshl,          INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalSaturateScalar,                                    8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqshl,          INS_uqshl,          INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalSaturateUnsigned,                                 -1,      2,      true,  {INS_sqshlu,         INS_invalid,        INS_sqshlu,         INS_invalid,        INS_sqshlu,         INS_invalid,        INS_sqshlu,         INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalSaturateUnsignedScalar,                            8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqshlu,         INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalScalar,                                            8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_shl,            INS_shl,            INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalWideningLower,                                     8,      2,      true,  {INS_sshll,          INS_ushll,          INS_sshll,          INS_ushll,          INS_sshll,          INS_ushll,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLeftLogicalWideningUpper,                                    16,      2,      true,  {INS_sshll2,         INS_ushll2,         INS_sshll2,         INS_ushll2,         INS_sshll2,         INS_ushll2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogical,                                                     -1,      2,      true,  {INS_ushl,           INS_ushl,           INS_ushl,           INS_ushl,           INS_ushl,           INS_ushl,           INS_ushl,           INS_ushl,           INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalRounded,                                              -1,      2,      true,  {INS_urshl,          INS_urshl,          INS_urshl,          INS_urshl,          INS_urshl,          INS_urshl,          INS_urshl,          INS_urshl,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalRoundedSaturate,                                      -1,      2,      true,  {INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalRoundedSaturateScalar,                                 8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_uqrshl,         INS_uqrshl,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalRoundedScalar,                                         8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_urshl,          INS_urshl,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalSaturate,                                             -1,      2,      true,  {INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalSaturateScalar,                                        8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_uqshl,          INS_uqshl,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftLogicalScalar,                                                8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ushl,           INS_ushl,           INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightAndInsert,                                              -1,      3,      true,  {INS_sri,            INS_sri,            INS_sri,            INS_sri,            INS_sri,            INS_sri,            INS_sri,            INS_sri,            INS_sri,            INS_sri},         HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightAndInsertScalar,                                         8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sri,            INS_sri,            INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmetic,                                             -1,      2,      true,  {INS_sshr,           INS_invalid,        INS_sshr,           INS_invalid,        INS_sshr,           INS_invalid,        INS_sshr,           INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticAdd,                                          -1,      3,      true,  {INS_ssra,           INS_invalid,        INS_ssra,           INS_invalid,        INS_ssra,           INS_invalid,        INS_ssra,           INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticAddScalar,                                     8,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ssra,           INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticNarrowingSaturateLower,                        8,      2,      true,  {INS_sqshrn,         INS_invalid,        INS_sqshrn,         INS_invalid,        INS_sqshrn,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticNarrowingSaturateUnsignedLower,                8,      2,      true,  {INS_invalid,        INS_sqshrun,        INS_invalid,        INS_sqshrun,        INS_invalid,        INS_sqshrun,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticNarrowingSaturateUnsignedUpper,               16,      3,      true,  {INS_invalid,        INS_sqshrun2,       INS_invalid,        INS_sqshrun2,       INS_invalid,        INS_sqshrun2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticNarrowingSaturateUpper,                       16,      3,      true,  {INS_sqshrn2,        INS_invalid,        INS_sqshrn2,        INS_invalid,        INS_sqshrn2,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRounded,                                      -1,      2,      true,  {INS_srshr,          INS_invalid,        INS_srshr,          INS_invalid,        INS_srshr,          INS_invalid,        INS_srshr,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedAdd,                                   -1,      3,      true,  {INS_srsra,          INS_invalid,        INS_srsra,          INS_invalid,        INS_srsra,          INS_invalid,        INS_srsra,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedAddScalar,                              8,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_srsra,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedNarrowingSaturateLower,                 8,      2,      true,  {INS_sqrshrn,        INS_invalid,        INS_sqrshrn,        INS_invalid,        INS_sqrshrn,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedNarrowingSaturateUnsignedLower,         8,      2,      true,  {INS_invalid,        INS_sqrshrun,       INS_invalid,        INS_sqrshrun,       INS_invalid,        INS_sqrshrun,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedNarrowingSaturateUnsignedUpper,        16,      3,      true,  {INS_invalid,        INS_sqrshrun2,      INS_invalid,        INS_sqrshrun2,      INS_invalid,        INS_sqrshrun2,      INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedNarrowingSaturateUpper,                16,      3,      true,  {INS_sqrshrn2,       INS_invalid,        INS_sqrshrn2,       INS_invalid,        INS_sqrshrn2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticRoundedScalar,                                 8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_srshr,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightArithmeticScalar,                                        8,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sshr,           INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogical,                                                -1,      2,      true,  {INS_ushr,           INS_ushr,           INS_ushr,           INS_ushr,           INS_ushr,           INS_ushr,           INS_ushr,           INS_ushr,           INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalAdd,                                             -1,      3,      true,  {INS_usra,           INS_usra,           INS_usra,           INS_usra,           INS_usra,           INS_usra,           INS_usra,           INS_usra,           INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalAddScalar,                                        8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_usra,           INS_usra,           INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalNarrowingLower,                                   8,      2,      true,  {INS_shrn,           INS_shrn,           INS_shrn,           INS_shrn,           INS_shrn,           INS_shrn,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalNarrowingSaturateLower,                           8,      2,      true,  {INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalNarrowingSaturateUpper,                          16,      3,      true,  {INS_uqshrn2,        INS_uqshrn2,        INS_uqshrn2,        INS_uqshrn2,        INS_uqshrn2,        INS_uqshrn2,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalNarrowingUpper,                                  16,      3,      true,  {INS_shrn2,          INS_shrn2,          INS_shrn2,          INS_shrn2,          INS_shrn2,          INS_shrn2,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRounded,                                         -1,      2,      true,  {INS_urshr,          INS_urshr,          INS_urshr,          INS_urshr,          INS_urshr,          INS_urshr,          INS_urshr,          INS_urshr,          INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedAdd,                                      -1,      3,      true,  {INS_ursra,          INS_ursra,          INS_ursra,          INS_ursra,          INS_ursra,          INS_ursra,          INS_ursra,          INS_ursra,          INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedAddScalar,                                 8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ursra,          INS_ursra,          INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedNarrowingLower,                            8,      2,      true,  {INS_rshrn,          INS_rshrn,          INS_rshrn,          INS_rshrn,          INS_rshrn,          INS_rshrn,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedNarrowingSaturateLower,                    8,      2,      true,  {INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedNarrowingSaturateUpper,                   16,      3,      true,  {INS_uqrshrn2,       INS_uqrshrn2,       INS_uqrshrn2,       INS_uqrshrn2,       INS_uqrshrn2,       INS_uqrshrn2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedNarrowingUpper,                           16,      3,      true,  {INS_rshrn2,         INS_rshrn2,         INS_rshrn2,         INS_rshrn2,         INS_rshrn2,         INS_rshrn2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalRoundedScalar,                                    8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_urshr,          INS_urshr,          INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       ShiftRightLogicalScalar,                                           8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ushr,           INS_ushr,           INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       SignExtendWideningLower,                                           8,      1,      true,  {INS_sxtl,           INS_invalid,        INS_sxtl,           INS_invalid,        INS_sxtl,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       SignExtendWideningUpper,                                          16,      1,      true,  {INS_sxtl2,          INS_invalid,        INS_sxtl2,          INS_invalid,        INS_sxtl2,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       SqrtScalar,                                                        8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fsqrt,          INS_fsqrt},       HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       Store,                                                            -1,      2,      true,  {INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1},         HW_Category_Helper,                HW_Flag_SpecialImport|HW_Flag_BaseTypeFromSecondArg|HW_Flag_NoCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       StoreSelectedScalar,                                              -1,      3,      true,  {INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1,            INS_st1},         HW_Category_MemoryStore,           HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       Subtract,                                                         -1,      2,      true,  {INS_sub,            INS_sub,            INS_sub,            INS_sub,            INS_sub,            INS_sub,            INS_sub,            INS_sub,            INS_fsub,           INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       SubtractHighNarrowingLower,                                        8,      2,      true,  {INS_subhn,          INS_subhn,          INS_subhn,          INS_subhn,          INS_subhn,          INS_subhn,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       SubtractHighNarrowingUpper,                                       16,      3,      true,  {INS_subhn2,         INS_subhn2,         INS_subhn2,         INS_subhn2,         INS_subhn2,         INS_subhn2,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       SubtractRoundedHighNarrowingLower,                                 8,      2,      true,  {INS_rsubhn,         INS_rsubhn,         INS_rsubhn,         INS_rsubhn,         INS_rsubhn,         INS_rsubhn,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       SubtractRoundedHighNarrowingUpper,                                16,      3,      true,  {INS_rsubhn2,        INS_rsubhn2,        INS_rsubhn2,        INS_rsubhn2,        INS_rsubhn2,        INS_rsubhn2,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd,       SubtractSaturate,                                                 -1,      2,      true,  {INS_sqsub,          INS_uqsub,          INS_sqsub,          INS_uqsub,          INS_sqsub,          INS_uqsub,          INS_sqsub,          INS_uqsub,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd,       SubtractSaturateScalar,                                            8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqsub,          INS_uqsub,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       SubtractScalar,                                                    8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sub,            INS_sub,            INS_fsub,           INS_fsub},        HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd,       SubtractWideningLower,                                             8,      2,      true,  {INS_ssubl,          INS_usubl,          INS_ssubl,          INS_usubl,          INS_ssubl,          INS_usubl,          INS_ssubw,          INS_usubw,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       SubtractWideningUpper,                                            16,      2,      true,  {INS_ssubl2,         INS_usubl2,         INS_ssubl2,         INS_usubl2,         INS_ssubl2,         INS_usubl2,         INS_ssubw2,         INS_usubw2,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd,       VectorTableLookup,                                                 8,      2,      true,  {INS_tbl,            INS_tbl,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_NeedsConsecutiveRegisters)
HARDWARE_INTRINSIC(AdvSimd,       VectorTableLookupExtension,                                        8,      3,      true,  {INS_tbx,            INS_tbx,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_HasRMWSemantics|HW_Flag_NeedsConsecutiveRegisters)
HARDWARE_INTRINSIC(AdvSimd,       Xor,                                                              -1,      2,      true,  {INS_eor,            INS_eor,            INS_eor,            INS_eor,            INS_eor,            INS_eor,            INS_eor,            INS_eor,            INS_eor,            INS_eor},         HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd,       ZeroExtendWideningLower,                                           8,      1,      true,  {INS_uxtl,           INS_uxtl,           INS_uxtl,           INS_uxtl,           INS_uxtl,           INS_uxtl,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd,       ZeroExtendWideningUpper,                                          16,      1,      true,  {INS_uxtl2,          INS_uxtl2,          INS_uxtl2,          INS_uxtl2,          INS_uxtl2,          INS_uxtl2,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  AdvSimd 64-bit only Intrinsics
HARDWARE_INTRINSIC(AdvSimd_Arm64, Abs,                                                              16,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_abs,            INS_invalid,        INS_invalid,        INS_fabs},        HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsSaturate,                                                      16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqabs,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsSaturateScalar,                                                 8,      1,      true,  {INS_sqabs,          INS_invalid,        INS_sqabs,          INS_invalid,        INS_sqabs,          INS_invalid,        INS_sqabs,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsScalar,                                                         8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_abs,            INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareGreaterThan,                                       16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facgt},       HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareGreaterThanOrEqual,                                16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facge},       HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareGreaterThanOrEqualScalar,                           8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facge,          INS_facge},       HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareGreaterThanScalar,                                  8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facgt,          INS_facgt},       HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareLessThan,                                          16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facgt},       HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareLessThanOrEqual,                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facge},       HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareLessThanOrEqualScalar,                              8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facge,          INS_facge},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteCompareLessThanScalar,                                     8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_facgt,          INS_facgt},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteDifference,                                               16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fabd},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AbsoluteDifferenceScalar,                                          8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fabd,           INS_fabd},        HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Add,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fadd},        HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AddAcross,                                                        -1,      1,      true,  {INS_addv,           INS_addv,           INS_addv,           INS_addv,           INS_addv,           INS_addv,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AddAcrossWidening,                                                -1,      1,      true,  {INS_saddlv,         INS_uaddlv,         INS_saddlv,         INS_uaddlv,         INS_saddlv,         INS_uaddlv,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AddPairwise,                                                      16,      2,      true,  {INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_addp,           INS_faddp,          INS_faddp},       HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AddPairwiseScalar,                                                -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_addp,           INS_addp,           INS_faddp,          INS_faddp},       HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AddSaturate,                                                      -1,      2,      true,  {INS_suqadd,         INS_usqadd,         INS_suqadd,         INS_usqadd,         INS_suqadd,         INS_usqadd,         INS_suqadd,         INS_usqadd,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, AddSaturateScalar,                                                 8,      2,      true,  {INS_sqadd,          INS_uqadd,          INS_sqadd,          INS_uqadd,          INS_sqadd,          INS_uqadd,          INS_suqadd,         INS_usqadd,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Ceiling,                                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintp},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareEqual,                                                     16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmeq,           INS_cmeq,           INS_invalid,        INS_fcmeq},       HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareEqualScalar,                                                8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmeq,           INS_cmeq,           INS_fcmeq,          INS_fcmeq},       HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareGreaterThan,                                               16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmgt,           INS_cmhi,           INS_invalid,        INS_fcmgt},       HW_Category_SIMD,                  HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareGreaterThanOrEqual,                                        16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmge,           INS_cmhs,           INS_invalid,        INS_fcmge},       HW_Category_SIMD,                  HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareGreaterThanOrEqualScalar,                                   8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmge,           INS_cmhs,           INS_fcmge,          INS_fcmge},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareGreaterThanScalar,                                          8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmgt,           INS_cmhi,           INS_fcmgt,          INS_fcmgt},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareLessThan,                                                  16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmgt,           INS_cmhi,           INS_invalid,        INS_fcmgt},       HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareLessThanOrEqual,                                           16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmge,           INS_cmhs,           INS_invalid,        INS_fcmge},       HW_Category_SIMD,                  HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareLessThanOrEqualScalar,                                      8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmge,           INS_cmhs,           INS_fcmge,          INS_fcmge},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareLessThanScalar,                                             8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmgt,           INS_cmhi,           INS_fcmgt,          INS_fcmgt},       HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareTest,                                                      16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmtst,          INS_cmtst,          INS_invalid,        INS_cmtst},       HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, CompareTestScalar,                                                 8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cmtst,          INS_cmtst,          INS_invalid,        INS_cmtst},       HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToDouble,                                                  -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_scvtf,          INS_ucvtf,          INS_fcvtl,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToDoubleScalar,                                             8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_scvtf,          INS_ucvtf,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToDoubleUpper,                                             16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtl2,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundAwayFromZero,                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtas},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundAwayFromZeroScalar,                             8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtas},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToEven,                                        16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtns},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToEvenScalar,                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtns},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToNegativeInfinity,                            16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtms},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToNegativeInfinityScalar,                       8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtms},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToPositiveInfinity,                            16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtps},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToPositiveInfinityScalar,                       8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtps},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToZero,                                        16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzs},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToInt64RoundToZeroScalar,                                   8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzs},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToSingleLower,                                              8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtn,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToSingleRoundToOddLower,                                    8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtxn,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToSingleRoundToOddUpper,                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtxn2,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToSingleUpper,                                             16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtn2,         INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundAwayFromZero,                                 16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtau},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundAwayFromZeroScalar,                            8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtau},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToEven,                                       16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtnu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToEvenScalar,                                  8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtnu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToNegativeInfinity,                           16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtmu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToNegativeInfinityScalar,                      8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtmu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToPositiveInfinity,                           16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtpu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToPositiveInfinityScalar,                      8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtpu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToZero,                                       16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ConvertToUInt64RoundToZeroScalar,                                  8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fcvtzu},      HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Divide,                                                           -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fdiv,           INS_fdiv},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, DuplicateSelectedScalarToVector128,                               16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_dup,            INS_dup,            INS_invalid,        INS_dup},         HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, DuplicateToVector64,                                              16,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_mov,            INS_mov,            INS_invalid,        INS_fmov},        HW_Category_SIMD,                  HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, DuplicateToVector128,                                             16,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_dup,            INS_dup,            INS_invalid,        INS_dup},         HW_Category_SIMD,                  HW_Flag_SpecialCodeGen|HW_Flag_SupportsContainment)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ExtractNarrowingSaturateScalar,                                    8,      1,      true,  {INS_sqxtn,          INS_uqxtn,          INS_sqxtn,          INS_uqxtn,          INS_sqxtn,          INS_uqxtn,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ExtractNarrowingSaturateUnsignedScalar,                            8,      1,      true,  {INS_invalid,        INS_sqxtun,         INS_invalid,        INS_sqxtun,         INS_invalid,        INS_sqxtun,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Floor,                                                            16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintm},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplyAdd,                                                 16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmla},        HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplyAddByScalar,                                         -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmla,           INS_fmla},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplyAddBySelectedScalar,                                 -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmla,           INS_fmla},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplyAddScalarBySelectedScalar,                            8,      4,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmla,           INS_fmla},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplySubtract,                                            16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmls},        HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplySubtractByScalar,                                    -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmls,           INS_fmls},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplySubtractBySelectedScalar,                            -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmls,           INS_fmls},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(AdvSimd_Arm64, FusedMultiplySubtractScalarBySelectedScalar,                       8,      4,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmls,           INS_fmls},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, InsertSelectedScalar,                                             -1,      4,      true,  {INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins,            INS_ins},         HW_Category_SIMD,                  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_NoJmpTableIMM|HW_Flag_SIMDScalar|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadAndReplicateToVector128,                                      16,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ld1r,           INS_ld1r,           INS_invalid,        INS_ld1r},        HW_Category_MemoryLoad,            HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadPairScalarVector64,                                            8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ldp,            INS_ldp,            INS_invalid,        INS_invalid,        INS_ldp,            INS_invalid},     HW_Category_MemoryLoad,            HW_Flag_BaseTypeFromFirstArg|HW_Flag_MultiReg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadPairScalarVector64NonTemporal,                                 8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_ldnp,           INS_ldnp,           INS_invalid,        INS_invalid,        INS_ldnp,           INS_invalid},     HW_Category_MemoryLoad,            HW_Flag_BaseTypeFromFirstArg|HW_Flag_MultiReg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadPairVector64,                                                  8,      1,      true,  {INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp},         HW_Category_MemoryLoad,            HW_Flag_BaseTypeFromFirstArg|HW_Flag_MultiReg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadPairVector64NonTemporal,                                       8,      1,      true,  {INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp},        HW_Category_MemoryLoad,            HW_Flag_BaseTypeFromFirstArg|HW_Flag_MultiReg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadPairVector128,                                                16,      1,      true,  {INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp,            INS_ldp},         HW_Category_MemoryLoad,            HW_Flag_BaseTypeFromFirstArg|HW_Flag_MultiReg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(AdvSimd_Arm64, LoadPairVector128NonTemporal,                                     16,      1,      true,  {INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp,           INS_ldnp},        HW_Category_MemoryLoad,            HW_Flag_BaseTypeFromFirstArg|HW_Flag_MultiReg|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Max,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmax},        HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxAcross,                                                        -1,      1,      true,  {INS_smaxv,          INS_umaxv,          INS_smaxv,          INS_umaxv,          INS_smaxv,          INS_umaxv,          INS_invalid,        INS_invalid,        INS_fmaxv,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxNumber,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxnm},      HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxNumberAcross,                                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxnmv,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxNumberPairwise,                                                -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxnmp,        INS_fmaxnmp},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxNumberPairwiseScalar,                                          -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxnmp,        INS_fmaxnmp},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxPairwise,                                                      16,      2,      true,  {INS_smaxp,          INS_umaxp,          INS_smaxp,          INS_umaxp,          INS_smaxp,          INS_umaxp,          INS_invalid,        INS_invalid,        INS_fmaxp,          INS_fmaxp},       HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxPairwiseScalar,                                                -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmaxp,          INS_fmaxp},       HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MaxScalar,                                                         8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmax,           INS_fmax},        HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Min,                                                              16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmin},        HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinAcross,                                                        -1,      1,      true,  {INS_sminv,          INS_uminv,          INS_sminv,          INS_uminv,          INS_sminv,          INS_uminv,          INS_invalid,        INS_invalid,        INS_fminv,          INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinNumber,                                                        16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminnm},      HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinNumberAcross,                                                  16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminnmv,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinNumberPairwise,                                                -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminnmp,        INS_fminnmp},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinNumberPairwiseScalar,                                          -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminnmp,        INS_fminnmp},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinPairwise,                                                      16,      2,      true,  {INS_sminp,          INS_uminp,          INS_sminp,          INS_uminp,          INS_sminp,          INS_uminp,          INS_invalid,        INS_invalid,        INS_fminp,          INS_fminp},       HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinPairwiseScalar,                                                -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fminp,          INS_fminp},       HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MinScalar,                                                         8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmin,           INS_fmin},        HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Multiply,                                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmul},        HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyByScalar,                                                 16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmul},        HW_Category_SIMDByIndexedElement,  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyBySelectedScalar,                                         16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmul},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingSaturateHighScalar,                                8,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingScalarBySelectedScalarSaturateHigh,                8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_sqdmulh,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingWideningAndAddSaturateScalar,                      8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingWideningAndSubtractSaturateScalar,                 8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingWideningSaturateScalar,                            8,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingWideningSaturateScalarBySelectedScalar,            8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_sqdmull,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingWideningScalarBySelectedScalarAndAddSaturate,      8,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_sqdmlal,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyDoublingWideningScalarBySelectedScalarAndSubtractSaturate, 8,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_sqdmlsl,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_BaseTypeFromSecondArg|HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyExtended,                                                 -1,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmulx,          INS_fmulx},       HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyExtendedByScalar,                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmulx},       HW_Category_SIMDByIndexedElement,  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyExtendedBySelectedScalar,                                 -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmulx,          INS_fmulx},       HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyExtendedScalar,                                            8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmulx,          INS_fmulx},       HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyExtendedScalarBySelectedScalar,                            8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmulx,          INS_fmulx},       HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyRoundedDoublingSaturateHighScalar,                         8,      2,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyRoundedDoublingScalarBySelectedScalarSaturateHigh,         8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_sqrdmulh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, MultiplyScalarBySelectedScalar,                                    8,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fmul},        HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Negate,                                                           16,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_neg,            INS_invalid,        INS_invalid,        INS_fneg},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, NegateSaturate,                                                   16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sqneg,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, NegateSaturateScalar,                                              8,      1,      true,  {INS_sqneg,          INS_invalid,        INS_sqneg,          INS_invalid,        INS_sqneg,          INS_invalid,        INS_sqneg,          INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, NegateScalar,                                                      8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_neg,            INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalEstimate,                                               16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frecpe},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalEstimateScalar,                                          8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frecpe,         INS_frecpe},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalExponentScalar,                                          8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frecpx,         INS_frecpx},      HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalSquareRootEstimate,                                     16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frsqrte},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalSquareRootEstimateScalar,                                8,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frsqrte,        INS_frsqrte},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalSquareRootStep,                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frsqrts},     HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalSquareRootStepScalar,                                    8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frsqrts,        INS_frsqrts},     HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalStep,                                                   16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frecps},      HW_Category_SIMD,                  HW_Flag_Commutative)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReciprocalStepScalar,                                              8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frecps,         INS_frecps},      HW_Category_SIMD,                  HW_Flag_Commutative|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ReverseElementBits,                                               -1,      1,      true,  {INS_rbit,           INS_rbit,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, RoundAwayFromZero,                                                16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frinta},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, RoundToNearest,                                                   16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintn},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, RoundToNegativeInfinity,                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintm},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, RoundToPositiveInfinity,                                          16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintp},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, RoundToZero,                                                      16,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_frintz},      HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftArithmeticRoundedSaturateScalar,                              8,      2,      true,  {INS_sqrshl,         INS_invalid,        INS_sqrshl,         INS_invalid,        INS_sqrshl,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftArithmeticSaturateScalar,                                     8,      2,      true,  {INS_sqshl,          INS_invalid,        INS_sqshl,          INS_invalid,        INS_sqshl,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftLeftLogicalSaturateScalar,                                    8,      2,      true,  {INS_sqshl,          INS_uqshl,          INS_sqshl,          INS_uqshl,          INS_sqshl,          INS_uqshl,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftLeftLogicalSaturateUnsignedScalar,                            8,      2,      true,  {INS_sqshlu,         INS_invalid,        INS_sqshlu,         INS_invalid,        INS_sqshlu,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftLeftByImmediate,  HW_Flag_BaseTypeFromFirstArg|HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftLogicalRoundedSaturateScalar,                                 8,      2,      true,  {INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_uqrshl,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftLogicalSaturateScalar,                                        8,      2,      true,  {INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_uqshl,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftRightArithmeticNarrowingSaturateScalar,                       8,      2,      true,  {INS_sqshrn,         INS_invalid,        INS_sqshrn,         INS_invalid,        INS_sqshrn,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftRightArithmeticNarrowingSaturateUnsignedScalar,               8,      2,      true,  {INS_invalid,        INS_sqshrun,        INS_invalid,        INS_sqshrun,        INS_invalid,        INS_sqshrun,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftRightArithmeticRoundedNarrowingSaturateScalar,                8,      2,      true,  {INS_sqrshrn,        INS_invalid,        INS_sqrshrn,        INS_invalid,        INS_sqrshrn,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftRightArithmeticRoundedNarrowingSaturateUnsignedScalar,        8,      2,      true,  {INS_invalid,        INS_sqrshrun,       INS_invalid,        INS_sqrshrun,       INS_invalid,        INS_sqrshrun,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftRightLogicalNarrowingSaturateScalar,                          8,      2,      true,  {INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_uqshrn,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ShiftRightLogicalRoundedNarrowingSaturateScalar,                   8,      2,      true,  {INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_uqrshrn,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_ShiftRightByImmediate, HW_Flag_HasImmediateOperand|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Sqrt,                                                             -1,      1,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fsqrt,          INS_fsqrt},       HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, StorePair,                                                        -1,      3,      true,  {INS_stp,            INS_stp,            INS_stp,            INS_stp,            INS_stp,            INS_stp,            INS_stp,            INS_stp,            INS_stp,            INS_stp},         HW_Category_MemoryStore,           HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, StorePairScalar,                                                   8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_stp,            INS_stp,            INS_invalid,        INS_invalid,        INS_stp,            INS_invalid},     HW_Category_MemoryStore,           HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, StorePairScalarNonTemporal,                                        8,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_stnp,           INS_stnp,           INS_invalid,        INS_invalid,        INS_stnp,           INS_invalid},     HW_Category_MemoryStore,           HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, StorePairNonTemporal,                                             -1,      3,      true,  {INS_stnp,           INS_stnp,           INS_stnp,           INS_stnp,           INS_stnp,           INS_stnp,           INS_stnp,           INS_stnp,           INS_stnp,           INS_stp},         HW_Category_MemoryStore,           HW_Flag_BaseTypeFromSecondArg|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(AdvSimd_Arm64, Subtract,                                                         16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_fsub},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, SubtractSaturateScalar,                                            8,      2,      true,  {INS_sqsub,          INS_uqsub,          INS_sqsub,          INS_uqsub,          INS_sqsub,          INS_uqsub,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(AdvSimd_Arm64, TransposeEven,                                                    -1,      2,      true,  {INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1,           INS_trn1},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, TransposeOdd,                                                     -1,      2,      true,  {INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2,           INS_trn2},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, UnzipEven,                                                        -1,      2,      true,  {INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1,           INS_uzp1},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, UnzipOdd,                                                         -1,      2,      true,  {INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2,           INS_uzp2},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, VectorTableLookup,                                                16,      2,      true,  {INS_tbl,            INS_tbl,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_NeedsConsecutiveRegisters)
HARDWARE_INTRINSIC(AdvSimd_Arm64, VectorTableLookupExtension,                                       16,      3,      true,  {INS_tbx,            INS_tbx,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SpecialImport|HW_Flag_SpecialCodeGen|HW_Flag_HasRMWSemantics|HW_Flag_NeedsConsecutiveRegisters)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ZipHigh,                                                          -1,      2,      true,  {INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2,           INS_zip2},        HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(AdvSimd_Arm64, ZipLow,                                                           -1,      2,      true,  {INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1,           INS_zip1},        HW_Category_SIMD,                  HW_Flag_NoFlag)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  AES Intrinsics
HARDWARE_INTRINSIC(Aes,           Decrypt,                                                          16,      2,     false,  {INS_invalid,        INS_aesd,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Aes,           Encrypt,                                                          16,      2,     false,  {INS_invalid,        INS_aese,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Aes,           InverseMixColumns,                                                16,      1,     false,  {INS_invalid,        INS_aesimc,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(Aes,           MixColumns,                                                       16,      1,     false,  {INS_invalid,        INS_aesmc,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_NoFlag)
HARDWARE_INTRINSIC(Aes,           PolynomialMultiplyWideningLower,                                   8,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_pmull,          INS_pmull,          INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)
HARDWARE_INTRINSIC(Aes,           PolynomialMultiplyWideningUpper,                                  16,      2,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_pmull2,         INS_pmull2,         INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_BaseTypeFromFirstArg|HW_Flag_Commutative)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Base Intrinsics
HARDWARE_INTRINSIC(ArmBase,       LeadingZeroCount,                                                  0,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_clz,            INS_clz,            INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoFloatingPointUsed)
HARDWARE_INTRINSIC(ArmBase,       ReverseElementBits,                                                0,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_rbit,           INS_rbit,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_NoFloatingPointUsed)
HARDWARE_INTRINSIC(ArmBase,       Yield,                                                             0,      0,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Special,               HW_Flag_NoFloatingPointUsed|HW_Flag_SpecialCodeGen|HW_Flag_SpecialImport|HW_Flag_SpecialSideEffect_Other)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  Base 64-bit only Intrinsics
HARDWARE_INTRINSIC(ArmBase_Arm64, LeadingSignCount,                                                  0,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_cls,            INS_invalid,        INS_cls,            INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoFloatingPointUsed)
HARDWARE_INTRINSIC(ArmBase_Arm64, LeadingZeroCount,                                                  0,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_clz,            INS_clz,            INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromFirstArg|HW_Flag_NoFloatingPointUsed)
HARDWARE_INTRINSIC(ArmBase_Arm64, MultiplyHigh,                                                      0,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_smulh,          INS_umulh,          INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_NoFloatingPointUsed)
HARDWARE_INTRINSIC(ArmBase_Arm64, ReverseElementBits,                                                0,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_rbit,           INS_rbit,           INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_NoFloatingPointUsed)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  CRC32 Intrinsics
HARDWARE_INTRINSIC(Crc32,         ComputeCrc32,                                                      0,      2,     false,  {INS_invalid,        INS_crc32b,         INS_invalid,        INS_crc32h,         INS_invalid,        INS_crc32w,         INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromSecondArg|HW_Flag_NoFloatingPointUsed|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Crc32,         ComputeCrc32C,                                                     0,      2,     false,  {INS_invalid,        INS_crc32cb,        INS_invalid,        INS_crc32ch,        INS_invalid,        INS_crc32cw,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromSecondArg|HW_Flag_NoFloatingPointUsed|HW_Flag_SpecialCodeGen)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  CRC32 64-bit only Intrinsics
HARDWARE_INTRINSIC(Crc32_Arm64,   ComputeCrc32,                                                      0,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_crc32x,         INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromSecondArg|HW_Flag_NoFloatingPointUsed|HW_Flag_SpecialCodeGen)
HARDWARE_INTRINSIC(Crc32_Arm64,   ComputeCrc32C,                                                     0,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_crc32cx,        INS_invalid,        INS_invalid},     HW_Category_Scalar,                HW_Flag_BaseTypeFromSecondArg|HW_Flag_NoFloatingPointUsed|HW_Flag_SpecialCodeGen)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  DP Intrinsics
HARDWARE_INTRINSIC(Dp,            DotProduct,                                                       -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sdot,           INS_udot,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Dp,            DotProductBySelectedQuadruplet,                                   -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sdot,           INS_udot,           INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  RDM Intrinsics
HARDWARE_INTRINSIC(Rdm,           MultiplyRoundedDoublingAndAddSaturateHigh,                        -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Rdm,           MultiplyRoundedDoublingAndSubtractSaturateHigh,                   -1,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Rdm,           MultiplyRoundedDoublingBySelectedScalarAndAddSaturateHigh,        -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Rdm,           MultiplyRoundedDoublingBySelectedScalarAndSubtractSaturateHigh,   -1,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  RDM 64-bit only Intrinsics
HARDWARE_INTRINSIC(Rdm_Arm64,     MultiplyRoundedDoublingAndAddSaturateHighScalar,                   8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(Rdm_Arm64,     MultiplyRoundedDoublingAndSubtractSaturateHighScalar,              8,      3,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(Rdm_Arm64,     MultiplyRoundedDoublingScalarBySelectedScalarAndAddSaturateHigh,   8,      4,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_sqrdmlah,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(Rdm_Arm64,     MultiplyRoundedDoublingScalarBySelectedScalarAndSubtractSaturateHigh, 8,   4,      true,  {INS_invalid,        INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_sqrdmlsh,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMDByIndexedElement,  HW_Flag_HasImmediateOperand|HW_Flag_HasRMWSemantics|HW_Flag_SIMDScalar)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  SHA1 Intrinsics
HARDWARE_INTRINSIC(Sha1,          FixedRotate,                                                       8,      1,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha1h,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_SIMDScalar)
HARDWARE_INTRINSIC(Sha1,          HashUpdateChoose,                                                 16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha1c,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha1,          HashUpdateMajority,                                               16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha1m,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha1,          HashUpdateParity,                                                 16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha1p,          INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha1,          ScheduleUpdate0,                                                  16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha1su0,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha1,          ScheduleUpdate1,                                                  16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha1su1,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)

// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//                 ISA            Function name                                              SIMD size  NumArg  EncodesExtraTypeArg                                                                                            Instructions                                                                                        Category                           Flags
//                                                                                                                          {TYP_BYTE,           TYP_UBYTE,          TYP_SHORT,          TYP_USHORT,         TYP_INT,            TYP_UINT,           TYP_LONG,           TYP_ULONG,          TYP_FLOAT,          TYP_DOUBLE}
// ***************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
//  SHA256 Intrinsics
HARDWARE_INTRINSIC(Sha256,        HashUpdate1,                                                      16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha256h,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha256,        HashUpdate2,                                                      16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha256h2,       INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha256,        ScheduleUpdate0,                                                  16,      2,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha256su0,      INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)
HARDWARE_INTRINSIC(Sha256,        ScheduleUpdate1,                                                  16,      3,     false,  {INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid,        INS_sha256su1,      INS_invalid,        INS_invalid,        INS_invalid,        INS_invalid},     HW_Category_SIMD,                  HW_Flag_HasRMWSemantics)

#endif // FEATURE_HW_INTRINSIC

#undef HARDWARE_INTRINSIC

// clang-format on
