# 0.0.16

**Version:** 0.0.16
**Published:** 2022-10-12T09:47:51Z

## Release Notes

## Highlights
* The minimum supported Rust version is now 1.59.
* Many utils now return exit code `1` on usage errors instead of `2` to match GNU.
* `tail` has had another significant refactor with slight improvements.
* `chroot` returns better exit codes and supports commands with flags.
* `cp` supports the `-H` flag and handles more cases correctly.
* `test` supports `-N`, `-ef`, `-nt` & `-ot` and supports 128 bit integers.
* `dd`'s argument parsing has been overhauled and is more compatible with GNU.
* There have been refactors, fixes and performance improvements in many utils, see below for details.

## GNU test suite compatibility

Many utils have seen minor changes to improve GNU compatibility. Below is a summary of the progress. See https://github.com/uutils/coreutils-tracking/ for more details

| result | 0.0.15 | 0.0.16 | change |
|--------|-------:|-------:|-------:|
| pass   |    293 |    322 |    +29 |
| skip   |     73 |     49 |    -24 |
| fail   |    222 |    217 |     -5 |
| error  |      5 |      5 |      0 |

## Changes
The PR's listed below are a selection of all the contributions in this release.

### General
* Change remaining usage codes of `2` to `1` for GNU compat by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3922
* Create new adaptive svg logo by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3892

### `cat`
* Remove deprecated `unix_socket` dependency by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3854

### `chcon`
* Fix GNU `tests/misc/chcon-fail.sh` test by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3857

### `chroot`
* Improve support of `--skip-chdir` by @sylvestre in https://github.com/uutils/coreutils/pull/4004
* Set exit codes to `125`, `126` or `127` for errors from `chroot` itself by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3908
* Set trailing var arg by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3907
* Various improvements to chroot by @sylvestre in https://github.com/uutils/coreutils/pull/3960

### `cp`
* Fix `cp-i` GNU test by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3949
* Add `-H` option by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3971
* Assume `--reflink=always` on no value by @sssemil in https://github.com/uutils/coreutils/pull/3992
* Correct error message on copying dir to itself by @jfinkels in https://github.com/uutils/coreutils/pull/3981
* Allow removing symbolic link loop destination by @jfinkels in https://github.com/uutils/coreutils/pull/3972
* Preserve permissions when copying directory and don't terminate early on inaccessible file by @jfinkels in https://github.com/uutils/coreutils/pull/3973

### `dd`
* Handle stdout redirected to seekable file by @jfinkels in https://github.com/uutils/coreutils/pull/3880
* Parse operands manually via positional args by @tertsdiepraam in https://github.com/uutils/coreutils/pull/3938

### `df`
* Remove trailing spaces in rightmost column by @jfinkels in https://github.com/uutils/coreutils/pull/3882

### `factor`
* Enable `union` feature for `smallvec` by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3928

### `ls`
* Exit code 2 when `IOError` happened for argument by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3921
* Add support for `+FORMAT` in timestyle by @dmatos2012 in https://github.com/uutils/coreutils/pull/3988
* Align `--ignore` behavior with that of GNU ls by @ackerleytng in https://github.com/uutils/coreutils/pull/3803

### `mktemp`
* Respect `TMPDIR` environment variable by @jfinkels in https://github.com/uutils/coreutils/pull/3552
* Match GNU error message on too many args by @jfinkels in https://github.com/uutils/coreutils/pull/3951
* Add message for directory not found by @jfinkels in https://github.com/uutils/coreutils/pull/3940

### `pr`
* Migrate from `chrono` to `time` by @niyaznigmatullin in https://github.com/uutils/coreutils/pull/3918
* Use clap to handle help & version by @cakebaker in https://github.com/uutils/coreutils/pull/3904

### `rm`
* Added write-protected check for files by @stefins in https://github.com/uutils/coreutils/pull/3853
* Added descend messages for interactive mode Fixes #3817 by @palaster in https://github.com/uutils/coreutils/pull/3931

### `split`
* Add support for starting suffix numbers by @andrewbaptist in https://github.com/uutils/coreutils/pull/3976

### `sync`
* Various compatibility improvement by @sylvestre in https://github.com/uutils/coreutils/pull/4003

### `tail`
* Fix stdin redirect (#3842) by @jhscheer in https://github.com/uutils/coreutils/pull/3845
* Fix tail panicking when seeking backwards by @kilpkonn in https://github.com/uutils/coreutils/pull/3873
* Refactor tail by @Joining7943 in https://github.com/uutils/coreutils/pull/3905
* Fix random errors for piped input on macos by @Joining7943 in https://github.com/uutils/coreutils/pull/3953

### `test`
* Add a bunch of operations by @sylvestre in https://github.com/uutils/coreutils/pull/4002

## New Contributors
@sssemil (https://github.com/uutils/coreutils/pull/3852), @kilpkonn (https://github.com/uutils/coreutils/pull/3873), @stefins (https://github.com/uutils/coreutils/pull/3853), @snapdgn (https://github.com/uutils/coreutils/pull/3923), @sashashura (https://github.com/uutils/coreutils/pull/3980), @dmatos2012 (https://github.com/uutils/coreutils/pull/3988)

**Full Changelog**: https://github.com/uutils/coreutils/compare/0.0.15...0.0.16
