dnl -*- Autoconf -*-
dnl Copyright (C) 1993-2008, 2017 Free Software Foundation, Inc.
dnl This file is free software, distributed under the terms of the GNU
dnl General Public License.  As a special exception to the GNU General
dnl Public License, this file may be distributed as part of a program
dnl that contains a configuration script generated by Autoconf, under
dnl the same distribution terms as the rest of that program.

dnl From Bruno Haible, Marcus Daniels, Sam Steingold.

AC_PREREQ([2.57])

AC_DEFUN([CL_TERM],
[
  AC_BEFORE([$0], [CL_IOCTL])
  AC_CHECK_HEADERS([termios.h])
  if test $ac_cv_header_termios_h = yes; then
    dnl HAVE_TERMIOS_H defined
    dnl Linux libc5 defines struct winsize in <termios.h>, <termio.h>, <sys/ioctl.h>.
    dnl Linux libc6 defines struct winsize in <termio.h>, <sys/ioctl.h>.
    dnl Since we don't want to include both <termios.h> and <termio.h> (they may
    dnl conflict), prefer <sys/ioctl.h> to <termio.h>.
    CL_COMPILE_CHECK([struct winsize in termios.h], [cl_cv_struct_winsize],
      [#include <termios.h>],
      [struct winsize w;],
      [])
    if test $cl_cv_struct_winsize = no; then
      CL_COMPILE_CHECK([struct winsize in sys/ioctl.h], [cl_cv_struct_winsize_ioctl],
        [#include <sys/types.h>
         #include <sys/ioctl.h>],
        [struct winsize w;],
        [AC_DEFINE([WINSIZE_NEED_SYS_IOCTL_H],,
           [have <termios.h> but need <sys/ioctl.h> for `struct winsize'])
        ])
    fi
  fi
])
