/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.services.JetspeedSecurity;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.security.LoginException;
import org.apache.turbine.modules.ActionEvent;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.chefproject.service.ServerConfigurationService;

public class ChefLoginUser
extends ActionEvent {
    public void doPerform(RunData rundata) throws Exception {
        JetspeedRunData data = (JetspeedRunData)rundata;
        String username = data.getParameters().getString("username", "");
        String password = data.getParameters().getString("password", "");
        JetspeedUser user = null;
        String redirect = "";
        try {
            user = JetspeedSecurity.login((String)username, (String)password);
        }
        catch (LoginException e) {
            redirect = "/template/" + JetspeedResources.getString((String)"template.login") + "?err=invalid";
            Log.info("chef", "ChefLoginUser: Credential Failure on login for user: " + username);
        }
        try {
            String link = ServerConfigurationService.getPortalUrl() + redirect;
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", " ** login redirect url: " + link);
            }
            data.setRedirectURI(link);
        }
        catch (Exception e) {
            Log.warn("chef", "ChefLoginUser: exception processing redirect: " + e);
        }
    }
}

