# Table of Contents

- [What is oscs?](#what-is-oscs)
  * [OSCS stands for](#oscs-stands-for)
  * [How to install](#how-to-install)
  * [What it does](#what-it-does)
  * [How to use](#how-to-use)
  * [Color display in your prompt](#color-display-in-your-prompt)

# What is oscs?
## OSCS stands for

OpenStack Cloud selector.

## How to install

Get it from Debian Unstable the usual apt-get way, or, for Bookworm backport:

```
apt-get install extrepo
extrepo enable openstack_dalmatian
apt-get update
apt-get install oscs
```

## What it does

OSCS manages the OS_CLOUD shell environment variable. When invoked, It parses
~/.config/openstack/clouds.yaml (or /etc/openstack/clouds.yaml if none in
your home direction). Then it prompts for what credential to use (with fzf)
in that file, and sets the OS_CLOUD variable according to user's selection.

![alt text](oscs.png "OSCS screenshot")

## How to use

The easiest is to just source oscs in your ~/.bashrc:

```
echo ". /usr/share/oscs/oscs" >>~/.bashrc
```

Then simply use:

```
oscs set
```

and

```
oscs unset
```

## Color display in your prompt

Simply add this to your .bashrc:

```
print_os_cloud() {
        if [ -n "${OS_CLOUD}" ] ; then
                echo " ${OS_CLOUD}"
        fi
}
   NO_COL="\033[0m"
   YELLOW="\033[1;33m"
     TEAL="\033[38;5;6m"

export PS1=${PS1} ${YELLOW}\$(print_os_cloud)${NO_COL}
```
