
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <AppStdL_Application.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_AppStdL(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("AppStdL"));
py::object klass;

//Python trampoline classes

// classes

    // Class AppStdL_Application from ./opencascade/AppStdL_Application.hxx
    klass = m.attr("AppStdL_Application");

    // default constructor
    register_default_constructor<AppStdL_Application ,opencascade::handle<AppStdL_Application>>(m,"AppStdL_Application");

    // nested enums

    static_cast<py::class_<AppStdL_Application ,opencascade::handle<AppStdL_Application>  , TDocStd_Application >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ResourcesName",
             (Standard_CString (AppStdL_Application::*)() ) static_cast<Standard_CString (AppStdL_Application::*)() >(&AppStdL_Application::ResourcesName),
             R"#(returns the file name which contains application resources)#" 
          )
        .def("DumpJson",
             (void (AppStdL_Application::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (AppStdL_Application::*)( std::ostream & ,  Standard_Integer  ) const>(&AppStdL_Application::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&AppStdL_Application::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&AppStdL_Application::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (AppStdL_Application::*)() const) static_cast<const opencascade::handle<Standard_Type> & (AppStdL_Application::*)() const>(&AppStdL_Application::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/AppStdL_Application.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
