
/**************************************************************************
 *                                                                        *
 *  Regina - A Normal Surface Theory Calculator                           *
 *  Python Interface                                                      *
 *                                                                        *
 *  Copyright (c) 1999-2025, Ben Burton                                   *
 *  For further details contact Ben Burton (bab@debian.org).              *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  As an exception, when this program is distributed through (i) the     *
 *  App Store by Apple Inc.; (ii) the Mac App Store by Apple Inc.; or     *
 *  (iii) Google Play by Google Inc., then that store may impose any      *
 *  digital rights management, device limits and/or redistribution        *
 *  restrictions that are required by its terms of service.               *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public License     *
 *  along with this program. If not, see <https://www.gnu.org/licenses/>. *
 *                                                                        *
 **************************************************************************/

#include "triangulation-bindings.h"
#include "boundarycomponent-bindings.h"
#include "component-bindings.h"
#include "simplex-bindings.h"

void addTriangulations15(pybind11::module_& m, pybind11::module_& internal) {
    addSimplex<15>(m, "Simplex15");
    addComponent<15>(m, internal, "Component15");
    addBoundaryComponent<15>(m, internal, "BoundaryComponent15");
    addTriangulation<15>(m, internal, "Triangulation15");

    addIsoSigClassic<15>(m, "IsoSigClassic15");
    addIsoSigEdgeDegrees<15>(m, "IsoSigEdgeDegrees15");
    addIsoSigRidgeDegrees<15>(m, "IsoSigRidgeDegrees15");
    addIsoSigPrintable<15, true>(m, "IsoSigPrintable15");
    addIsoSigPrintable<15, false>(m, "IsoSigPrintableLockFree15");

    m.attr("Face15_15") = m.attr("Simplex15");
}

