// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, DBusInterfaceSkeleton, DBusMethodInvocation, DBusObject};
use glib::{
    object::ObjectType as _,
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GDBusObjectSkeleton")]
    pub struct DBusObjectSkeleton(Object<ffi::GDBusObjectSkeleton, ffi::GDBusObjectSkeletonClass>) @implements DBusObject;

    match fn {
        type_ => || ffi::g_dbus_object_skeleton_get_type(),
    }
}

impl DBusObjectSkeleton {
    pub const NONE: Option<&'static DBusObjectSkeleton> = None;

    #[doc(alias = "g_dbus_object_skeleton_new")]
    pub fn new(object_path: &str) -> DBusObjectSkeleton {
        unsafe {
            from_glib_full(ffi::g_dbus_object_skeleton_new(
                object_path.to_glib_none().0,
            ))
        }
    }
}

pub trait DBusObjectSkeletonExt: IsA<DBusObjectSkeleton> + 'static {
    #[doc(alias = "g_dbus_object_skeleton_add_interface")]
    fn add_interface(&self, interface_: &impl IsA<DBusInterfaceSkeleton>) {
        unsafe {
            ffi::g_dbus_object_skeleton_add_interface(
                self.as_ref().to_glib_none().0,
                interface_.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_object_skeleton_flush")]
    fn flush(&self) {
        unsafe {
            ffi::g_dbus_object_skeleton_flush(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "g_dbus_object_skeleton_remove_interface")]
    fn remove_interface(&self, interface_: &impl IsA<DBusInterfaceSkeleton>) {
        unsafe {
            ffi::g_dbus_object_skeleton_remove_interface(
                self.as_ref().to_glib_none().0,
                interface_.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_object_skeleton_remove_interface_by_name")]
    fn remove_interface_by_name(&self, interface_name: &str) {
        unsafe {
            ffi::g_dbus_object_skeleton_remove_interface_by_name(
                self.as_ref().to_glib_none().0,
                interface_name.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g_dbus_object_skeleton_set_object_path")]
    fn set_object_path(&self, object_path: &str) {
        unsafe {
            ffi::g_dbus_object_skeleton_set_object_path(
                self.as_ref().to_glib_none().0,
                object_path.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "g-object-path")]
    fn g_object_path(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "g-object-path")
    }

    #[doc(alias = "g-object-path")]
    fn set_g_object_path(&self, g_object_path: Option<&str>) {
        ObjectExt::set_property(self.as_ref(), "g-object-path", g_object_path)
    }

    #[doc(alias = "authorize-method")]
    fn connect_authorize_method<
        F: Fn(&Self, &DBusInterfaceSkeleton, &DBusMethodInvocation) -> bool + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn authorize_method_trampoline<
            P: IsA<DBusObjectSkeleton>,
            F: Fn(&P, &DBusInterfaceSkeleton, &DBusMethodInvocation) -> bool + 'static,
        >(
            this: *mut ffi::GDBusObjectSkeleton,
            interface: *mut ffi::GDBusInterfaceSkeleton,
            invocation: *mut ffi::GDBusMethodInvocation,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                DBusObjectSkeleton::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(interface),
                &from_glib_borrow(invocation),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"authorize-method".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    authorize_method_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "g-object-path")]
    fn connect_g_object_path_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_g_object_path_trampoline<
            P: IsA<DBusObjectSkeleton>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GDBusObjectSkeleton,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(DBusObjectSkeleton::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                c"notify::g-object-path".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_g_object_path_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl<O: IsA<DBusObjectSkeleton>> DBusObjectSkeletonExt for O {}
