// Symphonia
// Copyright (c) 2019-2022 The Project Symphonia Developers.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

/// Layer 1 and 2 shared scale factors. Derived from ISO/ISO 11172-3 Table 3-B.1.
pub const LAYER12_SCALEFACTORS: [f32; 64] = [
    2.00000000000000,
    1.58740105196820,
    1.25992104989487,
    1.00000000000000,
    0.79370052598410,
    0.62996052494744,
    0.50000000000000,
    0.39685026299205,
    0.31498026247372,
    0.25000000000000,
    0.19842513149602,
    0.15749013123686,
    0.12500000000000,
    0.09921256574801,
    0.07874506561843,
    0.06250000000000,
    0.04960628287401,
    0.03937253280921,
    0.03125000000000,
    0.02480314143700,
    0.01968626640461,
    0.01562500000000,
    0.01240157071850,
    0.00984313320230,
    0.00781250000000,
    0.00620078535925,
    0.00492156660115,
    0.00390625000000,
    0.00310039267963,
    0.00246078330058,
    0.00195312500000,
    0.00155019633981,
    0.00123039165029,
    0.00097656250000,
    0.00077509816991,
    0.00061519582514,
    0.00048828125000,
    0.00038754908495,
    0.00030759791257,
    0.00024414062500,
    0.00019377454248,
    0.00015379895629,
    0.00012207031250,
    0.00009688727124,
    0.00007689947814,
    0.00006103515625,
    0.00004844363562,
    0.00003844973907,
    0.00003051757813,
    0.00002422181781,
    0.00001922486954,
    0.00001525878906,
    0.00001211090890,
    0.00000961243477,
    0.00000762939453,
    0.00000605545445,
    0.00000480621738,
    0.00000381469727,
    0.00000302772723,
    0.00000240310869,
    0.00000190734863,
    0.00000151386361,
    0.00000120155435,
    // This value is not in the table provided by ISO/IEC 11172-3. However, some files do use 63 as
    // a scalefactor index. To increase compatibility, a dummy scalefactor has been added.
    0.00000000000000,
];
