Recursion limit reached while creating drop-check rules.

Example of erroneous code:

```compile_fail,E0320
enum A<T> {
    B,
    C(T, Box<A<(T, T)>>)
}

fn foo<T>() {
    A::<T>::B; // error: overflow while adding drop-check rules for A<T>
}
```

The Rust compiler must be able to reason about how a type is [`Drop`]ped, and
by extension the types of its fields, to be able to generate the glue to
properly drop a value. The code example above shows a type where this inference
is impossible because it is recursive. Note that this is *not* the same as
[E0072](E0072.html), where a type has an infinite size; the type here has a
finite size but any attempt to `Drop` it would recurse infinitely. For more
information, read [the `Drop` docs](../std/ops/trait.Drop.html).

It is not possible to define a type with recursive drop-check rules. All such
recursion must be removed.

[`Drop`]: ../std/ops/trait.Drop.html
