/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEPININTELDIALOG_H
#define CHANGEPININTELDIALOG_H

#include <QDialog>
#include <QWidget>
#include <QPaintEvent>
#include <QPainter>
#include <QPainterPath>
#include <QMouseEvent>
#include <QSharedPointer>
#include <QVBoxLayout>
#include <QFrame>
#include <QHBoxLayout>
#include <QString>
#include <QGSettings/QGSettings>
#include "digitalauthinteldialog.h"
#include "phoneauthinteldialog.h"
#include "changepwdinteldialog.h"
#define UKUI_QT_STYLE                      "org.ukui.style"
#define UKUI_STYLE_KEY                     "style-name"

class QLabel;
class QPushButton;

namespace Ui {
class ChangePinIntelDialog;
}

class ChangePinIntelDialog : public QDialog
{
    Q_OBJECT

public:
    explicit ChangePinIntelDialog(QString username, QWidget *parent = nullptr);
    ~ChangePinIntelDialog();
    static int m_isThemeChanged;                                    //主题

protected:
    void paintEvent(QPaintEvent *);

private:
    Ui::ChangePinIntelDialog *ui;
    QPushButton *closeBtn;
    DigitalAuthIntelDialog *m_pdigitalAuthWidget;
    PhoneAuthIntelDialog *m_pPhoneAuthWidget;
    ChangePwdIntelDialog *m_pChangePwdDialog;
    QGSettings  *m_style = nullptr;

Q_SIGNALS:
    void EmitThemeChanged(int theme);
    void changepwd();

private slots:
    void setpwdstyle(QString key);
};

#endif // CHANGEPININTELDIALOG_H
