/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef TIMEBTN_H
#define TIMEBTN_H
#include <QPushButton>
#include "fixlabel.h"
#include "lightlabel.h"
#include <QGSettings>
#include <QTimeZone>
#include <QLabel>
#include "ukccframe.h"
#include <QTimerEvent>

class TimeBtn : public UkccFrame
{
    Q_OBJECT
public:
    TimeBtn(const QString &timezone, const QString &kyTimezone = "");
    ~TimeBtn();
    void updateTime(bool hour_24);

protected:
    void enterEvent(QEvent *event);
    void leaveEvent(QEvent *event);
    void timerEvent(QTimerEvent *e);

private:
    QTimeZone thisZone;
    int timerId = 0;
    FixLabel       *labelInfo     = nullptr;
    LightLabel     *labelTime     = nullptr;
    QDBusInterface *areaInterface = nullptr;
    QPushButton    *deleteBtn     = nullptr;

Q_SIGNALS:
    void deleted();
};


#endif // TIMEBTN_H
