/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "dotlabel.h"
#include <QPainter>
#include <QPalette>

Dotlabel::Dotlabel(const QSize &size, QWidget *parent):
    mSize(size),
    QLabel(parent)
{

}

void Dotlabel::paintEvent(QPaintEvent *event)
{
    QPainter painter(this);
    painter.setRenderHint(QPainter::Antialiasing);  // 反锯齿;
    painter.setClipping(true);
    painter.setPen(Qt::transparent);

    QPainterPath path;
    path.addEllipse(0, 0, mSize.width(), mSize.height());
    painter.setClipPath(path);

    QPalette pal;
    painter.setBrush(pal.highlight());
    painter.drawRoundedRect(this->rect(), 0, 0);

    return QLabel::paintEvent(event);
}
