/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef MOUSEINTERFACE_H
#define MOUSEINTERFACE_H

#include <QObject>
#include "universalinterface.h"

class MouseInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Mouse")
    Q_PROPERTY(bool dominantHand READ getDominantHand)
    Q_PROPERTY(bool scrollDirection READ getScrollDirection)
    Q_PROPERTY(int wheelSpeed READ getWheelSpeed)
    Q_PROPERTY(int doubleClick READ getDoubleClick)
    Q_PROPERTY(double pointerSpeed READ getPointerSpeed)
    Q_PROPERTY(bool mouseAcceleration READ getMouseAcceleration)
    Q_PROPERTY(bool pointerPosition READ getPointerPosition)
    Q_PROPERTY(int pointerSize READ getPointerSize)
    Q_PROPERTY(bool cursorBlink READ getCursorBlink)
    Q_PROPERTY(int cursorSpeed READ getCursorSpeed)

public:
    MouseInterface();
    ~MouseInterface();

    void initConnect();

private:
    const QString DOMINANT_HAND_KEY      = QString("leftHanded");
    const QString SCROLL_DIRECTION_KEY   = QString("naturalScroll");
    const QString WHEEL_SPEED_KEY        = QString("wheelSpeed");
    const QString DOUBLECLICK_KEY        = QString("doubleClick");
    const QString POINTER_SPEED_KEY      = QString("motionAcceleration");
    const QString MOUSE_ACCELERATION_KEY = QString("mouseAccel");
    const QString POINTER_POSITION_KEY   = QString("locatePointer");
    const QString POINTER_SIZE_KEY       = QString("cursorSize");

    const QString CURSOR_BLINK_KEY       = QString("cursorBlink");
    const QString CURSOR_SPEED_KEY       = QString("cursorBlinkTime");

    QGSettings         *ukuiMouseGsettings    = nullptr;
    QGSettings         *mateInterfaceGsettings= nullptr;
    QGSettings         *ukuiStyleGsettings    = nullptr;

protected:
    // 对属性的访问函数
    const bool   getDominantHand();
    const bool   getScrollDirection();
    const int    getWheelSpeed();
    const int    getDoubleClick();
    const double getPointerSpeed();
    const bool   getMouseAcceleration();
    const bool   getPointerPosition();
    const int    getPointerSize();
    const bool   getCursorBlink();
    const int    getCursorSpeed();

public Q_SLOTS:
    // 对属性的设置函数
    void setDominantHand(const bool rightHand);
    void setScrollDirection(const bool reverse);
    void setWheelSpeed(const int value);
    void setDoubleClick(const int value);
    void setPointerSpeed(const double value);
    void setMouseAcceleration(const bool checked);
    void setPointerPosition(const bool checked);
    void setPointerSize(const int value);
    void setCursorBlink(const bool checked);
    void setCursorSpeed(const int value);

    void resetKey(QString key);

Q_SIGNALS:
    void changed(QString keyName);

};

#endif // MOUSEINTERFACE_H
